/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.RowIcon;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.ui.icons.DarkIconProvider;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBCachingScalableIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LayeredIcon
extends JBCachingScalableIcon<LayeredIcon>
implements DarkIconProvider,
CompositeIcon {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.LayeredIcon");
    private final Icon[] myIcons;
    private Icon[] myScaledIcons;
    private final boolean[] myDisabledLayers;
    private final int[] myHShifts;
    private final int[] myVShifts;
    private int myXShift;
    private int myYShift;
    private int myWidth;
    private int myHeight;

    public LayeredIcon(int layerCount) {
        this.getScaleContext().addUpdateListener(this::updateSize);
        this.setAutoUpdateScaleContext(false);
        this.myIcons = new Icon[layerCount];
        this.myDisabledLayers = new boolean[layerCount];
        this.myHShifts = new int[layerCount];
        this.myVShifts = new int[layerCount];
    }

    public LayeredIcon(Icon ... icons) {
        if (icons == null) {
            LayeredIcon.$$$reportNull$$$0(0);
        }
        this(icons.length);
        for (int i = 0; i < icons.length; ++i) {
            this.setIcon(icons[i], i);
        }
    }

    protected LayeredIcon(LayeredIcon icon) {
        super((JBCachingScalableIcon)icon);
        this.getScaleContext().addUpdateListener(this::updateSize);
        this.setAutoUpdateScaleContext(false);
        this.myIcons = (Icon[])ArrayUtil.copyOf((Object[])icon.myIcons);
        this.myScaledIcons = null;
        this.myDisabledLayers = ArrayUtil.copyOf((boolean[])icon.myDisabledLayers);
        this.myHShifts = ArrayUtil.copyOf((int[])icon.myHShifts);
        this.myVShifts = ArrayUtil.copyOf((int[])icon.myVShifts);
        this.myXShift = icon.myXShift;
        this.myYShift = icon.myYShift;
        this.myWidth = icon.myWidth;
        this.myHeight = icon.myHeight;
    }

    @NotNull
    public LayeredIcon copy() {
        return new LayeredIcon(this);
    }

    @NotNull
    public LayeredIcon deepCopy() {
        LayeredIcon icon = new LayeredIcon(this);
        for (int i = 0; i < icon.myIcons.length; ++i) {
            icon.myIcons[i] = IconUtil.copy(icon.myIcons[i], null);
        }
        LayeredIcon layeredIcon = icon;
        if (layeredIcon == null) {
            LayeredIcon.$$$reportNull$$$0(1);
        }
        return layeredIcon;
    }

    private Icon @NotNull [] myScaledIcons() {
        if (this.myScaledIcons != null) {
            if (this.myScaledIcons == null) {
                LayeredIcon.$$$reportNull$$$0(2);
            }
            return this.myScaledIcons;
        }
        this.myScaledIcons = RowIcon.scaleIcons(this.myIcons, this.getScale());
        if (this.myScaledIcons == null) {
            LayeredIcon.$$$reportNull$$$0(3);
        }
        return this.myScaledIcons;
    }

    @NotNull
    public LayeredIcon withIconPreScaled(boolean preScaled) {
        super.withIconPreScaled(preScaled);
        this.updateSize();
        LayeredIcon layeredIcon = this;
        if (layeredIcon == null) {
            LayeredIcon.$$$reportNull$$$0(4);
        }
        return layeredIcon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LayeredIcon)) {
            return false;
        }
        LayeredIcon icon = (LayeredIcon)((Object)o);
        if (this.myHeight != icon.myHeight) {
            return false;
        }
        if (this.myWidth != icon.myWidth) {
            return false;
        }
        if (this.myXShift != icon.myXShift) {
            return false;
        }
        if (this.myYShift != icon.myYShift) {
            return false;
        }
        if (!Arrays.equals(this.myHShifts, icon.myHShifts)) {
            return false;
        }
        if (!Arrays.equals(this.myIcons, icon.myIcons)) {
            return false;
        }
        return Arrays.equals(this.myVShifts, icon.myVShifts);
    }

    public int hashCode() {
        return 0;
    }

    public void setIcon(Icon icon, int layer) {
        this.setIcon(icon, layer, 0, 0);
    }

    public Icon getIcon(int layer) {
        return this.myIcons[layer];
    }

    public int getIconCount() {
        return this.myIcons.length;
    }

    public Icon @NotNull [] getAllLayers() {
        if (this.myIcons == null) {
            LayeredIcon.$$$reportNull$$$0(5);
        }
        return this.myIcons;
    }

    public void setIcon(Icon icon, int layer, int hShift, int vShift) {
        if (icon instanceof LayeredIcon) {
            ((LayeredIcon)((Object)icon)).checkIHaventIconInsideMe((Icon)((Object)this));
        }
        this.myIcons[layer] = icon;
        this.myScaledIcons = null;
        this.myHShifts[layer] = hShift;
        this.myVShifts[layer] = vShift;
        this.updateSize();
    }

    public void setIcon(Icon icon, int layer, int constraint) {
        int y;
        int x;
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        if (width <= 1 || height <= 1) {
            this.setIcon(icon, layer);
            return;
        }
        switch (constraint) {
            case 0: {
                x = (width - w) / 2;
                y = (height - h) / 2;
                break;
            }
            case 1: {
                x = (width - w) / 2;
                y = 0;
                break;
            }
            case 2: {
                x = width - w;
                y = 0;
                break;
            }
            case 3: {
                x = width - w;
                y = (height - h) / 2;
                break;
            }
            case 4: {
                x = width - w;
                y = height - h;
                break;
            }
            case 5: {
                x = (width - w) / 2;
                y = height - h;
                break;
            }
            case 6: {
                x = 0;
                y = height - h;
                break;
            }
            case 7: {
                x = 0;
                y = (height - h) / 2;
                break;
            }
            case 8: {
                x = 0;
                y = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("The constraint should be one of SwingConstants' compass-directions [1..8] or CENTER [0], actual value is " + constraint);
            }
        }
        this.setIcon(icon, layer, x, y);
    }

    private void checkIHaventIconInsideMe(Icon icon) {
        LOG.assertTrue(icon != this);
        for (Icon child : this.myIcons) {
            if (!(child instanceof LayeredIcon)) continue;
            ((LayeredIcon)((Object)child)).checkIHaventIconInsideMe(icon);
        }
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getScaleContext().update();
        Icon[] icons = this.myScaledIcons();
        for (int i = 0; i < icons.length; ++i) {
            Icon icon = icons[i];
            if (icon == null || this.myDisabledLayers[i]) continue;
            int xOffset = (int)Math.floor((double)x + this.scaleVal(this.myXShift + this.myHShifts(i), ScaleType.OBJ_SCALE));
            int yOffset = (int)Math.floor((double)y + this.scaleVal(this.myYShift + this.myVShifts(i), ScaleType.OBJ_SCALE));
            icon.paintIcon(c, g, xOffset, yOffset);
        }
    }

    public boolean isLayerEnabled(int layer) {
        return !this.myDisabledLayers[layer];
    }

    public void setLayerEnabled(int layer, boolean enabled) {
        this.myDisabledLayers[layer] = !enabled;
    }

    public int getIconWidth() {
        this.getScaleContext().update();
        if (this.myWidth <= 1) {
            this.updateSize();
        }
        return (int)Math.ceil(this.scaleVal(this.myWidth, ScaleType.OBJ_SCALE));
    }

    public int getIconHeight() {
        this.getScaleContext().update();
        if (this.myHeight <= 1) {
            this.updateSize();
        }
        return (int)Math.ceil(this.scaleVal(this.myHeight, ScaleType.OBJ_SCALE));
    }

    private int myHShifts(int i) {
        return (int)Math.floor(this.scaleVal(this.myHShifts[i], ScaleType.USR_SCALE));
    }

    private int myVShifts(int i) {
        return (int)Math.floor(this.scaleVal(this.myVShifts[i], ScaleType.USR_SCALE));
    }

    protected void updateSize() {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        boolean allIconsAreNull = true;
        for (int i = 0; i < this.myIcons.length; ++i) {
            Icon icon = this.myIcons[i];
            if (icon == null) continue;
            allIconsAreNull = false;
            int hShift = this.myHShifts(i);
            int vShift = this.myVShifts(i);
            minX = Math.min(minX, hShift);
            maxX = Math.max(maxX, hShift + icon.getIconWidth());
            minY = Math.min(minY, vShift);
            maxY = Math.max(maxY, vShift + icon.getIconHeight());
        }
        if (allIconsAreNull) {
            return;
        }
        this.myWidth = maxX - minX;
        this.myHeight = maxY - minY;
        if (this.myIcons.length > 1) {
            this.myXShift = -minX;
            this.myYShift = -minY;
        }
    }

    @NotNull
    public Icon getDarkIcon(boolean isDark) {
        LayeredIcon newIcon = this.copy();
        for (int i = 0; i < newIcon.myIcons.length; ++i) {
            newIcon.myIcons[i] = newIcon.myIcons[i] == null ? null : IconLoader.getDarkIcon((Icon)newIcon.myIcons[i], (boolean)isDark);
        }
        LayeredIcon layeredIcon = newIcon;
        if (layeredIcon == null) {
            LayeredIcon.$$$reportNull$$$0(6);
        }
        return layeredIcon;
    }

    public static Icon create(Icon backgroundIcon, Icon foregroundIcon) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(backgroundIcon, 0);
        layeredIcon.setIcon(foregroundIcon, 1);
        return layeredIcon;
    }

    public String toString() {
        return "Layered icon " + this.getIconWidth() + "x" + this.getIconHeight() + ". myIcons=" + Arrays.asList(this.myIcons);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/LayeredIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/LayeredIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "deepCopy";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "myScaledIcons";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withIconPreScaled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLayers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDarkIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

