/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.transport.FetchV2Request;
import org.eclipse.jgit.transport.LsRefsV2Request;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.TransferConfig;

final class ProtocolV2Parser {
    private final TransferConfig transferConfig;

    ProtocolV2Parser(TransferConfig transferConfig) {
        this.transferConfig = transferConfig;
    }

    private static String consumeCapabilities(PacketLineIn pckIn, Consumer<String> serverOptionConsumer, Consumer<String> agentConsumer) throws IOException {
        String serverOptionPrefix = "server-option=";
        String agentPrefix = "agent=";
        String line = pckIn.readString();
        while (line != PacketLineIn.DELIM && line != PacketLineIn.END) {
            if (line.startsWith(serverOptionPrefix)) {
                serverOptionConsumer.accept(line.substring(serverOptionPrefix.length()));
            } else if (line.startsWith(agentPrefix)) {
                agentConsumer.accept(line.substring(agentPrefix.length()));
            }
            line = pckIn.readString();
        }
        return line;
    }

    FetchV2Request parseFetchRequest(PacketLineIn pckIn, RefDatabase refdb) throws PackProtocolException, IOException {
        FetchV2Request.Builder reqBuilder = FetchV2Request.builder();
        reqBuilder.addClientCapability("side-band-64k");
        String line = ProtocolV2Parser.consumeCapabilities(pckIn, serverOption -> reqBuilder.addServerOption((String)serverOption), agent -> reqBuilder.setAgent((String)agent));
        if (line == PacketLineIn.END) {
            return reqBuilder.build();
        }
        if (line != PacketLineIn.DELIM) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line));
        }
        boolean filterReceived = false;
        while ((line = pckIn.readString()) != PacketLineIn.END) {
            if (line.startsWith("want ")) {
                reqBuilder.addWantId(ObjectId.fromString(line.substring(5)));
                continue;
            }
            if (this.transferConfig.isAllowRefInWant() && line.startsWith("want-ref ")) {
                String refName = line.substring("want-ref".length() + 1);
                Ref ref = refdb.exactRef(refName);
                if (ref == null) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidRefName, refName));
                }
                ObjectId oid = ref.getObjectId();
                if (oid == null) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidRefName, refName));
                }
                reqBuilder.addWantedRef(refName, oid);
                reqBuilder.addWantId(oid);
                continue;
            }
            if (line.startsWith("have ")) {
                reqBuilder.addPeerHas(ObjectId.fromString(line.substring(5)));
                continue;
            }
            if (line.equals("done")) {
                reqBuilder.setDoneReceived();
                continue;
            }
            if (line.equals("thin-pack")) {
                reqBuilder.addClientCapability("thin-pack");
                continue;
            }
            if (line.equals("no-progress")) {
                reqBuilder.addClientCapability("no-progress");
                continue;
            }
            if (line.equals("include-tag")) {
                reqBuilder.addClientCapability("include-tag");
                continue;
            }
            if (line.equals("ofs-delta")) {
                reqBuilder.addClientCapability("ofs-delta");
                continue;
            }
            if (line.startsWith("shallow ")) {
                reqBuilder.addClientShallowCommit(ObjectId.fromString(line.substring(8)));
                continue;
            }
            if (line.startsWith("deepen ")) {
                int parsedDepth = Integer.parseInt(line.substring(7));
                if (parsedDepth <= 0) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidDepth, parsedDepth));
                }
                if (reqBuilder.getDeepenSince() != 0) {
                    throw new PackProtocolException(JGitText.get().deepenSinceWithDeepen);
                }
                if (reqBuilder.hasDeepenNotRefs()) {
                    throw new PackProtocolException(JGitText.get().deepenNotWithDeepen);
                }
                reqBuilder.setDepth(parsedDepth);
                continue;
            }
            if (line.startsWith("deepen-not ")) {
                reqBuilder.addDeepenNotRef(line.substring(11));
                if (reqBuilder.getDepth() == 0) continue;
                throw new PackProtocolException(JGitText.get().deepenNotWithDeepen);
            }
            if (line.equals("deepen-relative")) {
                reqBuilder.addClientCapability("deepen-relative");
                continue;
            }
            if (line.startsWith("deepen-since ")) {
                int ts = Integer.parseInt(line.substring(13));
                if (ts <= 0) {
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidTimestamp, line));
                }
                if (reqBuilder.getDepth() != 0) {
                    throw new PackProtocolException(JGitText.get().deepenSinceWithDeepen);
                }
                reqBuilder.setDeepenSince(ts);
                continue;
            }
            if (this.transferConfig.isAllowFilter() && line.startsWith("filter ")) {
                if (filterReceived) {
                    throw new PackProtocolException(JGitText.get().tooManyFilters);
                }
                filterReceived = true;
                reqBuilder.setFilterBlobLimit(ProtocolV2Parser.filterLine(line.substring("filter".length() + 1)));
                continue;
            }
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line));
        }
        return reqBuilder.build();
    }

    LsRefsV2Request parseLsRefsRequest(PacketLineIn pckIn) throws PackProtocolException, IOException {
        LsRefsV2Request.Builder builder = LsRefsV2Request.builder();
        ArrayList<String> prefixes = new ArrayList<String>();
        String line = ProtocolV2Parser.consumeCapabilities(pckIn, serverOption -> builder.addServerOption((String)serverOption), agent -> builder.setAgent((String)agent));
        if (line == PacketLineIn.END) {
            return builder.build();
        }
        if (line != PacketLineIn.DELIM) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line));
        }
        while ((line = pckIn.readString()) != PacketLineIn.END) {
            if (line.equals("peel")) {
                builder.setPeel(true);
                continue;
            }
            if (line.equals("symrefs")) {
                builder.setSymrefs(true);
                continue;
            }
            if (line.startsWith("ref-prefix ")) {
                prefixes.add(line.substring("ref-prefix ".length()));
                continue;
            }
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line));
        }
        return builder.setRefPrefixes(prefixes).build();
    }

    static long filterLine(String blobLine) throws PackProtocolException {
        long blobLimit = -1L;
        if (blobLine.equals("blob:none")) {
            blobLimit = 0L;
        } else if (blobLine.startsWith("blob:limit=")) {
            try {
                blobLimit = Long.parseLong(blobLine.substring("blob:limit=".length()));
            }
            catch (NumberFormatException e) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidFilter, blobLine));
            }
        }
        if (blobLimit < 0L) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidFilter, blobLine));
        }
        return blobLimit;
    }
}

