/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.lexer.YAMLGrammarCharUtil;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

public class YAMLQuotedTextImpl
extends YAMLScalarImpl
implements YAMLQuotedText {
    private final boolean a;
    private static final long b = c.a(8721183855533433737L, -1585825125448044215L, MethodHandles.lookup().lookupClass()).a(50709042126903L);

    public YAMLQuotedTextImpl(@NotNull ASTNode node) {
        if (node == null) {
            YAMLQuotedTextImpl.d(0);
        }
        super(node);
        ASTNode aSTNode = this.getFirstContentNode();
        this.a = aSTNode != null && aSTNode.getElementType() == YAMLTokenTypes.SCALAR_STRING;
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        ASTNode aSTNode = this.getFirstContentNode();
        if (aSTNode == null) {
            List<TextRange> list2 = Collections.emptyList();
            if (list2 == null) {
                YAMLQuotedTextImpl.d(1);
            }
            return list2;
        }
        ArrayList<TextRange> arrayList = new ArrayList<TextRange>();
        TextRange textRange = TextRange.create((int)aSTNode.getStartOffset(), (int)this.getTextRange().getEndOffset()).shiftRight(-this.getTextRange().getStartOffset());
        List list3 = StringUtil.split((String)textRange.substring(this.getText()), (String)"\n", (boolean)true, (boolean)false);
        int n2 = textRange.getStartOffset();
        for (int i10 = 0; i10 < list3.size(); ++i10) {
            int n3;
            String string = (String)list3.get(i10);
            int n4 = string.length();
            if (i10 == 0) {
                ++n3;
            } else {
                for (n3 = 0; n3 < string.length() && YAMLGrammarCharUtil.isSpaceLike(string.charAt(n3)); ++n3) {
                }
            }
            if (i10 == list3.size() - 1) {
                --n4;
            } else {
                while (n4 > n3 && YAMLGrammarCharUtil.isSpaceLike(string.charAt(n4 - 1))) {
                    --n4;
                }
            }
            arrayList.add(TextRange.create((int)n3, (int)n4).shiftRight(n2));
            n2 += string.length() + 1;
        }
        ArrayList<TextRange> arrayList2 = arrayList;
        if (arrayList2 == null) {
            YAMLQuotedTextImpl.d(2);
        }
        return arrayList2;
    }

    @Override
    @NotNull
    protected String getRangesJoiner(@NotNull CharSequence text2, @NotNull List<TextRange> contentRanges, int indexBefore) {
        TextRange textRange;
        if (text2 == null) {
            YAMLQuotedTextImpl.d(3);
        }
        if (contentRanges == null) {
            YAMLQuotedTextImpl.d(4);
        }
        if ((textRange = contentRanges.get(indexBefore)).isEmpty() || !this.isSingleQuote() && text2.charAt(textRange.getEndOffset() - 1) == '\\') {
            if ("\n" == null) {
                YAMLQuotedTextImpl.d(5);
            }
            return "\n";
        }
        if (contentRanges.get(indexBefore + 1).isEmpty()) {
            if ("" == null) {
                YAMLQuotedTextImpl.d(6);
            }
            return "";
        }
        if (" " == null) {
            YAMLQuotedTextImpl.d(7);
        }
        return " ";
    }

    @Override
    protected List<Pair<TextRange, String>> getDecodeReplacements(@NotNull CharSequence input) {
        if (input == null) {
            YAMLQuotedTextImpl.d(8);
        }
        ArrayList<Pair<TextRange, String>> arrayList = new ArrayList<Pair<TextRange, String>>();
        int n2 = 0;
        while (n2 + 1 < input.length()) {
            if (this.isSingleQuote() && input.charAt(n2) == '\'' && input.charAt(n2 + 1) == '\'') {
                arrayList.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)n2, (int)2), (Object)"'"));
                ++n2;
            } else if (!this.isSingleQuote() && input.charAt(n2) == '\\') {
                if (input.charAt(n2 + 1) == '\n') {
                    arrayList.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)n2, (int)2), (Object)""));
                    ++n2;
                } else {
                    int n3 = Escaper.findEscapementLength(input, n2);
                    int n4 = Escaper.toUnicodeChar(input, n2, n3);
                    TextRange textRange = TextRange.create((int)n2, (int)Math.min(n2 + n3 + 1, input.length()));
                    arrayList.add((Pair<TextRange, String>)Pair.create((Object)textRange, (Object)Character.toString((char)n4)));
                    n2 += textRange.getLength() - 1;
                }
            }
            ++n2;
        }
        return arrayList;
    }

    @Override
    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        int n2;
        long l2 = b ^ 0x308BB0540F36L;
        if (input == null) {
            YAMLQuotedTextImpl.d(9);
        }
        if (this.isSingleQuote()) {
            for (n2 = 0; n2 < input.length(); ++n2) {
                if (input.charAt(n2) != '\n' || YAMLQuotedTextImpl.isSurroundedByNoSpace(input, n2)) continue;
                throw new IllegalArgumentException("Newlines with spaces around are not convertible");
            }
        }
        n2 = YAMLUtil.getIndentToThisElement((PsiElement)this);
        String string = StringUtil.repeatSymbol((char)' ', (int)n2);
        ArrayList<Pair<TextRange, String>> arrayList = new ArrayList<Pair<TextRange, String>>();
        int n3 = 0;
        for (int i10 = 0; i10 < input.length(); ++i10) {
            char c10 = input.charAt(i10);
            if (c10 == '\n') {
                if (!this.isSingleQuote() && i10 + 1 < input.length() && YAMLGrammarCharUtil.isSpaceLike(input.charAt(i10 + 1))) {
                    arrayList.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i10, (int)1), (Object)("\\n\\\n" + string + "\\")));
                } else if (!this.isSingleQuote() && i10 + 1 < input.length() && input.charAt(i10 + 1) == '\n') {
                    arrayList.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i10, (int)1), (Object)("\\\n" + string + "\\n")));
                } else {
                    arrayList.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i10, (int)1), (Object)("\n\n" + string)));
                }
                n3 = 0;
                continue;
            }
            if (n3 > 60 && (!this.isSingleQuote() || c10 == ' ' && YAMLQuotedTextImpl.isSurroundedByNoSpace(input, i10))) {
                String string2 = this.isSingleQuote() ? "\n" + string : (YAMLGrammarCharUtil.isSpaceLike(c10) ? "\\\n" + string + "\\" : "\\\n" + string);
                arrayList.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i10, (int)(this.isSingleQuote() ? 1 : 0)), (Object)string2));
                n3 = 0;
            }
            ++n3;
            if (this.isSingleQuote() && c10 == '\'') {
                arrayList.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i10, (int)1), (Object)"''"));
                continue;
            }
            if (this.isSingleQuote()) continue;
            if (c10 == '\"') {
                arrayList.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i10, (int)1), (Object)"\\\""));
                continue;
            }
            if (c10 != '\\') continue;
            arrayList.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i10, (int)1), (Object)"\\\\"));
        }
        return arrayList;
    }

    @Override
    public boolean isMultiline() {
        return this.textContains('\n');
    }

    @Override
    public boolean isSingleQuote() {
        return this.a;
    }

    @Override
    public String toString() {
        long l2 = b ^ 0x21202668FD09L;
        return "YAML quoted text";
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            YAMLQuotedTextImpl.d(10);
        }
        if (visitor2 instanceof YamlPsiElementVisitor) {
            ((YamlPsiElementVisitor)visitor2).visitQuotedText(this);
        } else {
            super.accept(visitor2);
        }
    }

    private static /* synthetic */ void d(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x193B215A8975L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRanges";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRanges";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesJoiner";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRangesJoiner";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDecodeReplacements";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEncodeReplacements";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Escaper {
        private static final int[][] b;
        private static final NotNullLazyValue<Map<Integer, Integer>> c;
        private static final NotNullLazyValue<Map<Integer, Integer>> a;
        private static final long d;

        private Escaper() {
        }

        static int findEscapementLength(@NotNull CharSequence text2, int pos) {
            long l2 = d ^ 0x39B2FB2121CEL;
            if (text2 == null) {
                Escaper.a(0);
            }
            if (pos + 1 >= text2.length() || text2.charAt(pos) != '\\') {
                throw new IllegalArgumentException("This is not an escapement start");
            }
            char c10 = text2.charAt(pos + 1);
            if (c10 == 'x') {
                return 3;
            }
            if (c10 == 'u') {
                return 5;
            }
            if (c10 == 'U') {
                return 9;
            }
            return 1;
        }

        static int toUnicodeChar(@NotNull CharSequence text2, int pos, int length) {
            if (text2 == null) {
                Escaper.a(1);
            }
            if (length > 1) {
                CharSequence charSequence = text2.subSequence(pos + 2, Math.min(text2.length(), pos + length + 1));
                try {
                    return Integer.parseInt(charSequence.toString(), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return 63;
                }
            }
            Integer n2 = (Integer)((Map)c.getValue()).get(text2.charAt(pos + 1));
            return (Integer)ObjectUtils.notNull((Object)n2, (Object)text2.charAt(pos + 1));
        }

        static {
            d = com.jetbrains.python.psi.c.a(-5767679276752067208L, 8851507102925260040L, MethodHandles.lookup().lookupClass()).a(89212016875309L);
            b = new int[][]{{48, 0}, {97, 7}, {98, 8}, {116, 9}, {9, 9}, {110, 10}, {118, 11}, {102, 12}, {114, 13}, {101, 27}, {32, 32}, {34, 34}, {47, 47}, {92, 92}, {78, 133}, {95, 160}, {76, 8232}, {80, 8233}};
            c = new NotNullLazyValue<Map<Integer, Integer>>(){
                private static final long a = com.jetbrains.python.psi.c.a(3445094876553710406L, 1927731372741706481L, MethodHandles.lookup().lookupClass()).a(142585678753842L);

                @NotNull
                protected Map<Integer, Integer> compute() {
                    HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(b.length);
                    for (int[] nArray : b) {
                        hashMap.put(nArray[0], nArray[1]);
                    }
                    HashMap<Integer, Integer> hashMap2 = hashMap;
                    if (hashMap2 == null) {
                        1.a(0);
                    }
                    return hashMap2;
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x6515799BE55CL;
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl$Escaper$1", "compute"));
                }
            };
            a = new NotNullLazyValue<Map<Integer, Integer>>(){
                private static final long a = com.jetbrains.python.psi.c.a(8776274875111263019L, -3404476455107384875L, MethodHandles.lookup().lookupClass()).a(4816846217561L);

                @NotNull
                protected Map<Integer, Integer> compute() {
                    HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(b.length);
                    for (int[] nArray : b) {
                        hashMap.put(nArray[1], nArray[2]);
                    }
                    HashMap<Integer, Integer> hashMap2 = hashMap;
                    if (hashMap2 == null) {
                        2.a(0);
                    }
                    return hashMap2;
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0xB45B7EF1910L;
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl$Escaper$2", "compute"));
                }
            };
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = d ^ 0x7092B8E23137L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "text";
            objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl$Escaper";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findEscapementLength";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toUnicodeChar";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

