/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;

public class YAMLUtil {
    public static final FileBasedIndex.InputFilter YAML_INPUT_FILTER;
    private static final TokenSet b;
    private static final Logger a;
    private static final long c;

    @Deprecated
    @NotNull
    public static String getFullKey(YAMLKeyValue yamlKeyValue) {
        String string = YAMLUtil.getConfigFullName(yamlKeyValue);
        String string2 = StringUtil.notNullize((String)StringUtil.substringAfter((String)string, (String)"."));
        if (string2 == null) {
            YAMLUtil.a(0);
        }
        return string2;
    }

    @ApiStatus.Experimental
    @NotNull
    public static String getConfigFullName(@NotNull YAMLPsiElement target) {
        if (target == null) {
            YAMLUtil.a(1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        YAMLPsiElement yAMLPsiElement = target;
        while (yAMLPsiElement != null) {
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)yAMLPsiElement, (Class[])new Class[]{YAMLKeyValue.class, YAMLSequenceItem.class});
            if (yAMLPsiElement instanceof YAMLKeyValue) {
                stringBuilder.insert(0, ((YAMLKeyValue)yAMLPsiElement).getKeyText());
                if (psiElement != null) {
                    stringBuilder.insert(0, '.');
                }
            } else if (yAMLPsiElement instanceof YAMLSequenceItem) {
                stringBuilder.insert(0, "[" + ((YAMLSequenceItem)yAMLPsiElement).getItemIndex() + "]");
            }
            yAMLPsiElement = psiElement;
        }
        String string = stringBuilder.toString();
        if (string == null) {
            YAMLUtil.a(2);
        }
        return string;
    }

    @NotNull
    public static Collection<YAMLKeyValue> getTopLevelKeys(YAMLFile file) {
        YAMLValue yAMLValue = file.getDocuments().get(0).getTopLevelValue();
        if (yAMLValue instanceof YAMLMapping) {
            Collection<YAMLKeyValue> collection = ((YAMLMapping)yAMLValue).getKeyValues();
            if (collection == null) {
                YAMLUtil.a(3);
            }
            return collection;
        }
        List<YAMLKeyValue> list2 = Collections.emptyList();
        if (list2 == null) {
            YAMLUtil.a(4);
        }
        return list2;
    }

    @Nullable
    public static YAMLKeyValue getQualifiedKeyInFile(YAMLFile file, List<String> key) {
        return YAMLUtil.getQualifiedKeyInDocument(file.getDocuments().get(0), key);
    }

    @Nullable
    public static YAMLKeyValue getQualifiedKeyInDocument(@NotNull YAMLDocument document, @NotNull List<String> key) {
        long l2 = c ^ 0x490DB5DC1150L;
        if (document == null) {
            YAMLUtil.a(5);
        }
        if (key == null) {
            YAMLUtil.a(6);
        }
        assert (key.size() != 0);
        YAMLMapping yAMLMapping = (YAMLMapping)ObjectUtils.tryCast((Object)document.getTopLevelValue(), YAMLMapping.class);
        for (int i10 = 0; i10 < key.size(); ++i10) {
            if (yAMLMapping == null) {
                return null;
            }
            YAMLKeyValue yAMLKeyValue = yAMLMapping.getKeyValueByKey(key.get(i10));
            if (yAMLKeyValue == null || i10 + 1 == key.size()) {
                return yAMLKeyValue;
            }
            yAMLMapping = (YAMLMapping)ObjectUtils.tryCast((Object)yAMLKeyValue.getValue(), YAMLMapping.class);
        }
        throw new IllegalStateException("Should have returned from the loop");
    }

    @Nullable
    public static YAMLKeyValue getQualifiedKeyInFile(YAMLFile file, String ... key) {
        return YAMLUtil.getQualifiedKeyInFile(file, Arrays.asList(key));
    }

    @Nullable
    public static YAMLKeyValue findKeyInProbablyMapping(@Nullable YAMLValue node, @NotNull String keyText) {
        if (keyText == null) {
            YAMLUtil.a(7);
        }
        if (!(node instanceof YAMLMapping)) {
            return null;
        }
        return ((YAMLMapping)node).getKeyValueByKey(keyText);
    }

    @Nullable
    public static Pair<PsiElement, String> getValue(YAMLFile file, String ... key) {
        YAMLKeyValue yAMLKeyValue = YAMLUtil.getQualifiedKeyInFile(file, key);
        if (yAMLKeyValue != null) {
            YAMLValue yAMLValue = yAMLKeyValue.getValue();
            return Pair.create((Object)yAMLValue, (Object)yAMLKeyValue.getValueText());
        }
        return null;
    }

    public YAMLKeyValue createI18nRecord(YAMLFile file, String key, String text2) {
        long l2 = c ^ 0x62353E99C627L;
        return YAMLUtil.createI18nRecord(file, key.split("\\."), text2);
    }

    @Nullable
    public static YAMLKeyValue createI18nRecord(YAMLFile file, String[] key, String text2) {
        Object object;
        int n2;
        Object object2;
        long l2 = c ^ 0x6A5933EBA531L;
        YAMLDocument yAMLDocument = file.getDocuments().get(0);
        assert (yAMLDocument != null);
        assert (key.length > 0);
        YAMLMapping yAMLMapping = (YAMLMapping)PsiTreeUtil.findChildOfType((PsiElement)yAMLDocument, YAMLMapping.class);
        if (yAMLMapping == null) {
            object2 = YAMLElementGenerator.getInstance(file.getProject()).createDummyYamlWithText(key[0] + ":");
            YAMLMapping yAMLMapping2 = (YAMLMapping)object2.getDocuments().get(0).getTopLevelValue();
            assert (yAMLMapping2 != null);
            yAMLMapping = (YAMLMapping)yAMLDocument.add((PsiElement)yAMLMapping2);
        }
        object2 = yAMLMapping;
        int n3 = key.length;
        for (n2 = 0; n2 < n3; ++n2) {
            Object object3;
            object = object2.getKeyValueByKey(key[n2]);
            if (object != null && (object3 = (YAMLMapping)ObjectUtils.tryCast((Object)object.getValue(), YAMLMapping.class)) != null) {
                object2 = object3;
                continue;
            }
            object3 = StringUtil.repeatSymbol((char)' ', (int)YAMLUtil.getIndentInThisLine((PsiElement)object2));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("---");
            for (int i10 = n2; i10 < n3; ++i10) {
                stringBuilder.append("\n").append((String)object3);
                stringBuilder.append(key[i10]).append(":");
                object3 = (String)object3 + "  ";
            }
            stringBuilder.append(" ").append(text2);
            YAMLFile yAMLFile = YAMLElementGenerator.getInstance(file.getProject()).createDummyYamlWithText(stringBuilder.toString());
            YAMLMapping yAMLMapping3 = (YAMLMapping)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)yAMLFile.getDocuments().get(0)), YAMLMapping.class);
            assert (yAMLMapping3 != null && yAMLMapping3.getKeyValues().size() == 1);
            YAMLKeyValue yAMLKeyValue = yAMLMapping3.getKeyValues().iterator().next();
            object2.putKeyValue(yAMLKeyValue);
            if (!(yAMLKeyValue.getValue() instanceof YAMLMapping)) {
                return yAMLKeyValue;
            }
            object2 = (YAMLMapping)yAMLKeyValue.getValue();
        }
        object = new StringBuilder();
        int n4 = Math.min(n2 + 1, n3);
        for (int i11 = 0; i11 < n4; ++i11) {
            if (((StringBuilder)object).length() > 0) {
                ((StringBuilder)object).append('.');
            }
            ((StringBuilder)object).append(key[i11]);
        }
        throw new IncorrectOperationException(YAMLBundle.message("new.name.conflicts.with", ((StringBuilder)object).toString()));
    }

    public static PsiElement rename(YAMLKeyValue element, String newName) {
        long l2 = c ^ 0x787B3839CB91L;
        if (newName.contains(".")) {
            throw new IncorrectOperationException(YAMLBundle.message("rename.wrong.name"));
        }
        if (newName.equals(element.getName())) {
            throw new IncorrectOperationException(YAMLBundle.message("rename.same.name"));
        }
        YAMLKeyValue yAMLKeyValue = YAMLElementGenerator.getInstance(element.getProject()).createYamlKeyValue(newName, "Foo");
        PsiElement psiElement = element.getKey();
        if (psiElement == null || yAMLKeyValue.getKey() == null) {
            throw new IllegalStateException();
        }
        psiElement.replace(yAMLKeyValue.getKey());
        return element;
    }

    public static int getIndentInThisLine(@NotNull PsiElement elementInLine) {
        if (elementInLine == null) {
            YAMLUtil.a(8);
        }
        PsiElement psiElement = elementInLine;
        while (psiElement != null) {
            IElementType iElementType = psiElement.getNode().getElementType();
            if (iElementType == YAMLTokenTypes.EOL) {
                return 0;
            }
            if (iElementType == YAMLTokenTypes.INDENT) {
                return psiElement.getTextLength();
            }
            psiElement = PsiTreeUtil.prevLeaf((PsiElement)psiElement);
        }
        return 0;
    }

    public static int getIndentToThisElement(@NotNull PsiElement element) {
        long l2 = c ^ 0x223FEE5170C0L;
        if (element == null) {
            YAMLUtil.a(9);
        }
        if (element instanceof YAMLBlockMappingImpl) {
            try {
                element = ((YAMLBlockMappingImpl)element).getFirstKeyValue();
            }
            catch (IllegalStateException illegalStateException) {
                if (!illegalStateException.getMessage().equals("YAML map without any key-value")) {
                    throw illegalStateException;
                }
                a.warn("YAML map without any key-value");
            }
        }
        int n2 = element.getTextOffset();
        PsiElement psiElement = element;
        while (psiElement != null) {
            IElementType iElementType = psiElement.getNode().getElementType();
            if (YAMLElementTypes.EOL_ELEMENTS.contains(iElementType)) {
                return n2 - psiElement.getTextOffset() - 1;
            }
            psiElement = PsiTreeUtil.prevLeaf((PsiElement)psiElement);
        }
        return n2;
    }

    public static void deleteSurroundingWhitespace(@NotNull PsiElement element) {
        if (element == null) {
            YAMLUtil.a(10);
        }
        if (element.getNextSibling() != null) {
            YAMLUtil.a(() -> ((PsiElement)element).getNextSibling(), b);
            YAMLUtil.a(() -> ((PsiElement)element).getNextSibling(), YAMLElementTypes.SPACE_ELEMENTS);
        } else {
            YAMLUtil.a(() -> ((PsiElement)element).getPrevSibling(), YAMLElementTypes.SPACE_ELEMENTS);
        }
    }

    private static void a(@NotNull Supplier<? extends PsiElement> supplier, @NotNull TokenSet tokenSet) {
        if (supplier == null) {
            YAMLUtil.a(11);
        }
        if (tokenSet == null) {
            YAMLUtil.a(12);
        }
        while (supplier.get() != null && tokenSet.contains(PsiUtilCore.getElementType((PsiElement)supplier.get()))) {
            supplier.get().delete();
        }
    }

    static {
        c = com.jetbrains.python.psi.c.a(5015206581322582683L, -4094796804444756948L, MethodHandles.lookup().lookupClass()).a(107084520909590L);
        YAML_INPUT_FILTER = new DefaultFileTypeSpecificInputFilter(new FileType[]{YAMLLanguage.INSTANCE.getAssociatedFileType()});
        b = TokenSet.andNot((TokenSet)YAMLElementTypes.BLANK_ELEMENTS, (TokenSet)YAMLElementTypes.EOL_ELEMENTS);
        a = Logger.getInstance(YAMLUtil.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x65726A77AC98L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/YAMLUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementInLine";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullKey";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/YAMLUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFullName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelKeys";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFullName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedKeyInDocument";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findKeyInProbablyMapping";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIndentInThisLine";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIndentToThisElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteSurroundingWhitespace";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteElementsOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

