/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rvm;

import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.ui.SdkComparator;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.sdk.RVMGemsetDialog;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurableUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkType;
import org.jetbrains.plugins.ruby.utils.OSUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.ConfiguredRvmSdk;
import org.jetbrains.plugins.ruby.version.management.rvm.LocalRvmPathsSettings;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSdkInfo;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkData;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkRefresher;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSettings;

@Deprecated
public class RVMSupportUtil {
    public static final Topic<RVMGemsetListener> RVM_GEMSET_ADDED_TOPIC;
    @NonNls
    public static final String FAKE_NA_GEMSET = "[n/a]";
    @NonNls
    public static final String RUBY = "ruby";
    public static final Key<Object> NEW_RVM_GEMSET_SDK;
    private static final Logger j;
    @NonNls
    private static final String a = "default";
    @NonNls
    public static final String DEFAULT_GEMSET_NAME = "[default]";
    @NonNls
    private static final String c = "ruby";
    @NonNls
    private static final String k = "MY_RUBY_HOME";
    @NonNls
    private static final String l = "system";
    @NonNls
    private static final String e = "macruby";
    @NonNls
    private static final String m = "rbx";
    @NonNls
    private static final String g = "maglev";
    @NonNls
    private static final String i = "ree";
    @NonNls
    private static final String b = "jruby";
    @NonNls
    private static final String h = "ironruby";
    private static final Object d;
    private static final Pattern f;
    private static final long n;

    private RVMSupportUtil() {
    }

    @NotNull
    public static String getGemsetSuffix(@NotNull String gemset) {
        long l2 = n ^ 0x438353A3EE23L;
        if (gemset == null) {
            RVMSupportUtil.a(0);
        }
        String string = " [" + gemset + ']';
        if (string == null) {
            RVMSupportUtil.a(1);
        }
        return string;
    }

    public static boolean isRVMInterpreter(@NotNull String executablePath, @NotNull RvmSettings rvmSettings) {
        long l2 = n ^ 0x6C77DCAB3B53L;
        if (executablePath == null) {
            RVMSupportUtil.a(2);
        }
        if (rvmSettings == null) {
            RVMSupportUtil.a(3);
        }
        if (!rvmSettings.isRvmSupportEnabled()) {
            return false;
        }
        String string = rvmSettings.getRvmHomePath();
        if (string == null) {
            return false;
        }
        return executablePath.startsWith(string + "/" + "rubies");
    }

    public static boolean isRVMInterpreter(@Nullable RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        return versionManagerSdkAdditionalData instanceof RvmSdkData;
    }

    public static boolean isRVMInterpreter(@Nullable Sdk sdk) {
        return RvmSdkData.from(sdk) != null;
    }

    @Deprecated
    public static void patchEnvForRVM(@NotNull Map<String, String> envParams, @NotNull Map<String, String> userDefinedEnvVars, @NotNull Sdk sdk, @NotNull PathMappingSettings mappingSettings) {
        if (envParams == null) {
            RVMSupportUtil.a(4);
        }
        if (userDefinedEnvVars == null) {
            RVMSupportUtil.a(5);
        }
        if (sdk == null) {
            RVMSupportUtil.a(6);
        }
        if (mappingSettings == null) {
            RVMSupportUtil.a(7);
        }
        Collection<String> collection = GemManager.getInstance().getGemRootUrlsForSDK(sdk);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string : collection) {
            if (BundlerUtil.isFakeRVMBundlerGemRootUrl(string)) continue;
            linkedHashSet.add(VirtualFileManager.extractPath((String)string));
        }
        RVMSupportUtil.a(RubySdkAdditionalData.getInterpreterPathFor(sdk), linkedHashSet, envParams, userDefinedEnvVars, sdk, null, mappingSettings);
    }

    public static void patchEnvForRVM(@NotNull String executablePath, @NotNull Set<String> gemsRootsPaths, @NotNull Map<String, String> envParams, @NotNull Map<String, String> userDefinedEnvVars, @Nullable Sdk sdk, @Nullable Map<String, String> defaultEnvVars) {
        if (executablePath == null) {
            RVMSupportUtil.a(8);
        }
        if (gemsRootsPaths == null) {
            RVMSupportUtil.a(9);
        }
        if (envParams == null) {
            RVMSupportUtil.a(10);
        }
        if (userDefinedEnvVars == null) {
            RVMSupportUtil.a(11);
        }
        RVMSupportUtil.a(executablePath, gemsRootsPaths, envParams, userDefinedEnvVars, sdk, defaultEnvVars, new PathMappingSettings());
    }

    private static void a(@NotNull String string, @NotNull Set<String> set, @NotNull Map<String, String> map2, @NotNull Map<String, String> map3, @Nullable Sdk sdk, @Nullable Map<String, String> map4, @NotNull PathMappingSettings pathMappingSettings) {
        if (string == null) {
            RVMSupportUtil.a(12);
        }
        if (set == null) {
            RVMSupportUtil.a(13);
        }
        if (map2 == null) {
            RVMSupportUtil.a(14);
        }
        if (map3 == null) {
            RVMSupportUtil.a(15);
        }
        if (pathMappingSettings == null) {
            RVMSupportUtil.a(16);
        }
        if (sdk == null) {
            return;
        }
        RubySdkAdditionalData rubySdkAdditionalData = RubySdkUtil.getRubySdkAdditionalData(sdk);
        RubySdkSystemAccessor rubySdkSystemAccessor = rubySdkAdditionalData.getSdkSystemAccessor();
        String string2 = !ApplicationManager.getApplication().isUnitTestMode() ? rubySdkSystemAccessor.getPathSeparator() : ":";
        try {
            RvmSdkData rvmSdkData = RvmSdkData.notNullFrom((SdkAdditionalData)rubySdkAdditionalData);
            RVMSupportUtil.a(string, rvmSdkData.getGemsetName(), set, map2, map3, RVMSupportUtil.isGlobalGempathIgnored(sdk), string2, OSUtil.getPathEnvVariableName(rubySdkSystemAccessor), map4, rubySdkAdditionalData.getRvmSettings(), pathMappingSettings);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            j.error((Throwable)illegalArgumentException);
        }
    }

    @Nullable
    public static String getGemsetName(@Nullable Sdk sdk) {
        RvmSdkData rvmSdkData = RvmSdkData.from(sdk);
        return rvmSdkData == null ? null : rvmSdkData.getGemsetName();
    }

    @Nullable
    public static String getGemsetName(@Nullable SdkAdditionalData additionalData) {
        return (String)ObjectUtils.doIfNotNull((Object)RvmSdkData.from(additionalData), rvmSdkData -> rvmSdkData.getGemsetName());
    }

    public static boolean isRvmIgnoreGlobalGemSet(@Nullable Sdk sdk) {
        RvmSdkData rvmSdkData = RvmSdkData.from(sdk);
        return rvmSdkData != null && rvmSdkData.isRVMIgnoreGlobalGemset();
    }

    @NotNull
    public static String getGemsetPresentableName(@Nullable Sdk sdk) {
        long l2 = n ^ 0x728022BA9B0AL;
        if (!RVMSupportUtil.isRVMInterpreter(sdk)) {
            if (FAKE_NA_GEMSET == null) {
                RVMSupportUtil.a(17);
            }
            return FAKE_NA_GEMSET;
        }
        String string = RVMSupportUtil.getGemsetName(sdk);
        String string2 = string == null ? DEFAULT_GEMSET_NAME : string;
        if (string2 == null) {
            RVMSupportUtil.a(18);
        }
        return string2;
    }

    public static RubyDistToGemsetTable getInterpreterDistName2GemSetsTable(@Nullable VirtualFile rvmSdksRoot, @Nullable VirtualFile rvmGemsFolder) {
        if (rvmGemsFolder == null || rvmSdksRoot == null) {
            return RubyDistToGemsetTable.emptyTable();
        }
        RubyDistToGemsetTable rubyDistToGemsetTable = new RubyDistToGemsetTable();
        RVMSupportUtil.a(rvmGemsFolder, rvmSdksRoot).forEach(rVMSdkInfo -> rubyDistToGemsetTable.putGemset(StringUtil.nullize((String)rVMSdkInfo.getGemSet()), rVMSdkInfo.getRubyDistName()));
        return rubyDistToGemsetTable;
    }

    @NotNull
    private static Stream<RVMSdkInfo> a(@NotNull VirtualFile virtualFile3, @NotNull VirtualFile virtualFile4) {
        if (virtualFile3 == null) {
            RVMSupportUtil.a(19);
        }
        if (virtualFile4 == null) {
            RVMSupportUtil.a(20);
        }
        Stream<RVMSdkInfo> stream2 = Arrays.stream(virtualFile3.getChildren()).filter(virtualFile -> virtualFile.isDirectory()).map(virtualFile2 -> {
            String string = virtualFile2.getName();
            String string2 = RVMSupportUtil.getDistName(string);
            if (virtualFile4.findChild(string2) != null) {
                return new RVMSdkInfo(RVMSupportUtil.getGemsetName(string), string2);
            }
            return null;
        }).filter(Objects::nonNull);
        if (stream2 == null) {
            RVMSupportUtil.a(21);
        }
        return stream2;
    }

    public static String getGemsetSeparator() {
        String string;
        long l2 = n ^ 0x6B3D03CDF801L;
        if (SystemInfo.isUnix && (string = EnvironmentUtil.getValue((String)"rvm_gemset_separator")) != null) {
            return string;
        }
        return "@";
    }

    public static boolean isGlobalGempathIgnored(@Nullable Sdk sdk) {
        RvmSdkData rvmSdkData = RvmSdkData.from(sdk);
        return rvmSdkData != null && rvmSdkData.isRVMIgnoreGlobalGemset();
    }

    public static void updateSdk(@Nullable Sdk sdk, boolean ignoreGlobalGemset) {
        if (sdk == null) {
            return;
        }
        if (ignoreGlobalGemset == RVMSupportUtil.isGlobalGempathIgnored(sdk)) {
            return;
        }
        RvmSdkData rvmSdkData = RvmSdkData.from(sdk);
        if (rvmSdkData != null) {
            rvmSdkData.withRVMIgnoreGlobalGemset(ignoreGlobalGemset);
        }
        GemManager.getInstance().softRefreshRoots(sdk, GemUtil.determineGemUrlsForSDK(sdk));
    }

    public static Set<String> determineGemRootsPaths(Sdk sdk) {
        return Sets.newLinkedHashSet((Iterable)Collections2.transform(RVMSupportUtil.determineSdkRootsPaths(sdk), string -> {
            long l2 = n ^ 0x29A7FCEA8EA9L;
            return string + "/gems";
        }));
    }

    public static Set<String> determineSdkRootsPaths(Sdk sdk) {
        long l2 = n ^ 0x425976E2BA3FL;
        try {
            RubySdkAdditionalData rubySdkAdditionalData = RubySdkUtil.getRubySdkAdditionalData(sdk);
            String string = RVMSupportUtil.getGemsetName(sdk);
            Pair<String, String> pair = RVMSupportUtil.getMainAndGlobalGemPaths(rubySdkAdditionalData.getInterpreterPath(sdk), string, rubySdkAdditionalData.getRvmSettings());
            if (pair == null) {
                j.warn("unable to get main and global paths for " + sdk + "\n\tinterpreter path = " + rubySdkAdditionalData.getInterpreterPath(sdk) + "\n\t rvm home = " + rubySdkAdditionalData.getRvmSettings().getRvmHomePath());
                return new LinkedHashSet<String>();
            }
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            linkedHashSet.add((String)pair.first);
            if (!RVMSupportUtil.isRvmIgnoreGlobalGemSet(sdk)) {
                linkedHashSet.add((String)pair.second);
            }
            return linkedHashSet;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            j.error((Throwable)illegalArgumentException);
            return new LinkedHashSet<String>(0);
        }
    }

    @Nullable
    public static String determineMainGemRootPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            RVMSupportUtil.a(22);
        }
        try {
            RubySdkAdditionalData rubySdkAdditionalData = RubySdkUtil.getRubySdkAdditionalData(sdk);
            String string = rubySdkAdditionalData.getInterpreterPath(sdk);
            String string2 = RVMSupportUtil.getGemsetName(sdk);
            Pair<String, String> pair = RVMSupportUtil.getMainAndGlobalGemPaths(string, string2, rubySdkAdditionalData.getRvmSettings());
            return (String)Pair.getFirst(pair);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            j.error((Throwable)illegalArgumentException);
            return null;
        }
    }

    @Nullable
    public static Pair<String, String> determineMainAndGlobalGemPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            RVMSupportUtil.a(23);
        }
        try {
            RubySdkAdditionalData rubySdkAdditionalData = RubySdkUtil.getRubySdkAdditionalData(sdk);
            String string = rubySdkAdditionalData.getInterpreterPath(sdk);
            String string2 = RVMSupportUtil.getGemsetName(sdk);
            Pair<String, String> pair = RVMSupportUtil.getMainAndGlobalGemPaths(string, string2, rubySdkAdditionalData.getRvmSettings());
            if (pair == null) {
                return null;
            }
            return Pair.create((Object)pair.first, !RVMSupportUtil.isRvmIgnoreGlobalGemSet(sdk) ? (String)pair.second : null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            j.error((Throwable)illegalArgumentException);
            return null;
        }
    }

    public static boolean isMRIRubyRvmSdk(@NotNull Sdk sdk) {
        VirtualFile virtualFile;
        long l2 = n ^ 0x55F5DF199C57L;
        if (sdk == null) {
            RVMSupportUtil.a(24);
        }
        if (!RVMSupportUtil.isRVMInterpreter(sdk)) {
            return false;
        }
        VirtualFile virtualFile2 = sdk.getHomeDirectory();
        VirtualFile virtualFile3 = virtualFile2 != null ? virtualFile2.getParent() : null;
        VirtualFile virtualFile4 = virtualFile = virtualFile3 != null ? virtualFile3.getParent() : null;
        if (virtualFile != null) {
            String string = virtualFile.getName();
            return StringUtil.toLowerCase((String)string).startsWith("ruby");
        }
        return false;
    }

    @Nullable
    public static String getCurrentRvmSdkName() {
        long l2 = n ^ 0x44CE4AF5BAF2L;
        if (!SystemInfo.isUnix) {
            return null;
        }
        String string = EnvironmentUtil.getValue((String)k);
        if (StringUtil.isEmpty((String)string)) {
            return null;
        }
        if (string.charAt(string.length() - 1) == File.separatorChar) {
            string = string.substring(0, string.length() - 1);
        }
        String string2 = string.substring(string.lastIndexOf(File.separatorChar) + 1);
        String string3 = EnvironmentUtil.getValue((String)"GEM_HOME");
        int n2 = string3 == null ? -1 : string3.lastIndexOf(RVMSupportUtil.getGemsetSeparator());
        String string4 = n2 == -1 ? null : string3.substring(n2 + 1);
        return StringUtil.isEmpty(string4) ? string2 : string2 + RVMSupportUtil.getGemsetSeparator() + string4;
    }

    @Nullable
    public static ConfiguredRvmSdk splitToRVMDistAndGemset(@NotNull String rubySdkAndGemset, @NotNull String source) {
        String string;
        String string2;
        int n2;
        if (rubySdkAndGemset == null) {
            RVMSupportUtil.a(25);
        }
        if (source == null) {
            RVMSupportUtil.a(26);
        }
        String string3 = (n2 = rubySdkAndGemset.indexOf(string2 = RVMSupportUtil.getGemsetSeparator())) > -1 ? rubySdkAndGemset.substring(0, n2) : rubySdkAndGemset;
        String string4 = string = n2 > -1 ? rubySdkAndGemset.substring(n2 + string2.length()) : null;
        if (StringUtil.isEmpty((String)string3)) {
            return null;
        }
        return new ConfiguredRvmSdk(string3, string, source);
    }

    @Nullable
    public static Sdk findSdkBy(@NotNull String rvmSdkDistName, @Nullable String gemset) {
        long l2 = n ^ 0x63BCE0794EFCL;
        if (rvmSdkDistName == null) {
            RVMSupportUtil.a(27);
        }
        if (l.equals(rvmSdkDistName)) {
            return null;
        }
        String string = "/rubies/" + rvmSdkDistName + "/bin";
        ArrayList<Sdk> arrayList = RubySdkType.getAllValidRubySdks();
        for (Sdk sdk : arrayList) {
            String string2 = sdk.getHomePath();
            assert (string2 != null);
            if (!string2.contains(string) || !RVMSupportUtil.a(gemset, RVMSupportUtil.getGemsetName(sdk))) continue;
            return sdk;
        }
        return null;
    }

    private static void a(@NotNull String string, @Nullable String string2, @NotNull Collection<String> collection, @NotNull Map<String, String> map2, @NotNull Map<String, String> map3, boolean bl2, String string3, String string4, @Nullable Map<String, String> map4, @NotNull RvmSettings rvmSettings, @NotNull PathMappingSettings pathMappingSettings) throws IllegalArgumentException {
        Object object;
        String string5;
        CharSequence charSequence;
        long l2 = n ^ 0x3DD49C51B7BL;
        if (string == null) {
            RVMSupportUtil.a(28);
        }
        if (collection == null) {
            RVMSupportUtil.a(29);
        }
        if (map2 == null) {
            RVMSupportUtil.a(30);
        }
        if (map3 == null) {
            RVMSupportUtil.a(31);
        }
        if (rvmSettings == null) {
            RVMSupportUtil.a(32);
        }
        if (pathMappingSettings == null) {
            RVMSupportUtil.a(33);
        }
        if (collection.size() > 2) {
            throw new IllegalArgumentException("Not more than 2 gems roots are expected here, but was:\n" + collection.toString());
        }
        Pair<String, String> pair = RVMSupportUtil.a(string, rvmSettings);
        String string6 = "Probably you are using unsupported RVM gem version. Ruby interpreter: " + string;
        if (pair == null || pair.second == null) {
            throw new IllegalArgumentException(string6);
        }
        map2.put("rvm_ruby_string", (String)pair.second);
        Pair<String, String> pair2 = RVMSupportUtil.getMainAndGlobalGemPaths(string, string2, rvmSettings);
        if (pair2 == null) {
            throw new IllegalArgumentException(string6);
        }
        String string7 = (String)pair2.first;
        if (RVMSupportUtil.a("gemset", map3, map4)) {
            map2.put("gemset", string2 != null ? string2 : "");
        }
        if (RVMSupportUtil.a("GEM_HOME", map3, map4)) {
            map2.put("GEM_HOME", string7);
        }
        if (RVMSupportUtil.a("BUNDLE_PATH", map3, map4)) {
            map2.remove("BUNDLE_PATH");
        }
        boolean bl3 = "global".equals(string2);
        if (RVMSupportUtil.a("GEM_PATH", map3, map4)) {
            charSequence = new StringBuilder();
            for (String string8 : collection) {
                if (((StringBuilder)charSequence).length() != 0) {
                    ((StringBuilder)charSequence).append(string3);
                }
                if (!(string8 = pathMappingSettings.convertToRemote(string8)).endsWith("/gems")) {
                    throw new IllegalArgumentException("Incorrect gems root: " + string8);
                }
                string5 = string8.substring(0, string8.length() - "/gems".length());
                ((StringBuilder)charSequence).append(string5);
            }
            map2.put("GEM_PATH", ((StringBuilder)charSequence).toString());
        }
        if ((charSequence = RVMSupportUtil.b(string)) == null) {
            throw new IllegalArgumentException("Sdk bin folder can't be null, interpreter path: " + string);
        }
        if (RVMSupportUtil.a(k, map3, map4)) {
            object = RVMSupportUtil.b((String)charSequence);
            if (object == null) {
                throw new IllegalArgumentException("Sdk distributive folder can't be null, interpreter path: " + (String)charSequence);
            }
            map2.put(k, (String)object);
        }
        if (RVMSupportUtil.a("IRBRC", map3, map4)) {
            object = RVMSupportUtil.b((String)charSequence);
            if (object == null) {
                throw new IllegalArgumentException("Sdk distributive folder can't be null, interpreter path: " + (String)charSequence);
            }
            map2.put("IRBRC", (String)object + "/.irbrc");
        }
        if (RVMSupportUtil.a(string4, map3, map4)) {
            String string8;
            object = new StringBuilder();
            ((StringBuilder)object).append((String)charSequence);
            ((StringBuilder)object).append(string3).append(string7).append("/bin");
            if (!bl3 && !bl2) {
                string8 = (String)pair2.second;
                ((StringBuilder)object).append(string3).append(string8).append("/bin");
            }
            string8 = string.substring(0, string.indexOf("/rubies/"));
            ((StringBuilder)object).append(string3).append(string8).append("/bin");
            string5 = map2.get(string4);
            if (string5 != null) {
                ((StringBuilder)object).append(string3).append(string5);
            }
            map2.put(string4, ((StringBuilder)object).toString());
        }
    }

    private static boolean a(@NotNull String string, @NotNull Map<String, String> map2, @Nullable Map<String, String> map3) {
        if (string == null) {
            RVMSupportUtil.a(34);
        }
        if (map2 == null) {
            RVMSupportUtil.a(35);
        }
        if (!map2.containsKey(string)) {
            return true;
        }
        if (map3 != null) {
            String string2 = map2.get(string);
            String string3 = map3.get(string);
            if (string2 == null) {
                return string3 == null;
            }
            return string2.equals(string3);
        }
        return false;
    }

    @Nullable
    private static String b(@Nullable String string) {
        if (string == null) {
            return null;
        }
        int n2 = Math.max(string.lastIndexOf("/"), string.lastIndexOf("\\"));
        return n2 < 0 ? null : string.substring(0, n2);
    }

    @Nullable
    public static Pair<String, String> getMainAndGlobalGemPaths(@NotNull String executablePath, @Nullable String gemSetName, @NotNull RvmSettings rvmSettings) throws IllegalArgumentException {
        String string;
        long l2 = n ^ 0x13B6F9E53993L;
        if (executablePath == null) {
            RVMSupportUtil.a(36);
        }
        if (rvmSettings == null) {
            RVMSupportUtil.a(37);
        }
        if ((string = RVMSupportUtil.getBaseGemsPath(executablePath, rvmSettings)) == null) {
            return null;
        }
        String string2 = RVMSupportUtil.getGemsetSeparator();
        boolean bl2 = gemSetName == null;
        String string3 = bl2 ? string : string + string2 + gemSetName;
        String string4 = string + string2 + "global";
        return Pair.create((Object)string3, (Object)string4);
    }

    @Nullable
    public static String getGemsetName(@NotNull String rvmGemsSubFolder) {
        int n2;
        if (rvmGemsSubFolder == null) {
            RVMSupportUtil.a(38);
        }
        return (n2 = rvmGemsSubFolder.indexOf(RVMSupportUtil.getGemsetSeparator())) == -1 ? null : rvmGemsSubFolder.substring(n2 + 1);
    }

    @NotNull
    public static String getDistName(@NotNull String rvmGemsSubFolder) {
        int n2;
        if (rvmGemsSubFolder == null) {
            RVMSupportUtil.a(39);
        }
        String string = (n2 = rvmGemsSubFolder.indexOf(RVMSupportUtil.getGemsetSeparator())) == -1 ? rvmGemsSubFolder : rvmGemsSubFolder.substring(0, n2);
        if (string == null) {
            RVMSupportUtil.a(40);
        }
        return string;
    }

    @Nullable
    public static String getRVMSdkVersion(@NotNull Sdk sdk) {
        VirtualFile virtualFile;
        if (sdk == null) {
            RVMSupportUtil.a(41);
        }
        if ((virtualFile = sdk.getHomeDirectory()) == null) {
            return null;
        }
        return RvmSdkRefresher.getRvmRubyDistName(virtualFile);
    }

    @Nullable
    public static String determineSuitableRVMSdkDist(@NotNull String rvmrcSdkRef, @Nullable String rvmrcGemset, @NotNull RubyDistToGemsetTable distName2GemsetsTable) {
        if (rvmrcSdkRef == null) {
            RVMSupportUtil.a(42);
        }
        if (distName2GemsetsTable == null) {
            RVMSupportUtil.a(43);
        }
        String string = null;
        for (Map.Entry entry : distName2GemsetsTable.a.entrySet()) {
            String string2 = (String)entry.getKey();
            if (!RVMSupportUtil.sdkRefMatches(rvmrcSdkRef, string2)) continue;
            List list2 = (List)entry.getValue();
            for (String string3 : list2) {
                if (!RVMSupportUtil.a(rvmrcGemset, string3)) continue;
                if (rvmrcSdkRef.equalsIgnoreCase(string2)) {
                    return string2;
                }
                if (VersionComparatorUtil.compare((String)string2, string) <= 0) continue;
                string = string2;
            }
        }
        return string;
    }

    public static boolean sdkRefMatches(@NotNull String sdkRef, @NotNull String distName) {
        long l2 = n ^ 0x21ED8EBF21ECL;
        if (sdkRef == null) {
            RVMSupportUtil.a(44);
        }
        if (distName == null) {
            RVMSupportUtil.a(45);
        }
        if (distName.startsWith(sdkRef)) {
            return true;
        }
        if (StringUtil.isEmptyOrSpaces((String)sdkRef)) {
            return false;
        }
        if (sdkRef.endsWith("-p0")) {
            return RVMSupportUtil.sdkRefMatches(sdkRef.substring(0, sdkRef.length() - 3), distName);
        }
        if (sdkRef.startsWith("1.3") || sdkRef.startsWith("1.4") || sdkRef.startsWith("1.5") || sdkRef.startsWith("1.6") || sdkRef.startsWith("1.7") || sdkRef.matches("^9\\.\\d\\.\\d\\.\\d.*$")) {
            return distName.startsWith("jruby-" + sdkRef);
        }
        if (Character.isDigit(sdkRef.charAt(0))) {
            return distName.startsWith("ruby-" + sdkRef);
        }
        return false;
    }

    private static boolean a(@Nullable String string, @Nullable String string2) {
        long l2 = n ^ 0x813FB1125FCL;
        if (a.equals(string)) {
            string = null;
        }
        if (a.equals(string2)) {
            string2 = null;
        }
        return string == null && string2 == null || string != null && string.equals(string2);
    }

    @Nullable
    public static String getBaseGemsPath(@NotNull String executablePath, @NotNull RvmSettings rvmSettings) throws IllegalArgumentException {
        Pair<String, String> pair;
        if (executablePath == null) {
            RVMSupportUtil.a(46);
        }
        if (rvmSettings == null) {
            RVMSupportUtil.a(47);
        }
        if ((pair = RVMSupportUtil.a(executablePath, rvmSettings)) == null) {
            return null;
        }
        return (String)pair.first + "/" + (String)pair.second;
    }

    @NotNull
    private static Pair<String, String> a(@NotNull RvmSettings rvmSettings, @NotNull String string, @NotNull String string2) {
        VirtualFile virtualFile;
        if (rvmSettings == null) {
            RVMSupportUtil.a(48);
        }
        if (string == null) {
            RVMSupportUtil.a(49);
        }
        if (string2 == null) {
            RVMSupportUtil.a(50);
        }
        if (rvmSettings instanceof LocalRvmPathsSettings && ((LocalRvmPathsSettings)rvmSettings).isMixedMode() && (virtualFile = ((LocalRvmPathsSettings)rvmSettings).getGemsFolder()) != null) {
            Pair pair = Pair.create((Object)virtualFile.getPath(), (Object)string2);
            if (pair == null) {
                RVMSupportUtil.a(51);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)string, (Object)string2);
        if (pair == null) {
            RVMSupportUtil.a(52);
        }
        return pair;
    }

    @Nullable
    private static Pair<String, String> a(@NotNull String string, @NotNull RvmSettings rvmSettings) throws IllegalArgumentException {
        String string2;
        String string3;
        long l2 = n ^ 0x36495B80B175L;
        if (string == null) {
            RVMSupportUtil.a(53);
        }
        if (rvmSettings == null) {
            RVMSupportUtil.a(54);
        }
        if ((string3 = rvmSettings.getRvmHomePath()) == null) {
            return null;
        }
        String string4 = string3 + "/";
        String string5 = string4 + "rubies" + "/";
        if (!string.startsWith(string5)) {
            return null;
        }
        String string6 = string2 = string.startsWith(string5) ? string.substring(string5.length()) : null;
        if (string2 == null) {
            return null;
        }
        String string7 = string2.substring(0, string2.indexOf("/"));
        if (StringUtil.isEmptyOrSpaces((String)string7)) {
            throw new IllegalArgumentException("Unable to fetch ruby distributive name for: " + string);
        }
        return RVMSupportUtil.a(rvmSettings, string4 + "gems", string7);
    }

    @Nullable
    public static RubySdkType getRubySdkType(@NotNull String distName) {
        long l2 = n ^ 0x578B9CED7817L;
        if (distName == null) {
            RVMSupportUtil.a(55);
        }
        if (distName.startsWith("ruby") || distName.startsWith(i) || distName.startsWith(e) || distName.startsWith(m) || distName.startsWith(h) || distName.startsWith(g)) {
            return RubySdkType.getInstance();
        }
        if (distName.startsWith(b)) {
            return JRubySdkType.getInstance();
        }
        return null;
    }

    @Nullable
    public static String getRVMSdkDistName(@NotNull Sdk rvmSdk) {
        if (rvmSdk == null) {
            RVMSupportUtil.a(56);
        }
        return RbenvGemsetManager.getSdkVersion(rvmSdk);
    }

    @Nullable
    public static Sdk findRVMGemsetSdk(@NotNull Sdk rvmSdk, @NotNull String rvmGemset) {
        String string;
        if (rvmSdk == null) {
            RVMSupportUtil.a(57);
        }
        if (rvmGemset == null) {
            RVMSupportUtil.a(58);
        }
        if ((string = RVMSupportUtil.getRVMSdkDistName(rvmSdk)) == null) {
            return null;
        }
        return RVMSupportUtil.findSdkBy(string, rvmGemset);
    }

    @NotNull
    public static Collection<Sdk> getRVMSdks(@NotNull Sdk[] existingSdks) {
        if (existingSdks == null) {
            RVMSupportUtil.a(59);
        }
        List list2 = ContainerUtil.filter((Object[])existingSdks, sdk -> RVMSupportUtil.isRVMInterpreter(sdk) && RVMSupportUtil.getGemsetName(sdk) == null && !RubyRemoteInterpreterManager.getInstance().isRemoteSdk((Sdk)sdk));
        if (list2 == null) {
            RVMSupportUtil.a(60);
        }
        return list2;
    }

    public static boolean isNewRVMGemsetSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            RVMSupportUtil.a(61);
        }
        return sdk.getUserData(NEW_RVM_GEMSET_SDK) != null;
    }

    public static void unmarkNewRVMGemsetSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            RVMSupportUtil.a(62);
        }
        sdk.putUserData(NEW_RVM_GEMSET_SDK, null);
    }

    @Nullable
    public static Sdk getPreferableRVMSdk(@Nullable Project project, @NotNull Sdk[] sdksOfType, @Nullable Sdk selectedSdk) {
        Sdk sdk;
        if (sdksOfType == null) {
            RVMSupportUtil.a(63);
        }
        if (RVMSupportUtil.isLocalRootRVMSdk(selectedSdk)) {
            return selectedSdk;
        }
        Collection<Sdk> collection = RVMSupportUtil.getRVMSdks(sdksOfType);
        if (RVMSupportUtil.getGemsetName(selectedSdk) != null && RVMSupportUtil.isLocalRootRVMSdk(sdk = RVMSupportUtil.findRootRVMSdk(selectedSdk, collection))) {
            return sdk;
        }
        if (project != null && RVMSupportUtil.isLocalRootRVMSdk(sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk())) {
            return sdk;
        }
        sdk = ProjectRootManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).getProjectSdk();
        if (RVMSupportUtil.isLocalRootRVMSdk(sdk)) {
            return sdk;
        }
        return collection.stream().min(SdkComparator.SDK_COMPARATOR).orElse(null);
    }

    public static List<Sdk> getSortedRVMSdks(@NotNull Sdk[] existingSdks) {
        if (existingSdks == null) {
            RVMSupportUtil.a(64);
        }
        return ContainerUtil.sorted(RVMSupportUtil.getRVMSdks(existingSdks), (Comparator)SdkComparator.SDK_COMPARATOR);
    }

    public static void showNewRVMGemsetDialog(@Nullable Project project, @Nullable Sdk initSelectedSdk, @NotNull Sdk[] allSdks, @NotNull NullableConsumer<? super Sdk> consumer) {
        long l2 = n ^ 0x55CD7189522BL;
        if (allSdks == null) {
            RVMSupportUtil.a(65);
        }
        if (consumer == null) {
            RVMSupportUtil.a(66);
        }
        if (initSelectedSdk == null) {
            j.warn("No RVM sdks were found.");
            return;
        }
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        RVMGemsetDialog rVMGemsetDialog = new RVMGemsetDialog(project, allSdks, initSelectedSdk);
        dialogBuilder.setCenterPanel((JComponent)rVMGemsetDialog.getMainPanel());
        dialogBuilder.setOkOperation(() -> {
            Sdk sdk;
            long l2 = n ^ 0x1815516CB6B8L;
            String string = rVMGemsetDialog.getRVMGemsetName();
            if (!RVMSupportUtil.a(dialogBuilder, string, sdk = rVMGemsetDialog.getSelectedSdk())) {
                return;
            }
            if (sdk == null) {
                j.warn("For some reason sdk isn't selected.");
                return;
            }
            dialogBuilder.getDialogWrapper().close(0);
            Sdk sdk2 = RVMSupportUtil.a(string, sdk);
            if (project != null) {
                ((RVMGemsetListener)project.getMessageBus().syncPublisher(RVM_GEMSET_ADDED_TOPIC)).onNewRVMGemsetAdded(sdk2);
            }
            consumer.consume((Object)sdk2);
        });
        dialogBuilder.setPreferredFocusComponent(rVMGemsetDialog.getRVMGemsetTextField());
        dialogBuilder.addOkAction();
        dialogBuilder.addCancelAction();
        dialogBuilder.setTitle(RBundle.message("ruby.ide.sdk.configurable.create.rvm.gemset.dialog.title"));
        dialogBuilder.setHelpId("rvm.new.gemset.dialog");
        dialogBuilder.show();
    }

    private static Sdk a(@NotNull String string, @NotNull Sdk sdk) {
        if (string == null) {
            RVMSupportUtil.a(67);
        }
        if (sdk == null) {
            RVMSupportUtil.a(68);
        }
        RubySdkAdditionalData rubySdkAdditionalData = new RubySdkAdditionalData(RubySdkAdditionalData.notNullFrom(sdk));
        RvmSdkData rvmSdkData = RvmSdkData.notNullFrom((SdkAdditionalData)rubySdkAdditionalData).withGemsetName(string);
        VirtualFile virtualFile = sdk.getHomeDirectory();
        VirtualFile virtualFile2 = virtualFile != null ? virtualFile.getParent() : null;
        VirtualFile virtualFile3 = virtualFile2 != null ? virtualFile2.getParent() : null;
        String string2 = RubySdkType.getInstance().createSdkName(sdk.getHomePath(), virtualFile3 != null ? virtualFile3 : virtualFile, rvmSdkData);
        ProjectJdkImpl projectJdkImpl = new ProjectJdkImpl(string2, (SdkTypeId)RubySdkType.getInstance(), sdk.getHomePath(), sdk.getVersionString());
        SdkModificator sdkModificator = projectJdkImpl.getSdkModificator();
        sdkModificator.setHomePath(sdk.getHomePath());
        sdkModificator.setSdkAdditionalData((SdkAdditionalData)rubySdkAdditionalData);
        sdkModificator.commitChanges();
        projectJdkImpl.putUserData(NEW_RVM_GEMSET_SDK, d);
        return projectJdkImpl;
    }

    private static boolean a(@NotNull DialogBuilder dialogBuilder, @NotNull String string, @Nullable Sdk sdk) {
        long l2 = n ^ 0x698510621D5EL;
        if (dialogBuilder == null) {
            RVMSupportUtil.a(69);
        }
        if (string == null) {
            RVMSupportUtil.a(70);
        }
        if (!f.matcher(string).matches()) {
            dialogBuilder.setErrorText(RBundle.message("ruby.ide.sdk.configurable.create.rvm.gemset.validation.failed"));
            return false;
        }
        if (sdk == null) {
            dialogBuilder.setErrorText(RBundle.message("ruby.ide.sdk.configurable.create.rvm.gemset.no.sdk"));
            return false;
        }
        if (RVMSupportUtil.findRVMGemsetSdk(sdk, string) != null) {
            dialogBuilder.setErrorText(RBundle.message("ruby.ide.sdk.configurable.create.rvm.gemset.already.exists", string, sdk.getName()));
            return false;
        }
        return true;
    }

    public static boolean isLocalRootRVMSdk(@Nullable Sdk initSelectedSdk) {
        return RVMSupportUtil.isRVMInterpreter(initSelectedSdk) && RVMSupportUtil.getGemsetName(initSelectedSdk) == null && !RubyRemoteInterpreterManager.getInstance().isRemoteSdk(initSelectedSdk);
    }

    @Nullable
    public static Sdk findRootRVMSdk(@NotNull Sdk rvmSdk, @NotNull Collection<? extends Sdk> sdks) {
        if (rvmSdk == null) {
            RVMSupportUtil.a(71);
        }
        if (sdks == null) {
            RVMSupportUtil.a(72);
        }
        return (Sdk)ContainerUtil.find(sdks, sdk2 -> StringUtil.equals((CharSequence)rvmSdk.getHomePath(), (CharSequence)sdk2.getHomePath()) && RVMSupportUtil.getGemsetName(sdk2) == null);
    }

    public static boolean isRvmSdk(@NotNull File interpreterFile) {
        File file;
        long l2 = n ^ 0x5198BA6518B8L;
        if (interpreterFile == null) {
            RVMSupportUtil.a(73);
        }
        if ((file = interpreterFile.getParentFile()) == null) {
            return false;
        }
        return "gems".equals(file.getName());
    }

    static {
        n = com.jetbrains.python.psi.c.a(-5525935526226432118L, -2554717005564607302L, MethodHandles.lookup().lookupClass()).a(116357115092857L);
        long l2 = n ^ 0x600C5EC0172AL;
        RVM_GEMSET_ADDED_TOPIC = Topic.create((String)"RVM gemset added", RVMGemsetListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.NONE);
        NEW_RVM_GEMSET_SDK = Key.create((String)"NEW_RVM_GEMSET_SDK");
        j = Logger.getInstance(RubySdkConfigurableUtil.class);
        d = new Object();
        f = Pattern.compile("[-_.A-Za-z0-9]+");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = n ^ 0x4AA03D5102E4L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 17: 
            case 18: 
            case 21: 
            case 40: 
            case 51: 
            case 52: 
            case 60: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 17: 
            case 18: 
            case 21: 
            case 40: 
            case 51: 
            case 52: 
            case 60: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemset";
                break;
            }
            case 1: 
            case 17: 
            case 18: 
            case 21: 
            case 40: 
            case 51: 
            case 52: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rvm/RVMSupportUtil";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 28: 
            case 36: 
            case 46: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 3: 
            case 32: 
            case 37: 
            case 47: 
            case 48: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmSettings";
                break;
            }
            case 4: 
            case 10: 
            case 14: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envParams";
                break;
            }
            case 5: 
            case 11: 
            case 15: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userDefinedEnvVars";
                break;
            }
            case 6: 
            case 22: 
            case 23: 
            case 24: 
            case 41: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: 
            case 16: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingSettings";
                break;
            }
            case 9: 
            case 13: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsRootsPaths";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsFolder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distFolder";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubySdkAndGemset";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmSdkDistName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVariable";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmGemsSubFolder";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmrcSdkRef";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distName2GemsetsTable";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkRef";
                break;
            }
            case 45: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distName";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dist";
                break;
            }
            case 56: 
            case 57: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmSdk";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmGemset";
                break;
            }
            case 59: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdksOfType";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSdks";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmGemsetName";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootRVMSdk";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogBuilder";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RVMSupportUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsetSuffix";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsetPresentableName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsetsForSdk";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistName";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "mixedModeGemPathUpdate";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getRVMSdks";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetSuffix";
                break;
            }
            case 1: 
            case 17: 
            case 18: 
            case 21: 
            case 40: 
            case 51: 
            case 52: 
            case 60: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRVMInterpreter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "patchEnvForRVM";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "patchEnvForRvmImpl";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetsForSdk";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "determineMainGemRootPath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "determineMainAndGlobalGemPaths";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isMRIRubyRvmSdk";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "splitToRVMDistAndGemset";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findSdkBy";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "canOverride";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getMainAndGlobalGemPaths";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getGemsetName";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getDistName";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getRVMSdkVersion";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "determineSuitableRVMSdkDist";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "sdkRefMatches";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getBaseGemsPath";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "mixedModeGemPathUpdate";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getRVMGemsRootAndDistName";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getRubySdkType";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getRVMSdkDistName";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findRVMGemsetSdk";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getRVMSdks";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isNewRVMGemsetSdk";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "unmarkNewRVMGemsetSdk";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getPreferableRVMSdk";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getSortedRVMSdks";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "showNewRVMGemsetDialog";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createRVMGemsetMockSdk";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "checkValid";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "findRootRVMSdk";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isRvmSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 17: 
            case 18: 
            case 21: 
            case 40: 
            case 51: 
            case 52: 
            case 60: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RubyDistToGemsetTable {
        private final Map<String, List<String>> a;

        public RubyDistToGemsetTable() {
            this(new HashMap<String, List<String>>());
        }

        private RubyDistToGemsetTable(Map<String, List<String>> tableImpl) {
            this.a = tableImpl;
        }

        public void putGemset(String gemsetName, String distName) {
            List<String> list2 = this.a.get(distName);
            if (list2 == null) {
                list2 = new ArrayList<String>(1);
                this.a.put(distName, list2);
            }
            list2.add(gemsetName);
        }

        public boolean isEmpty() {
            return this.a.isEmpty();
        }

        public List<String> getGemsets(String distName) {
            return this.a.get(distName);
        }

        public static RubyDistToGemsetTable emptyTable() {
            return new RubyDistToGemsetTable(Collections.emptyMap());
        }
    }

    public static interface RVMGemsetListener {
        public void onNewRVMGemsetAdded(@NotNull Sdk var1);
    }

    public static interface Constants {
        public static final String LOCAL_RVM_HOME_FOLDER_NAME = ".rvm";
        public static final String RVM_GEMS_FOLDER_NAME = "gems";
        public static final String RVM_RUBIES_FOLDER_NAME = "rubies";
        public static final String RVM_BIN_FOLDER_RELATIVE_PATH = "/bin";
        public static final String RVM_EXECUTABLE = "rvm";
        public static final String DEFAULT_GEMSET_SEPARATOR = "@";
        public static final String RVM_GEMSET_SEPARATOR_ENVVAR = "rvm_gemset_separator";
        public static final String GLOBAL_GEMSET_NAME = "global";
        public static final String GEM_PATH = "GEM_PATH";
        public static final String GEM_HOME = "GEM_HOME";
        @Deprecated
        public static final String BUNDLE_PATH = "BUNDLE_PATH";
        public static final String MY_RUBY_HOME = "MY_RUBY_HOME";
        public static final String GEMS_ROOT_RELATIVE_PATH = "/gems";
        public static final String RVM_RUBY_STRING = "rvm_ruby_string";
        public static final String RVM_GEMSET = "gemset";
        public static final String IRBRC = "IRBRC";
    }
}

