/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rvm;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkRefresher;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSettings;

public class LocalRvmPathsSettings
implements RvmSettings {
    public static final String SHARE_RVM_PATH = "/usr/share/rvm";
    private static final Logger h;
    private static final String[] a;
    private static final String d = "export rvm_gems_path=\"${HOME}/.rvm/gems\"";
    private AtomicNullableLazyValue<VirtualFile> g;
    private VirtualFile c;
    private RVMInstallationType f = RVMInstallationType.SINGLE;
    private AtomicNullableLazyValue<VirtualFile> e;
    private AtomicNullableLazyValue<VirtualFile> i;
    private String b;
    private static final long j;

    public LocalRvmPathsSettings() {
        this.j();
    }

    private void j() {
        this.g = AtomicNullableLazyValue.createValue(() -> this.f());
        this.e = AtomicNullableLazyValue.createValue(() -> this.a());
        this.i = AtomicNullableLazyValue.createValue(() -> this.h());
    }

    @Nullable
    public VirtualFile getRvmHome() {
        return this.c != null ? this.c : LocalRvmPathsSettings.a(this.g);
    }

    @Nullable
    public VirtualFile getInterpretersFolder() {
        return LocalRvmPathsSettings.a(this.i);
    }

    public void setRvmHome(@Nullable VirtualFile rvmHomeDir) {
        long l2 = j ^ 0x3F8534D78423L;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new UnsupportedOperationException("This method is only for testing purposes");
        }
        this.c = rvmHomeDir;
    }

    @Nullable
    private VirtualFile h() {
        long l2 = j ^ 0x683B09C809F3L;
        VirtualFile virtualFile = this.getRvmHome();
        return virtualFile == null ? null : virtualFile.findChild("rubies");
    }

    @Nullable
    public VirtualFile getGemsFolder() {
        return LocalRvmPathsSettings.a(this.e);
    }

    @Nullable
    private static <T> T a(@NotNull AtomicNullableLazyValue<T> atomicNullableLazyValue) {
        long l2 = j ^ 0x48E56A454D43L;
        if (atomicNullableLazyValue == null) {
            LocalRvmPathsSettings.a(0);
        }
        if (RvmSdkRefresher.isInitialized()) {
            return (T)atomicNullableLazyValue.getValue();
        }
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread() && application.isReadAccessAllowed()) {
            h.error("Potential ReadAction deadlock avoided.");
            return null;
        }
        return (T)atomicNullableLazyValue.getValue();
    }

    @Nullable
    public VirtualFile getRvmExecutable() {
        long l2 = j ^ 0x385D0A209C33L;
        VirtualFile virtualFile = this.getRvmHome();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile.findChild("/bin");
        if (virtualFile2 == null || !virtualFile2.isDirectory()) {
            return null;
        }
        return virtualFile2.findChild("rvm");
    }

    @Override
    @Nullable
    public String getRvmHomePath() {
        return this.b != null ? this.b : (String)ObjectUtils.doIfNotNull((Object)this.getRvmHome(), VirtualFile::getPath);
    }

    public void setRvmHomePath(@Nullable String path) {
        long l2 = j ^ 0x57C92B652B46L;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new UnsupportedOperationException("This method is only for testing purposes");
        }
        this.b = path;
    }

    public void tearDown() {
        this.c = null;
        this.b = null;
        this.j();
        this.f = RVMInstallationType.SINGLE;
    }

    public boolean isMixedMode() {
        return this.f == RVMInstallationType.MIXED_MODE;
    }

    private boolean l() {
        long l2 = j ^ 0xECD86A0D757L;
        VirtualFile virtualFile = VfsUtil.getUserHomeDir();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile.findChild(".rvmrc");
        if (virtualFile2 == null) {
            return false;
        }
        String string = RvmSdkRefresher.loadText(virtualFile2);
        if (string != null && StringUtil.contains((CharSequence)string, (CharSequence)d)) {
            this.f = RVMInstallationType.MIXED_MODE;
            return true;
        }
        return false;
    }

    @Nullable
    private VirtualFile a() {
        VirtualFile virtualFile;
        long l2 = j ^ 0x49052A484DEAL;
        if (this.isMixedMode() && (virtualFile = LocalRvmPathsSettings.e()) != null) {
            VirtualFile virtualFile2 = virtualFile.findChild("gems");
            if (virtualFile2 != null) {
                return virtualFile2;
            }
            h.warn("Cannot find gems folder for Mixed Mode installed RVM in /usr/share/rvm");
        }
        return (virtualFile = this.getRvmHome()) == null ? null : virtualFile.findChild("gems");
    }

    private void c() {
        this.f = RVMInstallationType.MULTI_USER;
        this.l();
    }

    @Nullable
    private VirtualFile f() {
        long l2 = j ^ 0x6F1B33F12D3DL;
        if (SystemInfo.isWindows) {
            return null;
        }
        String string = LocalRvmPathsSettings.g();
        if (string != null) {
            VirtualFile virtualFile;
            String string2 = VirtualFileUtil.constructLocalUrl(string);
            if (string.startsWith(SHARE_RVM_PATH)) {
                this.c();
            }
            if ((virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(string2)) == null) {
                h.warn("Cannot find custom rvm home directory: " + string);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = LocalRvmPathsSettings.d();
        if (virtualFile != null) {
            this.c();
            return virtualFile;
        }
        virtualFile = LocalRvmPathsSettings.e();
        if (virtualFile != null) {
            return virtualFile;
        }
        String string3 = LocalRvmPathsSettings.i();
        if (string3 != null) {
            h.info("System wide RVM detected: " + string3);
            String string4 = VirtualFileUtil.constructLocalUrl(string3);
            virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(string4);
            if (virtualFile == null) {
                h.warn("Cannot find rvm home directory: " + string3);
            }
            return virtualFile;
        }
        h.info("RVM installation wasn't detected.");
        return null;
    }

    @Override
    public boolean isRvmSupportEnabled() {
        if (!SystemInfo.isUnix) {
            return false;
        }
        VirtualFile virtualFile = this.getInterpretersFolder();
        return virtualFile != null && virtualFile.isDirectory();
    }

    public static LocalRvmPathsSettings getInstance() {
        return (LocalRvmPathsSettings)ServiceManager.getService(LocalRvmPathsSettings.class);
    }

    @Nullable
    private static VirtualFile d() {
        long l2 = j ^ 0x303B13AD6AA3L;
        String string = FileUtil.toSystemIndependentName((String)SHARE_RVM_PATH);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string);
        if (virtualFile != null) {
            virtualFile.refresh(false, false);
            VirtualFile[] virtualFileArray = virtualFile.getChildren();
            if (virtualFileArray != null && virtualFileArray.length != 0) {
                return virtualFile;
            }
            h.warn("Local share folder is empty: " + virtualFile.getPath() + ". Looking for local rvm installation.");
        }
        return virtualFile;
    }

    @Nullable
    private static VirtualFile e() {
        long l2 = j ^ 0x7816D4B7B5AAL;
        VirtualFile virtualFile = VfsUtil.getUserHomeDir();
        if (virtualFile == null) {
            h.warn("Cannot find User home folder: " + SystemProperties.getUserHome());
            return null;
        }
        virtualFile.refresh(false, false);
        VirtualFile virtualFile2 = virtualFile.findChild(".rvm");
        if (virtualFile2 != null) {
            virtualFile2.refresh(false, false);
            VirtualFile[] virtualFileArray = virtualFile2.getChildren();
            if (virtualFileArray != null && virtualFileArray.length != 0) {
                return virtualFile2;
            }
            h.warn("Local .rvm folder is empty: " + virtualFile2.getPath() + ". Looking for system-wide installation.");
        }
        return virtualFile2;
    }

    @Nullable
    private static String g() {
        long l2 = j ^ 0x6CCDBAE4D6FFL;
        if (SystemInfo.isWindows) {
            throw new UnsupportedOperationException("RVM support isn't implemented for Windows");
        }
        String string = EnvironmentUtil.getValue((String)"rvm_path");
        return !StringUtil.isEmpty((String)string) ? string : null;
    }

    @Nullable
    private static String i() {
        long l2 = j ^ 0x3E243CE996B7L;
        if (SystemInfo.isWindows) {
            throw new UnsupportedOperationException("RVM support isn't implemented for Windows");
        }
        for (String string : a) {
            String string2 = string + "/" + "rubies";
            File file = new File(string2);
            if (!file.exists()) continue;
            return string;
        }
        return null;
    }

    static {
        j = com.jetbrains.python.psi.c.a(4878089933648840849L, -2494063348362188395L, MethodHandles.lookup().lookupClass()).a(230714514897825L);
        long l2 = j ^ 0x141A634D0C1EL;
        h = Logger.getInstance(LocalRvmPathsSettings.class);
        a = new String[]{"/usr/local/rvm"};
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = j ^ 0x7C36A05A0F5DL;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lazyValue", "org/jetbrains/plugins/ruby/version/management/rvm/LocalRvmPathsSettings", "getLazyValueSafely"));
    }

    static final class RVMInstallationType
    extends Enum<RVMInstallationType> {
        public static final /* enum */ RVMInstallationType SINGLE;
        public static final /* enum */ RVMInstallationType MULTI_USER;
        public static final /* enum */ RVMInstallationType MIXED_MODE;
        private static final /* synthetic */ RVMInstallationType[] a;

        public static RVMInstallationType[] values() {
            return (RVMInstallationType[])a.clone();
        }

        public static RVMInstallationType valueOf(String name) {
            return Enum.valueOf(RVMInstallationType.class, name);
        }

        static {
            long l2 = com.jetbrains.python.psi.c.a(1192768227078037269L, -7468076899892404241L, MethodHandles.lookup().lookupClass()).a(224063130516233L) ^ 0x2A927697D413L;
            SINGLE = new RVMInstallationType();
            MULTI_USER = new RVMInstallationType();
            MIXED_MODE = new RVMInstallationType();
            a = new RVMInstallationType[]{SINGLE, MULTI_USER, MIXED_MODE};
        }
    }
}

