/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandlerBase;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;

public interface SdkRefresher {
    public static final ExtensionPointName<SdkRefresher> EP_NAME;
    public static final long v;

    @Contract(value="null -> false")
    public boolean isManagedSdk(@Nullable Sdk var1);

    public void refreshSDKs();

    public void refreshAsynchronously();

    @Nullable
    public String suggestSdkName(@NotNull String var1, @NotNull String var2, @NotNull RubyVersionManagerSdkData var3);

    public void initializeIfNecessary();

    default public void onProjectOpened(@NotNull Project project) {
        if (project == null) {
            SdkRefresher.a(0);
        }
    }

    @Contract(pure=true)
    @Nullable
    public RubyVersionManagerHandlerBase getVersionManagerHandler();

    public static void refreshAll() {
        long l2 = v ^ 0x64C176985273L;
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> SdkRefresher.forEach(sdkRefresher -> {
            sdkRefresher.initializeIfNecessary();
            sdkRefresher.refreshSDKs();
        }), RBundle.message("ruby.sdk.scanning"), true, null);
    }

    public static void forEach(@NotNull Consumer<? super SdkRefresher> action) {
        if (action == null) {
            SdkRefresher.a(1);
        }
        SdkRefresher.getRefreshers().forEach(action);
    }

    public static boolean isAutoRefreshable(@Nullable Sdk sdk) {
        return SdkRefresher.getRefreshers().stream().anyMatch(sdkRefresher -> sdkRefresher.isManagedSdk(sdk));
    }

    @NotNull
    public static List<? extends SdkRefresher> getRefreshers() {
        List list2 = EP_NAME.getExtensionList();
        if (list2 == null) {
            SdkRefresher.a(2);
        }
        return list2;
    }

    static {
        v = c.a(816816645422325591L, -4935537327493493280L, MethodHandles.lookup().lookupClass()).a(177587779944811L);
        long l2 = v ^ 0x6104535B50C1L;
        EP_NAME = new ExtensionPointName("org.jetbrains.plugins.ruby.rubySdkRefresher");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = v ^ 0x220D9502762L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/SdkRefresher";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/SdkRefresher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefreshers";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpened";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

