/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandlerBase;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkDataBase;
import org.jetbrains.plugins.ruby.version.management.SdkRefresher;

public abstract class AbstractSdkRefresher
implements SdkRefresher {
    protected final Logger myLog;
    private final AtomicNullableLazyValue<Boolean> a;
    @Nullable
    private String c;
    private final MergingUpdateQueue d;
    private final AtomicInteger b;
    private static final long u = com.jetbrains.python.psi.c.a(-2129755121997261186L, 987305138260343523L, MethodHandles.lookup().lookupClass()).a(71859878658319L);

    public AbstractSdkRefresher() {
        long l2 = u ^ 0x6901B17E2E91L;
        this.myLog = Logger.getInstance(this.getClass());
        this.a = AtomicNullableLazyValue.createValue(() -> {
            Application application = ApplicationManager.getApplication();
            if (!application.isUnitTestMode()) {
                this.myLog.assertTrue(!application.isDispatchThread());
                this.myLog.assertTrue(!application.isReadAccessAllowed());
            }
            this.doInitialize();
            return null;
        });
        this.c = null;
        this.d = new MergingUpdateQueue("SDK auto-refreshes", 300, true, null, (Disposable)ApplicationManager.getApplication(), null, false);
        this.b = new AtomicInteger();
    }

    @Override
    public final void initializeIfNecessary() {
        this.a.getValue();
    }

    protected abstract void doInitialize();

    @Override
    public final void refreshAsynchronously() {
        long l2 = u ^ 0x2D432349DA44L;
        this.d.queue(Update.create((Object)"update", () -> {
            if (this.b.get() > 0 && !ApplicationManager.getApplication().isUnitTestMode()) {
                this.refreshAsynchronously();
            } else {
                this.refreshSDKs();
            }
        }));
    }

    @Override
    public void refreshSDKs() {
        this.b.incrementAndGet();
        try {
            this.doRefreshSDKs();
        }
        finally {
            this.b.decrementAndGet();
        }
    }

    protected abstract void doRefreshSDKs();

    protected final void cancelQueuedUpdates() {
        this.d.cancelAllUpdates();
    }

    @Nullable
    public String getUserDefinedPath() {
        return this.c;
    }

    @NotNull
    protected final Set<String> getVersionManagerPathsFromExistingSdks() {
        Set<String> set = Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).filter(this::isManagedSdk).map(RubyVersionManagerSdkData::from).filter(rubyVersionManagerSdkData -> rubyVersionManagerSdkData instanceof RubyVersionManagerSdkDataBase && ((RubyVersionManagerSdkDataBase)rubyVersionManagerSdkData).hasVersionManagerPath()).map(rubyVersionManagerSdkData -> ((RubyVersionManagerSdkDataBase)rubyVersionManagerSdkData).getVersionManagerPath()).collect(Collectors.toSet());
        if (set == null) {
            AbstractSdkRefresher.b(0);
        }
        return set;
    }

    protected final void addCustomPathAndRefresh(@NotNull VirtualFile userFile) {
        long l2 = u ^ 0x3212EEFB29C2L;
        if (userFile == null) {
            AbstractSdkRefresher.b(1);
        }
        this.c = userFile.getPath();
        ProgressManager.getInstance().run((Task)new Task.Modal(null, RBundle.message("version.manager.refreshing.sdks"), false){
            private static final long a = com.jetbrains.python.psi.c.a(1932077760337945994L, -5037817506078097355L, MethodHandles.lookup().lookupClass()).a(243225724925641L);

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.a(0);
                }
                AbstractSdkRefresher.this.refreshSDKs();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x2400DE6D667DL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/version/management/AbstractSdkRefresher$1", "run"));
            }
        });
    }

    public static void chooseCustomManagerLocation(@Nullable Project project) {
        HashMap hashMap = new HashMap();
        SdkRefresher.forEach(sdkRefresher -> {
            if (!(sdkRefresher instanceof AbstractSdkRefresher)) {
                return;
            }
            RubyVersionManagerHandlerBase rubyVersionManagerHandlerBase = sdkRefresher.getVersionManagerHandler();
            if (rubyVersionManagerHandlerBase != null) {
                hashMap.put(rubyVersionManagerHandlerBase.getVersionManagerExecutableName(), (AbstractSdkRefresher)sdkRefresher);
            }
        });
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false).withFileFilter(virtualFile -> hashMap.containsKey(virtualFile.getName()));
        VirtualFile virtualFile2 = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Project)project, null);
        if (virtualFile2 == null || !virtualFile2.isValid()) {
            return;
        }
        String string = virtualFile2.getName();
        AbstractSdkRefresher abstractSdkRefresher = (AbstractSdkRefresher)hashMap.get(string);
        if (abstractSdkRefresher != null) {
            abstractSdkRefresher.addCustomPathAndRefresh(virtualFile2);
        }
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = u ^ 0x1863927F920AL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/AbstractSdkRefresher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionManagerPathsFromExistingSdks";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/AbstractSdkRefresher";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addCustomPathAndRefresh";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

