/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.util.Processor;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileUtil {
    @NonNls
    public static final char VFS_PATH_SEPARATOR = '/';
    private static final long a = c.a(5970169092683653165L, 6624425384676965811L, MethodHandles.lookup().lookupClass()).a(274897137725733L);

    private VirtualFileUtil() {
    }

    @Nullable
    public static VirtualFile findFileBy(@NotNull String path) {
        VirtualFile virtualFile;
        if (path == null) {
            VirtualFileUtil.a(0);
        }
        if ((virtualFile = LocalFileSystem.getInstance().findFileByPath(path)) != null) {
            return virtualFile;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return TempFileSystem.getInstance().findFileByPath(path);
        }
        return null;
    }

    public static String constructLocalUrl(@NotNull String path) {
        long l2 = a ^ 0xA01BC277DF5L;
        if (path == null) {
            VirtualFileUtil.a(1);
        }
        if (path.startsWith("file://")) {
            return path;
        }
        return VfsUtilCore.pathToUrl((String)path);
    }

    @NotNull
    public static Collection<String> convertPathsToLocalUrls(@NotNull Collection<String> paths) {
        if (paths == null) {
            VirtualFileUtil.a(2);
        }
        if (paths.isEmpty()) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                VirtualFileUtil.a(3);
            }
            return list2;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : paths) {
            arrayList.add(VirtualFileUtil.constructLocalUrl(string));
        }
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            VirtualFileUtil.a(4);
        }
        return arrayList2;
    }

    public static int compareVirtualFiles(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            VirtualFileUtil.a(5);
        }
        if (file2 == null) {
            VirtualFileUtil.a(6);
        }
        String string = file1.getPath();
        String string2 = file2.getPath();
        return string.compareToIgnoreCase(string2);
    }

    public static boolean isValid(@Nullable VirtualFile file) {
        return file != null && file.isValid();
    }

    @NotNull
    public static String buildUrl(@NotNull String rootUrl, @NotNull String relativePath) {
        if (rootUrl == null) {
            VirtualFileUtil.a(7);
        }
        if (relativePath == null) {
            VirtualFileUtil.a(8);
        }
        String string = rootUrl + (rootUrl.endsWith(String.valueOf('/')) ? "" : Character.valueOf('/')) + FileUtil.toSystemIndependentName((String)relativePath);
        if (string == null) {
            VirtualFileUtil.a(9);
        }
        return string;
    }

    public static String buildSystemIndependentPath(@NotNull String rootPath, @NotNull String relativePath) {
        if (rootPath == null) {
            VirtualFileUtil.a(10);
        }
        if (relativePath == null) {
            VirtualFileUtil.a(11);
        }
        String string = FileUtil.toSystemIndependentName((String)rootPath);
        return string + (string.endsWith(String.valueOf('/')) ? "" : Character.valueOf('/')) + FileUtil.toSystemIndependentName((String)relativePath);
    }

    public static boolean fileExists(@Nullable VirtualFile file) {
        return file != null && file.exists();
    }

    @Nullable
    public static String getRelativePath(@NotNull String filePathOrUrl, @NotNull String rootPathOrUrl) {
        if (filePathOrUrl == null) {
            VirtualFileUtil.a(12);
        }
        if (rootPathOrUrl == null) {
            VirtualFileUtil.a(13);
        }
        if (filePathOrUrl.length() < rootPathOrUrl.length()) {
            return null;
        }
        String string = filePathOrUrl.substring(rootPathOrUrl.length());
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return string;
    }

    @Nullable
    public static String getFirstFolderNameFromRelativePath(VirtualFile file, VirtualFile root) {
        String string = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
        if (StringUtil.isEmpty((String)string)) {
            return null;
        }
        int n2 = string.indexOf(47);
        String string2 = n2 == -1 ? string : string.substring(0, n2);
        return string2;
    }

    @Nullable
    public static List<String> getRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile root) {
        if (file == null) {
            VirtualFileUtil.a(14);
        }
        if (root == null) {
            VirtualFileUtil.a(15);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (VirtualFile virtualFile = file; virtualFile != null; virtualFile = virtualFile.getParent()) {
            if (Comparing.equal((Object)virtualFile, (Object)root)) {
                Collections.reverse(arrayList);
                return arrayList;
            }
            arrayList.add(virtualFile.getName());
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static VirtualFile getAncestorByRelativePath(@Nullable VirtualFile file, @NotNull List<String> relativePath) {
        if (relativePath == null) {
            VirtualFileUtil.a(16);
        }
        if (file == null) {
            return null;
        }
        boolean bl2 = file.getFileSystem().isCaseSensitive();
        VirtualFile virtualFile = file;
        for (int n2 = relativePath.size() - 1; virtualFile != null && n2 >= 0; virtualFile = virtualFile.getParent(), --n2) {
            String string = relativePath.get(n2);
            if (!bl2 ? string.equalsIgnoreCase(virtualFile.getName()) : string.equals(virtualFile.getName())) continue;
            return null;
        }
        return virtualFile;
    }

    public static boolean processAncestor(@NotNull VirtualFile file, @NotNull Processor<? super VirtualFile> processor2, boolean strict) {
        VirtualFile virtualFile;
        if (file == null) {
            VirtualFileUtil.a(17);
        }
        if (processor2 == null) {
            VirtualFileUtil.a(18);
        }
        VirtualFile virtualFile2 = virtualFile = strict ? file.getParent() : file;
        while (virtualFile != null) {
            if (!processor2.process((Object)virtualFile)) {
                return false;
            }
            virtualFile = virtualFile.getParent();
        }
        return true;
    }

    @NotNull
    public static String convertToVFSPathAndNormalizeSlashes(@NotNull String path) {
        String string;
        if (path == null) {
            VirtualFileUtil.a(19);
        }
        if ((string = FileUtil.toSystemIndependentName((String)path)).length() != 0 && string.charAt(string.length() - 1) == '/') {
            String string2 = string.substring(0, string.length() - 1);
            if (string2 == null) {
                VirtualFileUtil.a(20);
            }
            return string2;
        }
        String string3 = string;
        if (string3 == null) {
            VirtualFileUtil.a(21);
        }
        return string3;
    }

    public static boolean existsNewerThanTimeStamp(final @Nullable VirtualFile root, final long ts) {
        if (root == null) {
            return false;
        }
        VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){
            private static final long a = c.a(6864865934126843699L, -2275578385390929502L, MethodHandles.lookup().lookupClass()).a(141832922899283L);

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    1.a(0);
                }
                VirtualFileVisitor.Result result = file.getTimeStamp() > ts ? 1.skipTo((VirtualFile)root) : CONTINUE;
                if (result == null) {
                    1.a(1);
                }
                return result;
            }

            private static /* synthetic */ void a(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                long l2 = a ^ 0x1F5E4B98DC93L;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 1: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/utils/VirtualFileUtil$1";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/utils/VirtualFileUtil$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        return result.skipToParent != null;
    }

    @Nullable
    public static String getRelativePath(@Nullable VirtualFile vFile, @NotNull Project project) {
        if (project == null) {
            VirtualFileUtil.a(22);
        }
        if (vFile != null) {
            String string;
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            VirtualFile virtualFile = projectFileIndex.getContentRootForFile(vFile);
            if (virtualFile == null) {
                virtualFile = projectFileIndex.getClassRootForFile(vFile);
            }
            if (virtualFile != null && (string = VfsUtilCore.getRelativePath((VirtualFile)vFile, (VirtualFile)virtualFile, (char)File.separatorChar)) != null) {
                return string;
            }
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x3A9DE9A6DAD7L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 20: 
            case 21: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/utils/VirtualFileUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootUrl";
                break;
            }
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePathOrUrl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPathOrUrl";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/utils/VirtualFileUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPathsToLocalUrls";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildUrl";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToVFSPathAndNormalizeSlashes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileBy";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "constructLocalUrl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertPathsToLocalUrls";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 20: 
            case 21: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compareVirtualFiles";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildUrl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildSystemIndependentPath";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorByRelativePath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processAncestor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "convertToVFSPathAndNormalizeSlashes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VirtualFilesComparator
    implements Comparator<VirtualFile> {
        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return VirtualFileUtil.compareVirtualFiles(file1, file2);
        }
    }
}

