/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.testing.BddTestsUtil;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecCallTypeProvider;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public class RSpecUtil {
    private static final Function<String, String> a;
    @NonNls
    public static final String RSPEC_GEM_NAME = "rspec";
    @NonNls
    public static final String RSPEC2_CORE_GEM_NAME = "rspec-core";
    @NonNls
    private static final String[] q;
    @NonNls
    private static final String[] x;
    @NonNls
    public static final String RSPEC_RAILS_GEM_NAME = "rspec-rails";
    @NonNls
    private static final String[] j;
    @NonNls
    private static final String A = "rspec-rails";
    @NonNls
    private static final String y = "rspec_on_rails";
    @NonNls
    public static final String SPECS_FOLDER = "spec";
    @NonNls
    public static final String SPEC_TEST_FILE_SUFFIX = "_spec.rb";
    @NonNls
    private static final String g = "rspec";
    @NonNls
    public static final String RSPEC_GEM_EXECUTABLE_API_1x = "spec";
    @NonNls
    private static final String M = "RSpec::Core::ExampleGroup.example";
    @NonNls
    private static final String h = "RSpec::Core::ExampleGroup.specify";
    @NonNls
    private static final String V = "RSpec::Core::ExampleGroup.it";
    @NonNls
    private static final String U = "RSpec::Core::Subject::ExampleGroupMethods.its";
    @NonNls
    private static final String e = "RSpec::Core::ExampleGroup.pending";
    @NonNls
    private static final String t = "RSpec::Core::ExampleGroup.focused";
    @NonNls
    private static final String m = "Spec::Example::ExampleGroupMethods.example";
    @NonNls
    private static final String f = "Spec::Example::ExampleGroupMethods.xexample";
    @NonNls
    private static final String F = "Spec::Example::ExampleGroupMethods.specify";
    @NonNls
    private static final String k = "Spec::Example::ExampleGroupMethods.xspecify";
    @NonNls
    private static final String R = "Spec::Example::ExampleGroupMethods.it";
    @NonNls
    private static final String D = "Spec::Example::ExampleGroupMethods.xit";
    @NonNls
    private static final String l = "RSpec::Core::ObjectExtensions.describe";
    @NonNls
    private static final String P = "Spec::DSL::Main.describe";
    @NonNls
    private static final String B = "Spec::Extensions::Main.describe";
    @NonNls
    private static final String z = "RSpec::Core::ExampleGroup.describe";
    @NonNls
    private static final String C = "Spec::Example::ExampleGroupMethods.describe";
    @NonNls
    private static final Set<String> H;
    @NonNls
    private static final Set<String> o;
    @NonNls
    private static final Set<String> N;
    @NonNls
    private static final Set<String> r;
    @NonNls
    private static final Set<String> T;
    @NonNls
    private static final Set<String> w;
    @NonNls
    private static final Set<String> I;
    @NonNls
    private static final Set<String> c;
    @NonNls
    private static final Set<String> u;
    public static final String LET_CALL_NAME = "let";
    public static final String LET_BEFORE_CALL_NAME = "let!";
    public static final String SUBJECT_CALL_NAME = "subject";
    private static final Set<String> G;
    @NonNls
    public static final Set<String> CLASS_CONTEXT_CALLS;
    @NonNls
    public static final Set<String> INSTANCE_CONTEXT_CALLS;
    private static final FQN E;
    private static final FQN b;
    private static final FQN i;
    private static final FQN s;
    private static final FQN L;
    private static final Pattern S;
    private static final String J = "pending";
    private static final String[] v;
    private static final String[] Q;
    private static final Set<String> W;
    private static final String[] d;
    private static final Set<String> n;
    private static final String[] K;
    private static final Set<String> O;
    private static final Set<String> p;
    public static final String GENERATORS_R30_PREFIX = "rspec:";
    public static final String RSPEC2_GEM_FIRST_BETA_VERSION = "2.0.0.beta.1";
    public static final String RSPEC3_GEM_FIRST_BETA_VERSION = "3.0.0.beta.1";
    public static final String RSPEC_RAILS_36_GEM_FIRST_BETA_VERSION = "3.6.0.beta.1";
    public static final String RSPEC_RAILS_40_GEM_FIRST_BETA_VERSION = "4.0.0.beta.1";
    public static final String RSPEC_RAILS_MARKER_SCRIPT = "spec/spec_helper.rb";
    public static final String RSPEC3_RAILS_MARKER_SCRIPT = "spec/rails_helper.rb";
    private static final long X;

    private RSpecUtil() {
    }

    @NotNull
    public static String getRailsSpecFolderPathOrUrl(@NotNull String railsAppRootPathOrUlr) {
        long l2 = X ^ 0x2932339570DAL;
        if (railsAppRootPathOrUlr == null) {
            RSpecUtil.a(0);
        }
        String string = railsAppRootPathOrUlr + '/' + "spec";
        if (string == null) {
            RSpecUtil.a(1);
        }
        return string;
    }

    public static boolean isRSpecRailsSupportInstalledInRailsProject(@NotNull String rorAppHomeDirUrl) {
        long l2 = X ^ 0x5EFB44FBFA3BL;
        if (rorAppHomeDirUrl == null) {
            RSpecUtil.a(2);
        }
        return RailsUtil.getPathIfFileExists(rorAppHomeDirUrl, RSPEC_RAILS_MARKER_SCRIPT) != null || RailsUtil.getPathIfFileExists(rorAppHomeDirUrl, RSPEC3_RAILS_MARKER_SCRIPT) != null;
    }

    public static boolean isRSpecSupportEnabled(@NotNull Module module2) {
        if (module2 == null) {
            RSpecUtil.a(3);
        }
        return GemUtil.isGemOrRailsPluginSupportEnabled(module2, x, v) || GemUtil.isGemOrRailsPluginSupportEnabled(module2, j, Q) || GemUtil.isGemOrRailsPluginSupportEnabled(module2, q, q) || RSpecUtil.isRSpecRailsSupportEnabled(module2);
    }

    public static boolean isRSpecRailsSupportEnabled(@NotNull Module module2) {
        if (module2 == null) {
            RSpecUtil.a(4);
        }
        if (!RailsFacetUtil.hasRailsSupport(module2)) {
            return false;
        }
        return GemUtil.isGemOrRailsPluginSupportEnabled(module2, j, Q);
    }

    public static boolean isRSpecRailsSupportProbablyEnabled(@NotNull Module module2, @NotNull Sdk sdk) {
        if (module2 == null) {
            RSpecUtil.a(5);
        }
        if (sdk == null) {
            RSpecUtil.a(6);
        }
        if (!RailsFacetUtil.hasRailsSupport(module2)) {
            return false;
        }
        return GemUtil.isGemOrRailsPluginSupportProbablyEnabled(module2, sdk, j, Q);
    }

    public static boolean isRSpecTestFile(Project project, @Nullable VirtualFile file) {
        if (!RSpecUtil.isFileWithRSpecTestFileName(file)) {
            return false;
        }
        return RSpecUtil.isRSpecSupportLoaded(project);
    }

    public static boolean isTestUnitWithRSpecFile(Project project, @NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            RSpecUtil.a(7);
        }
        if ((virtualFile = file.getVirtualFile()) == null || !TestUnitUtil.isFileWithValidTestUnitFileName(virtualFile)) {
            return false;
        }
        return RSpecUtil.isTestUnitWithRSpecSupportLoaded(project, file);
    }

    public static boolean isTestUnitWithRSpecSupportLoaded(Project project, @Nullable PsiFile invocationPoint) {
        return RSpecUtil.isRSpecSupportLoaded(project) && RubyFQNUtil.findContainerByFQN(project, Type.MODULE.asSet(), i, (PsiElement)invocationPoint) instanceof RModule;
    }

    public static boolean isRSpecRailsTestFile(Project project, @Nullable VirtualFile file) {
        if (!RSpecUtil.isFileWithRSpecTestFileName(file)) {
            return false;
        }
        return RSpecUtil.a(project);
    }

    public static boolean isFileWithRSpecTestFileName(@Nullable VirtualFile file) {
        long l2 = X ^ 0x4D430EFFF0C6L;
        return file != null && !file.isDirectory() && file.getName().endsWith(SPEC_TEST_FILE_SUFFIX);
    }

    public static boolean underSpecDirectory(@Nullable VirtualFile file) {
        long l2 = X ^ 0x34297F40314L;
        return file != null && file.getPath().contains("/spec/");
    }

    @Nullable
    public static String determinePreferredSpecExecutablePath(@Nullable Module module2, @Nullable Sdk alternativeSdk, @Nullable String forceRSpeGemVersion) {
        Object object;
        long l2 = X ^ 0x57038BDAA112L;
        if (module2 != null && RailsFacetUtil.hasRailsSupport(module2) && (object = RailsUtil.getRailsScriptExecutablePath(module2, "spec")) != null) {
            return object;
        }
        Object object2 = alternativeSdk == null ? (module2 != null ? RModuleUtil.getInstance().findRubySdkForModule(module2) : null) : (object = alternativeSdk);
        if (object != null) {
            return RSpecUtil.a(module2, object, forceRSpeGemVersion);
        }
        return null;
    }

    @Nullable
    public static String determineCurrentExampleName(@NotNull PsiElement psiElement, final boolean forExamplesFilter) {
        BddTestsUtil.ExampleNameBuilder exampleNameBuilder;
        GemInfo gemInfo;
        String string;
        BddTestsUtil.GroupNameBuilder groupNameBuilder;
        boolean bl2;
        if (psiElement == null) {
            RSpecUtil.a(8);
        }
        if (!(bl2 = BddTestsUtil.gatherGroupsAndExampleNames(psiElement, groupNameBuilder = new BddTestsUtil.GroupNameBuilder(K, string = (gemInfo = RSpecUtil.getAttachedRSpecGem(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement))) != null ? gemInfo.getVersion() : null){
            final /* synthetic */ String val$rspecVersion;
            private static final long c = com.jetbrains.python.psi.c.a(9221242713367378737L, -3877365593156370707L, MethodHandles.lookup().lookupClass()).a(280683073088182L);
            {
                this.val$rspecVersion = string;
                super(exampleCallsFqns);
            }

            @Override
            @NotNull
            public String getFullGroupName() {
                RPsiElement rPsiElement;
                String string;
                long l2 = c ^ 0x634554F2EC4FL;
                StringBuilder stringBuilder = new StringBuilder();
                List<? extends RPsiElement> list2 = this.getPartsInReversedOrder();
                int n2 = list2.size();
                if (n2 > 0 && (string = 1.getArgText(rPsiElement = list2.get(n2 - 1))) != null) {
                    if (string.startsWith("::") && rPsiElement instanceof RTopConstReference) {
                        stringBuilder.append(string.substring(2));
                    } else {
                        stringBuilder.append(string);
                    }
                }
                for (int i10 = n2 - 2; i10 >= 0; --i10) {
                    string = 1.getArgText(list2.get(i10));
                    if (string == null) continue;
                    if (!RSpecUtil.a(string, list2.get(i10 + 1), this.val$rspecVersion)) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(string);
                }
                String string2 = stringBuilder.toString();
                if (string2 == null) {
                    1.b(0);
                }
                return string2;
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = c ^ 0x145B35ABEA48L;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/testing/rspec/RSpecUtil$1", "getFullGroupName"));
            }
        }, exampleNameBuilder = new BddTestsUtil.ExampleNameBuilder(d){
            private static final long c = com.jetbrains.python.psi.c.a(-3973860514133278190L, 6815321519406534020L, MethodHandles.lookup().lookupClass()).a(57214846107957L);

            @Override
            public void register(@NotNull RubyPsiInterpreter interpreter) {
                if (interpreter == null) {
                    2.b(0);
                }
                super.register(interpreter);
                interpreter.registerCallable(new PsiCallable(){

                    @Override
                    public void processCall(RCallArguments arguments) {
                        PsiElement psiElement = arguments.getRCallElement();
                        RBlockCall rBlockCall = psiElement instanceof RPsiElement ? RBlockCallNavigator.getByCall((RPsiElement)psiElement) : null;
                        myExampleShortName = StringUtil.notNullize(rBlockCall != null ? RSpecUtil.determineItsExampleFullName(rBlockCall, forExamplesFilter) : null);
                    }
                }, ArrayUtilRt.toStringArray((Collection)r));
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = c ^ 0x1AF541D87B09L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "org/jetbrains/plugins/ruby/testing/rspec/RSpecUtil$2", "register"));
            }
        }))) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(groupNameBuilder.getFullGroupName());
        String string2 = exampleNameBuilder.getExampleShortName();
        if (string2 != null) {
            stringBuilder.append(' ').append(string2);
        }
        return stringBuilder.toString();
    }

    private static boolean a(@NotNull String string, @NotNull RPsiElement rPsiElement, @Nullable String string2) {
        long l2 = X ^ 0x7D1B4F605939L;
        if (string == null) {
            RSpecUtil.a(9);
        }
        if (rPsiElement == null) {
            RSpecUtil.a(10);
        }
        if (!(VersionComparatorUtil.compare((String)string2, (String)"2.12.0") <= 0 || rPsiElement instanceof RConstant || rPsiElement instanceof RColonReference || rPsiElement instanceof RTopConstReference)) {
            return false;
        }
        return S.matcher(string).find();
    }

    @Nullable
    public static String determineItsExampleFullName(@NotNull RBlockCall blockCall, boolean forExamplesFilter) {
        Object object;
        RPossibleCall rPossibleCall;
        if (blockCall == null) {
            RSpecUtil.a(11);
        }
        if (!((rPossibleCall = blockCall.getCall()) instanceof RCall)) {
            return null;
        }
        List<RPsiElement> list2 = ((RCall)rPossibleCall).getArguments();
        String string = null;
        if (list2.size() == 1) {
            List<RPsiElement> list3;
            object = list2.get(0);
            if (object instanceof RArray && (list3 = ((RArray)object).getElements()).size() == 1) {
                object = list3.get(0);
            }
            string = RubyPsiUtil.getElementText((PsiElement)object);
        }
        object = RSpecUtil.determineItsExampleMatcherName(blockCall);
        return forExamplesFilter ? string : string + (object != null ? " " + (String)object : "");
    }

    public static boolean isInExampleScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.a(12);
        }
        return RubyPsiInterpreter.isInResolvableCallScope(psiElement, O, p);
    }

    public static boolean isProbablyInExampleScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.a(13);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, W, n);
    }

    public static boolean isProbablyInInstanceContextScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.a(14);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, INSTANCE_CONTEXT_CALLS, n);
    }

    public static boolean isProbablyInExampleGroupScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.a(15);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, n, W);
    }

    public static boolean isProbablyInDefiningCallScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.a(16);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, G, W);
    }

    public static boolean isExampleGroupCall(@NotNull RPossibleCall call) {
        if (call == null) {
            RSpecUtil.a(17);
        }
        if (!(call instanceof RBlockCall)) {
            return false;
        }
        String string = call.getCommand();
        return string != null && (H.contains(string) || o.contains(string));
    }

    public static boolean isExampleCall(@NotNull RPossibleCall call) {
        String string;
        if (call == null) {
            RSpecUtil.a(18);
        }
        return (string = call.getCommand()) != null && (N.contains(string) || T.contains(string) || r.contains(string));
    }

    public static boolean isDisabledExampleCall(@NotNull RPossibleCall call) {
        String string;
        if (call == null) {
            RSpecUtil.a(19);
        }
        return (string = call.getCommand()) != null && T.contains(string);
    }

    public static boolean isExampleBeforeAfterCall(@NotNull RPossibleCall call) {
        if (call == null) {
            RSpecUtil.a(20);
        }
        if (!(call instanceof RBlockCall)) {
            return false;
        }
        String string = call.getCommand();
        return string != null && I.contains(string);
    }

    public static boolean isSharedExampleGroup(@NotNull RPossibleCall call) {
        if (call == null) {
            RSpecUtil.a(21);
        }
        if (!(call instanceof RBlockCall)) {
            return false;
        }
        String string = call.getCommand();
        return string != null && c.contains(string);
    }

    public static boolean isSharedGroupRef(@NotNull RPossibleCall call) {
        String string;
        if (call == null) {
            RSpecUtil.a(22);
        }
        return (string = call.getCommand()) != null && u.contains(string);
    }

    public static boolean isExampleSubjectCall(@NotNull RPossibleCall call) {
        String string;
        if (call == null) {
            RSpecUtil.a(23);
        }
        return (string = call.getCommand()) != null && r.contains(string);
    }

    public static boolean isPendingExampleCall(@NotNull RPossibleCall call) {
        PsiElement[] psiElementArray;
        long l2 = X ^ 0x15DA8D7B5457L;
        if (call == null) {
            RSpecUtil.a(24);
        }
        if (!RSpecUtil.isExampleCall(call) || RSpecUtil.isDisabledExampleCall(call)) {
            return false;
        }
        String string = call.getCommand();
        if (string != null && w.contains(string)) {
            return true;
        }
        RBlockCall rBlockCall = call instanceof RBlockCall ? (RBlockCall)call : RBlockCallNavigator.getByCall(call);
        if (rBlockCall == null) {
            return true;
        }
        RCodeBlock rCodeBlock = rBlockCall.getBlock();
        RCompoundStatement rCompoundStatement = rCodeBlock.getCompoundStatement();
        for (PsiElement psiElement : psiElementArray = rCompoundStatement.getChildren()) {
            if (!(psiElement instanceof RBlockCall ? J.equals(((RBlockCall)psiElement).getCommand()) : (psiElement instanceof RCall ? J.equals(((RCall)psiElement).getCommand()) : psiElement instanceof RIdentifier && J.equals(psiElement.getText())))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<RPsiElement> collectAllExamplesFrom(@NotNull RPsiElement root) {
        if (root == null) {
            RSpecUtil.a(25);
        }
        ArrayList arrayList = new ArrayList();
        RSpecUtil.a(root, arrayList);
        List<Object> list2 = arrayList.size() > 0 ? arrayList : Collections.emptyList();
        if (list2 == null) {
            RSpecUtil.a(26);
        }
        return list2;
    }

    @Nullable
    private static String a(@Nullable Module module2, @NotNull Sdk sdk, @Nullable String string) {
        GemInfo gemInfo;
        long l2 = X ^ 0x4507717CE6AAL;
        if (sdk == null) {
            RSpecUtil.a(27);
        }
        GemInfo gemInfo2 = gemInfo = (gemInfo = RSpecUtil.getAttachedRSpecGem(module2)) == null ? GemSearchUtil.findGem(module2, sdk, "rspec", null) : gemInfo;
        if (gemInfo == null) {
            return null;
        }
        boolean bl2 = StringUtil.isEmpty((String)string) ? !RSpecUtil.a(gemInfo.getVersion()) : !RSpecUtil.a(string);
        String string2 = bl2 ? "rspec" : "spec";
        String string3 = bl2 ? RSPEC2_CORE_GEM_NAME : "rspec";
        return RubyGemExecutionContext.getScriptPath(sdk, module2, string3, string2);
    }

    @Nullable
    public static GemInfo getAttachedRSpecGem(@Nullable Module module2) {
        long l2 = X ^ 0x77C960BFE39EL;
        if (module2 == null) {
            return null;
        }
        GemInfo gemInfo = GemManager.findGem(module2, "rspec");
        if (gemInfo != null) {
            return gemInfo;
        }
        return GemManager.findGem(module2, RSPEC2_CORE_GEM_NAME);
    }

    @Nullable
    public static GemInfo getAttachedRSpecRailsGem(@Nullable Module module2) {
        long l2 = X ^ 0x172B39BD0DCEL;
        if (module2 == null) {
            return null;
        }
        return GemManager.findGem(module2, "rspec-rails");
    }

    public static boolean isRSpec1xAttached(@Nullable Module module2) {
        GemInfo gemInfo = RSpecUtil.getAttachedRSpecGem(module2);
        return gemInfo != null && RSpecUtil.a(gemInfo.getVersion());
    }

    private static boolean a(String string) {
        long l2 = X ^ 0x1BDF81C72D33L;
        return VersionComparatorUtil.compare((String)string, (String)RSPEC2_GEM_FIRST_BETA_VERSION) < 0;
    }

    public static boolean isRSpec2xGemAttached(@NotNull Module module2) {
        GemInfo gemInfo;
        if (module2 == null) {
            RSpecUtil.a(28);
        }
        return (gemInfo = RSpecUtil.getAttachedRSpecGem(module2)) != null && !RSpecUtil.a(gemInfo.getVersion());
    }

    private static boolean c(String string) {
        long l2 = X ^ 0x6C3B7614D1F2L;
        return VersionComparatorUtil.compare((String)string, (String)RSPEC3_GEM_FIRST_BETA_VERSION) >= 0;
    }

    public static boolean isRSpec20SupportLoaded(Project project) {
        return RubyFQNUtil.findContainerByFQN(project, Type.CLASS.asSet(), E, null) instanceof RClass;
    }

    public static boolean isRSpec1xSupportLoaded(Project project) {
        return RubyFQNUtil.findContainerByFQN(project, Type.CLASS.asSet(), b, null) instanceof RClass;
    }

    public static boolean isRSpecSupportLoaded(Project project) {
        return RSpecUtil.isRSpec20SupportLoaded(project) || RSpecUtil.isRSpec1xSupportLoaded(project);
    }

    private static boolean a(Project project) {
        return RubyFQNUtil.findContainerByFQN(project, Type.MODULE.asSet(), s, null) instanceof RModule || RubyFQNUtil.findContainerByFQN(project, Type.MODULE.asSet(), L, null) instanceof RModule;
    }

    public static boolean isRailsRSpec36plusGemAttached(@NotNull Module module2) {
        GemInfo gemInfo;
        long l2 = X ^ 0x221CBE08FD25L;
        if (module2 == null) {
            RSpecUtil.a(29);
        }
        return (gemInfo = RSpecUtil.getAttachedRSpecRailsGem(module2)) != null && VersionComparatorUtil.compare((String)gemInfo.getVersion(), (String)RSPEC_RAILS_36_GEM_FIRST_BETA_VERSION) >= 0 && VersionComparatorUtil.compare((String)gemInfo.getVersion(), (String)RSPEC_RAILS_40_GEM_FIRST_BETA_VERSION) < 0;
    }

    public static void collectChildren(RPsiElement root, List<? super RPsiElement> nodeElements, List<? super RPsiElement> exampleLikeElements, boolean allowOnlyExampleLeafs) {
        block7: {
            block6: {
                PsiElement[] psiElementArray;
                if (!(root instanceof RBlockCall)) break block6;
                RBlockCall rBlockCall = (RBlockCall)root;
                if (!RSpecUtil.isExampleGroupCall(rBlockCall) && !RSpecUtil.isSharedExampleGroup(rBlockCall)) break block7;
                RCompoundStatement rCompoundStatement = rBlockCall.getBlock().getCompoundStatement();
                for (PsiElement psiElement : psiElementArray = rCompoundStatement.getChildren()) {
                    if (psiElement instanceof RPossibleCall) {
                        RPossibleCall rPossibleCall = (RPossibleCall)psiElement;
                        if (RSpecUtil.isExampleGroupCall(rPossibleCall) || RSpecUtil.isSharedExampleGroup(rPossibleCall)) {
                            nodeElements.add(rPossibleCall);
                            continue;
                        }
                        if ((allowOnlyExampleLeafs || !RSpecUtil.isExampleBeforeAfterCall(rPossibleCall)) && !RSpecUtil.isExampleCall(rPossibleCall) && !RSpecUtil.isSharedGroupRef(rPossibleCall)) continue;
                        exampleLikeElements.add(rPossibleCall);
                        continue;
                    }
                    if (!(psiElement instanceof RContainer) || psiElement instanceof RObjectClass) continue;
                    nodeElements.add((RContainer)psiElement);
                }
                break block7;
            }
            if (root instanceof RContainer) {
                List<RPsiElement> list2 = ((RContainer)root).getStatements();
                for (RPsiElement rPsiElement : list2) {
                    if (rPsiElement instanceof RBlockCall) {
                        RBlockCall rBlockCall = (RBlockCall)rPsiElement;
                        if (!RSpecUtil.isExampleGroupCall(rBlockCall) && !RSpecUtil.isSharedExampleGroup(rBlockCall)) continue;
                        nodeElements.add(rPsiElement);
                        continue;
                    }
                    if (!(rPsiElement instanceof RContainer) || rPsiElement instanceof RObjectClass) continue;
                    nodeElements.add(rPsiElement);
                }
            }
        }
    }

    private static void a(@NotNull RPsiElement rPsiElement, List<? super RPsiElement> list2) {
        if (rPsiElement == null) {
            RSpecUtil.a(30);
        }
        ArrayList arrayList = new ArrayList();
        RSpecUtil.collectChildren(rPsiElement, arrayList, list2, true);
        for (RPsiElement rPsiElement2 : arrayList) {
            RSpecUtil.a(rPsiElement2, list2);
        }
    }

    @Nullable
    public static RPossibleCall getSimpleCoveringExampleOrBeforeAfterScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.a(31);
        }
        return RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(psiElement, INSTANCE_CONTEXT_CALLS, CLASS_CONTEXT_CALLS);
    }

    @Nullable
    public static RBlockCall getSimpleCoveringExampleGroupScope(@NotNull PsiElement psiElement) {
        RPossibleCall rPossibleCall;
        if (psiElement == null) {
            RSpecUtil.a(32);
        }
        if ((rPossibleCall = RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(psiElement, CLASS_CONTEXT_CALLS, INSTANCE_CONTEXT_CALLS)) instanceof RBlockCall) {
            return (RBlockCall)rPossibleCall;
        }
        return null;
    }

    @Nullable
    public static VirtualFile getRSpecLibFolder(Module module2) {
        long l2 = X ^ 0x13DBF2E3958BL;
        return GemUtil.getGemOrRailsPluginLibDir(module2, "rspec", v);
    }

    @Nullable
    public static String determineItsExampleMatcherName(@Nullable RBlockCall itsBlockCall) {
        if (itsBlockCall == null) {
            return null;
        }
        RCompoundStatement rCompoundStatement = itsBlockCall.getBlock().getCompoundStatement();
        List<RPsiElement> list2 = rCompoundStatement.getStatements();
        if (!list2.isEmpty()) {
            RPsiElement rPsiElement = list2.get(list2.size() - 1);
            String string = rPsiElement.getText();
            return string.replace("\n", " ").replace("_", " ");
        }
        return null;
    }

    private static Set<String> a(String ... stringArray) {
        if (stringArray == null) {
            RSpecUtil.a(33);
        }
        return Collections.unmodifiableSet(Sets.newHashSet((Object[])stringArray));
    }

    private static Set<String> a(Collection<String> ... collectionArray) {
        if (collectionArray == null) {
            RSpecUtil.a(34);
        }
        HashSet hashSet = Sets.newHashSet();
        for (Collection<String> collection : collectionArray) {
            hashSet.addAll(collection);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public static boolean isShouldCall(RubyCallType<?> type) {
        long l2 = X ^ 0x44C3D0F8F685L;
        return type != RubyCallType.UNKNOWN && ("should".equals(type.getCommandName()) || "should_not".equals(type.getCommandName()));
    }

    public static boolean underShouldCall(RCall call) {
        RCall rCall = (RCall)PsiTreeUtil.getParentOfType((PsiElement)call, RCall.class, (boolean)true, (Class[])new Class[]{RCompoundStatement.class});
        return rCall != null && RSpecUtil.isShouldCall(rCall.getCallType());
    }

    @Nullable
    public static RCall findLetCall(@NotNull PsiElement element) {
        RCall rCall;
        if (element == null) {
            RSpecUtil.a(35);
        }
        if (element instanceof RCall) {
            rCall = (RCall)element;
        } else {
            if (!(element instanceof RSymbol)) {
                return null;
            }
            if (!(element.getParent().getParent() instanceof RCall)) {
                return null;
            }
            rCall = (RCall)element.getParent().getParent();
        }
        return RSpecCallTypeProvider.LET_CALL == rCall.getCallType() ? rCall : null;
    }

    static {
        X = com.jetbrains.python.psi.c.a(-7740823085165055102L, -7810457669760647428L, MethodHandles.lookup().lookupClass()).a(69178521158947L);
        long l2 = X ^ 0x7CF7522267C6L;
        a = string -> {
            long l2 = X ^ 0x65DEAC22816AL;
            return "RSpec." + string;
        };
        q = new String[]{RSPEC2_CORE_GEM_NAME};
        x = new String[]{"rspec"};
        j = new String[]{"rspec-rails"};
        H = RSpecUtil.a("feature", "describe", "context", "shared_examples", "shared_context");
        o = RSpecUtil.a(Collections2.transform(H, a));
        N = RSpecUtil.a("it", "scenario", "example", "specify", J, "focused");
        r = RSpecUtil.a(new String[]{"its"});
        T = RSpecUtil.a("xit", "xexample", "xspecify");
        w = RSpecUtil.a(new String[]{J});
        I = RSpecUtil.a("before", "after", "setup", "teardown", "append_before", "prepend_after");
        c = RSpecUtil.a("shared_examples_for", "share_examples_for", "share_as");
        u = RSpecUtil.a("it_should_behave_like", "it_behaves_like", "include_examples", "include_context");
        G = RSpecUtil.a(LET_CALL_NAME, LET_BEFORE_CALL_NAME, SUBJECT_CALL_NAME);
        CLASS_CONTEXT_CALLS = RSpecUtil.a(H, o);
        INSTANCE_CONTEXT_CALLS = RSpecUtil.a(N, T, I, r, c, u, G);
        E = FQN.Builder.fromString("RSpec::Core::ExampleGroup");
        b = FQN.Builder.fromString("Spec::Example::ExampleGroup");
        i = FQN.Builder.fromString("Spec::Test::Unit");
        s = FQN.Builder.fromString("RSpec::Rails");
        L = FQN.Builder.fromString("Spec::Rails::Example");
        S = Pattern.compile("^(\\s|\\.|#|::)");
        v = new String[]{"rspec "};
        Q = new String[]{"rspec-rails", y};
        W = RSpecUtil.a(N, T, r, w);
        d = ArrayUtilRt.toStringArray(W);
        n = RSpecUtil.a(H, o);
        K = ArrayUtilRt.toStringArray(n);
        O = RSpecUtil.a("RSpec::Its.its", "RSpec::Core::MemoizedHelpers::ClassMethods.its", U, M, h, V, e, t, m, f, F, k, R, D);
        p = RSpecUtil.a(l, P, B, z, C);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = X ^ 0x5F46AEC3E950L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 26: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsAppRootPathOrUlr";
                break;
            }
            case 1: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/RSpecUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rorAppHomeDirUrl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockCall";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collections";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/RSpecUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRailsSpecFolderPathOrUrl";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllExamplesFrom";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRailsSpecFolderPathOrUrl";
                break;
            }
            case 1: 
            case 26: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRSpecRailsSupportInstalledInRailsProject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRSpecSupportEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRSpecRailsSupportEnabled";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isRSpecRailsSupportProbablyEnabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTestUnitWithRSpecFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "determineCurrentExampleName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMethodDescriptionAfterModule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "determineItsExampleFullName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInExampleScope";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isProbablyInExampleScope";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isProbablyInInstanceContextScope";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isProbablyInExampleGroupScope";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isProbablyInDefiningCallScope";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isExampleGroupCall";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isExampleCall";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isDisabledExampleCall";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isExampleBeforeAfterCall";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSharedExampleGroup";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isSharedGroupRef";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isExampleSubjectCall";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isPendingExampleCall";
                break;
            }
            case 25: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "collectAllExamplesFrom";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getRSpecGemExecutablePath";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isRSpec2xGemAttached";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isRailsRSpec36plusGemAttached";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleCoveringExampleOrBeforeAfterScope";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleCoveringExampleGroupScope";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "newSet";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findLetCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

