/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.RubyGemsEnvironment;
import org.jetbrains.plugins.ruby.gem.inspection.quickfixes.RunBundlerInstallQuickFix;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurationException;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;

public abstract class RubySdkConfigurator {
    private static final Logger a;
    private static final ExtensionPointName<RubySdkConfigurator> b;
    private static final long d;

    public abstract boolean supports(@NotNull SdkAdditionalData var1);

    @NotNull
    public abstract RubyAbstractRunner buildRunner(@NotNull RubySdkAdditionalData var1, @Nullable Module var2);

    public void initSdk(@NotNull Sdk sdk) throws RubySdkConfigurationException {
        RubyGemsEnvironment rubyGemsEnvironment;
        long l2 = d ^ 0x15E894ABFF9BL;
        if (sdk == null) {
            RubySdkConfigurator.a(0);
        }
        RubySdkAdditionalData rubySdkAdditionalData = RubySdkAdditionalData.notNullFrom(sdk);
        String string = rubySdkAdditionalData.getInterpreterPath(sdk);
        String string2 = RubySdkType.getInstance().getVersionString(string);
        rubySdkAdditionalData.setNormalizedVersionString(string2);
        rubySdkAdditionalData.setLanguageLevel(RubyVersionUtil.extractLanguageLevelFromVersion(string2));
        if (SystemInfo.isWindows && !ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                rubySdkAdditionalData.setPlatform(RubyVersionUtil.extractPlatformFromVersion(RubyVersionUtil.getFullVersion(rubySdkAdditionalData.getRunner(null), string, false)));
            }
            catch (ExecutionException executionException) {
                a.error((Throwable)executionException);
            }
        }
        if ((rubyGemsEnvironment = RubyGemsEnvironment.get(sdk)).isEmpty()) {
            throw new RubySdkConfigurationException("Could not get RubyGems environment for " + sdk);
        }
        String string3 = rubyGemsEnvironment.getExecutableDirectory();
        if (StringUtil.isEmpty((String)string3)) {
            a.warn("No EXECUTABLE DIRECTORY: " + rubyGemsEnvironment);
            throw new RubySdkConfigurationException("No EXECUTABLE DIRECTORY in `gem env` response, see logs for more details");
        }
        rubySdkAdditionalData.setGemsBinDirectory(Objects.requireNonNull(string3));
        rubySdkAdditionalData.setGemsRootUrls(Collections.emptyList());
    }

    @NotNull
    public List<LocalQuickFix> getBundleInstallQuickFixes(@NotNull Sdk sdk, @NotNull Module module2) {
        if (sdk == null) {
            RubySdkConfigurator.a(1);
        }
        if (module2 == null) {
            RubySdkConfigurator.a(2);
        }
        List<LocalQuickFix> list2 = Collections.singletonList(new RunBundlerInstallQuickFix(module2));
        if (list2 == null) {
            RubySdkConfigurator.a(3);
        }
        return list2;
    }

    @NotNull
    public static RubySdkConfigurator from(SdkAdditionalData sdkAdditionalData) {
        long l2 = d ^ 0x4BF77E4BA3EAL;
        for (RubySdkConfigurator rubySdkConfigurator : b.getExtensionList()) {
            if (!rubySdkConfigurator.supports(sdkAdditionalData)) continue;
            RubySdkConfigurator rubySdkConfigurator2 = rubySdkConfigurator;
            if (rubySdkConfigurator2 == null) {
                RubySdkConfigurator.a(4);
            }
            return rubySdkConfigurator2;
        }
        throw new RuntimeException("Unable to find SdkConfigurator for " + sdkAdditionalData);
    }

    static {
        d = c.a(4160283557395167668L, 929884168142356541L, MethodHandles.lookup().lookupClass()).a(88140396300593L);
        long l2 = d ^ 0x30382BBD1ADFL;
        a = Logger.getInstance(RubySdkConfigurator.class);
        b = ExtensionPointName.create((String)"org.jetbrains.plugins.ruby.rubySdkConfigurator");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x464FD12102L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkConfigurator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkConfigurator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleInstallQuickFixes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initSdk";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBundleInstallQuickFixes";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

