/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration.debugger;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebugMode;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.run.configuration.DebugGemHelper;
import org.jetbrains.plugins.ruby.ruby.run.configuration.debugger.a;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.utils.OSUtil;

public class RubyDebugIdeGemHelper
implements DebugGemHelper {
    @NonNls
    public static final String RDEBUG_IDE_GEM_NAME = "ruby-debug-ide";
    @NonNls
    private static final String n = "ruby-debug-base";
    @NonNls
    private static final String i = "ruby-debug-base19x";
    @NonNls
    private static final String C = "debase";
    @NonNls
    private static final String h = "--debug";
    private static final Logger d;
    private static final Pattern q;
    private static final Pattern f;
    private static final Pattern m;
    private static final Pattern u;
    private static final String B = "(0\\.7(\\.[0-9A-z]+)*)";
    private static final String b = "(0\\.8(\\.[0-9A-z]+)*)";
    private static final Pattern s;
    private static final Pattern a;
    private static final Pattern y;
    private static final Pattern c;
    private static final String z = "(0\\.2(\\.[0-9A-z]+)*)";
    private static final String t = "(0\\.3(\\.[0-9A-z]+)*)";
    private static final Pattern p;
    private static final Pattern A;
    private static final Pattern x;
    private static final Pattern r;
    private static final String o = "0.8.0.beta8";
    private static final String k = "0.7.0.beta7";
    private static final String w = "0.10.5.rc10";
    private static final String v = "0.11.32";
    private static final String j = "0.3.0.beta8";
    private static final String l = "0.10.6";
    public static final String DEBUGGER_PRESENT_ASKED = "debugger.present.asked";
    public static final String DEBUGGER_SHOULD_USE_EXPERIMENTAL = "debugger.should.use.experimental";
    @Nullable
    private final State g;
    @NotNull
    private final RubyDebugMode e;
    private static final long D;

    public RubyDebugIdeGemHelper(@Nullable State state2, @NotNull RubyDebugMode mode) {
        if (mode == null) {
            RubyDebugIdeGemHelper.a(0);
        }
        this.g = state2;
        this.e = mode;
    }

    @Nullable
    public static GemInfo findGem(@NotNull String gemName, @Nullable Module module2, @NotNull Sdk sdk) {
        if (gemName == null) {
            RubyDebugIdeGemHelper.a(1);
        }
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(2);
        }
        GemInfo gemInfo = null;
        if (module2 != null) {
            gemInfo = GemSearchUtil.findGem(module2, gemName);
        }
        return gemInfo != null ? gemInfo : GemSearchUtil.findGem(module2, sdk, gemName);
    }

    public static boolean checkForDebuggerPresence(@Nullable Module module2) {
        long l2 = D ^ 0x39B0A022F72EL;
        return RubyDebugIdeGemHelper.a(module2, "debugger", DEBUGGER_PRESENT_ASKED);
    }

    private static boolean a(@Nullable Module module2, @NotNull String string, @NotNull String string2) {
        long l2 = D ^ 0x67CA47210A6BL;
        if (string == null) {
            RubyDebugIdeGemHelper.a(3);
        }
        if (string2 == null) {
            RubyDebugIdeGemHelper.a(4);
        }
        if (module2 == null || PropertiesComponent.getInstance((Project)module2.getProject()).getBoolean(string2)) {
            return true;
        }
        GemInfo gemInfo = GemSearchUtil.findGem(module2, string);
        if (gemInfo == null) {
            return true;
        }
        int n2 = Messages.showYesNoDialog((Project)module2.getProject(), (String)RBundle.message("gems.debugger.in.gemfile", string), (String)RBundle.message("gems.debugger.alert.title"), (Icon)Messages.getQuestionIcon());
        if (n2 == 0) {
            PropertiesComponent.getInstance((Project)module2.getProject()).setValue(string2, true);
            return true;
        }
        return false;
    }

    @NotNull
    public String getRdebugIdeGemName() {
        long l2 = D ^ 0x76E2639244E4L;
        if (RDEBUG_IDE_GEM_NAME == null) {
            RubyDebugIdeGemHelper.a(5);
        }
        return RDEBUG_IDE_GEM_NAME;
    }

    @NotNull
    public String getRdebugFrontEndGemName(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(6);
        }
        String string = DebugGemType.getBaseType(sdk).getGemName();
        if (string == null) {
            RubyDebugIdeGemHelper.a(7);
        }
        return string;
    }

    @Override
    public boolean isUsable() {
        return this.g != null;
    }

    @Override
    @NotNull
    public String updateRubyLib(@Nullable String rubyLib, @NotNull RubySdkSystemAccessor accessor, @NotNull PathMappingSettings mappingSettings) {
        long l2 = D ^ 0x2F2D6D9D03A6L;
        if (accessor == null) {
            RubyDebugIdeGemHelper.a(8);
        }
        if (mappingSettings == null) {
            RubyDebugIdeGemHelper.a(9);
        }
        assert (this.g != null) : "state must not be null at this point";
        rubyLib = OSUtil.prependToRUBYLIBEnvVariable(accessor, rubyLib, mappingSettings.convertToRemote(this.g.myIdeLib.getPath()));
        rubyLib = OSUtil.prependToRUBYLIBEnvVariable(accessor, rubyLib, mappingSettings.convertToRemote(this.g.myBaseLib.getPath()));
        if (this.g.myLineCacheNeeded) {
            VirtualFile virtualFile = this.g.myLineCacheLib;
            assert (this.g.myLineCacheLib != null);
            rubyLib = OSUtil.prependToRUBYLIBEnvVariable(accessor, rubyLib, mappingSettings.convertToRemote(virtualFile.getPath()));
        }
        String string = rubyLib;
        if (string == null) {
            RubyDebugIdeGemHelper.a(10);
        }
        return string;
    }

    @Override
    public boolean isMultiProcessDebugSupported() {
        long l2 = D ^ 0x1D995E992D30L;
        assert (this.g != null) : "state must not be null at this point";
        return this.g.myMultiProcessDebugSupported;
    }

    @Override
    @NotNull
    public String getRdebugScriptPath() {
        long l2 = D ^ 0x73F7D18CDB30L;
        assert (this.g != null) : "state must not be null at this point";
        String string = this.g.myRDebugScriptPath;
        if (string == null) {
            RubyDebugIdeGemHelper.a(11);
        }
        return string;
    }

    @Override
    @NotNull
    public String getErrorMsg() {
        long l2 = D ^ 0x549FDF2D2540L;
        String string = RBundle.message("gem.not.found.executable.for.gem", RDEBUG_IDE_GEM_NAME, this.e.getDebugScript());
        if (string == null) {
            RubyDebugIdeGemHelper.a(12);
        }
        return string;
    }

    @Override
    public void enableVerboseMode(@NotNull List<String> args, boolean enableMode) {
        long l2 = D ^ 0x2BCF827EBD81L;
        if (args == null) {
            RubyDebugIdeGemHelper.a(13);
        }
        if (enableMode) {
            args.add(h);
        }
    }

    @Override
    public void enableKeyValuePresentation(@NotNull List<String> args, boolean enableMode) {
        long l2 = D ^ 0x1CD699D59BB9L;
        if (args == null) {
            RubyDebugIdeGemHelper.a(14);
        }
        if (this.g != null && this.g.myKeyValueHashAvailable && enableMode) {
            args.add("--key-value");
        }
    }

    @Override
    public void enableSteppingOverIntoBlocks(@NotNull List<String> args, boolean enableMode) {
        long l2 = D ^ 0x18CEE4E2A395L;
        if (args == null) {
            RubyDebugIdeGemHelper.a(15);
        }
        if (this.g != null && this.g.mySmartSrepOverSupported && enableMode) {
            args.add("--step-over-in-blocks");
        }
    }

    @Override
    public void disableIntHandler(@NotNull List<String> args, boolean disableHandler) {
        long l2 = D ^ 0x2B7C7F54CDF9L;
        if (args == null) {
            RubyDebugIdeGemHelper.a(16);
        }
        if (disableHandler) {
            args.add("--disable-int-handler");
        }
    }

    @Override
    public void setEvaluationTimeout(@NotNull List<String> args, int seconds) {
        long l2 = D ^ 0x51F9878D7A49L;
        if (args == null) {
            RubyDebugIdeGemHelper.a(17);
        }
        if (this.g != null && this.g.myTimeoutConfigurable) {
            args.add("--evaluation-timeout");
            args.add(Integer.toString(seconds));
        }
    }

    @Override
    public void enableEvaluationControl(@NotNull List<String> args, boolean enableMode) {
        long l2 = D ^ 0x4DF3D4DAEE87L;
        if (args == null) {
            RubyDebugIdeGemHelper.a(18);
        }
        if (this.g != null && this.g.myEvaluationControlConfigurable && enableMode) {
            args.add("--evaluation-control");
        }
    }

    @Override
    public void setEvaluationTimeLimit(@NotNull List<String> args, int milliseconds) {
        long l2 = D ^ 0x1FB0E197FFE4L;
        if (args == null) {
            RubyDebugIdeGemHelper.a(19);
        }
        if (this.g != null && this.g.myEvaluationControlConfigurable) {
            args.add("--time-limit");
            args.add(Integer.toString(milliseconds));
        }
    }

    @Override
    public void setEvaluationMemoryLimit(@NotNull List<String> args, int megabytes) {
        long l2 = D ^ 0x1A07CB4F3CE1L;
        if (args == null) {
            RubyDebugIdeGemHelper.a(20);
        }
        if (this.g != null && this.g.myEvaluationControlConfigurable) {
            args.add("--memory-limit");
            args.add(Integer.toString(megabytes));
        }
    }

    @Override
    public void addGemSpecificArgs(@NotNull List<String> args) {
        long l2 = D ^ 0xB0842F70F6DL;
        if (args == null) {
            RubyDebugIdeGemHelper.a(21);
        }
        if (this.g != null && this.g.myRmProtocolExtensionsSupported) {
            args.add("--rubymine-protocol-extensions");
        }
    }

    @Override
    public boolean needsDebugPreLoader() {
        return true;
    }

    @Override
    public boolean supportsNonSuspendedFramesReading(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(22);
        }
        return !RubySdkUtil.isNativeRuby20(sdk) && !RubySdkUtil.isNativeRuby21(sdk) && !RubySdkUtil.isNativeRuby22(sdk) && !RubySdkUtil.isNativeRuby23(sdk) && !RubySdkUtil.isNativeRuby24(sdk) && !RubySdkUtil.isNativeRuby25(sdk) && !RubySdkUtil.isNativeRuby26(sdk) && !RubySdkUtil.isNativeRuby27(sdk);
    }

    @Override
    public boolean supportsCatchpointRemoval() {
        return this.g != null && this.g.myCatchPointRemovalSupported;
    }

    @Override
    @NotNull
    public List<VirtualFile> getSourceRoots(@Nullable Project project) {
        if (project == null || !this.supportFileFiltering()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                RubyDebugIdeGemHelper.a(23);
            }
            return list2;
        }
        List<VirtualFile> list3 = Arrays.asList(ProjectRootManager.getInstance((Project)project).getContentRoots());
        if (list3 == null) {
            RubyDebugIdeGemHelper.a(24);
        }
        return list3;
    }

    @Override
    @NotNull
    public List<VirtualFile> getExcludedDirs(@Nullable Project project) {
        if (project == null || !this.supportFileFiltering()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                RubyDebugIdeGemHelper.a(25);
            }
            return list2;
        }
        ArrayList arrayList = Lists.newArrayList();
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            ContainerUtil.addAll((Collection)arrayList, (Object[])ModuleRootManager.getInstance((Module)module2).getExcludeRoots());
        }
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            RubyDebugIdeGemHelper.a(26);
        }
        return arrayList2;
    }

    @Override
    public boolean supportFileFiltering() {
        return this.g != null && this.g.myFileFilterSupported;
    }

    @Override
    public boolean pauseActionSupported() {
        return true;
    }

    @Override
    public boolean debugConsoleSupported(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(27);
        }
        return this.g != null && this.g.myDebugConsoleSupported;
    }

    public static String getOrInstallDebugIdeGem(@Nullable Module module2, @NotNull Sdk sdk) throws ExecutionException {
        long l2 = D ^ 0xC9E18B07EEL;
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(28);
        }
        return RubyDebugIdeGemHelper.getOrInstallDebugIdeGem(module2, sdk, RDEBUG_IDE_GEM_NAME);
    }

    @Nullable
    protected static String getOrInstallDebugIdeGem(@Nullable Module module2, @NotNull Sdk sdk, @NotNull String ideName) throws ExecutionException {
        String string;
        long l2 = D ^ 0x305451A6A632L;
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(29);
        }
        if (ideName == null) {
            RubyDebugIdeGemHelper.a(30);
        }
        DebugGemType debugGemType = DebugGemType.getBaseType(sdk);
        boolean bl2 = LanguageLevel.RUBY19.isLessThan(RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk));
        boolean bl3 = Experiments.isFeatureEnabled((String)"ruby.use.experimental.debugger") && RubySdkUtil.isMRISdk(sdk) && LanguageLevel.RUBY22.isLessThan(RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk));
        Pattern pattern = bl3 ? a : s;
        GemInfo gemInfo = RubyDebugIdeGemHelper.a(ideName, module2, sdk, pattern);
        DebugGemType debugGemType2 = bl3 ? DebugGemType.IDE : DebugGemType.IDE_STABLE;
        boolean bl4 = debugGemType2.a(gemInfo);
        String string2 = debugGemType.getGemName();
        GemInfo gemInfo2 = bl2 && !JRubySdkUtil.isJRubySDK(sdk) ? RubyDebugIdeGemHelper.a(string2, module2, sdk, bl3 ? A : p) : RubyDebugIdeGemHelper.findGem(string2, module2, sdk);
        boolean bl5 = debugGemType.a(gemInfo2);
        if (gemInfo != null && bl4 && bl5) {
            return gemInfo.getVersion();
        }
        String string3 = RubySdkType.getPlatform(sdk);
        if (gemInfo2 == null) {
            string = RBundle.message("gems.install.debug.gem", string2);
        } else if (!bl5 && !RubyDebugIdeGemHelper.a(sdk, debugGemType)) {
            string = RBundle.message("gems.update.debug.gem", string2);
        } else if (gemInfo == null) {
            string = RBundle.message("gems.install.debug.gem", ideName);
        } else if (!bl4 && !RubyDebugIdeGemHelper.a(sdk, debugGemType2)) {
            string = RBundle.message("gems.update.debug.gem", ideName);
        } else {
            return gemInfo.getVersion();
        }
        int n2 = Messages.showYesNoDialog((Project)RModuleUtil.getInstance().getProject(module2), (String)string, (String)RBundle.message("gems.debugger.alert.title"), (Icon)Messages.getQuestionIcon());
        if (n2 == 0) {
            Object object;
            List<GemDependency> list2;
            Pattern pattern2;
            HashMap<GemDependency, String> hashMap = new HashMap<GemDependency, String>();
            boolean bl6 = RubySdkUtil.isRuby18(sdk);
            boolean bl7 = RubySdkUtil.getRubySdkAdditionalData(sdk).getSdkSystemAccessor().isWindows();
            boolean bl8 = JRubySdkUtil.isJRubySDK(sdk);
            Pattern pattern3 = pattern2 = bl3 ? y : c;
            if (bl8) {
                list2 = GemInstallUtil.findBundledGemsToInstall(RBundle.message("gems.bundled.jruby.debug.not.found"), q, pattern2);
            } else if (bl7 && bl6 && RubyDebugIdeGemHelper.a(string3)) {
                list2 = GemInstallUtil.findBundledGemsToInstall(RBundle.message("gems.bundled.win32.debug.not.found"), u, pattern2);
                list2.add(0, GemDependency.any("linecache"));
            } else {
                object = bl2 ? (bl3 ? x : r) : (bl6 ? f : m);
                list2 = GemInstallUtil.findBundledGemsToInstall(RBundle.message("gems.bundled.debug.not.found"), new Pattern[]{object, pattern2});
            }
            GemInstallUtil.installGemsRequirements(sdk, module2, list2, !bl8, false, false, false, false, null, hashMap);
            object = GemUiUtil.buildInstallErrorsText(hashMap);
            if (object != null) {
                String string4 = RBundle.message("gems.gem.installing.failed") + ". " + (String)object;
                d.warn(string4);
                throw new ExecutionException(string4);
            }
            RubyDebugIdeGemHelper.a(sdk, debugGemType2, debugGemType);
            GemInfo gemInfo3 = RubyDebugIdeGemHelper.a(ideName, module2, sdk, pattern);
            return gemInfo3 != null ? gemInfo3.getVersion() : null;
        }
        RubyDebugIdeGemHelper.a(sdk, debugGemType2, debugGemType);
        return gemInfo != null && gemInfo2 != null ? gemInfo.getVersion() : null;
    }

    @Nullable
    private static GemInfo a(@NotNull String string, @Nullable Module module2, @NotNull Sdk sdk, @NotNull Pattern pattern) {
        if (string == null) {
            RubyDebugIdeGemHelper.a(31);
        }
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(32);
        }
        if (pattern == null) {
            RubyDebugIdeGemHelper.a(33);
        }
        Collection<GemInfo> collection = GemManager.getInstance().getAllGems(sdk, module2);
        return GemSearchUtil.findGem(collection, (Function<? super GemInfo, Boolean>)((Function)gemInfo -> gemInfo.getName().equals(string) && pattern.matcher(gemInfo.getVersion()).matches()));
    }

    @Nullable
    private static GemInfo a(@NotNull String string, @Nullable String string2, @Nullable Module module2, @NotNull Sdk sdk) {
        if (string == null) {
            RubyDebugIdeGemHelper.a(34);
        }
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(35);
        }
        GemInfo gemInfo = null;
        if (module2 != null) {
            gemInfo = GemSearchUtil.findGem(module2, sdk, string, string2);
        }
        return gemInfo != null ? gemInfo : GemSearchUtil.findGem(module2, sdk, string, string2);
    }

    private static void a(Sdk sdk, DebugGemType debugGemType, DebugGemType debugGemType2) {
        PropertiesComponent.getInstance().setValue(RubyDebugIdeGemHelper.b(sdk, debugGemType2), debugGemType2.getVersion(), null);
        PropertiesComponent.getInstance().setValue(RubyDebugIdeGemHelper.b(sdk, debugGemType), debugGemType.getVersion(), null);
    }

    private static boolean a(@NotNull Sdk sdk, DebugGemType debugGemType) {
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(36);
        }
        return VersionComparatorUtil.compare((String)PropertiesComponent.getInstance().getValue(RubyDebugIdeGemHelper.b(sdk, debugGemType)), (String)debugGemType.getVersion()) >= 0;
    }

    private static String b(Sdk sdk, DebugGemType debugGemType) {
        return sdk.getHomePath() + ":" + debugGemType.name();
    }

    private static boolean a(String string) {
        long l2 = D ^ 0x3A67DF0F8B4DL;
        return string != null && string.contains("i386") && (RubySdkUtil.isMswin32(string) || RubySdkUtil.isMingw32(string));
    }

    @Nullable
    public static State createState(@Nullable Module module2, @NotNull Sdk sdk, @Nullable String gemVersion, @NotNull RubyDebugMode mode) throws ExecutionException {
        VirtualFile virtualFile;
        Object object;
        boolean bl2;
        long l2 = D ^ 0x38B40C52F44BL;
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(37);
        }
        if (mode == null) {
            RubyDebugIdeGemHelper.a(38);
        }
        if (gemVersion == null) {
            return null;
        }
        GemInfo gemInfo = RubyDebugIdeGemHelper.a(RDEBUG_IDE_GEM_NAME, gemVersion, module2, sdk);
        String string = DebugGemType.getBaseType(sdk).getGemName();
        GemInfo gemInfo2 = C.equals(string) ? RubyDebugIdeGemHelper.a(string, module2, sdk, (bl2 = s.matcher(gemVersion).matches()) ? p : A) : RubyDebugIdeGemHelper.findGem(string, module2, sdk);
        if (gemInfo == null || !gemInfo.isValid() || gemInfo2 == null || !gemInfo2.isValid()) {
            return null;
        }
        bl2 = RubyDebugIdeGemHelper.a(sdk, gemInfo2);
        GemInfo gemInfo3 = null;
        if (bl2 && ((gemInfo3 = GemSearchUtil.findGem(module2, sdk, (String)(object = RubySdkUtil.isRuby19(sdk) && !JRubySdkUtil.isJRubySDK(sdk) ? "linecache19" : "linecache"), null)) == null || !gemInfo3.isValid())) {
            String string2 = RBundle.message("ruby.debugger.cannot.start.debug", RBundle.message("ruby.debugger.cannot.find.gem", object));
            throw new ExecutionException(string2);
        }
        object = gemInfo.getFile();
        assert (object != null);
        String string3 = GemUtil.findScriptInBinDir(mode.getDebugScript(), object.findChild("bin"));
        VirtualFile virtualFile2 = gemInfo.getLibFolder();
        VirtualFile virtualFile3 = gemInfo2.getLibFolder();
        VirtualFile virtualFile4 = virtualFile = gemInfo3 != null ? gemInfo3.getLibFolder() : null;
        if (string3 == null || virtualFile2 == null || virtualFile3 == null || bl2 && virtualFile == null) {
            return null;
        }
        return new State(bl2, string3, virtualFile2, virtualFile3, virtualFile, gemInfo, null);
    }

    private static boolean a(@NotNull Sdk sdk, @NotNull GemInfo gemInfo) {
        long l2 = D ^ 0x6789A294B1BDL;
        if (sdk == null) {
            RubyDebugIdeGemHelper.a(39);
        }
        if (gemInfo == null) {
            RubyDebugIdeGemHelper.a(40);
        }
        String string = sdk.getVersionString();
        if (RubySdkUtil.isRuby18(sdk) && string != null && string.contains("1.8.6")) {
            return false;
        }
        if (C.equals(gemInfo.getName())) {
            return false;
        }
        String string2 = i.equals(gemInfo.getName()) ? "0.11.30.pre10" : "0.10.5.rc9";
        return VersionComparatorUtil.compare((String)gemInfo.getVersion(), (String)string2) <= 0;
    }

    static {
        D = com.jetbrains.python.psi.c.a(4740433196782248199L, -669844198753118143L, MethodHandles.lookup().lookupClass()).a(49266824336940L);
        long l2 = D ^ 0x4C2423918119L;
        d = Logger.getInstance(RubyDebugIdeGemHelper.class);
        q = Pattern.compile("ruby-debug-base-([0-9]+(\\.[0-9A-z]+)*)-java.gem");
        f = Pattern.compile("ruby-debug-base-([0-9]+(\\.[0-9A-z]+)*).gem");
        m = Pattern.compile("ruby-debug-base19x-([0-9]+(\\.[0-9A-z]+)*).gem");
        u = Pattern.compile("ruby-debug-base-([0-9]+(\\.[0-9A-z]+)*)(-x86)?-mswin32.gem");
        s = Pattern.compile(B);
        a = Pattern.compile(b);
        y = Pattern.compile("ruby-debug-ide-(0\\.8(\\.[0-9A-z]+)*).gem");
        c = Pattern.compile("ruby-debug-ide-(0\\.7(\\.[0-9A-z]+)*).gem");
        p = Pattern.compile(z);
        A = Pattern.compile(t);
        x = Pattern.compile("debase-(0\\.3(\\.[0-9A-z]+)*).gem");
        r = Pattern.compile("debase-(0\\.2(\\.[0-9A-z]+)*).gem");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = D ^ 0x2954AF886B63L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: 
            case 3: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 2: 
            case 6: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "askedProperty";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingSettings";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseInfo";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRdebugIdeGemName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRdebugFrontEndGemName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "updateRubyLib";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRdebugScriptPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMsg";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedDirs";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findGem";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkForGemPresence";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRdebugFrontEndGemName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateRubyLib";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "enableVerboseMode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "enableKeyValuePresentation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "enableSteppingOverIntoBlocks";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "disableIntHandler";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setEvaluationTimeout";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "enableEvaluationControl";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setEvaluationTimeLimit";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setEvaluationMemoryLimit";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addGemSpecificArgs";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "supportsNonSuspendedFramesReading";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "debugConsoleSupported";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getOrInstallDebugIdeGem";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findGemByVersionPattern";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "alreadyAskedToUpdate";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createState";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isLineCacheNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class State {
        @NotNull
        private static final String b = "0.4.17.beta9";
        @NotNull
        private static final String g = "0.4.23.beta2";
        @NotNull
        private static final String e = "0.6.1.beta9";
        @NotNull
        private static final String d = "0.4.23.beta2";
        @NotNull
        private static final String f = "0.4.24.beta4";
        @NotNull
        private static final String a = "0.5.0";
        @NotNull
        private static final String i = "0.6.0.pre1";
        @NotNull
        private static final String c = "0.8.0.beta1";
        @NotNull
        private static final String h = "0.7.0.beta5";
        public final boolean myLineCacheNeeded;
        public final boolean myMultiProcessDebugSupported;
        public final boolean myTimeoutConfigurable;
        public final boolean myEvaluationControlConfigurable;
        public final boolean myDebugConsoleSupported;
        public final boolean myCatchPointRemovalSupported;
        public final boolean myRmProtocolExtensionsSupported;
        public final boolean myFileFilterSupported;
        public final boolean mySmartSrepOverSupported;
        public final boolean myKeyValueHashAvailable;
        @NotNull
        public final String myRDebugScriptPath;
        @NotNull
        public final VirtualFile myIdeLib;
        @NotNull
        public final VirtualFile myBaseLib;
        @Nullable
        public final VirtualFile myLineCacheLib;
        private static final long j = com.jetbrains.python.psi.c.a(-8266296226645123952L, 2231230506582679096L, MethodHandles.lookup().lookupClass()).a(215343084520468L);

        private State(boolean lineCacheNeeded, @NotNull String rDebugScriptPath, @NotNull VirtualFile ideLib, @NotNull VirtualFile baseLib, @Nullable VirtualFile lineCacheLib, @Nullable GemInfo gemInfo) {
            long l2 = j ^ 0x58B9521D4C79L;
            if (rDebugScriptPath == null) {
                State.a(0);
            }
            if (ideLib == null) {
                State.a(1);
            }
            if (baseLib == null) {
                State.a(2);
            }
            this.myLineCacheNeeded = lineCacheNeeded;
            if (gemInfo != null) {
                String string = gemInfo.getVersion();
                this.myMultiProcessDebugSupported = VersionComparatorUtil.compare((String)string, (String)b) > 0;
                this.myTimeoutConfigurable = VersionComparatorUtil.compare((String)string, (String)"0.4.23.beta2") >= 0;
                this.myEvaluationControlConfigurable = VersionComparatorUtil.compare((String)string, (String)e) >= 0;
                this.myDebugConsoleSupported = VersionComparatorUtil.compare((String)string, (String)"0.4.23.beta2") >= 0;
                this.myRmProtocolExtensionsSupported = VersionComparatorUtil.compare((String)string, (String)f) >= 0;
                this.myCatchPointRemovalSupported = VersionComparatorUtil.compare((String)string, (String)a) >= 0;
                this.myFileFilterSupported = VersionComparatorUtil.compare((String)string, (String)i) >= 0;
                this.mySmartSrepOverSupported = VersionComparatorUtil.compare((String)string, (String)c) >= 0;
                this.myKeyValueHashAvailable = VersionComparatorUtil.compare((String)string, (String)h) >= 0;
            } else {
                this.myMultiProcessDebugSupported = false;
                this.myTimeoutConfigurable = false;
                this.myEvaluationControlConfigurable = false;
                this.myDebugConsoleSupported = false;
                this.myRmProtocolExtensionsSupported = false;
                this.myCatchPointRemovalSupported = false;
                this.myFileFilterSupported = false;
                this.mySmartSrepOverSupported = false;
                this.myKeyValueHashAvailable = false;
            }
            this.myRDebugScriptPath = rDebugScriptPath;
            this.myIdeLib = ideLib;
            this.myBaseLib = baseLib;
            this.myLineCacheLib = lineCacheLib;
            assert (!lineCacheNeeded || lineCacheLib != null);
        }

        /* synthetic */ State(boolean x0, String x1, VirtualFile x2, VirtualFile x3, VirtualFile x4, GemInfo x5, a x6) {
            this(x0, x1, x2, x3, x4, x5);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = j ^ 0x75788C617ADAL;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rDebugScriptPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ideLib";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "baseLib";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$State";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DebugGemType
    extends Enum<DebugGemType> {
        public static final /* enum */ DebugGemType BASE_18;
        public static final /* enum */ DebugGemType BASE_19;
        public static final /* enum */ DebugGemType BASE_20;
        public static final /* enum */ DebugGemType BASE_JAVA_18;
        public static final /* enum */ DebugGemType BASE_JAVA_19;
        public static final /* enum */ DebugGemType BASE_JAVA_20;
        public static final /* enum */ DebugGemType BASE_RBX_18;
        public static final /* enum */ DebugGemType BASE_RBX_19;
        public static final /* enum */ DebugGemType BASE_RBX_20;
        public static final /* enum */ DebugGemType IDE_STABLE;
        public static final /* enum */ DebugGemType IDE;
        private final String b;
        private final String c;
        private static final /* synthetic */ DebugGemType[] a;
        private static final long d;

        public static DebugGemType[] values() {
            return (DebugGemType[])a.clone();
        }

        public static DebugGemType valueOf(String name) {
            return Enum.valueOf(DebugGemType.class, name);
        }

        private DebugGemType(String version, String name) {
            if (version == null) {
                DebugGemType.a(0);
            }
            if (name == null) {
                DebugGemType.a(1);
            }
            this.b = version;
            this.c = name;
        }

        @NotNull
        public String getVersion() {
            String string = this.b;
            if (string == null) {
                DebugGemType.a(2);
            }
            return string;
        }

        @NotNull
        public String getGemName() {
            String string = this.c;
            if (string == null) {
                DebugGemType.a(3);
            }
            return string;
        }

        public static DebugGemType getBaseType(Sdk sdk) {
            long l2 = d ^ 0x3BCAF1D63FB2L;
            String string = RubySdkUtil.isRubinius(sdk) ? "BASE_RBX" : (JRubySdkUtil.isJRubySDK(sdk) ? "BASE_JAVA" : "BASE");
            String string2 = LanguageLevel.RUBY19.isLessThan(RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk)) ? "_20" : (RubySdkUtil.isRuby19(sdk) ? "_19" : "_18");
            return DebugGemType.valueOf(string + string2);
        }

        private boolean a(GemInfo gemInfo) {
            if (gemInfo == null) {
                return false;
            }
            String string = gemInfo.getVersion();
            return VersionComparatorUtil.compare((String)string, (String)this.getVersion()) >= 0;
        }

        static {
            d = com.jetbrains.python.psi.c.a(-4163163682982390971L, -1256170214672154600L, MethodHandles.lookup().lookupClass()).a(235870332794339L);
            long l2 = d ^ 0x34F7DD4FC21FL;
            BASE_18 = new DebugGemType(RubyDebugIdeGemHelper.w, RubyDebugIdeGemHelper.n);
            BASE_19 = new DebugGemType(RubyDebugIdeGemHelper.v, RubyDebugIdeGemHelper.i);
            BASE_20 = new DebugGemType(RubyDebugIdeGemHelper.j, RubyDebugIdeGemHelper.C);
            BASE_JAVA_18 = new DebugGemType(RubyDebugIdeGemHelper.l, RubyDebugIdeGemHelper.n);
            BASE_JAVA_19 = new DebugGemType(RubyDebugIdeGemHelper.l, RubyDebugIdeGemHelper.n);
            BASE_JAVA_20 = new DebugGemType(RubyDebugIdeGemHelper.l, RubyDebugIdeGemHelper.n);
            BASE_RBX_18 = new DebugGemType(RubyDebugIdeGemHelper.j, RubyDebugIdeGemHelper.C);
            BASE_RBX_19 = new DebugGemType(RubyDebugIdeGemHelper.j, RubyDebugIdeGemHelper.C);
            BASE_RBX_20 = new DebugGemType(RubyDebugIdeGemHelper.j, RubyDebugIdeGemHelper.C);
            IDE_STABLE = new DebugGemType(RubyDebugIdeGemHelper.k, RubyDebugIdeGemHelper.RDEBUG_IDE_GEM_NAME);
            IDE = new DebugGemType(RubyDebugIdeGemHelper.o, RubyDebugIdeGemHelper.RDEBUG_IDE_GEM_NAME);
            a = new DebugGemType[]{BASE_18, BASE_19, BASE_20, BASE_JAVA_18, BASE_JAVA_19, BASE_JAVA_20, BASE_RBX_18, BASE_RBX_19, BASE_RBX_20, IDE_STABLE, IDE};
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = d ^ 0x7283E18B99EL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$DebugGemType";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/debugger/RubyDebugIdeGemHelper$DebugGemType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersion";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

