/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public final class RunnerUtil {
    private static final Logger a;
    private static final long b;

    private RunnerUtil() {
    }

    public static void reportErrorsIfNeeded(@NotNull Project project, @NotNull String title, @NotNull String executablePath, @Nullable String stderr) {
        if (project == null) {
            RunnerUtil.a(0);
        }
        if (title == null) {
            RunnerUtil.a(1);
        }
        if (executablePath == null) {
            RunnerUtil.a(2);
        }
        if (!StringUtil.isEmpty((String)stderr) && !RunnerUtil.isJRubyOpenSSLWarning(stderr)) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(executablePath);
            ExecutionHelper.showErrors((Project)project, Collections.singletonList(new Exception(stderr)), (String)title, (VirtualFile)virtualFile);
        }
    }

    public static boolean isJRubyOpenSSLWarning(@Nullable String stderr) {
        long l2 = b ^ 0x3E92A2277060L;
        if (stderr == null) {
            return false;
        }
        String[] stringArray = stderr.split("\\n");
        return stringArray.length == 2 && RunnerUtil.isJRubyOpenSSLFirstLine(stringArray[0]) && RunnerUtil.isJRubyOpenSSLSecondLine(stringArray[1]);
    }

    public static boolean isSpring(@NotNull String stderr) {
        long l2 = b ^ 0x7AF3FDE04742L;
        if (stderr == null) {
            RunnerUtil.a(3);
        }
        return stderr.startsWith("Running via Spring preloader");
    }

    public static boolean isJRubyOpenSSLSecondLine(@NotNull String line2) {
        long l2 = b ^ 0x3D3C3843888AL;
        if (line2 == null) {
            RunnerUtil.a(4);
        }
        return line2.contains("JRuby_Builtin_OpenSSL") || line2.contains("gem install jruby-openssl");
    }

    public static boolean isJRubyOpenSSLFirstLine(@NotNull String line2) {
        long l2 = b ^ 0x1CF26238F126L;
        if (line2 == null) {
            RunnerUtil.a(5);
        }
        return line2.contains("JRuby limited openssl");
    }

    public static void showExecutionErrorDialog(ExecutionException e10) {
        Runnable runnable = () -> {
            long l2 = b ^ 0x1E51429325F8L;
            Messages.showErrorDialog((String)e10.getMessage(), (String)RBundle.message("execution.error.title"));
        };
        a.warn((Throwable)e10);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable);
        }
    }

    public static void validateSDK(@Nullable Sdk sdk) throws ExecutionException {
        long l2 = b ^ 0x3CE70C69F810L;
        if (sdk == null) {
            throw new ExecutionException(RBundle.message("sdk.no.specified"));
        }
        if (!RubySdkUtil.isRubySDK(sdk)) {
            throw new ExecutionException(RBundle.message("sdk.error.isnt.valid", sdk.getName()));
        }
        if (!RubySdkUtil.isRubyInterpreterExist(sdk)) {
            throw new ExecutionException(RBundle.message("sdk.error.homepath.doesnt.exists", sdk.getHomePath(), sdk.getName()));
        }
    }

    public static void showErrorMessage(Project project, String errorTitle, Exception exp) {
        String string = RunnerUtil.filterIoExceptionMessage(exp.getMessage());
        if (string == null || string.length() == 0) {
            string = exp.toString();
        }
        a.warn(errorTitle, (Throwable)exp);
        Messages.showErrorDialog((Project)project, (String)string, (String)errorTitle);
    }

    @Nullable
    public static String filterIoExceptionMessage(@Nullable String message) {
        long l2 = b ^ 0x7F167CC392F2L;
        if (message == null) {
            return null;
        }
        String string = "java.io.IOException:";
        if (message.startsWith("java.io.IOException:")) {
            return message.substring("java.io.IOException:".length());
        }
        return message;
    }

    public static List<String> collectCommands(@NotNull String rubyExe, @NotNull String script) {
        long l2 = b ^ 0x1E10B81280BL;
        if (rubyExe == null) {
            RunnerUtil.a(6);
        }
        if (script == null) {
            RunnerUtil.a(7);
        }
        LinkedList linkedList = Lists.newLinkedList();
        linkedList.add(rubyExe);
        linkedList.add("-e");
        linkedList.add(script);
        return ContainerUtil.filter((Collection)linkedList, string -> !StringUtil.isEmptyOrSpaces((String)string));
    }

    public static PathMappingSettings getRunnerDefaultMappings(@NotNull Sdk sdk, @Nullable Module module2) {
        if (sdk == null) {
            RunnerUtil.a(8);
        }
        return RunnerUtil.getRunner(sdk, module2).addDefaultMappings(null);
    }

    @NotNull
    public static RubyRunner getRunner(@NotNull Sdk sdk, @Nullable Module module2) {
        long l2 = b ^ 0x30C0A5C46E11L;
        if (sdk == null) {
            RunnerUtil.a(9);
        }
        SdkTypeId sdkTypeId = sdk.getSdkType();
        assert (sdkTypeId instanceof RubySdkType) : "Unexpected sdk type - " + sdkTypeId;
        RubyRunner rubyRunner = RubySdkAdditionalData.notNullFrom(sdk).getRunner(module2);
        if (rubyRunner == null) {
            RunnerUtil.a(10);
        }
        return rubyRunner;
    }

    public static boolean validateSdkWithDialog(@Nullable Sdk sdk) {
        try {
            RunnerUtil.validateSDK(sdk);
        }
        catch (ExecutionException executionException) {
            RunnerUtil.showExecutionErrorDialog(executionException);
            return false;
        }
        return true;
    }

    static {
        b = c.a(-3519557225717599732L, 3004602896219971053L, MethodHandles.lookup().lookupClass()).a(110823693481623L);
        a = Logger.getInstance(RubyUtil.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x72CA06759E0FL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stderr";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyExe";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/RunnerUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/RunnerUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reportErrorsIfNeeded";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSpring";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isJRubyOpenSSLSecondLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isJRubyOpenSSLFirstLine";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectCommands";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerDefaultMappings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRunner";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

