/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.inline;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyOverrideImplementUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.Scope;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeVariable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RemoveReturnFix;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyUnnecessaryReturnStatementInspection;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.RControlFlowUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RReturnStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RSingletonMethodImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RArrayToArguments;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFid;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyReplaceExpressionUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.NamesSuggestor;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.parameter.RubyIntroduceParameterProcessor;
import org.jetbrains.plugins.ruby.ruby.refactoring.introduce.variable.RubyIntroduceVariableHandler;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class RubyInlineMethodProcessor
extends BaseRefactoringProcessor {
    private static final Logger i;
    public static final String REFACTORING_NAME;
    private static final String b;
    public static final String HELP_ID = "refactoring.inlineMethod";
    private final RMethod a;
    private final Editor d;
    private final String c;
    private final PsiReference f;
    private final boolean g;
    private static final Key<String> h;
    private static final Key<Set<String>> e;
    private static final long j;

    public RubyInlineMethodProcessor(Project project, Editor editor2, RMethod method, PsiReference reference, boolean invokeThisOnly) {
        super(project);
        this.a = method;
        this.d = editor2;
        this.f = reference;
        this.g = invokeThisOnly;
        this.c = DescriptiveNameUtil.getDescriptiveName((PsiElement)this.a);
    }

    @NotNull
    protected String getCommandName() {
        long l2 = j ^ 0x76AB34606E78L;
        String string = RefactoringBundle.message((String)"inline.method.command", (Object[])new Object[]{this.c});
        if (string == null) {
            RubyInlineMethodProcessor.a(0);
        }
        return string;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            RubyInlineMethodProcessor.a(1);
        }
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){
            private static final long a = com.jetbrains.python.psi.c.a(5492316974613510112L, 2881395922846430186L, MethodHandles.lookup().lookupClass()).a(82151151480591L);

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{RubyInlineMethodProcessor.this.a};
                if (psiElementArray == null) {
                    1.a(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                long l2 = a ^ 0x249682481B55L;
                return RefactoringBundle.message((String)"all.invocations.in.project");
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x69D8F2971F9DL;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor$1", "getElements"));
            }
        };
        if (usageViewDescriptorAdapter == null) {
            RubyInlineMethodProcessor.a(2);
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        UsageInfo[] usageInfoArray = RubyInlineMethodProcessor.findUsages(this.a, this.f, this.g);
        if (usageInfoArray == null) {
            RubyInlineMethodProcessor.a(3);
        }
        return usageInfoArray;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            RubyInlineMethodProcessor.a(4);
        }
        UsageInfo[] usageInfoArray = (UsageInfo[])refUsages.get();
        MultiMap multiMap = new MultiMap();
        RubyInlineMethodProcessor.inspectUsages(this.a, (MultiMap<PsiElement, String>)multiMap, usageInfoArray);
        return this.showConflicts(multiMap, usageInfoArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        LocalHistoryAction localHistoryAction;
        if (usages == null) {
            RubyInlineMethodProcessor.a(5);
        }
        int n2 = -1;
        int n3 = -1;
        if (this.d != null) {
            n2 = this.d.getCaretModel().getLogicalPosition().column;
            n3 = this.d.getCaretModel().getLogicalPosition().line;
            localHistoryAction = new LogicalPosition(0, 0);
            this.d.getCaretModel().moveToLogicalPosition((LogicalPosition)localHistoryAction);
        }
        localHistoryAction = LocalHistory.getInstance().startAction(this.getCommandName());
        try {
            this.a(usages);
        }
        finally {
            localHistoryAction.finish();
        }
        if (this.d != null) {
            LogicalPosition logicalPosition = new LogicalPosition(n3, n2);
            this.d.getCaretModel().moveToLogicalPosition(logicalPosition);
        }
    }

    private void a(UsageInfo[] usageInfoArray) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed(RubyInlineMethodProcessor.a());
        RubyInlineMethodProcessor.invoke(this.myProject, this.a, this.g, usageInfoArray);
    }

    private static String a() {
        long l2 = j ^ 0x3222A56CCCD5L;
        return HELP_ID;
    }

    public static void invoke(@NotNull Project project, @NotNull RMethod method, boolean inlineThisOnly, @NotNull UsageInfo[] usages) {
        long l2 = j ^ 0x530F9D67AC44L;
        if (project == null) {
            RubyInlineMethodProcessor.a(6);
        }
        if (method == null) {
            RubyInlineMethodProcessor.a(7);
        }
        if (usages == null) {
            RubyInlineMethodProcessor.a(8);
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            long l2 = j ^ 0x479700CF92A8L;
            if (i.isDebugEnabled()) {
                i.info("Fix all the usages include super calls");
            }
            Object object = usages;
            int n2 = ((UsageInfo[])object).length;
            for (int i10 = 0; i10 < n2; ++i10) {
                Object object2;
                RContainer rContainer;
                RCall rCall;
                UsageInfo usageInfo = object[i10];
                RPsiElement rPsiElement = (RPsiElement)usageInfo.getElement();
                boolean bl3 = RubyInlineMethodProcessor.a((PsiElement)rPsiElement);
                RPsiElement rPsiElement2 = null;
                if (bl3) {
                    rPsiElement2 = ((RReference)rPsiElement).getReceiver();
                }
                if ((rCall = RCallNavigator.getByCommand((PsiElement)rPsiElement)) != null) {
                    rPsiElement = rCall;
                }
                if ((rContainer = RubyPsiUtil.getContainingRClassOrModule((PsiElement)rPsiElement)) == null) {
                    rContainer = RubyPsiUtil.getRFile((PsiElement)rPsiElement);
                }
                if (bl3) {
                    object2 = (Set)method.getUserData(e);
                    assert (object2 != null) : "fqn data should be initialized before inspecting all the references";
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        RubyPsiUtil.addIncludeFQNCall(rContainer, string);
                    }
                }
                if (RubyInlineMethodProcessor.a(project, (String)(object2 = RubyInlineMethodProcessor.a(project, method, rPsiElement2, bl3)), rPsiElement)) continue;
                return;
            }
            method.accept(new RubyRecursiveElementVisitor(){

                @Override
                public void visitElement(PsiElement element) {
                    element.putUserData(h, null);
                    super.visitElement(element);
                }
            });
            method.putUserData(e, null);
            if (!inlineThisOnly) {
                if (i.isDebugEnabled()) {
                    i.info("Removing method with comments");
                }
                if (!(object = RubyCommentsUtil.getPsiComments((PsiElement)method)).isEmpty()) {
                    PsiElement psiElement = (PsiElement)object.get(0);
                    PsiElement psiElement2 = ((PsiComment)object.get(object.size() - 1)).getNextSibling();
                    psiElement.getParent().deleteChildRange(psiElement, psiElement2);
                }
                method.delete();
            }
        }), RefactoringBundle.message((String)"inline.method.command", (Object[])new Object[]{method.getName()}), null);
    }

    private static boolean a(PsiElement psiElement) {
        if (!(psiElement instanceof RReference)) {
            return false;
        }
        RPsiElement rPsiElement = ((RReference)psiElement).getReceiver();
        return rPsiElement != null && !RubyTokenTypes.kSUPER.toString().equals(rPsiElement.getName());
    }

    private static String a(@NotNull Project project, @NotNull RMethod rMethod, @Nullable RPsiElement rPsiElement, boolean bl2) {
        String string;
        Object object;
        long l2 = j ^ 0x771AD80B582EL;
        if (project == null) {
            RubyInlineMethodProcessor.a(9);
        }
        if (rMethod == null) {
            RubyInlineMethodProcessor.a(10);
        }
        final String string2 = RubyInlineMethodProcessor.a(rMethod, rPsiElement);
        if (bl2) {
            object = new StringBuilder();
            rMethod.accept(new RubyRecursiveElementVisitor((StringBuilder)object){
                final /* synthetic */ StringBuilder val$builder;
                private static final long a = com.jetbrains.python.psi.c.a(4753829939021933745L, 2272072549900536394L, MethodHandles.lookup().lookupClass()).a(91395337414724L);
                {
                    this.val$builder = stringBuilder;
                }

                @Override
                public void visitElement(PsiElement element) {
                    long l2 = a ^ 0x365639D91B1CL;
                    if (string2 != null && element instanceof RPseudoConstant && RubyTokenTypes.kSELF.toString().equals(element.getText())) {
                        this.val$builder.append(string2);
                        return;
                    }
                    String string = (String)element.getUserData(h);
                    if (string != null) {
                        if (string2 != null && "self".equals(string)) {
                            string = string2 + "." + element.getText();
                        }
                        this.val$builder.append(string);
                        return;
                    }
                    if (element instanceof LeafPsiElement) {
                        this.val$builder.append(element.getText());
                        return;
                    }
                    super.visitElement(element);
                }
            });
            string = ((StringBuilder)object).toString();
        } else {
            string = rMethod.getText();
        }
        object = (RMethod)RubyElementFactory.createElementFromText(project, string, rMethod.getLanguageLevel());
        if (string2 != null && !rPsiElement.getText().equals(string2)) {
            object.getCompoundStatement().addBefore((PsiElement)RubyElementFactory.createExpressionFromText((PsiElement)rMethod, string2 + " = " + rPsiElement.getText()), object.getCompoundStatement().getFirstChild());
        }
        for (RReturnStatement rReturnStatement : RubyUnnecessaryReturnStatementInspection.inspectMethod((RMethod)object, true)) {
            ApplicationManager.getApplication().runWriteAction(() -> RemoveReturnFix.removeUnnecessaryReturn(rReturnStatement));
        }
        return object.getText();
    }

    private static String a(@NotNull RMethod rMethod, @Nullable RPsiElement rPsiElement) {
        String string;
        long l2 = j ^ 0x3129F5B43773L;
        if (rMethod == null) {
            RubyInlineMethodProcessor.a(11);
        }
        if (rPsiElement == null) {
            return null;
        }
        boolean bl2 = false;
        final Ref ref = new Ref((Object)0);
        if (RubyPsiUtil.isConstantValue((PsiElement)rPsiElement) || rPsiElement instanceof RField) {
            string = rPsiElement.getText();
            bl2 = true;
        } else {
            String string2;
            String[] stringArray = NamesSuggestor.getSuggestedNames((PsiElement)rPsiElement);
            string = string2 = stringArray.length != 0 ? stringArray[0] : "new_object";
            Set<String> set = rMethod.getScope().getAllDeclaredVariables().keySet();
            int n2 = 1;
            while (string.equals(rPsiElement.getName()) || set.contains(string)) {
                string = string2 + n2;
                ++n2;
            }
        }
        rMethod.accept(new RubyRecursiveElementVisitor(){
            private static final long a = com.jetbrains.python.psi.c.a(4061120512937917351L, 730347480958696387L, MethodHandles.lookup().lookupClass()).a(28747450436638L);

            @Override
            public void visitElement(PsiElement element) {
                long l2 = a ^ 0xF75CE13323CL;
                if (element instanceof RPseudoConstant && RubyTokenTypes.kSELF.toString().equals(element.getText()) || "self".equals(element.getUserData(h))) {
                    ref.set((Object)((Integer)ref.get() + 1));
                    return;
                }
                super.visitElement(element);
            }
        });
        boolean bl3 = (Integer)ref.get() > 1;
        return bl3 && !bl2 ? string : rPsiElement.getText();
    }

    public static UsageInfo[] findUsages(RMethod method, PsiReference reference, boolean inlineThisOnly) {
        Collection<Object> collection;
        long l2 = j ^ 0xEB6755E04A3L;
        ArrayList<UsageInfo> arrayList = new ArrayList<UsageInfo>();
        if (inlineThisOnly) {
            arrayList.add(new UsageInfo(reference.getElement()));
        } else {
            collection = RubyIntroduceParameterProcessor.findUsages(Collections.singletonList(method));
            if (i.isDebugEnabled()) {
                i.info("References Found: " + collection.size());
            }
            arrayList.addAll(collection);
        }
        collection = RubyOverrideImplementUtil.getOverridingElements(method);
        if (i.isDebugEnabled()) {
            i.info("Overriding Methods Found: " + collection.size());
        }
        for (RContainer rContainer : collection) {
            List<RPsiElement> list2 = rContainer.getCompoundStatement().getStatements();
            if (list2.isEmpty()) continue;
            RPsiElement rPsiElement = list2.get(0);
            if (rPsiElement instanceof RIdentifier && b.equals(rPsiElement.getText())) {
                arrayList.add(new UsageInfo((PsiElement)rPsiElement));
                continue;
            }
            if (!(rPsiElement instanceof RCall) || !b.equals(((RCall)rPsiElement).getCommand())) continue;
            arrayList.add(new UsageInfo((PsiElement)rPsiElement));
        }
        return arrayList.toArray(UsageInfo.EMPTY_ARRAY);
    }

    private static boolean a(@NotNull Project project, @NotNull String string2, @NotNull RPsiElement rPsiElement) {
        Object object;
        Scope scope;
        long l2 = j ^ 0x36EBFE1243DAL;
        if (project == null) {
            RubyInlineMethodProcessor.a(12);
        }
        if (string2 == null) {
            RubyInlineMethodProcessor.a(13);
        }
        if (rPsiElement == null) {
            RubyInlineMethodProcessor.a(14);
        }
        i.assertTrue((scope = ScopeUtil.getScope(rPsiElement)) != null, (Object)"Null scope is not expected here");
        final HashSet<String> hashSet = new HashSet<String>();
        for (ScopeVariable object52 : scope.getDeclaredVariables((PsiElement)rPsiElement)) {
            hashSet.add(object52.getName());
        }
        for (RIdentifier rIdentifier : scope.getImplicitLocalVariables((PsiElement)rPsiElement)) {
            if (!RubyPsiUtil.isBefore((PsiElement)rIdentifier, (PsiElement)rPsiElement)) continue;
            hashSet.add(rIdentifier.getName());
        }
        if (rPsiElement instanceof RCall) {
            RubyInlineMethodProcessor.a((RCall)rPsiElement);
        }
        Object object6 = rPsiElement.getLanguageLevel();
        final RMethod rMethod = (RMethod)RubyElementFactory.createElementFromText(project, string2, object6);
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        final Consumer<String> consumer = string -> {
            int n2 = 1;
            while (hashSet.contains(string + n2)) {
                ++n2;
            }
            hashMap.put((String)string, string + n2);
            hashSet.add(string + n2);
        };
        Collection<ScopeVariable> collection = rMethod.getScope().getAllDeclaredVariables().values();
        for (ScopeVariable scopeVariable : collection) {
            String string3 = scopeVariable.getName();
            if (!hashSet.contains(string3)) continue;
            consumer.accept(string3);
        }
        rMethod.accept(new RubyRecursiveElementVisitor(){

            @Override
            public void visitRIdentifier(RIdentifier rIdentifier) {
                String string;
                if (rIdentifier.isBlockParameterDeclaration() && RubyPsiUtil.getParentContainer((PsiElement)rIdentifier) == rMethod && !hashMap.containsKey(string = rIdentifier.getName()) && hashSet.contains(string)) {
                    consumer.accept(string);
                }
            }
        });
        final HashSet hashSet2 = new HashSet();
        rMethod.accept(new RubyRecursiveElementVisitor(){

            @Override
            public void visitRIdentifier(RIdentifier identifier) {
                if (RubyPsiUtil.getParentContainer((PsiElement)identifier) != rMethod || identifier.getParent() instanceof RReference && ((RReference)identifier.getParent()).getValue() == identifier) {
                    return;
                }
                String string = identifier.getName();
                if (hashMap.containsKey(string)) {
                    hashSet2.add(Pair.create((Object)identifier, hashMap.get(string)));
                }
            }
        });
        if (rPsiElement instanceof RCall) {
            for (RPsiElement rPsiElement2 : ((RCall)rPsiElement).getCallArguments().getElements()) {
                String string4;
                if (!(rPsiElement2 instanceof RAssoc) || !hashMap.containsKey(string4 = ((RAssoc)rPsiElement2).getKeyText())) continue;
                hashSet2.add(Pair.create((Object)((PsiNamedElement)((RAssoc)rPsiElement2).getKey()), hashMap.get(string4)));
            }
        }
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            ((PsiNamedElement)pair.first).setName((String)pair.second);
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        for (PsiElement psiElement : RubyInlineMethodProcessor.a(project, rPsiElement, object6, rMethod, hashMap)) {
            arrayList.add(psiElement.getNode());
            arrayList.add(RubyElementFactory.createNewLine((PsiElement)rPsiElement).getNode());
        }
        List<RPsiElement> list2 = rMethod.getCompoundStatement().getStatements();
        RPsiElement rPsiElement3 = RubyPsiUtil.getStatement((PsiElement)rPsiElement);
        String string5 = rMethod.getName() + "_value";
        if (hashSet.contains(string5)) {
            consumer.accept(string5);
            string5 = (String)hashMap.get(string5);
        }
        if (rPsiElement3 != rPsiElement && list2.size() > 1) {
            object = list2.get(list2.size() - 1);
            object.replace((PsiElement)RubyElementFactory.createExpressionFromText(project, string5 + " = " + object.getText(), object6));
        }
        object = RubyPsiUtil.getCompoundStatement((PsiElement)rPsiElement).getNode();
        ASTNode aSTNode = rPsiElement3.getNode();
        if (!arrayList.isEmpty()) {
            for (ASTNode aSTNode2 : arrayList) {
                object.addChild(aSTNode2, aSTNode);
            }
        }
        if (rPsiElement3 == rPsiElement) {
            for (ASTNode aSTNode3 : rMethod.getCompoundStatement().getNode().getChildren(null)) {
                object.addChild(aSTNode3, aSTNode);
            }
            RubyInlineMethodProcessor.b((PsiElement)rPsiElement);
            rPsiElement.delete();
        } else if (list2.isEmpty()) {
            rPsiElement.replace((PsiElement)RubyElementFactory.createExpressionFromText(project, RubyTokenTypes.kNIL.toString(), object6));
        } else if (list2.size() == 1) {
            if (RubyReplaceExpressionUtil.isNeedParenthesis(rPsiElement, list2.get(0))) {
                rPsiElement.replace((PsiElement)RubyElementFactory.createExpressionFromText(project, "(" + list2.get(0).getText() + ")", object6));
            } else {
                rPsiElement.replace((PsiElement)list2.get(0));
            }
        } else {
            for (ASTNode aSTNode4 : rMethod.getCompoundStatement().getNode().getChildren(null)) {
                object.addChild(aSTNode4, aSTNode);
            }
            object.addChild(RubyElementFactory.createNewLine((PsiElement)rPsiElement).getNode(), aSTNode);
            rPsiElement.replace((PsiElement)RubyElementFactory.createExpressionFromText(project, string5, object6));
        }
        return true;
    }

    private static void a(@NotNull RCall rCall) {
        if (rCall == null) {
            RubyInlineMethodProcessor.a(15);
        }
        for (RPsiElement rPsiElement : rCall.getCallArguments().getElements()) {
            RPsiElement rPsiElement2;
            if (!(rPsiElement instanceof RAssignmentExpression) || (rPsiElement2 = ((RAssignmentExpression)rPsiElement).getValue()) == null) continue;
            RubyIntroduceVariableHandler.insertDeclaration((PsiElement)rPsiElement, (PsiElement)rCall, null, false, RubyIntroduceVariableHandler.STANDARD_BODY_PRODUCER);
            rPsiElement.replace((PsiElement)rPsiElement2);
        }
    }

    private static void b(PsiElement psiElement) {
        PsiElement psiElement2 = psiElement.getPrevSibling();
        if (psiElement2 != null && psiElement2.getNode().getElementType() == RubyTokenTypes.tEOL) {
            psiElement2.delete();
        }
    }

    private static List<PsiElement> a(Project project, RPsiElement rPsiElement, LanguageLevel languageLevel, RMethod rMethod, Map<String, String> map2) {
        long l2 = j ^ 0x2B06B6D9BE1DL;
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        List<RPsiElement> list2 = rPsiElement instanceof RCall ? ((RCall)rPsiElement).getArguments() : Collections.emptyList();
        List<RArgument> list3 = rMethod.getArguments();
        int n2 = 0;
        for (int i10 = 0; i10 < list3.size(); ++i10) {
            StringBuilder stringBuilder;
            RArgument rArgument = list3.get(i10);
            ArgumentInfo.Type type = rArgument.getType();
            if (type == ArgumentInfo.Type.SIMPLE || type == ArgumentInfo.Type.PREDEFINED || type == ArgumentInfo.Type.NAMED || type == ArgumentInfo.Type.KEYREQ) {
                RPsiElement rPsiElement2;
                stringBuilder = new StringBuilder();
                if (n2 < list2.size()) {
                    if (list2.get(n2) instanceof RArrayToArguments) {
                        RubyInlineMethodProcessor.a(stringBuilder, list3, i10, list2, n2);
                        i10 = list3.size();
                        arrayList.add((PsiElement)RubyElementFactory.createExpressionFromText(project, stringBuilder.toString(), languageLevel));
                        continue;
                    }
                    rPsiElement2 = new Ref((Object)true);
                    if (RubyInlineMethodProcessor.tryToInlineArgument(rMethod, rArgument.getName(), (PsiElement)list2.get(n2), map2, (Ref<Boolean>)rPsiElement2)) {
                        if (!((Boolean)rPsiElement2.get()).booleanValue()) continue;
                        ++n2;
                        continue;
                    }
                    stringBuilder.append(rArgument.getName()).append(" = ").append(list2.get(n2).getText());
                    arrayList.add((PsiElement)RubyElementFactory.createExpressionFromText(project, stringBuilder.toString(), languageLevel));
                    ++n2;
                    continue;
                }
                rPsiElement2 = type == ArgumentInfo.Type.PREDEFINED || type == ArgumentInfo.Type.NAMED ? rArgument.getValue() : RubyElementFactory.createExpressionFromText(project, RubyTokenTypes.kNIL.toString(), languageLevel);
                Ref ref = new Ref((Object)true);
                if (RubyInlineMethodProcessor.tryToInlineArgument(rMethod, rArgument.getName(), (PsiElement)rPsiElement2, map2, (Ref<Boolean>)ref)) {
                    if (!((Boolean)ref.get()).booleanValue()) continue;
                    ++n2;
                    continue;
                }
                stringBuilder.append(rArgument.getName()).append(" = ").append(rPsiElement2.getText());
                arrayList.add((PsiElement)RubyElementFactory.createExpressionFromText(project, stringBuilder.toString(), languageLevel));
                continue;
            }
            if (type != ArgumentInfo.Type.ARRAY) continue;
            stringBuilder = new StringBuilder();
            RubyInlineMethodProcessor.a(stringBuilder, list3, i10, list2, n2);
            i10 = list3.size();
            arrayList.add((PsiElement)RubyElementFactory.createExpressionFromText(project, stringBuilder.toString(), languageLevel));
        }
        return arrayList;
    }

    private static void a(StringBuilder stringBuilder, List<RArgument> list2, int n2, List<RPsiElement> list3, int n3) {
        long l2 = j ^ 0x1603F793277BL;
        while (n2 < list2.size()) {
            RArgument rArgument;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            if ((rArgument = list2.get(n2)).getType() == ArgumentInfo.Type.ARRAY) {
                stringBuilder.append("*");
            }
            stringBuilder.append(rArgument.getName());
            ++n2;
        }
        stringBuilder.append(" = ");
        if (n3 < list3.size()) {
            while (n3 < list3.size()) {
                stringBuilder.append(list3.get(n3).getText());
                if (n3 < list3.size() - 1) {
                    stringBuilder.append(", ");
                }
                ++n3;
            }
        } else {
            stringBuilder.append("[]");
        }
    }

    public static boolean tryToInlineArgument(RMethod method, final String argumentName, PsiElement value, Map<String, String> renameMap, Ref<Boolean> matchCallArgument) {
        final ArrayList arrayList = new ArrayList();
        final Ref ref = new Ref((Object)true);
        method.getCompoundStatement().accept(new RubyRecursiveElementVisitor(){

            @Override
            public void visitRIdentifier(RIdentifier identifier) {
                if (argumentName.equals(identifier.getName()) && (identifier.isParameter() || identifier.isLocalVariable())) {
                    arrayList.add(identifier);
                    ref.set((Object)((Boolean)ref.get() != false && !RubyPsiUtil.isDeclaration((PsiElement)identifier) ? 1 : 0));
                }
            }
        });
        if (((Boolean)ref.get()).booleanValue() && (RubyPsiUtil.isConstantValue(value) || arrayList.size() <= 1)) {
            PsiElement psiElement = RubyInlineMethodProcessor.a(method, argumentName, value, renameMap, matchCallArgument);
            if (psiElement == null) {
                return false;
            }
            for (RIdentifier rIdentifier : arrayList) {
                rIdentifier.replace(psiElement);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiElement a(@NotNull RMethod rMethod, @NotNull String string, @NotNull PsiElement psiElement, @NotNull Map<String, String> map2, @NotNull Ref<Boolean> ref) {
        if (rMethod == null) {
            RubyInlineMethodProcessor.a(16);
        }
        if (string == null) {
            RubyInlineMethodProcessor.a(17);
        }
        if (psiElement == null) {
            RubyInlineMethodProcessor.a(18);
        }
        if (map2 == null) {
            RubyInlineMethodProcessor.a(19);
        }
        if (ref == null) {
            RubyInlineMethodProcessor.a(20);
        }
        LanguageLevel languageLevel = rMethod.getLanguageLevel();
        Object object = psiElement;
        if (languageLevel != null) {
            RPsiElement rPsiElement = null;
            if (!languageLevel.isLessThan(LanguageLevel.RUBY20) && psiElement instanceof RAssoc) {
                rPsiElement = ((RAssoc)psiElement).getKey();
                if (rPsiElement != null && string.equals(rPsiElement.getText())) {
                    object = ((RAssoc)psiElement).getValue();
                } else {
                    object = RubyInlineMethodProcessor.a(string, psiElement);
                    if (object == null && (object = (PsiElement)rMethod.getArguments().stream().filter(rArgument -> rArgument.getType() == ArgumentInfo.Type.NAMED && string.equals(rArgument.getName())).findFirst().orElse(null)) != null) {
                        object = ((RArgument)object).getValue();
                        ref.set((Object)false);
                    }
                }
            } else if (psiElement instanceof RAssignmentExpression) {
                String string2 = ((RAssignmentExpression)psiElement).getObject().getText();
                object = string.equals(string2 = map2.getOrDefault(string2, string2)) ? ((RAssignmentExpression)psiElement).getValue() : RubyInlineMethodProcessor.a(string, psiElement);
            }
        }
        if (object instanceof RBinaryExpression) {
            object = RubyElementFactory.createElementFromText(object, "(" + object.getText() + ")");
        }
        return object;
    }

    private static PsiElement a(@NotNull String string, @NotNull PsiElement psiElement) {
        PsiElement[] psiElementArray;
        if (string == null) {
            RubyInlineMethodProcessor.a(21);
        }
        if (psiElement == null) {
            RubyInlineMethodProcessor.a(22);
        }
        RPsiElement rPsiElement = null;
        PsiElement psiElement2 = psiElement.getParent();
        for (PsiElement psiElement3 : psiElementArray = psiElement2.getChildren()) {
            RPsiElement rPsiElement2;
            if (psiElement3 instanceof RAssoc && (rPsiElement2 = ((RAssoc)psiElement3).getKey()) != null && string.equals(rPsiElement2.getText())) {
                rPsiElement = ((RAssoc)psiElement3).getValue();
            }
            if (!(psiElement3 instanceof RAssignmentExpression) || !string.equals((rPsiElement2 = ((RAssignmentExpression)psiElement3).getObject()).getText())) continue;
            rPsiElement = ((RAssignmentExpression)psiElement3).getValue();
        }
        return rPsiElement;
    }

    public static void inspectUsages(RMethod method, final MultiMap<PsiElement, String> conflicts, UsageInfo[] usagesIn) {
        Object object;
        RCompoundStatement rCompoundStatement;
        Object object2;
        long l2 = j ^ 0x1CFE708587CDL;
        Collection<PsiElement> collection = RControlFlowUtil.findExitPointsAndStatements(method.getControlFlow());
        if (collection.size() > 1) {
            object2 = RefactoringBundle.message((String)"refactoring.is.not.supported.when.return.statement.interrupts.the.execution.flow", (Object[])new Object[]{REFACTORING_NAME});
            for (UsageInfo usageInfo : usagesIn) {
                PsiElement psiElement = usageInfo.getElement();
                RPsiElement rPsiElement = RubyPsiUtil.getStatement(psiElement);
                if (rPsiElement != psiElement) {
                    conflicts.putValue((Object)psiElement, object2);
                    continue;
                }
                rCompoundStatement = (RCompoundStatement)rPsiElement.getParent();
                if (PsiTreeUtil.getParentOfType((PsiElement)rCompoundStatement, (Class[])new Class[]{RContainer.class, RCompoundStatement.class}) instanceof RCompoundStatement) {
                    conflicts.putValue((Object)psiElement, object2);
                    continue;
                }
                object = rCompoundStatement.getStatements();
                if (object.get(object.size() - 1) == rPsiElement) continue;
                conflicts.putValue((Object)psiElement, object2);
            }
        }
        object2 = new HashSet();
        UsageInfo[] usageInfoArray = new HashSet();
        Ref ref = new Ref((Object)false);
        method.acceptChildren(new RubyRecursiveElementVisitor((Set)usageInfoArray, (Set)object2, ref){
            final /* synthetic */ Set val$classFieldsUsed;
            final /* synthetic */ Set val$instanceFieldsUsed;
            final /* synthetic */ Ref val$superCallUsed;
            {
                this.val$classFieldsUsed = set;
                this.val$instanceFieldsUsed = set2;
                this.val$superCallUsed = ref;
            }

            @Override
            public void visitRClassVariable(RClassVariable rClassVariable) {
                this.val$classFieldsUsed.add(rClassVariable.getText());
            }

            @Override
            public void visitRInstanceVariable(RInstanceVariable rInstanceVariable) {
                this.val$instanceFieldsUsed.add(rInstanceVariable.getText());
            }

            @Override
            public void visitRPseudoConstant(RPseudoConstant rPseudoConstant) {
                if (RubyTokenTypes.kSUPER.toString().equals(rPseudoConstant.getText())) {
                    this.val$superCallUsed.set((Object)true);
                }
            }
        });
        if (!object2.isEmpty() || !usageInfoArray.isEmpty() || ((Boolean)ref.get()).booleanValue()) {
            for (UsageInfo usageInfo : usagesIn) {
                rCompoundStatement = usageInfo.getElement();
                if (!(rCompoundStatement instanceof RReference)) continue;
                object = object2.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    conflicts.putValue((Object)rCompoundStatement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{string, rCompoundStatement.getText()}));
                }
                for (String string : usageInfoArray) {
                    conflicts.putValue((Object)rCompoundStatement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{string, rCompoundStatement.getText()}));
                }
                if (!((Boolean)ref.get()).booleanValue()) continue;
                conflicts.putValue((Object)rCompoundStatement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{RubyTokenTypes.kSUPER.toString(), rCompoundStatement.getText()}));
            }
        }
        method.putUserData(e, new HashSet());
        for (UsageInfo usageInfo : usagesIn) {
            rCompoundStatement = usageInfo.getElement();
            if (!RubyInlineMethodProcessor.a((PsiElement)rCompoundStatement)) continue;
            method.acceptChildren(new RubyRecursiveElementVisitor((PsiElement)rCompoundStatement, method){
                final /* synthetic */ PsiElement val$callElement;
                final /* synthetic */ RMethod val$method;
                private static final long a = com.jetbrains.python.psi.c.a(355203693832199681L, 5460922422518736413L, MethodHandles.lookup().lookupClass()).a(24166053563995L);
                {
                    this.val$callElement = psiElement;
                    this.val$method = rMethod;
                }

                @Override
                public void visitRIdentifier(RIdentifier rIdentifier) {
                    if (rIdentifier.isParameter() || rIdentifier.isLocalVariable()) {
                        return;
                    }
                    this.inspectElement(rIdentifier);
                }

                @Override
                public void visitRFid(RFid rFid) {
                    this.inspectElement(rFid);
                }

                @Override
                public void visitRConstant(RConstant rConstant) {
                    this.inspectElement(rConstant);
                }

                public void inspectElement(RPsiElement psiElement) {
                    long l2 = a ^ 0x705531312483L;
                    if (RReferenceNavigator.getRRefenceOrTopReference((PsiElement)psiElement) != null) {
                        return;
                    }
                    PsiReference psiReference = psiElement.getReference();
                    if (psiReference == null) {
                        return;
                    }
                    Symbol symbol = ResolveUtil.resolveToSymbolWithCaching(psiReference);
                    if (symbol == null) {
                        return;
                    }
                    if (SymbolUtil.isTopLevelSymbol(symbol)) {
                        return;
                    }
                    Symbol symbol2 = symbol.getParentSymbol();
                    if (symbol2 != null && SymbolUtil.isTopLevelSymbol(symbol2) && ("Kernel".equals(symbol2.getName()) || "Object".equals(symbol2.getName()))) {
                        return;
                    }
                    if (symbol.getType() == Type.CLASS_METHOD) {
                        if (((RMethodSymbol)symbol).getVisibility() != Visibility.PUBLIC) {
                            conflicts.putValue((Object)psiElement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{psiElement.getText(), this.val$callElement.getText()}));
                        }
                        String string = RSingletonMethodImpl.makeRubyCallableFQN(symbol.getFQNWithNesting()).getFullPath();
                        psiElement.putUserData(h, string);
                        return;
                    }
                    if (symbol.getType() == Type.CONSTANT) {
                        String string = symbol.getFQNWithNesting().getFullPath();
                        psiElement.putUserData(h, string);
                        return;
                    }
                    if (symbol.getType() == Type.INSTANCE_METHOD) {
                        if (((RMethodSymbol)symbol).getVisibility() != Visibility.PUBLIC) {
                            conflicts.putValue((Object)psiElement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{psiElement.getText(), this.val$callElement.getText()}));
                        }
                        if (symbol2 != null && Types.MODULE_OR_CLASS.contains(symbol2.getType())) {
                            if (symbol2.getType() == Type.CLASS) {
                                psiElement.putUserData(h, "self");
                                return;
                            }
                            Set set = (Set)this.val$method.getUserData(e);
                            String string = symbol2.getFQNWithNesting().getFullPath();
                            assert (set != null) : "data should be initialized before inspection";
                            set.add(string);
                            return;
                        }
                    }
                    conflicts.putValue((Object)psiElement, (Object)RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{psiElement.getText(), this.val$callElement.getText()}));
                }
            });
        }
    }

    public static boolean inspectMethod(Project project, Editor editor2, final RMethod method) {
        long l2 = j ^ 0x1264EC510E90L;
        if (!ApplicationManager.getApplication().isUnitTestMode() && !CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)method)) {
            return false;
        }
        if (RailsUtil.isUnderVendor((PsiElement)method) || ModuleUtilCore.findModuleForPsiElement((PsiElement)method) == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)"Cannot perform refactoring with method in libraries", (String)REFACTORING_NAME, (String)HELP_ID);
            return false;
        }
        if (method.isConstructor()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)"Cannot perform refactoring with constructor", (String)REFACTORING_NAME, (String)HELP_ID);
            return false;
        }
        List<ArgumentInfo> list2 = method.getArgumentInfos();
        for (ArgumentInfo argumentInfo : list2) {
            if (argumentInfo.getType() != ArgumentInfo.Type.BLOCK) continue;
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)"Cannot perform refactoring with method that has block parameter", (String)REFACTORING_NAME, (String)HELP_ID);
            return false;
        }
        final Ref ref = new Ref((Object)false);
        method.accept(new RubyRecursiveElementVisitor(){

            @Override
            public void visitRFid(RFid rFid) {
                PsiReference psiReference = rFid.getReference();
                if (psiReference != null && ResolveUtil.isReferenceTo(psiReference, (PsiElement)method)) {
                    ref.set((Object)true);
                }
            }

            @Override
            public void visitRIdentifier(RIdentifier rIdentifier) {
                PsiReference psiReference = rIdentifier.getReference();
                if (psiReference != null && ResolveUtil.isReferenceTo(psiReference, (PsiElement)method)) {
                    ref.set((Object)true);
                }
            }
        });
        if (((Boolean)ref.get()).booleanValue()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)RefactoringBundle.message((String)"refactoring.is.not.supported.for.recursive.methods", (Object[])new Object[]{REFACTORING_NAME}), (String)REFACTORING_NAME, (String)HELP_ID);
            return false;
        }
        return true;
    }

    static {
        j = com.jetbrains.python.psi.c.a(3216655392299241774L, -6842803775770355897L, MethodHandles.lookup().lookupClass()).a(75335154784427L);
        long l2 = j ^ 0x383E4F7DA868L;
        i = Logger.getInstance(RubyInlineMethodProcessor.class);
        REFACTORING_NAME = RefactoringBundle.message((String)"inline.method.title");
        b = RubyTokenTypes.kSUPER.toString();
        h = Key.create((String)"ruby.inline.method.fqn.transformation");
        e = Key.create((String)"ruby.inline.method.include.transformation");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = j ^ 0x60DC56D2C087L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageText";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameMap";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchCallArgument";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/inline/RubyInlineMethodProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareMethodForInline";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getReplacement";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateReference";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractAssignmentParameters";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "tryParsePredefinedParams";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findPredefinedParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

