/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.common;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.AbstractUsesDependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.DependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.jetbrains.python.psi.c;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfoStorage;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.UpDirectedMembersMovingDialog;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public abstract class RubyExtractSuperBaseDialog
extends UpDirectedMembersMovingDialog {
    protected JTextField mySourceClassField;
    protected JLabel mySuperNameLabel;
    protected JTextField myExtractedSuperNameField;
    protected TextFieldWithBrowseButton myTargetDirField;
    protected JLabel myDirLabel;
    private static final long c = com.jetbrains.python.psi.c.a(-776260656646319689L, -5322854429755539653L, MethodHandles.lookup().lookupClass()).a(91593370169809L);

    public RubyExtractSuperBaseDialog(Project project, RContainer clazz, RubyMemberInfoStorage memberInfos) {
        super(project, clazz);
        this.myMemberInfos = memberInfos.getClassMemberInfos((PsiElement)this.myClass);
        this.myExtractedSuperNameField = new JTextField();
        this.myTargetDirField = new TextFieldWithBrowseButton();
        this.initSourceClassField();
    }

    @Override
    protected DependencyMemberInfoModel<RPsiElement, RubyMemberInfo> createMemberInfoModel() {
        return new MyMemberInfoModel(this.myClass);
    }

    protected void initSourceClassField() {
        this.mySourceClassField = new JTextField();
        this.mySourceClassField.setEditable(false);
        this.mySourceClassField.setText(this.myClass instanceof RClass ? ((RClass)this.myClass).getQualifiedName() : ((RModule)this.myClass).getQualifiedName());
    }

    @Override
    protected abstract String getMembersBorderTitle();

    public JComponent getPreferredFocusedComponent() {
        return this.myExtractedSuperNameField;
    }

    @Override
    protected void doOKAction() {
        long l2 = c ^ 0x6806E8327B05L;
        String string = this.getSuperBaseName();
        if (!NamingConventions.isInCamelCaseExt(string)) {
            this.setErrorText(RBundle.message("refactoring.extract.superbase.name.error", StringUtil.capitalize((String)this.getSuperBaseType())), this.myExtractedSuperNameField);
            return;
        }
        String string2 = this.a();
        VirtualFile virtualFile = this.getTargetDirectory();
        if (virtualFile == null) {
            this.setErrorText(RBundle.message("refactoring.extract.superbase.directory.does.not.exist", string2), (JComponent)this.myTargetDirField);
            return;
        }
        String string3 = RubyRefactoringUtil.getNewFileName(string);
        if (virtualFile.findFileByRelativePath(string3) != null) {
            this.setErrorText(RBundle.message("refactoring.extract.superbase.directory.file.exists", string3), this.myExtractedSuperNameField);
            return;
        }
        super.doOKAction();
    }

    @Nullable
    public VirtualFile getTargetDirectory() {
        return VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)this.a())));
    }

    private String a() {
        return this.myTargetDirField.getText();
    }

    protected abstract String getSuperBaseType();

    public String getSuperBaseName() {
        return this.myExtractedSuperNameField.getText();
    }

    protected VirtualFile getRoot() {
        return this.myClass.getContainingFile().getVirtualFile().getParent();
    }

    protected JPanel createNorthPanel() {
        long l2 = c ^ 0x10CC8CCDB6DL;
        Box box = this.createBox();
        box.add(Box.createVerticalStrut(10));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)box, "Center");
        return jPanel;
    }

    protected Box createBox() {
        long l2 = c ^ 0x4381EEABE3C8L;
        Box box = Box.createVerticalBox();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(RBundle.message("refactoring.extract.superbase.from", this.getSuperBaseType())), "North");
        jPanel.add((Component)this.mySourceClassField, "Center");
        box.add(jPanel);
        box.add(Box.createVerticalStrut(10));
        this.mySuperNameLabel = new JLabel();
        this.mySuperNameLabel.setText(RBundle.message("refactoring.extract.superbase.name.prompt", StringUtil.capitalize((String)this.getSuperBaseType())));
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.mySuperNameLabel, "North");
        jPanel.add((Component)this.myExtractedSuperNameField, "Center");
        box.add(jPanel);
        box.add(Box.createVerticalStrut(5));
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        VirtualFile virtualFile = this.getRoot();
        fileChooserDescriptor.setRoots(new VirtualFile[]{virtualFile});
        fileChooserDescriptor.withTreeRootVisible(true);
        this.myTargetDirField.setText(FileUtil.toSystemDependentName((String)virtualFile.getPath()));
        this.myTargetDirField.addBrowseFolderListener(this.getFileBrowserTitle(), null, this.myClass.getProject(), fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        jPanel = new JPanel(new BorderLayout());
        this.myDirLabel = new JLabel();
        this.myDirLabel.setText(this.getFileBrowserTitle());
        jPanel.add((Component)this.myDirLabel, "North");
        jPanel.add((Component)this.myTargetDirField, "Center");
        box.add(jPanel);
        return box;
    }

    @Override
    public boolean checkConflicts() {
        long l2 = c ^ 0x580E119B7673L;
        Collection<RubyMemberInfo> collection = this.getSelectedMemberInfos();
        if (!RubyExtractSuperBaseDialog.checkWritable(this.myClass, collection)) {
            return false;
        }
        if (collection.size() == 0) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(this.myClass.getProject(), new String[]{RBundle.message("refactoring.extract.superbase.no.members", this.getSuperBaseType())});
            return conflictsDialog.showAndGet();
        }
        return true;
    }

    protected abstract String getFileBrowserTitle();

    protected boolean isStaticAllowed() {
        return true;
    }

    protected boolean isInstanceAllowed() {
        return true;
    }

    private class MyMemberInfoModel
    extends AbstractUsesDependencyMemberInfoModel<RPsiElement, RContainer, RubyMemberInfo> {
        private static final long a = com.jetbrains.python.psi.c.a(2344225108125439441L, -1765616414161149599L, MethodHandles.lookup().lookupClass()).a(123339296740569L);

        MyMemberInfoModel(RContainer clazz) {
            super((PsiElement)clazz, null, false);
        }

        public boolean isMemberEnabled(RubyMemberInfo member) {
            return member.isStatic() && RubyExtractSuperBaseDialog.this.isStaticAllowed() || !member.isStatic() && RubyExtractSuperBaseDialog.this.isInstanceAllowed();
        }

        public boolean isAbstractEnabled(RubyMemberInfo member) {
            return false;
        }

        public int checkForProblems(@NotNull RubyMemberInfo member) {
            if (member == null) {
                MyMemberInfoModel.a(0);
            }
            return member.isChecked() ? 0 : super.checkForProblems((MemberInfoBase)member);
        }

        protected int doCheck(@NotNull RubyMemberInfo memberInfo, int problem) {
            if (memberInfo == null) {
                MyMemberInfoModel.a(1);
            }
            if (problem == 2 && memberInfo.isStatic()) {
                return 1;
            }
            return problem;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = a ^ 0x3BA2631D4529L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberInfo";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/common/RubyExtractSuperBaseDialog$MyMemberInfoModel";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkForProblems";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCheck";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

