/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.common;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.jetbrains.python.psi.c;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.motion.RubyMotionUtil;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsRequireUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyVisibilityCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;

public class RubyClassMembersPsiHelper {
    private static final long a = c.a(-8826374077608666065L, 5980188568796991861L, MethodHandles.lookup().lookupClass()).a(223473180440242L);

    private RubyClassMembersPsiHelper() {
    }

    public static PsiElement findPrepared(RFile file, String superBaseName) {
        Symbol symbol = SymbolUtil.findConstantByFQN(file.getProject(), Type.CLASS, superBaseName, null);
        PsiElement psiElement = symbol != null ? symbol.getPsiElement() : null;
        return psiElement != null ? psiElement : file;
    }

    public static void insertRequire(PsiFile toFile, RFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        assert (virtualFile != null);
        RailsApp railsApp = RailsApp.fromPsiElement((PsiElement)toFile);
        if (railsApp != null) {
            for (VirtualFile virtualFile2 : RailsRequireUtil.getRailsDefaultLoadPath(railsApp.getModule())) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)false)) continue;
                return;
            }
        }
        if (RubyMotionUtil.getInstance().hasMacRubySupport((PsiElement)toFile)) {
            return;
        }
        RubyClassMembersPsiHelper.insertRequireByAnchor(file, toFile.getFirstChild());
    }

    public static void insertRequireByAnchor(RFile file, PsiElement anchor) {
        long l2 = a ^ 0x5F203A8913ECL;
        VirtualFile virtualFile = file.getVirtualFile();
        assert (virtualFile != null);
        PsiFile psiFile = anchor.getContainingFile();
        VirtualFile virtualFile2 = psiFile.getVirtualFile();
        assert (virtualFile2 != null);
        String string = VfsUtilCore.findRelativePath((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (char)'/');
        assert (string != null);
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
        String string2 = sdk != null && RubyVersionUtil.isVersionGreaterOrEqual(sdk, "1.9.2") ? "require_relative '" + string.replace("\\", "/") + "'\n" : "require File.expand_path(File.dirname(__FILE__) + '/" + string.replace("\\", "/") + "')\n";
        List<RPsiElement> list2 = RubyElementFactory.getNotEmptyTopLevelElements((PsiElement)psiFile, string2);
        RefactoringPsiHelper.insertElements(anchor, list2);
    }

    public static RFile createTargetFile(Project project, VirtualFile targetDirectory, String newFileName, String statements) throws IOException {
        int n2 = newFileName.lastIndexOf(47);
        if (n2 > 0) {
            targetDirectory = RubyClassMembersPsiHelper.createDirectoryIfMissing(targetDirectory.getFileSystem(), targetDirectory.getPath() + "/" + newFileName.substring(0, n2));
            newFileName = newFileName.substring(n2 + 1);
        }
        assert (targetDirectory != null);
        VirtualFile virtualFile = targetDirectory.createChildData(RubyClassMembersPsiHelper.class, newFileName);
        VfsUtil.saveText((VirtualFile)virtualFile, (String)statements);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        assert (psiFile instanceof RFile);
        RubyClassMembersPsiHelper.b(Collections.singletonList(psiFile));
        return (RFile)psiFile;
    }

    @Nullable
    public static VirtualFile createDirectoryIfMissing(@NotNull VirtualFileSystem fileSystem, @NotNull String directoryPath2) throws IOException {
        String string;
        VirtualFile virtualFile;
        if (fileSystem == null) {
            RubyClassMembersPsiHelper.a(0);
        }
        if (directoryPath2 == null) {
            RubyClassMembersPsiHelper.a(1);
        }
        if ((virtualFile = fileSystem.refreshAndFindFileByPath(string = FileUtil.toSystemIndependentName((String)directoryPath2))) == null) {
            int n2 = string.lastIndexOf(47);
            if (n2 < 0) {
                return null;
            }
            VirtualFile virtualFile2 = RubyClassMembersPsiHelper.createDirectoryIfMissing(fileSystem, string.substring(0, n2));
            if (virtualFile2 == null) {
                return null;
            }
            String string2 = string.substring(n2 + 1);
            return virtualFile2.createChildDirectory((Object)fileSystem, string2);
        }
        return virtualFile;
    }

    public static String prepareContainerStatements(String superBaseName, Collection<? extends RubyMemberInfo> members, String type, boolean isStatic) {
        long l2 = a ^ 0x69395030953DL;
        return RubyClassMembersPsiHelper.a(superBaseName.split("::"), members, type, isStatic, 0);
    }

    @Nullable
    public static PsiElement insertMethods(RContainer toClass, Collection<? extends RubyMemberInfo> members, String access, boolean isStatic) {
        if (members.size() == 0) {
            return null;
        }
        PsiElement psiElement = null;
        for (RubyMemberInfo rubyMemberInfo : members) {
            Pair<PsiElement, Boolean> pair = RubyClassMembersPsiHelper.a(toClass, access);
            String string = RubyClassMembersPsiHelper.a(rubyMemberInfo, access, true, (boolean)((Boolean)pair.second), isStatic);
            RFile rFile = RubyElementFactory.createRubyFile(toClass.getProject(), string, RubyPsiUtil.getLanguageLevel((PsiElement)toClass));
            RClass rClass = RContainerUtil.getFirstClassInFile(rFile);
            assert (rClass != null);
            List<? extends PsiElement> list2 = rClass.getStatements();
            list2 = RubyClassMembersPsiHelper.a(list2);
            list2 = RefactoringPsiHelper.insertElements((PsiElement)pair.first, list2);
            RubyClassMembersPsiHelper.b(list2);
            psiElement = list2.size() > 0 ? list2.get(0) : psiElement;
        }
        return psiElement;
    }

    public static void removeMembers(Collection<? extends RubyMemberInfo> members) {
        for (RubyMemberInfo rubyMemberInfo : members) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (rubyMemberInfo.getMember() instanceof RMethod) {
                arrayList.addAll(RubyClassMembersPsiHelper.c(rubyMemberInfo));
            } else {
                arrayList.addAll(RubyClassMembersPsiHelper.b(rubyMemberInfo));
            }
            arrayList.addAll(rubyMemberInfo.getComments());
            arrayList.addAll(rubyMemberInfo.getAliases());
            RubyPsiUtil.removeElements(arrayList.toArray(PsiElement.EMPTY_ARRAY));
        }
    }

    public static void splitByAccess(Collection<? extends RubyMemberInfo> members, Collection<? super RubyMemberInfo> pub, Collection<? super RubyMemberInfo> prot, Collection<? super RubyMemberInfo> priv) {
        for (RubyMemberInfo rubyMemberInfo : members) {
            Visibility visibility = rubyMemberInfo.getVisibility();
            if (visibility == Visibility.PUBLIC) {
                pub.add(rubyMemberInfo);
                continue;
            }
            if (visibility == Visibility.PROTECTED) {
                prot.add(rubyMemberInfo);
                continue;
            }
            priv.add(rubyMemberInfo);
        }
    }

    private static List<PsiElement> c(RubyMemberInfo rubyMemberInfo) {
        List<PsiElement> list2;
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        PsiElement psiElement = rubyMemberInfo.getMember();
        if ((psiElement = RubyClassMembersPsiHelper.a(psiElement, arrayList, false)) == null || RubyClassMembersPsiHelper.a(psiElement)) {
            for (psiElement = ((RPsiElement)rubyMemberInfo.getMember()).getPrevSibling(); psiElement != null && RefactoringPsiHelper.isExtendedWhitespace(psiElement); psiElement = psiElement.getPrevSibling()) {
            }
            if (RubyClassMembersPsiHelper.a(psiElement)) {
                RubyClassMembersPsiHelper.a(psiElement, arrayList, false);
            }
        }
        if ((list2 = RubyClassMembersPsiHelper.a(rubyMemberInfo)) != null) {
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    @Nullable
    private static PsiElement a(@NotNull PsiElement psiElement, @NotNull ArrayList<? super PsiElement> arrayList, boolean bl2) {
        if (psiElement == null) {
            RubyClassMembersPsiHelper.a(2);
        }
        if (arrayList == null) {
            RubyClassMembersPsiHelper.a(3);
        }
        arrayList.add((PsiElement)psiElement);
        PsiElement psiElement2 = psiElement;
        for (psiElement = psiElement.getNextSibling(); psiElement != null && RefactoringPsiHelper.isExtendedWhitespace(psiElement); psiElement = psiElement.getNextSibling()) {
            if (!(psiElement instanceof PsiComment || !bl2 && psiElement2 instanceof PsiComment)) {
                arrayList.add((PsiElement)psiElement);
            }
            psiElement2 = psiElement;
        }
        return psiElement;
    }

    @Nullable
    private static List<PsiElement> a(RubyMemberInfo rubyMemberInfo) {
        RContainer rContainer = rubyMemberInfo.getContainingClass();
        Symbol symbol = SymbolUtil.getSymbolByContainer(rContainer);
        if (symbol == null) {
            return null;
        }
        for (PsiElement psiElement : symbol.getAllDeclarations(null)) {
            if (!(psiElement instanceof RContainer)) continue;
            for (RPsiElement rPsiElement : ((RContainer)psiElement).getStatements()) {
                List<PsiElement> list2;
                if (!(rPsiElement instanceof RCall) || !(((RCall)rPsiElement).getCallType() instanceof RubyVisibilityCallType) || (list2 = RubyClassMembersPsiHelper.a(rubyMemberInfo, (RCall)rPsiElement)) == null) continue;
                return list2;
            }
        }
        return null;
    }

    @Nullable
    private static List<PsiElement> a(RubyMemberInfo rubyMemberInfo, RCall rCall) {
        List<RPsiElement> list2 = rCall.getArguments();
        if (list2.size() == 0) {
            return null;
        }
        if (list2.size() == 1 && RubyClassMembersPsiHelper.a(rubyMemberInfo, list2.get(0))) {
            return Collections.singletonList(rCall);
        }
        for (int i10 = 0; i10 < list2.size(); ++i10) {
            RPsiElement rPsiElement = list2.get(i10);
            if (!RubyClassMembersPsiHelper.a(rubyMemberInfo, rPsiElement)) continue;
            if (i10 == list2.size() - 1) {
                return RubyClassMembersPsiHelper.b((PsiElement)rPsiElement);
            }
            return RubyClassMembersPsiHelper.c((PsiElement)rPsiElement);
        }
        return null;
    }

    private static boolean a(RubyMemberInfo rubyMemberInfo, RPsiElement rPsiElement) {
        String string = ((RPsiElement)rubyMemberInfo.getMember()).getName();
        String string2 = rPsiElement instanceof RSymbol ? ((RPsiElement)((RSymbol)rPsiElement).getContent()).getName() : (rPsiElement instanceof RStringLiteral ? rPsiElement.getName() : null);
        return string != null && string.equals(string2);
    }

    private static boolean a(PsiElement psiElement) {
        return RubyClassMembersPsiHelper.a(psiElement, null);
    }

    private static boolean a(@Nullable PsiElement psiElement, @Nullable String string) {
        long l2 = a ^ 0x467E1678DDF3L;
        String string2 = psiElement instanceof RIdentifier ? psiElement.getText() : null;
        return string2 != null && (string == null && ("public".equals(string2) || "protected".equals(string2) || "private".equals(string2)) || string2.equals(string));
    }

    private static List<PsiElement> b(RubyMemberInfo rubyMemberInfo) {
        long l2 = a ^ 0x279D53520684L;
        RPsiElement rPsiElement = (RPsiElement)rubyMemberInfo.getMember();
        RCall rCall = RubyPsiUtil.getCoveringRCall((PsiElement)rPsiElement);
        assert (rCall != null) : "Can't get covering call: member = [" + (Object)((Object)rubyMemberInfo) + "]arg = [" + (rPsiElement == null ? null : rPsiElement.getText()) + "]";
        List<RPsiElement> list2 = rCall.getArguments();
        if (list2.size() == 1) {
            return Collections.singletonList(rCall);
        }
        return list2.get(list2.size() - 1) == rPsiElement ? RubyClassMembersPsiHelper.b((PsiElement)rPsiElement) : RubyClassMembersPsiHelper.c((PsiElement)rPsiElement);
    }

    private static List<PsiElement> c(PsiElement psiElement) {
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        arrayList.add(psiElement);
        psiElement = psiElement.getNextSibling();
        while (psiElement instanceof PsiWhiteSpace) {
            arrayList.add(psiElement);
            psiElement = psiElement.getNextSibling();
        }
        if (psiElement != null && ",".equals(psiElement.getText())) {
            arrayList.add(psiElement);
            psiElement = psiElement.getNextSibling();
        }
        while (psiElement instanceof PsiWhiteSpace) {
            arrayList.add(psiElement);
            psiElement = psiElement.getNextSibling();
        }
        return arrayList;
    }

    private static List<PsiElement> b(PsiElement psiElement) {
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        arrayList.add(psiElement);
        psiElement = psiElement.getPrevSibling();
        while (psiElement instanceof PsiWhiteSpace) {
            arrayList.add(psiElement);
            psiElement = psiElement.getPrevSibling();
        }
        if (psiElement != null && psiElement.getNode().getElementType() == RubyTokenTypes.tCOMMA) {
            arrayList.add(psiElement);
            psiElement = psiElement.getPrevSibling();
        }
        while (psiElement instanceof PsiWhiteSpace) {
            arrayList.add(psiElement);
            psiElement = psiElement.getPrevSibling();
        }
        return arrayList;
    }

    private static void b(List<? extends PsiElement> list2) {
        if (list2.size() == 0) {
            return;
        }
        PsiElement psiElement = list2.get(0);
        int n2 = psiElement.getTextRange().getStartOffset();
        int n3 = list2.get(list2.size() - 1).getTextRange().getEndOffset();
        PsiFile psiFile = psiElement.getContainingFile();
        PsiFile psiFile2 = psiFile.getViewProvider().getPsi(psiFile.getViewProvider().getBaseLanguage());
        assert (psiFile2 != null);
        CodeStyleManager.getInstance((Project)psiElement.getProject()).reformatText(psiFile2, n2, n3);
    }

    private static Pair<PsiElement, Boolean> a(RContainer rContainer, String string) {
        long l2 = a ^ 0x3843C1D8836FL;
        List<RPsiElement> list2 = rContainer.getStatements();
        if ("public".equals(string) && list2.size() > 0) {
            return Pair.create((Object)list2.get(0), (Object)false);
        }
        for (RPsiElement rPsiElement : list2) {
            int n2;
            if (!RubyClassMembersPsiHelper.a((PsiElement)rPsiElement, string) || (n2 = list2.indexOf(rPsiElement)) + 1 >= list2.size()) continue;
            return Pair.create((Object)list2.get(n2 + 1), (Object)false);
        }
        return Pair.create((Object)RubyClassMembersPsiHelper.findDefaultAnchor(rContainer), (Object)true);
    }

    @Nullable
    public static PsiElement findDefaultAnchor(RContainer toClass) {
        PsiElement psiElement = toClass.getLastChild();
        return psiElement != null ? psiElement.getPrevSibling() : null;
    }

    private static String a(RubyMemberInfo rubyMemberInfo, String string, boolean bl2, boolean bl3, boolean bl4) {
        long l2 = a ^ 0x1F8E084B765CL;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append("class Foo\n");
        }
        if (bl3 && !"public".equals(string)) {
            stringBuilder.append(string).append('\n').append('\n');
        }
        for (PsiComment object : rubyMemberInfo.getComments()) {
            stringBuilder.append(object.getText()).append('\n');
        }
        RPsiElement rPsiElement = (RPsiElement)rubyMemberInfo.getMember();
        if (rPsiElement instanceof RConstant) {
            stringBuilder.append(rubyMemberInfo.getDisplayName()).append('\n');
        } else {
            String string2 = rPsiElement.getText();
            if (!bl4) {
                stringBuilder.append(string2);
            } else {
                stringBuilder.append(string2.replaceFirst("^\\s*def\\s*(self|a-zA-Z:)\\.", "def "));
            }
            stringBuilder.append('\n');
        }
        for (RAliasStatement rAliasStatement : rubyMemberInfo.getAliases()) {
            stringBuilder.append(rAliasStatement.getText()).append('\n');
        }
        if (bl2) {
            stringBuilder.append("end");
        }
        return stringBuilder.toString();
    }

    private static List<? extends PsiElement> a(List<? extends PsiElement> list2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (PsiElement psiElement : list2) {
            arrayList.addAll(RubyCommentsUtil.getPsiComments(psiElement));
            arrayList.add(psiElement);
        }
        return arrayList;
    }

    private static String a(String[] stringArray, Collection<? extends RubyMemberInfo> collection, String string, boolean bl2, int n2) {
        long l2 = a ^ 0x5F3869CE9791L;
        boolean bl3 = n2 == stringArray.length - 1;
        String string2 = bl3 ? string : "module";
        String string3 = bl3 ? RubyClassMembersPsiHelper.a(collection, bl2) : RubyClassMembersPsiHelper.a(stringArray, collection, string, bl2, n2 + 1);
        return string2 + " " + stringArray[n2] + "\n" + string3 + "end\n";
    }

    private static String a(Collection<? extends RubyMemberInfo> collection, boolean bl2) {
        long l2 = a ^ 0x68CC7CFA5A1CL;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        RubyClassMembersPsiHelper.splitByAccess(collection, arrayList, arrayList2, arrayList3);
        StringBuilder stringBuilder = new StringBuilder();
        for (RubyMemberInfo rubyMemberInfo : arrayList) {
            stringBuilder.append(RubyClassMembersPsiHelper.a(rubyMemberInfo, "public", false, false, bl2));
        }
        if (!arrayList2.isEmpty()) {
            stringBuilder.append("\n\nprotected\n");
            for (RubyMemberInfo rubyMemberInfo : arrayList2) {
                stringBuilder.append(RubyClassMembersPsiHelper.a(rubyMemberInfo, "protected", false, false, bl2));
            }
        }
        if (!arrayList3.isEmpty()) {
            stringBuilder.append("\n\nprivate\n");
            for (RubyMemberInfo rubyMemberInfo : arrayList3) {
                stringBuilder.append(RubyClassMembersPsiHelper.a(rubyMemberInfo, "private", false, false, bl2));
            }
        }
        return stringBuilder.toString();
    }

    public static void removeContainer(RContainer container) {
        RubyPsiUtil.removeElements(new PsiElement[]{container});
    }

    public static void removeComments(@NotNull List<? extends PsiComment> comments) {
        if (comments == null) {
            RubyClassMembersPsiHelper.a(4);
        }
        if (comments.isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        RubyClassMembersPsiHelper.a((PsiElement)comments.get(0), arrayList, true);
        RubyPsiUtil.removeElements(arrayList.toArray(PsiElement.EMPTY_ARRAY));
        RubyPsiUtil.removeElements(comments.toArray(PsiElement.EMPTY_ARRAY));
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x1E3E90728A04L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/common/RubyClassMembersPsiHelper";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createDirectoryIfMissing";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeWithWhitespaces";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeComments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

