/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.common;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.codeFragment.RCodeFragmentBuilder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ContextPsiFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocValue;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RVariable;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class RefactoringPsiHelper {
    private static final long a = c.a(8316014265339821302L, 8764284706239479194L, MethodHandles.lookup().lookupClass()).a(135816531372677L);

    private RefactoringPsiHelper() {
    }

    public static PsiElement replaceExpressionWithText(Project project, PsiElement expression, String text2) {
        RPsiElement rPsiElement;
        long l2 = a ^ 0x1576C3E65DF4L;
        RStringLiteral rStringLiteral = (RStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)expression, RStringLiteral.class);
        RExpressionSubstitution rExpressionSubstitution = (RExpressionSubstitution)PsiTreeUtil.getParentOfType((PsiElement)expression, RExpressionSubstitution.class);
        if (rStringLiteral != null && rExpressionSubstitution == null) {
            rPsiElement = RubyElementFactory.createExpressionSubstitutionFromText(expression, "#{" + text2 + "}");
        } else if (expression instanceof RListOfExpressions && text2.startsWith("*")) {
            RCall rCall = (RCall)RubyElementFactory.createExpressionFromText(expression, "foo(" + text2 + ")");
            rPsiElement = rCall.getCallArguments();
        } else {
            rPsiElement = RubyElementFactory.createExpressionFromText(expression, text2);
        }
        return RefactoringPsiHelper.replaceExpression(project, expression, (PsiElement)rPsiElement);
    }

    @Nullable
    public static RContainer getClassOrModuleOrFile(PsiElement element) {
        RContainer rContainer;
        PsiElement psiElement = element.getParent();
        if (psiElement instanceof RSuperClass) {
            return (RContainer)psiElement.getParent().getParent();
        }
        RContainer rContainer2 = rContainer = element instanceof RContainer ? (RContainer)element : (RContainer)PsiTreeUtil.getParentOfType((PsiElement)element, RContainer.class);
        while (rContainer instanceof RMethod) {
            rContainer = rContainer.getParentContainer();
        }
        return rContainer;
    }

    public static PsiElement replaceExpression(Project project, PsiElement expression, PsiElement newExpression) {
        Pair pair = (Pair)expression.getUserData(RubyPsiUtil.SELECTION_BREAKS_AST_NODE);
        if (pair != null) {
            String string = ((RPsiElement)pair.first).getText();
            TextRange textRange = (TextRange)pair.second;
            String string2 = string.substring(0, textRange.getStartOffset());
            String string3 = string.substring(textRange.getEndOffset());
            LanguageLevel languageLevel = RubyLanguageLevelPusher.getInstance().getLanguageLevelByElement(expression);
            RExpression rExpression = RubyElementFactory.createExpressionFromText(project, string2 + newExpression.getText() + string3, languageLevel);
            return ((RPsiElement)pair.first).replace((PsiElement)rExpression);
        }
        return expression.replace(newExpression);
    }

    @Nullable
    public static Object getSelectedExpression(Project project, PsiFile file, PsiElement element1, PsiElement element2, boolean checkStateChangeInside, String helpId) {
        RPsiElement rPsiElement;
        long l2 = a ^ 0x1EC6778A2A2CL;
        PsiElement psiElement2 = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        RPsiElement rPsiElement2 = rPsiElement = psiElement2 instanceof RPsiElement ? (RPsiElement)psiElement2 : (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement2, RPsiElement.class);
        if (rPsiElement == null) {
            return null;
        }
        String string = RefactoringPsiHelper.checkCanExtract(rPsiElement, checkStateChangeInside, helpId);
        if (string != null) {
            return string;
        }
        if (RefactoringPsiHelper.b((PsiElement)rPsiElement, element1) && RefactoringPsiHelper.a((PsiElement)rPsiElement, element2)) {
            return rPsiElement;
        }
        if (rPsiElement instanceof RBinaryExpression) {
            LanguageLevel languageLevel;
            String string2 = file.getText().substring(element1.getTextRange().getStartOffset(), element2.getTextRange().getEndOffset());
            RExpression rExpression = RubyElementFactory.createExpressionFromText(project, string2, languageLevel = RubyLanguageLevelPusher.getInstance().getLanguageLevelByElement(element1));
            PsiElement psiElement3 = PsiTreeUtil.getTopmostParentOfType((PsiElement)rExpression, PsiElement.class);
            if (!PsiTreeUtil.processElements((PsiElement)psiElement3, psiElement -> !(psiElement instanceof PsiErrorElement))) {
                return null;
            }
            String string3 = rPsiElement.getText();
            int n2 = element1.getTextRange().getStartOffset() - rPsiElement.getTextRange().getStartOffset();
            int n3 = element2.getTextRange().getEndOffset() - rPsiElement.getTextRange().getStartOffset();
            TextRange textRange = new TextRange(n2, n3);
            String string4 = string3.substring(0, n2);
            String string5 = string3.substring(n3);
            psiElement3 = PsiTreeUtil.getTopmostParentOfType((PsiElement)RubyElementFactory.createExpressionFromText(project, string4 + "RubyMineRulezzz" + string5, languageLevel), PsiElement.class);
            if (!PsiTreeUtil.processElements((PsiElement)psiElement3, psiElement -> !(psiElement instanceof PsiErrorElement))) {
                return null;
            }
            rExpression.putUserData(RubyPsiUtil.SELECTION_BREAKS_AST_NODE, Pair.create((Object)rPsiElement, (Object)textRange));
            ContextPsiFile.set((PsiElement)rExpression, (PsiElement)file);
            return rExpression;
        }
        return null;
    }

    @Nullable
    public static String checkCanExtract(RPsiElement element, boolean checkStateChangeInside, String helpId) {
        long l2 = a ^ 0x1BB139CBA0D6L;
        if (RCallNavigator.getByCommand((PsiElement)element) != null || RBlockCallNavigator.getByCall(element) != null) {
            return RBundle.message("refactoring.introduce.command.error");
        }
        if (RReferenceNavigator.getRRefenceOrTopReference((PsiElement)element) != null || element instanceof RHeredocValue) {
            return "";
        }
        if ("refactoring.introduceParameter".equals(helpId)) {
            if (PsiTreeUtil.getParentOfType((PsiElement)element, RArgumentList.class, (boolean)false) != null || element instanceof ControlFlowHolder) {
                return "";
            }
            if (element instanceof RPossibleCall && !(element instanceof RColonReference) && !(element instanceof RConstant) && !(element instanceof RPseudoConstant)) {
                return "";
            }
        }
        if (!"refactoring.extractMethod".equals(helpId) && element instanceof RAssignmentExpression) {
            return "";
        }
        if (RubyPsiUtil.getAnyAssignmentByLeftPart((PsiElement)element) != null) {
            return element instanceof RVariable ? null : "";
        }
        if (!checkStateChangeInside) {
            return null;
        }
        TextRange textRange = element.getTextRange();
        RContainer rContainer = element.getParentContainer();
        if (rContainer == null) {
            throw new IllegalStateException("Element " + element + " has no container");
        }
        RCodeFragmentBuilder rCodeFragmentBuilder = new RCodeFragmentBuilder(textRange.getStartOffset(), textRange.getEndOffset(), rContainer);
        rContainer.accept(rCodeFragmentBuilder);
        if (!("refactoring.introduceVariable".equals(helpId) || "refactoring.introduceField".equals(helpId) || rCodeFragmentBuilder.getInElements().isEmpty())) {
            return RBundle.message("refactoring.introduce.input.error");
        }
        return rCodeFragmentBuilder.getOutElements().isEmpty() && rCodeFragmentBuilder.getModifiedFields().isEmpty() ? null : RBundle.message("refactoring.introduce.state.changed.error");
    }

    public static Pair<PsiElement, PsiElement> getSelectedElements(Editor editor2, PsiFile file) {
        SelectionModel selectionModel = editor2.getSelectionModel();
        PsiElement psiElement = null;
        PsiElement psiElement2 = null;
        if (selectionModel.hasSelection()) {
            psiElement = file.findElementAt(selectionModel.getSelectionStart());
            psiElement2 = file.findElementAt(selectionModel.getSelectionEnd() - 1);
        } else {
            CaretModel caretModel = editor2.getCaretModel();
            Document document = editor2.getDocument();
            int n2 = document.getLineNumber(caretModel.getOffset());
            if (0 <= n2 && n2 < document.getLineCount()) {
                psiElement = file.findElementAt(document.getLineStartOffset(n2));
                psiElement2 = file.findElementAt(document.getLineEndOffset(n2) - 1);
            }
        }
        if (psiElement == null || psiElement2 == null) {
            return Pair.create(null, null);
        }
        while (psiElement != null && RefactoringPsiHelper.isExtendedWhitespace(psiElement)) {
            if (!((psiElement = psiElement.getNextSibling()) instanceof RPsiElement)) continue;
            psiElement = PsiTreeUtil.getDeepestFirst((PsiElement)psiElement);
        }
        while (psiElement2 != null && RefactoringPsiHelper.isExtendedWhitespace(psiElement2)) {
            if (!((psiElement2 = psiElement2.getPrevSibling()) instanceof RPsiElement)) continue;
            psiElement2 = PsiTreeUtil.getDeepestLast((PsiElement)psiElement2);
        }
        return Pair.create((Object)psiElement, (Object)psiElement2);
    }

    @NotNull
    public static List<? extends PsiElement> insertElements(@NotNull PsiElement element, @NotNull List<? extends PsiElement> newElements) {
        Object object;
        RPsiElement rPsiElement32;
        if (element == null) {
            RefactoringPsiHelper.a(0);
        }
        if (newElements == null) {
            RefactoringPsiHelper.a(1);
        }
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        RContainer rContainer = (RContainer)PsiTreeUtil.getParentOfType((PsiElement)element, RContainer.class);
        assert (rContainer != null);
        RCompoundStatement rCompoundStatement = rContainer.getCompoundStatement();
        RPsiElement rPsiElement2 = null;
        for (RPsiElement rPsiElement32 : rCompoundStatement.getStatements()) {
            if (!RubyPsiUtil.isBefore(element, (PsiElement)rPsiElement32)) continue;
            rPsiElement2 = rPsiElement32;
            break;
        }
        Object object2 = rCompoundStatement;
        rPsiElement32 = rPsiElement2;
        if (rPsiElement2 != null && (object = RubyCommentsUtil.getPsiComments(rPsiElement2)).size() > 0) {
            rPsiElement32 = (PsiElement)object.get(0);
            object2 = rPsiElement32.getParent();
        }
        for (PsiElement psiElement : newElements) {
            arrayList.add(object2.addBefore(psiElement, (PsiElement)rPsiElement32));
        }
        ArrayList<PsiElement> arrayList2 = arrayList;
        if (arrayList2 == null) {
            RefactoringPsiHelper.a(2);
        }
        return arrayList2;
    }

    static boolean isExtendedWhitespace(PsiElement element) {
        return element instanceof PsiWhiteSpace || "\n".equals(element.getText()) || ";".equals(element.getText()) || element instanceof PsiComment;
    }

    private static boolean b(@NotNull PsiElement psiElement, @NotNull PsiElement psiElement2) {
        if (psiElement == null) {
            RefactoringPsiHelper.a(3);
        }
        if (psiElement2 == null) {
            RefactoringPsiHelper.a(4);
        }
        return RefactoringPsiHelper.a(psiElement, psiElement2, true);
    }

    private static boolean a(@NotNull PsiElement psiElement, @NotNull PsiElement psiElement2) {
        if (psiElement == null) {
            RefactoringPsiHelper.a(5);
        }
        if (psiElement2 == null) {
            RefactoringPsiHelper.a(6);
        }
        return RefactoringPsiHelper.a(psiElement, psiElement2, false);
    }

    private static boolean a(@NotNull PsiElement psiElement, @NotNull PsiElement psiElement2, boolean bl2) {
        if (psiElement == null) {
            RefactoringPsiHelper.a(7);
        }
        if (psiElement2 == null) {
            RefactoringPsiHelper.a(8);
        }
        psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)psiElement2, RPsiElement.class, (boolean)false);
        PsiElement psiElement3 = bl2 ? PsiTreeUtil.getDeepestFirst((PsiElement)psiElement) : PsiTreeUtil.getDeepestLast((PsiElement)psiElement);
        psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)psiElement3, RPsiElement.class, (boolean)false);
        return psiElement2 == psiElement3;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x4A1A4C9E9A8BL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/common/RefactoringPsiHelper";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/common/RefactoringPsiHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "insertElements";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "insertElements";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFirst";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isLast";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isFirstOrLast";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

