/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.highlighter;

import com.intellij.lang.Language;
import com.intellij.lexer.LayeredLexer;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import java.util.Map;
import org.jetbrains.plugins.ruby.rdoc.RDocLanguage;
import org.jetbrains.plugins.ruby.ruby.actions.editor.RubyEditorOptions;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlightingLexerAdapter;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;

public class RubyEditorHighlighter
extends LayeredLexerEditorHighlighter {
    public RubyEditorHighlighter(EditorColorsScheme scheme, Project project, VirtualFile file) {
        super(SyntaxHighlighterFactory.getSyntaxHighlighter((Language)RubyLanguage.INSTANCE, (Project)project, (VirtualFile)file), scheme);
        Map map2;
        if (RubyEditorOptions.getInstance().isHighlightRDocInComments() && LayeredLexer.ourDisableLayersFlag.get() != Boolean.TRUE) {
            map2 = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)RDocLanguage.INSTANCE, (Project)project, (VirtualFile)file);
            LayerDescriptor layerDescriptor = new LayerDescriptor((SyntaxHighlighter)map2, "\n", RubyHighlighter.COMMENT);
            this.registerLayer(RubyTokenTypes.TLINE_COMMENT, layerDescriptor);
        }
        map2 = (Map)RubyHighlightingLexerAdapter.ourLanguageTypesMap.getValue();
        for (Language language : Language.getRegisteredLanguages()) {
            IElementType iElementType = (IElementType)map2.get(StringUtil.toLowerCase((String)language.getDisplayName()));
            if (iElementType == null) continue;
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)file);
            LayerDescriptor layerDescriptor = new LayerDescriptor(syntaxHighlighter, "\n", null);
            this.registerLayer(iElementType, layerDescriptor);
        }
    }
}

