/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.nilanalysis;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ThreeState;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.NilAnalysisUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.TypeInferenceContext;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;

public class RubyNilAnalysisVisitor
extends RubyInspectionVisitor {
    private static final long b = c.a(-9134126779592023744L, 3616809532187683725L, MethodHandles.lookup().lookupClass()).a(50710873717887L);

    public RubyNilAnalysisVisitor(ProblemsHolder holder) {
        super(holder);
    }

    @Override
    public void visitRDotReference(RDotReference rDotReference) {
        if (!rDotReference.isSafeNavigation()) {
            this.visitRReference(rDotReference);
        }
    }

    @Override
    public void visitRReference(RReference rReference) {
        String string;
        long l2 = b ^ 0x73AE11C7E3E6L;
        if (!(rReference.getReceiver() instanceof RExpression)) {
            return;
        }
        RExpression rExpression = (RExpression)rReference.getReceiver();
        String string2 = rExpression.getName();
        if (StringUtil.startsWithChar((CharSequence)string2, (char)'@')) {
            return;
        }
        ControlFlowHolder controlFlowHolder = TypeInferenceContext.getControlFlowHolder(rExpression);
        if (controlFlowHolder == null) {
            return;
        }
        Project project = rReference.getProject();
        if (NilAnalysisUtil.getCanBeNil(rExpression, controlFlowHolder) == ThreeState.YES && (string = rReference.getCommand()) != null && !NilAnalysisUtil.isClassMethod(project, "NilClass", string)) {
            RPsiElement rPsiElement = rReference.getValue();
            assert (rPsiElement != null);
            this.registerProblem((PsiElement)rPsiElement, RBundle.message("inspection.nilanalysis.warning", rPsiElement.getText()));
        }
    }
}

