/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.UsageAnalyzer;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyRenameFix;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.ConventionInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.d;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;

public class RubyInstanceVariableNamingConventionInspection
extends ConventionInspection {
    private static final int c = 2;
    private static final int b = 30;
    private static final long d = com.jetbrains.python.psi.c.a(-7092830961112494890L, -6311820335620599408L, MethodHandles.lookup().lookupClass()).a(45694370174945L);

    @Override
    protected String getDefaultRegex() {
        return TextUtil.IDENTIFIER_LOWERCASE_PATTERN.pattern();
    }

    @Override
    protected String getMotionDefaultRegex() {
        long l2 = d ^ 0x591186D053ECL;
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 2;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 30;
    }

    @Override
    protected RubyFix buildFix(PsiElement location) {
        return new RubyRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = d ^ 0x371F37210DBEL;
        if ("Instance variable naming convention" == null) {
            RubyInstanceVariableNamingConventionInspection.d(0);
        }
        return "Instance variable naming convention";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        long l2 = d ^ 0xE793DD72988L;
        String string = (String)args[0];
        if (string.length() < this.getMinLength()) {
            if ("Instance variable name '#ref' is too short" == null) {
                RubyInstanceVariableNamingConventionInspection.d(1);
            }
            return "Instance variable name '#ref' is too short";
        }
        if (string.length() > this.getMaxLength()) {
            if ("Instance variable name '#ref' is too long" == null) {
                RubyInstanceVariableNamingConventionInspection.d(2);
            }
            return "Instance variable name '#ref' is too long";
        }
        String string2 = "Instance variable name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string2 == null) {
            RubyInstanceVariableNamingConventionInspection.d(3);
        }
        return string2;
    }

    @Override
    public RubyInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor(null);
    }

    private static /* synthetic */ void d(int n2) {
        Object[] objectArray;
        long l2 = d ^ 0x801067F5A95L;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyInstanceVariableNamingConventionInspection";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NamingConventionsVisitor
    extends RubyInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitRInstanceVariable(RInstanceVariable rInstanceVariable) {
            if (!UsageAnalyzer.isDeclaration((PsiElement)rInstanceVariable)) {
                return;
            }
            String string = rInstanceVariable.getName();
            if (RubyInstanceVariableNamingConventionInspection.this.isValid(string, (PsiElement)rInstanceVariable)) {
                return;
            }
            this.registerFieldError(rInstanceVariable, string);
        }

        /* synthetic */ NamingConventionsVisitor(d x1) {
            this();
        }
    }
}

