/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyRenameFix;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.ConventionInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.c;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.search.overriden.RubySuperMethodsSearch;

public class RubyInstanceMethodNamingConventionInspection
extends ConventionInspection {
    public static final String DEFAULT_REGEX;
    private static final int c = 2;
    private static final int b = 30;
    private static final long d;

    @Override
    protected String getDefaultRegex() {
        return DEFAULT_REGEX;
    }

    @Override
    protected String getMotionDefaultRegex() {
        long l2 = d ^ 0x1F767B58A3C9L;
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 2;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 30;
    }

    @Override
    protected RubyFix buildFix(PsiElement location) {
        return new RubyRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = d ^ 0x7875CAF02204L;
        if ("Instance method naming convention" == null) {
            RubyInstanceMethodNamingConventionInspection.d(0);
        }
        return "Instance method naming convention";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        long l2 = d ^ 0x481EC05FD9ADL;
        String string = (String)args[0];
        if (string.length() < this.getMinLength()) {
            if ("Method name '#ref' is too short" == null) {
                RubyInstanceMethodNamingConventionInspection.d(1);
            }
            return "Method name '#ref' is too short";
        }
        if (string.length() > this.getMaxLength()) {
            if ("Method name '#ref' is too long" == null) {
                RubyInstanceMethodNamingConventionInspection.d(2);
            }
            return "Method name '#ref' is too long";
        }
        String string2 = "Method name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string2 == null) {
            RubyInstanceMethodNamingConventionInspection.d(3);
        }
        return string2;
    }

    @Override
    public RubyInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor(null);
    }

    static {
        d = com.jetbrains.python.psi.c.a(-7306439810312658970L, 7528821452685898671L, MethodHandles.lookup().lookupClass()).a(236671560023362L);
        long l2 = d ^ 0x6F37A74B6D2CL;
        DEFAULT_REGEX = TextUtil.IDENTIFIER_LOWERCASE_PATTERN.pattern() + "[!?=]?";
    }

    private static /* synthetic */ void d(int n2) {
        Object[] objectArray;
        long l2 = d ^ 0x17DF689BB5E1L;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyInstanceMethodNamingConventionInspection";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NamingConventionsVisitor
    extends RubyInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitRMethod(RMethod rMethod) {
            if (PsiTreeUtil.getParentOfType((PsiElement)rMethod, RContainer.class) instanceof RObjectClass) {
                return;
            }
            String string = rMethod.getName();
            if (RubyInstanceMethodNamingConventionInspection.this.isValid(string, (PsiElement)rMethod) || RubySuperMethodsSearch.search(rMethod).findFirst() != null) {
                return;
            }
            this.registerMethodError(rMethod, string);
        }

        /* synthetic */ NamingConventionsVisitor(c x1) {
            this();
        }
    }
}

