/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyThreadInfo;

public class RubyExecutionStack
extends XExecutionStack {
    @NotNull
    private final List<RubyStackFrame> b;
    private RubyStackFrame a;
    private static final Logger c;
    private static final long d;

    public RubyExecutionStack(Project project, @NotNull RubyDebugProcess process2, RubyDebuggerProxy debuggerProxy, RubyThreadInfo rubyThreadInfo, RubyThread rubyThread, boolean processPaused) {
        long l2 = d ^ 0x3448E18BFDDDL;
        if (process2 == null) {
            RubyExecutionStack.a(0);
        }
        super(RubyExecutionStack.a(rubyThreadInfo), rubyThread.isSuspended() ? AllIcons.Debugger.ThreadAtBreakpoint : AllIcons.Debugger.ThreadSuspended);
        this.a = null;
        if (!debuggerProxy.waitForDebuggerProxyReady()) {
            c.warn("Couldn't evaluate execution stack during timeout");
            this.b = Collections.emptyList();
            return;
        }
        if (processPaused && rubyThread.supportsFrameReading()) {
            this.b = new ArrayList<RubyStackFrame>();
            try {
                RubyFrame[] rubyFrameArray = rubyThread.getFrames();
                RubyFrame rubyFrame = rubyThread.getTopFrame();
                for (RubyFrame rubyFrame2 : rubyFrameArray) {
                    RubyStackFrame rubyStackFrame = new RubyStackFrame(project, process2, debuggerProxy, rubyThread, rubyFrame2);
                    this.b.add(rubyStackFrame);
                    if (rubyFrame != rubyFrame2) continue;
                    this.a = rubyStackFrame;
                }
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                this.b.clear();
                this.a = null;
            }
        } else {
            this.b = Collections.emptyList();
            this.a = null;
        }
    }

    private static String a(RubyThreadInfo rubyThreadInfo) {
        long l2 = d ^ 0x1AD351F410CFL;
        int n2 = rubyThreadInfo.getPid();
        return "Thread " + rubyThreadInfo.getId() + " [" + rubyThreadInfo.getStatus() + "]" + (n2 != -1 ? " (pid " + n2 + ")" : "");
    }

    public XStackFrame getTopFrame() {
        return this.a;
    }

    public void computeStackFrames(int frameCount, XExecutionStack.XStackFrameContainer container) {
        long l2 = d ^ 0x1C23B4BD7707L;
        if (frameCount <= this.b.size()) {
            List list2 = this.b.subList(frameCount, this.b.size());
            if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowLibraryStackFrames()) {
                list2 = ContainerUtil.filter(list2, rubyStackFrame -> rubyStackFrame.isInProjectFrame());
            }
            container.addStackFrames(list2, true);
        } else {
            container.errorOccurred(RBundle.message("ruby.debugger.no.stackframes.available"));
        }
    }

    public boolean equals(Object other) {
        return other instanceof RubyExecutionStack && this.getDisplayName().equals(((RubyExecutionStack)((Object)other)).getDisplayName());
    }

    public int hashCode() {
        return this.getDisplayName().hashCode();
    }

    static {
        d = com.jetbrains.python.psi.c.a(-7722258451451011396L, -1439342317774920691L, MethodHandles.lookup().lookupClass()).a(85705033708414L);
        c = Logger.getInstance(RubyExecutionStack.class);
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = d ^ 0x6ABA1953F27CL;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyExecutionStack", "<init>"));
    }
}

