/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubySuspendContext;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValueFactory;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.ExpressionInfo;
import org.rubyforge.debugcommons.model.RubyVariable;

public class RubyDebuggerEvaluator
extends XDebuggerEvaluator {
    private final Project c;
    protected RubyStackFrame myFrame;
    private final RubyDebuggerProxy b;
    private static final Logger a;
    private static final long d;

    public RubyDebuggerEvaluator(Project project, @NotNull RubyStackFrame frame, RubyDebuggerProxy debuggerProxy) {
        if (frame == null) {
            RubyDebuggerEvaluator.a(0);
        }
        this.c = project;
        this.myFrame = frame;
        this.b = debuggerProxy;
    }

    public static boolean evaluateCondition(RubySuspendContext rubySuspendContext, @Nullable XExpression condition) {
        XStackFrame xStackFrame;
        if (condition == null || StringUtil.isEmptyOrSpaces((String)condition.getExpression())) {
            return true;
        }
        XExecutionStack xExecutionStack = rubySuspendContext.getActiveExecutionStack();
        if (xExecutionStack != null && (xStackFrame = xExecutionStack.getTopFrame()) != null) {
            try {
                RubyVariable rubyVariable = ((RubyStackFrame)xStackFrame).getFrame().inspectExpression(condition.getExpression());
                if (rubyVariable == null) {
                    return false;
                }
                String string = RubyDebuggerSupportUtils.getRubyValuePresentationString(rubyVariable.getValue());
                return !RubyTokenTypes.kFALSE.toString().equals(string) && !RubyTokenTypes.kNIL.toString().equals(string);
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                a.info((Throwable)rubyDebuggerException);
            }
        }
        return true;
    }

    @NotNull
    public static String evaluateExpression(@NotNull RubySuspendContext rubySuspendContext, @Nullable String expression) {
        XStackFrame xStackFrame;
        XExecutionStack xExecutionStack;
        if (rubySuspendContext == null) {
            RubyDebuggerEvaluator.a(1);
        }
        if ((xExecutionStack = rubySuspendContext.getActiveExecutionStack()) != null && (xStackFrame = xExecutionStack.getTopFrame()) != null) {
            String string = RubyDebuggerEvaluator.evaluateExpression(xStackFrame, expression);
            String string2 = string != null ? string : "";
            if (string2 == null) {
                RubyDebuggerEvaluator.a(2);
            }
            return string2;
        }
        if ("" == null) {
            RubyDebuggerEvaluator.a(3);
        }
        return "";
    }

    @Nullable
    public static String evaluateExpression(@NotNull XStackFrame frame, @Nullable String expression) {
        if (frame == null) {
            RubyDebuggerEvaluator.a(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)expression)) {
            return null;
        }
        try {
            RubyVariable rubyVariable = ((RubyStackFrame)frame).getFrame().inspectExpression(expression);
            if (rubyVariable == null) {
                return null;
            }
            return RubyDebuggerSupportUtils.getRubyValuePresentationString(rubyVariable.getValue());
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            a.info((Throwable)rubyDebuggerException);
            return null;
        }
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            RubyDebuggerEvaluator.a(5);
        }
        if (callback == null) {
            RubyDebuggerEvaluator.a(6);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            long l2 = d ^ 0x7CED1F5958FL;
            if (!this.b.waitForDebuggerProxyReady()) {
                callback.errorOccurred(RBundle.message("ruby.debugger.is.not.ready"));
                return;
            }
            try {
                RubyVariable rubyVariable = this.b.inspectExpression(this.myFrame.getFrame(), expression);
                if (rubyVariable == null) {
                    callback.errorOccurred(RBundle.message("ruby.debugger.couldnt.evaluate", expression));
                    return;
                }
                callback.evaluated(RubyDebugValueFactory.create(this.c, expressionPosition, this.myFrame, expression, rubyVariable, false));
                RubyDebuggerSupportUtils.invalidateSessionFrames(XDebuggerManager.getInstance((Project)this.c).getCurrentSession());
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                a.info((Throwable)rubyDebuggerException);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(RBundle.message("ruby.debugger.couldnt.evaluate", expression)).append("\n");
                stringBuilder.append(rubyDebuggerException.getMessage());
                callback.errorOccurred(stringBuilder.toString());
            }
        });
    }

    @Nullable
    public ExpressionInfo getExpressionInfo(@NotNull String expression) {
        if (expression == null) {
            RubyDebuggerEvaluator.a(7);
        }
        if (!this.b.waitForDebuggerProxyReady()) {
            return null;
        }
        try {
            return this.b.getExpressionInfo(this.myFrame.getFrame(), expression);
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            a.info((Throwable)rubyDebuggerException);
            return null;
        }
    }

    public TextRange getExpressionRangeAtOffset(Project project, Document document, int offset, boolean sideEffectsAllowed) {
        return RubyDebuggerSupportUtils.getExpressionAtOffset(project, document, offset);
    }

    static {
        d = com.jetbrains.python.psi.c.a(282028312032825350L, 3809361022549235855L, MethodHandles.lookup().lookupClass()).a(95799380073164L);
        a = Logger.getInstance(RubyDebuggerEvaluator.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x2EC0C4E09C49L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubySuspendContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyDebuggerEvaluator";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyDebuggerEvaluator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateExpression";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExpression";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

