/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.google.common.collect.Maps;
import com.intellij.execution.Platform;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.text.Normalizer;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.debugger.SourcePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyPosition;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubySourcePosition;
import org.rubyforge.debugcommons.model.RubySuspensionLocation;

public class LocalPositionConverter
implements SourcePositionConverter {
    private static final Logger a;
    @NotNull
    private final Project d;
    private final boolean c;
    private final Map<String, String> b;
    private static final long e;

    public LocalPositionConverter(@NotNull Project project, boolean useCanonicalPaths) {
        if (project == null) {
            LocalPositionConverter.a(0);
        }
        this.b = Maps.newHashMap();
        this.d = project;
        this.c = useCanonicalPaths;
    }

    @Override
    @NotNull
    public RubyPosition createRemotePosition(@NotNull XSourcePosition xSourcePosition) {
        if (xSourcePosition == null) {
            LocalPositionConverter.a(1);
        }
        String string = this.getRemotePath(xSourcePosition.getFile());
        this.b.put(string, xSourcePosition.getFile().getPath());
        RubySuspensionLocation rubySuspensionLocation = null;
        if (xSourcePosition instanceof RubySourcePosition) {
            rubySuspensionLocation = ((RubySourcePosition)xSourcePosition).getLocation();
        }
        RubyPosition rubyPosition = new RubyPosition(string, xSourcePosition.getLine() + 1, rubySuspensionLocation);
        if (rubyPosition == null) {
            LocalPositionConverter.a(2);
        }
        return rubyPosition;
    }

    @Override
    @NotNull
    public String getRemotePath(@NotNull VirtualFile file) {
        if (file == null) {
            LocalPositionConverter.a(3);
        }
        String string = null;
        if (this.c) {
            string = file.getCanonicalPath();
        }
        if (string == null) {
            string = file.getPath();
        }
        if (file.isDirectory() && string.charAt(string.length() - 1) != Platform.current().fileSeparator) {
            string = string + Platform.current().fileSeparator;
        }
        if (SystemInfo.isMac) {
            String string2 = Normalizer.normalize(string, Normalizer.Form.NFD);
            if (string2 == null) {
                LocalPositionConverter.a(4);
            }
            return string2;
        }
        String string3 = string;
        if (string3 == null) {
            LocalPositionConverter.a(5);
        }
        return string3;
    }

    @Override
    public XSourcePosition createLocalPosition(@NotNull RubyPosition rubyPosition) {
        if (rubyPosition == null) {
            LocalPositionConverter.a(6);
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(this.b(rubyPosition.getPath()));
        return (XSourcePosition)ReadAction.compute(() -> RubySourcePosition.createPosition(XDebuggerUtil.getInstance().createPosition(virtualFile, rubyPosition.getLine() - 1), rubyPosition.getLocation(), this.d));
    }

    @NotNull
    private String b(@NotNull String string) {
        long l2 = e ^ 0x7ED3651253AL;
        if (string == null) {
            LocalPositionConverter.a(7);
        }
        if (this.b.containsKey(string)) {
            String string2 = this.b.get(string);
            if (string2 == null) {
                LocalPositionConverter.a(8);
            }
            return string2;
        }
        if (a.isDebugEnabled()) {
            a.debug("Looking for \"" + string + "\" in filename index by name");
        }
        Collection collection = (Collection)ReadAction.compute(() -> FilenameIndex.getVirtualFilesByName((Project)this.d, (String)new File(string).getName(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.d)));
        for (VirtualFile virtualFile : collection) {
            if (!string.equals(virtualFile.getCanonicalPath())) continue;
            this.b.put(string, virtualFile.getPath());
            String string3 = virtualFile.getPath();
            if (string3 == null) {
                LocalPositionConverter.a(9);
            }
            return string3;
        }
        if (a.isDebugEnabled()) {
            a.debug("Unable to find \"" + string + "\" by name, returning as is");
        }
        String string4 = string;
        if (string4 == null) {
            LocalPositionConverter.a(10);
        }
        return string4;
    }

    static {
        e = com.jetbrains.python.psi.c.a(-7898579502194738517L, -773666990246599345L, MethodHandles.lookup().lookupClass()).a(149772324744657L);
        a = Logger.getInstance(LocalPositionConverter.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x5E36296C0ED6L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xSourcePosition";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/LocalPositionConverter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyPosition";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyPath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/LocalPositionConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemotePosition";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemotePath";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findPathByRubyPosition";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createRemotePosition";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRemotePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createLocalPosition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPathByRubyPosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

