/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable;

import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.jetbrains.python.psi.c;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.signature.RSignature;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.CollectionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.FullyQualifiedType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.HashType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.ProcType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.QualifiedType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableTypeKind;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.UnionType;

public class SerializableTypeUtil {
    public static final SerializableType EMPTY;
    public static final SerializableType TRUE;
    public static final SerializableType FALSE;
    public static final SerializableType NIL;
    public static final SerializableType STRING;
    public static final SerializableType BOOLEAN;
    private static final long a;

    private SerializableTypeUtil() {
    }

    @NotNull
    public static SerializableType createFullyQualifiedType(@NotNull String fqn) {
        if (fqn == null) {
            SerializableTypeUtil.a(0);
        }
        FullyQualifiedType fullyQualifiedType = new FullyQualifiedType(fqn);
        if (fullyQualifiedType == null) {
            SerializableTypeUtil.a(1);
        }
        return fullyQualifiedType;
    }

    @NotNull
    public static SerializableType createQualifiedType(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            SerializableTypeUtil.a(2);
        }
        QualifiedType qualifiedType = new QualifiedType(qualifiedName);
        if (qualifiedType == null) {
            SerializableTypeUtil.a(3);
        }
        return qualifiedType;
    }

    @NotNull
    public static SerializableType createUnionType(@NotNull Collection<SerializableType> serializableTypes) {
        if (serializableTypes == null) {
            SerializableTypeUtil.a(4);
        }
        if (serializableTypes.isEmpty()) {
            SerializableType serializableType = EMPTY;
            if (serializableType == null) {
                SerializableTypeUtil.a(5);
            }
            return serializableType;
        }
        if (serializableTypes.size() == 1) {
            SerializableType serializableType = serializableTypes.iterator().next();
            if (serializableType == null) {
                SerializableTypeUtil.a(6);
            }
            return serializableType;
        }
        UnionType unionType = new UnionType(serializableTypes);
        if (unionType == null) {
            SerializableTypeUtil.a(7);
        }
        return unionType;
    }

    @NotNull
    public static SerializableType createCollectionType(@NotNull SerializableType collectionType, @NotNull SerializableType elementType) {
        if (collectionType == null) {
            SerializableTypeUtil.a(8);
        }
        if (elementType == null) {
            SerializableTypeUtil.a(9);
        }
        if (elementType == EMPTY) {
            SerializableType serializableType = collectionType;
            if (serializableType == null) {
                SerializableTypeUtil.a(10);
            }
            return serializableType;
        }
        CollectionType collectionType2 = new CollectionType(collectionType, elementType);
        if (collectionType2 == null) {
            SerializableTypeUtil.a(11);
        }
        return collectionType2;
    }

    public static boolean isEmpty(@Nullable SerializableType serializableType) {
        return serializableType == null || serializableType == EMPTY;
    }

    @NotNull
    public static SerializableType createHashType(@NotNull SerializableType hashType, @NotNull SerializableType keyType, @NotNull SerializableType valueType) {
        if (hashType == null) {
            SerializableTypeUtil.a(12);
        }
        if (keyType == null) {
            SerializableTypeUtil.a(13);
        }
        if (valueType == null) {
            SerializableTypeUtil.a(14);
        }
        if (keyType == EMPTY && valueType == EMPTY) {
            SerializableType serializableType = hashType;
            if (serializableType == null) {
                SerializableTypeUtil.a(15);
            }
            return serializableType;
        }
        HashType hashType2 = new HashType(hashType, keyType, valueType);
        if (hashType2 == null) {
            SerializableTypeUtil.a(16);
        }
        return hashType2;
    }

    public static SerializableType createProcType(@NotNull SerializableType selfType, @NotNull RSignature signature) {
        if (selfType == null) {
            SerializableTypeUtil.a(17);
        }
        if (signature == null) {
            SerializableTypeUtil.a(18);
        }
        return new ProcType(selfType, signature);
    }

    @NotNull
    public static SerializableType deserialize(@NotNull StubInputStream stubInputStream) throws IOException {
        long l2 = a ^ 0x252F86A926ACL;
        if (stubInputStream == null) {
            SerializableTypeUtil.a(19);
        }
        SerializableTypeKind serializableTypeKind = SerializableTypeKind.valueOf(stubInputStream.readVarInt());
        switch (serializableTypeKind) {
            case FULLY_QUALIFIED: {
                String string = Objects.requireNonNull(stubInputStream.readNameString());
                if (string.isEmpty()) {
                    SerializableType serializableType = EMPTY;
                    if (serializableType == null) {
                        SerializableTypeUtil.a(20);
                    }
                    return serializableType;
                }
                if (string.equals("TrueClass")) {
                    SerializableType serializableType = TRUE;
                    if (serializableType == null) {
                        SerializableTypeUtil.a(21);
                    }
                    return serializableType;
                }
                if (string.equals("FalseClass")) {
                    SerializableType serializableType = FALSE;
                    if (serializableType == null) {
                        SerializableTypeUtil.a(22);
                    }
                    return serializableType;
                }
                if (string.equals("NilClass")) {
                    SerializableType serializableType = NIL;
                    if (serializableType == null) {
                        SerializableTypeUtil.a(23);
                    }
                    return serializableType;
                }
                if (string.equals("String")) {
                    SerializableType serializableType = STRING;
                    if (serializableType == null) {
                        SerializableTypeUtil.a(24);
                    }
                    return serializableType;
                }
                FullyQualifiedType fullyQualifiedType = new FullyQualifiedType(string);
                if (fullyQualifiedType == null) {
                    SerializableTypeUtil.a(25);
                }
                return fullyQualifiedType;
            }
            case QUALIFIED: {
                QualifiedType qualifiedType = new QualifiedType(Objects.requireNonNull(stubInputStream.readNameString()));
                if (qualifiedType == null) {
                    SerializableTypeUtil.a(26);
                }
                return qualifiedType;
            }
            case UNION: {
                int n2 = stubInputStream.readVarInt();
                ArrayList<SerializableType> arrayList = new ArrayList<SerializableType>();
                for (int i10 = 0; i10 < n2; ++i10) {
                    arrayList.add(SerializableTypeUtil.deserialize(stubInputStream));
                }
                UnionType unionType = new UnionType(arrayList);
                if (unionType == null) {
                    SerializableTypeUtil.a(27);
                }
                return unionType;
            }
            case COLLECTION: {
                CollectionType collectionType = new CollectionType(SerializableTypeUtil.deserialize(stubInputStream), SerializableTypeUtil.deserialize(stubInputStream));
                if (collectionType == null) {
                    SerializableTypeUtil.a(28);
                }
                return collectionType;
            }
            case HASH: {
                HashType hashType = new HashType(SerializableTypeUtil.deserialize(stubInputStream), SerializableTypeUtil.deserialize(stubInputStream), SerializableTypeUtil.deserialize(stubInputStream));
                if (hashType == null) {
                    SerializableTypeUtil.a(29);
                }
                return hashType;
            }
            case PROC: {
                ProcType procType = new ProcType(SerializableTypeUtil.deserialize(stubInputStream), SerializableTypeUtil.deserializeSignature(stubInputStream));
                if (procType == null) {
                    SerializableTypeUtil.a(30);
                }
                return procType;
            }
        }
        throw new IllegalArgumentException(serializableTypeKind.toString());
    }

    public static void serialize(@NotNull StubOutputStream stream2, @NotNull SerializableType type) throws IOException {
        if (stream2 == null) {
            SerializableTypeUtil.a(31);
        }
        if (type == null) {
            SerializableTypeUtil.a(32);
        }
        stream2.writeVarInt(type.getKind().getOrder());
        switch (type.getKind()) {
            case FULLY_QUALIFIED: {
                stream2.writeName(((FullyQualifiedType)type).getType());
                break;
            }
            case QUALIFIED: {
                stream2.writeName(((QualifiedType)type).getType());
                break;
            }
            case UNION: {
                UnionType unionType = (UnionType)type;
                stream2.writeVarInt(unionType.getTypes().size());
                for (SerializableType serializableType : unionType.getTypes()) {
                    SerializableTypeUtil.serialize(stream2, serializableType);
                }
                break;
            }
            case COLLECTION: {
                CollectionType collectionType = (CollectionType)type;
                SerializableTypeUtil.serialize(stream2, collectionType.getCollectionType());
                SerializableTypeUtil.serialize(stream2, collectionType.getElementType());
                break;
            }
            case HASH: {
                HashType hashType = (HashType)type;
                SerializableTypeUtil.serialize(stream2, hashType.getHashType());
                SerializableTypeUtil.serialize(stream2, hashType.getKeyType());
                SerializableTypeUtil.serialize(stream2, hashType.getValueType());
                break;
            }
            case PROC: {
                ProcType procType = (ProcType)type;
                SerializableTypeUtil.serialize(stream2, procType.getSelfType());
                SerializableTypeUtil.serializeSignature(stream2, procType.getSignature());
            }
        }
    }

    public static void serializeSignature(@NotNull StubOutputStream dataStream, @NotNull RSignature signature) throws IOException {
        if (dataStream == null) {
            SerializableTypeUtil.a(33);
        }
        if (signature == null) {
            SerializableTypeUtil.a(34);
        }
        DataInputOutputUtilRt.writeSeq((DataOutput)dataStream, signature.getParameterTypes(), typedArgument -> SerializableTypeUtil.serializeTypedArgument(dataStream, typedArgument));
        SerializableTypeUtil.serialize(dataStream, signature.getReturnType());
    }

    @NotNull
    public static RSignature deserializeSignature(@NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            SerializableTypeUtil.a(35);
        }
        List list2 = DataInputOutputUtilRt.readSeq((DataInput)dataStream, () -> SerializableTypeUtil.deserializeTypedArgument(dataStream));
        SerializableType serializableType = SerializableTypeUtil.deserialize(dataStream);
        RSignature rSignature = new RSignature(list2, serializableType);
        if (rSignature == null) {
            SerializableTypeUtil.a(36);
        }
        return rSignature;
    }

    public static void serializeTypedArgument(@NotNull StubOutputStream dataStream, @NotNull RSignature.TypedArgument argument) throws IOException {
        if (dataStream == null) {
            SerializableTypeUtil.a(37);
        }
        if (argument == null) {
            SerializableTypeUtil.a(38);
        }
        dataStream.writeName(argument.name);
        SerializableTypeUtil.serialize(dataStream, argument.type);
    }

    @NotNull
    public static RSignature.TypedArgument deserializeTypedArgument(@NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            SerializableTypeUtil.a(39);
        }
        RSignature.TypedArgument typedArgument = new RSignature.TypedArgument(Objects.requireNonNull(dataStream.readNameString()), SerializableTypeUtil.deserialize(dataStream));
        if (typedArgument == null) {
            SerializableTypeUtil.a(40);
        }
        return typedArgument;
    }

    static {
        a = c.a(-8297326439851980184L, -3235307416927561062L, MethodHandles.lookup().lookupClass()).a(128018257953101L);
        long l2 = a ^ 0x11AB76D026A5L;
        EMPTY = new FullyQualifiedType("");
        TRUE = new FullyQualifiedType("TrueClass");
        FALSE = new FullyQualifiedType("FalseClass");
        NIL = new FullyQualifiedType("NilClass");
        STRING = new FullyQualifiedType("String");
        BOOLEAN = new UnionType(Arrays.asList(TRUE, FALSE));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x7B7DEFAF28FCL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 40: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/serializable/SerializableTypeUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializableTypes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selfType";
                break;
            }
            case 18: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubInputStream";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 33: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/serializable/SerializableTypeUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFullyQualifiedType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createQualifiedType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnionType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollectionType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createHashType";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeSignature";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeTypedArgument";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFullyQualifiedType";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 40: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUnionType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCollectionType";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createHashType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createProcType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "serializeSignature";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "deserializeSignature";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "serializeTypedArgument";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "deserializeTypedArgument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

