/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PathUtil;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Node;

public class RubyUtil {
    private static final Logger b;
    public static final Set<String> KNOWN_RUBY_ROOTS;
    @NonNls
    public static final String RUBYOPT = "RUBYOPT";
    private static final Constructor a;
    private static final long c;

    private RubyUtil() {
    }

    @Nullable
    public static Map loadYaml(@NotNull InputStream inputStream2) {
        if (inputStream2 == null) {
            RubyUtil.a(0);
        }
        return (Map)new Yaml((BaseConstructor)a).load(inputStream2);
    }

    @Nullable
    public static Iterable<Object> loadAllYamlDocs(@NotNull InputStream inputStream2) {
        if (inputStream2 == null) {
            RubyUtil.a(1);
        }
        return new Yaml((BaseConstructor)a).loadAll(inputStream2);
    }

    @NotNull
    public static Set<String> getScriptBasePaths() {
        Set<String> set = Collections.unmodifiableSet(KNOWN_RUBY_ROOTS);
        if (set == null) {
            RubyUtil.a(2);
        }
        return set;
    }

    @Nullable
    public static String getScriptFullPath(@NotNull String scriptPath) {
        long l2 = c ^ 0x2B2A604FFC84L;
        if (scriptPath == null) {
            RubyUtil.a(3);
        }
        Set<String> set = RubyUtil.getScriptBasePaths();
        for (String string : set) {
            File file = new File(string, scriptPath);
            if (!file.exists()) continue;
            return file.getPath();
        }
        File file = new File(scriptPath);
        if (file.exists()) {
            return file.getPath();
        }
        b.error("Could not find " + scriptPath);
        return null;
    }

    public static List<String> getBuiltinScriptFolders() {
        long l2 = c ^ 0x75A3879B8AE8L;
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> set = RubyUtil.getScriptBasePaths();
        for (String string : set) {
            arrayList.add(new File(string, "rb/scripts").getPath());
        }
        return arrayList;
    }

    public static void addScriptBasePathForClass(@NotNull Class<?> clazz) {
        long l2 = c ^ 0x4C87BBC3D07AL;
        if (clazz == null) {
            RubyUtil.a(4);
        }
        String string = PathUtil.getJarPathForClass(clazz);
        assert (!string.endsWith(".jar"));
        KNOWN_RUBY_ROOTS.add(string);
    }

    static {
        c = com.jetbrains.python.psi.c.a(8556019991333412873L, 6923505263618194842L, MethodHandles.lookup().lookupClass()).a(53123948901718L);
        long l2 = c ^ 0x738C4327A347L;
        b = Logger.getInstance(RubyUtil.class);
        KNOWN_RUBY_ROOTS = new HashSet<String>();
        String string = PathUtil.getJarPathForClass(RubyUtil.class);
        File file = new File(string);
        b.assertTrue(file.exists(), (Object)"jar file cannot be null");
        if (string.endsWith(".jar")) {
            File file2 = file.getParentFile().getParentFile();
            KNOWN_RUBY_ROOTS.add(file2.getPath());
        } else {
            KNOWN_RUBY_ROOTS.add(string);
            KNOWN_RUBY_ROOTS.add(file.getParentFile() + File.separator + "intellij.ruby.testing");
            KNOWN_RUBY_ROOTS.add(file.getParentFile() + File.separator + "intellij.ruby.coverage");
        }
        a = new Constructor(HashMap.class){

            protected Class<?> getClassForNode(Node node) {
                try {
                    return super.getClassForNode(node);
                }
                catch (YAMLException yAMLException) {
                    return HashMap.class;
                }
            }
        };
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x77FE4868070AL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/RubyUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/RubyUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptBasePaths";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadYaml";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadAllYamlDocs";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getScriptFullPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addScriptBasePathForClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

