/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.psi.c;
import java.awt.Color;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.run.filters.FileLinksFilterUtil;
import org.jetbrains.plugins.ruby.ruby.run.filters.OpenSrcFileHyperlinkInfo;

public class RStackTraceFilter
implements Filter {
    public static final String FILE_PATH_WITHOUT_EXTENSION_PATTERN = "(?<=^|[\\s\\[])(?:\\.{1,2}|[A-Za-z]:|[/\\p{Alnum}_~])[^:\\s]+\\.";
    public static final String EXCEPTION_LINE_NUMBER_PATTERN = ":(\\d+)";
    private static final Pattern l;
    private final String e;
    private static final String h = "/app/";
    private static final String d = "/lib/";
    private static final String g = "/vendor/";
    private static final String c = "/config/";
    private static final String j = "/db/migrate/";
    private static final String a = "/test/";
    private static final String i = "/spec/";
    private static final TextAttributes k;
    private final Project b;
    private final List<String> f;
    private static final long m;

    public RStackTraceFilter(@NotNull Project project) {
        if (project == null) {
            RStackTraceFilter.a(0);
        }
        this(project, null);
    }

    public RStackTraceFilter(@NotNull Module module2) {
        if (module2 == null) {
            RStackTraceFilter.a(1);
        }
        this(module2, null);
    }

    public RStackTraceFilter(@NotNull Module module2, @Nullable String workingDir) {
        if (module2 == null) {
            RStackTraceFilter.a(2);
        }
        this(module2.getProject(), workingDir);
    }

    public RStackTraceFilter(@NotNull Project project, @Nullable String workingDir) {
        if (project == null) {
            RStackTraceFilter.a(3);
        }
        this.b = project;
        this.e = !StringUtil.isEmpty((String)workingDir) ? workingDir + '/' : null;
        this.f = RubyPsiUtil.collectNotNull(ContainerUtil.map((Object[])RModuleUtil.getInstance().getAllModulesWithRubySupport(project), module2 -> RStackTraceFilter.b(module2)));
    }

    private static String b(Module module2) {
        String string = RailsFacetUtil.getRailsAppHomeDirPath(module2);
        if (string != null) {
            return string;
        }
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        return virtualFileArray.length > 0 ? virtualFileArray[0].getPath() : null;
    }

    public Filter.Result applyFilter(@NotNull String line2, int entireLength) {
        Matcher matcher;
        if (line2 == null) {
            RStackTraceFilter.a(4);
        }
        if (this.b.isDisposed()) {
            return null;
        }
        String string = FileLinksFilterUtil.cutLineIfLong(line2);
        int n2 = 0;
        while ((matcher = RStackTraceFilter.matchLine(string, n2)) != null) {
            int n3;
            n2 = matcher.end();
            File file = this.a(matcher.group(1));
            if (file == null || FileLinksFilterUtil.hasExeExtension(file)) continue;
            try {
                n3 = matcher.group(2) == null ? 1 : Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            int n4 = entireLength - line2.length();
            int n5 = n4 + matcher.start();
            int n6 = n4 + matcher.end();
            OpenSrcFileHyperlinkInfo openSrcFileHyperlinkInfo = new OpenSrcFileHyperlinkInfo(this.b, file, n3 - 1){

                @Override
                @Nullable
                protected VirtualFile findVirtualFile() {
                    return (VirtualFile)WriteAction.computeAndWait(() -> VfsUtil.findFileByIoFile((File)this.getFile(), (boolean)true));
                }
            };
            TextAttributes textAttributes = k.clone();
            if (!this.a(file)) {
                Color color = UIUtil.getInactiveTextColor();
                textAttributes.setForegroundColor(color);
                textAttributes.setEffectColor(color);
            }
            return new Filter.Result(n5, n6, (HyperlinkInfo)openSrcFileHyperlinkInfo, textAttributes);
        }
        return null;
    }

    @Nullable
    private File a(String string) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        long l2 = m ^ 0x764A7F5B0DFFL;
        if (this.e != null && string.startsWith(".")) {
            string = this.e + string;
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.f);
        arrayList.add(this.e);
        File file = FileLinksFilterUtil.getFileByRubyLink(string, arrayList);
        if (file != null) {
            return file;
        }
        int n7 = (string = FileUtil.toSystemIndependentName((String)string)).indexOf(h);
        int n8 = n7 > 0 ? n7 : ((n6 = string.indexOf(d)) > 0 ? n6 : ((n5 = string.indexOf(g)) > 0 ? n5 : ((n4 = string.indexOf(j)) > 0 ? n4 : ((n3 = string.indexOf(c)) > 0 ? n3 : ((n2 = string.indexOf(a)) > 0 ? n2 : string.indexOf(i))))));
        if (n8 < 0) {
            return null;
        }
        List<String> list2 = ApplicationManager.getApplication().isUnitTestMode() ? Collections.singletonList(this.e) : this.f;
        String string2 = string.substring(n8);
        for (String string3 : list2) {
            String string4 = string3 + string2;
            File file2 = FileLinksFilterUtil.getFileByRubyLink(string4);
            if (file2 == null) continue;
            return file2;
        }
        return null;
    }

    private boolean a(@NotNull File file) {
        if (file == null) {
            RStackTraceFilter.a(5);
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            VirtualFile virtualFile = localFileSystem.findFileByIoFile(file2);
            if (virtualFile == null || !virtualFile.isValid()) continue;
            return ProjectRootManager.getInstance((Project)this.b).getFileIndex().isInContent(virtualFile);
        }
        return false;
    }

    protected static Pattern getPattern() {
        return l;
    }

    public static Matcher matchLine(@NotNull String line2) {
        if (line2 == null) {
            RStackTraceFilter.a(6);
        }
        return RStackTraceFilter.matchLine(line2, 0);
    }

    @Nullable
    public static Matcher matchLine(String cuttedLine, int offset) {
        Matcher matcher = l.matcher(cuttedLine);
        if (!matcher.find(offset)) {
            return null;
        }
        return matcher;
    }

    static {
        m = com.jetbrains.python.psi.c.a(-6177593469066199276L, -5027295733499717370L, MethodHandles.lookup().lookupClass()).a(233553058791827L);
        long l2 = m ^ 0x17E1104CA4E9L;
        l = Pattern.compile("((?<=^|[\\s\\[])(?:\\.{1,2}|[A-Za-z]:|[/\\p{Alnum}_~])[^:\\s]+\\.[\\w~]+)(?::(\\d+))?");
        k = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = m ^ 0x4E7053496CBAL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/run/filters/RStackTraceFilter";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isInContent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "matchLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

