/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.routes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.codeInsight.paramDefs.ControllerActionRefParam;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.RubyPsiManager;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class RouteParser
implements Disposable {
    private static final Set<String> d;
    private static final Set<String> e;
    public static final String MEMBER = "member";
    public static final String COLLECTION = "collection";
    @NotNull
    private RoutesInfo a = RoutesInfo.EMPTY;
    private final InflectorService b;
    private boolean f;
    @NotNull
    private RailsApp.RoutesFiles<RFile> c;
    private final Module g;
    private static final long h;

    public RouteParser(Module module2, InflectorService inflectorService) {
        this.b = inflectorService;
        this.g = module2;
        this.f = true;
        this.c = RailsApp.RoutesFiles.empty();
        this.g.getMessageBus().connect().subscribe(InflectorService.INFLECTIONS_CHANGED, () -> {
            this.f = true;
        });
    }

    public void dispose() {
        this.a = RoutesInfo.EMPTY;
        this.c = RailsApp.RoutesFiles.empty();
    }

    public void reparse() {
        RailsApp railsApp = RailsApp.fromModule(this.g);
        if (railsApp != null) {
            this.c = railsApp.getRoutesFiles().toType(virtualFile -> {
                PsiFile psiFile = PsiManager.getInstance((Project)this.g.getProject()).findFile(virtualFile);
                return (RFile)ObjectUtils.tryCast((Object)psiFile, RFile.class);
            });
            if (!this.c.isEmpty()) {
                this.a(this.c);
                this.c.allFiles().forEach(rFile -> RubyPsiManager.getInstance(this.g.getProject()).addChangeWatcher((PsiElement)rFile, psiElement -> {
                    this.f = true;
                }));
            }
        }
    }

    public static RouteParser getInstance(Module module2) {
        return (RouteParser)ModuleServiceManager.getService((Module)module2, RouteParser.class);
    }

    private void a(RailsApp.RoutesFiles<RFile> routesFiles) {
        RubyPsiInterpreter rubyPsiInterpreter = new RubyPsiInterpreter(true);
        final RoutesCallable routesCallable = new RoutesCallable(this, new RoutesInfo());
        PsiCallable psiCallable = new PsiCallable(){
            private static final long a = com.jetbrains.python.psi.c.a(4639445239560077469L, 2084650895240999768L, MethodHandles.lookup().lookupClass()).a(38438029932595L);

            @Override
            public void processCall(RCallArguments arguments) {
                long l2 = a ^ 0x26898AA9CD5BL;
                if (arguments.getCommand().equals("draw")) {
                    arguments.interpretBlockWithGivenSelf(routesCallable, routesCallable);
                }
            }
        };
        if (!routesFiles.isEmpty()) {
            rubyPsiInterpreter.interpret((PsiElement)routesFiles.getMainRoutesFile(), psiCallable);
            for (RFile rFile : routesFiles.getAdditionalRoutesFiles()) {
                rubyPsiInterpreter.child().interpret((PsiElement)rFile, routesCallable);
            }
        }
        this.a = routesCallable.f;
        this.f = false;
    }

    @NonNls
    public String getUrlFor(String controller, @NonNls String action) {
        long l2 = h ^ 0x5DEB177B6871L;
        if (this.c().b.contains(controller)) {
            if (action.equals("index")) {
                return controller;
            }
            if (action.equals("show")) {
                return controller + "/1";
            }
            if (action.equals("edit")) {
                return controller + "/1/edit";
            }
        }
        return controller + "/" + action;
    }

    private void a() {
        if (this.f) {
            if (!this.c.isEmpty() && this.c.allFiles().allMatch(PomTarget::isValid)) {
                this.a(this.c);
            } else {
                this.reparse();
            }
        }
    }

    public void cleanupForNextText() {
        this.f = true;
    }

    private static boolean a(RPsiElement rPsiElement) {
        return !(rPsiElement instanceof RSymbol) && !(rPsiElement instanceof RStringLiteral);
    }

    public Collection<String> getNamedRoutes() {
        return this.c().c.keySet();
    }

    @NotNull
    public FQN getFQNForControllerRef(@NotNull PsiElement controllerActionRef) {
        String string;
        if (controllerActionRef == null) {
            RouteParser.a(0);
        }
        if ((string = (String)ObjectUtils.chooseNotNull((Object)ControllerActionRefParam.getControllerName(controllerActionRef), (Object)RubyPsiUtil.getElementText(controllerActionRef))) == null) {
            FQN fQN = FQN.INVALID;
            if (fQN == null) {
                RouteParser.a(1);
            }
            return fQN;
        }
        for (Pair pair : this.c().a.getOrDefault(string, Collections.emptyList())) {
            if (controllerActionRef != ((SmartPsiElementPointer)pair.getFirst()).getElement()) continue;
            FQN fQN = (FQN)pair.getSecond();
            if (fQN == null) {
                RouteParser.a(2);
            }
            return fQN;
        }
        FQN fQN = FQN.INVALID;
        if (fQN == null) {
            RouteParser.a(3);
        }
        return fQN;
    }

    @Nullable
    public PsiElement getDeclaration(String route) {
        SmartPsiElementPointer smartPsiElementPointer = (SmartPsiElementPointer)this.c().c.get(route);
        return smartPsiElementPointer != null ? smartPsiElementPointer.getElement() : null;
    }

    @NotNull
    private RoutesInfo c() {
        this.a();
        RoutesInfo routesInfo = this.a;
        if (routesInfo == null) {
            RouteParser.a(4);
        }
        return routesInfo;
    }

    static {
        h = com.jetbrains.python.psi.c.a(-483943332770809523L, 6781197388791442397L, MethodHandles.lookup().lookupClass()).a(112271688800523L);
        long l2 = h ^ 0x1C22F02EA7A9L;
        d = ContainerUtil.immutableSet((Object[])new String[]{"get", "post", "put", "delete"});
        e = ContainerUtil.immutableSet((Object[])new String[]{"connect", "draw"});
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x1DAF47AB4332L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controllerActionRef";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/routes/RouteParser";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/routes/RouteParser";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQNForControllerRef";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedRoutesInfo";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFQNForControllerRef";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RoutesInfo {
        static final RoutesInfo EMPTY;
        @NotNull
        private final Map<String, SmartPsiElementPointer<?>> c;
        @NotNull
        private final List<String> b;
        @NotNull
        private final Map<String, List<Pair<SmartPsiElementPointer<?>, FQN>>> a;
        private static final long d;

        private RoutesInfo() {
            this(ContainerUtil.newConcurrentMap(), new ArrayList<String>(), ContainerUtil.newConcurrentMap());
        }

        private RoutesInfo(@NotNull Map<String, SmartPsiElementPointer<?>> routes, @NotNull List<String> resources, @NotNull Map<String, List<Pair<SmartPsiElementPointer<?>, FQN>>> shortNameToCallAndFQNMap) {
            if (routes == null) {
                RoutesInfo.a(0);
            }
            if (resources == null) {
                RoutesInfo.a(1);
            }
            if (shortNameToCallAndFQNMap == null) {
                RoutesInfo.a(2);
            }
            this.c = routes;
            this.b = resources;
            this.a = shortNameToCallAndFQNMap;
        }

        public void addControllerRef(@NotNull RPsiElement callElement, @NotNull FQN accumulatedNamespace) {
            String string2;
            if (callElement == null) {
                RoutesInfo.a(3);
            }
            if (accumulatedNamespace == null) {
                RoutesInfo.a(4);
            }
            if ((string2 = (String)ObjectUtils.chooseNotNull((Object)ControllerActionRefParam.getControllerName((PsiElement)callElement), (Object)RubyPsiUtil.getElementText((PsiElement)callElement))) == null) {
                return;
            }
            String string3 = NamingConventions.toCamelCase(string2);
            this.a.computeIfAbsent(string2, string -> new ArrayList()).add(Pair.create((Object)SmartPointerManager.getInstance((Project)callElement.getProject()).createSmartPsiElementPointer((PsiElement)callElement), (Object)FQN.Builder.concat(accumulatedNamespace, string3)));
        }

        static {
            d = com.jetbrains.python.psi.c.a(-1974760092975804198L, -3962061898114021457L, MethodHandles.lookup().lookupClass()).a(74120180250099L);
            EMPTY = new RoutesInfo(Collections.emptyMap(), Collections.emptyList(), Collections.emptyMap());
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = d ^ 0x4056CC7D85BCL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "routes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resources";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shortNameToCallAndFQNMap";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accumulatedNamespace";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/rails/routes/RouteParser$RoutesInfo";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addControllerRef";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class RoutesCallable
    implements PsiCallable {
        @NotNull
        private final RoutesInfo f;
        @NotNull
        private final String e;
        @NotNull
        private final FQN c;
        @Nullable
        private final List<String> a;
        @Nullable
        private final List<String> b;
        private final boolean d;
        final /* synthetic */ RouteParser this$0;
        private static final long g = com.jetbrains.python.psi.c.a(1216532514830811185L, 4961421675956759968L, MethodHandles.lookup().lookupClass()).a(216600884355190L);

        private RoutesCallable(@NotNull RouteParser routeParser, RoutesInfo routesInfo) {
            if (routesInfo == null) {
                RoutesCallable.a(0);
            }
            this(routeParser, routesInfo, "", FQN.INVALID, null, null, false);
        }

        private RoutesCallable(@NotNull RouteParser routeParser, @NotNull RoutesInfo routesInfo, @NotNull String resourcePrefix, @Nullable FQN namespace, @Nullable List<String> only, List<String> except, boolean shallow) {
            if (routesInfo == null) {
                RoutesCallable.a(1);
            }
            if (resourcePrefix == null) {
                RoutesCallable.a(2);
            }
            if (namespace == null) {
                RoutesCallable.a(3);
            }
            this.this$0 = routeParser;
            this.f = routesInfo;
            this.e = resourcePrefix;
            this.c = namespace;
            this.a = only;
            this.b = except;
            this.d = shallow;
        }

        @Override
        public void processCall(RCallArguments arguments) {
            long l2 = g ^ 0x5C8F52C544FFL;
            PsiElement psiElement = arguments.getCallElement();
            if (psiElement instanceof RIdentifier && ((RIdentifier)psiElement).isBlockParameterDeclaration()) {
                return;
            }
            String string = arguments.getCommand();
            if (string.equals("with_options") || string.equals("controller")) {
                RoutesCallable routesCallable = new RoutesCallable(this.this$0, this.f);
                arguments.interpretBlockWithGivenSelf(routesCallable, routesCallable);
            } else if (string.equals("resource")) {
                this.a(arguments, true);
            } else if (string.equals("resources")) {
                this.a(arguments, false);
            } else if (string.equals("match") || arguments.getOptionValue("as") != null) {
                this.a(arguments);
            } else if (this.a(string)) {
                this.a(arguments, this.e, false, false);
            } else if (RouteParser.MEMBER.equals(string) || RouteParser.COLLECTION.equals(string)) {
                MethodsCallable methodsCallable = new MethodsCallable(this.e, RouteParser.COLLECTION.equals(string), RouteParser.MEMBER.equals(string));
                arguments.interpretBlockWithGivenSelf(methodsCallable, new PsiCallable[0]);
            } else if (!this.b(string)) {
                if (arguments.hasBlock()) {
                    this.a(string, arguments);
                } else {
                    this.a(string, arguments.getRCallElement());
                }
            }
        }

        private void a(RCallArguments rCallArguments, String string, boolean bl2, boolean bl3) {
            RPsiElement rPsiElement;
            Object object;
            long l2 = g ^ 0x62969A5F543L;
            List<RPsiElement> list2 = rCallArguments.getArguments();
            if (list2.size() == 1 && list2.get(0) instanceof RAssoc && (object = (RAssoc)list2.get(0)).getKey() instanceof RStringLiteral) {
                this.a(object.getKeyText(), rCallArguments.getRCallElement());
            }
            if (!this.this$0.b.isInflectorAvailable()) {
                return;
            }
            string = !string.isEmpty() ? string.substring(0, string.length() - 1) : "";
            object = this.this$0.b.pluralize(string);
            String string2 = this.this$0.b.singularize(string);
            String string3 = (String)object + (StringUtil.equals((CharSequence)object, (CharSequence)string2) ? "_index" : "");
            String string4 = rCallArguments.getOptionValue("on");
            for (int i10 = 0; i10 < list2.size() && !RouteParser.a(rPsiElement = list2.get(i10)); ++i10) {
                String string5 = rCallArguments.evaluateArgument(i10);
                if (StringUtil.isEmpty((String)string5)) continue;
                string5 = this.c(string5);
                if (bl2 && (string4 == null || RouteParser.COLLECTION.equals(string4))) {
                    this.a(string5 + "_" + string3, (PsiElement)rPsiElement);
                }
                if (bl3 && (string4 == null || RouteParser.MEMBER.equals(string4))) {
                    this.a(string5 + "_" + string2, (PsiElement)rPsiElement);
                }
                if (!string.isEmpty()) continue;
                this.a(string5, (PsiElement)rPsiElement);
            }
        }

        private void a(String string, RCallArguments rCallArguments) {
            List<String> list2;
            Object object;
            String string2;
            long l2 = g ^ 0x31858FB76054L;
            if (!this.this$0.b.isInflectorAvailable()) {
                return;
            }
            boolean bl2 = string.equals("namespace");
            if (!bl2) {
                string2 = rCallArguments.getOptionValue("as");
            } else {
                object = rCallArguments.evaluateArgument(0);
                if (object == null) {
                    return;
                }
                string2 = object;
            }
            object = rCallArguments.getOptionValues("only");
            if (object == null) {
                object = this.a;
            }
            if ((list2 = rCallArguments.getOptionValues("except")) == null) {
                list2 = this.b;
            }
            boolean bl3 = this.d || "true".equals(rCallArguments.getOptionValue("shallow", ""));
            FQN fQN = string2 != null ? FQN.Builder.concat(this.c, NamingConventions.toCamelCase(string2)) : this.c;
            String string3 = this.e + (string2 != null ? this.this$0.b.singularize(string2) + "_" : "");
            RoutesCallable routesCallable = new RoutesCallable(this.this$0, this.f, string3, fQN, (List<String>)object, list2, bl3);
            rCallArguments.interpretBlockWithGivenSelf(routesCallable, routesCallable);
        }

        private void a(RCallArguments rCallArguments) {
            String string;
            long l2 = g ^ 0x60C54031D2D7L;
            String string2 = rCallArguments.getOptionValue("as");
            String string3 = string = string2 != null ? string2 : this.c(rCallArguments.evaluateArgument(0));
            if (string != null) {
                this.a(string, rCallArguments.getRCallElement());
            }
        }

        private String c(String string) {
            long l2 = g ^ 0x590CB2615482L;
            if (string == null) {
                return null;
            }
            for (char c10 : string.toCharArray()) {
                if (c10 == '/' || c10 == '_' || Character.isLetterOrDigit(c10)) continue;
                return null;
            }
            while (string.contains("//")) {
                string = string.replace("//", "/");
            }
            string = string.startsWith("/") ? string.substring(1) : string;
            return string.replaceAll("/", "_");
        }

        private void a(@NonNls String string, PsiElement psiElement) {
            if (string == null) {
                return;
            }
            this.f.c.put(string, SmartPointerManager.getInstance((Project)psiElement.getProject()).createSmartPsiElementPointer(psiElement));
        }

        private void a(RCallArguments rCallArguments, boolean bl2) {
            List<String> list2;
            List<String> list3;
            long l2 = g ^ 0x21CFA3F9C438L;
            String string = rCallArguments.getOptionValue("name_prefix", this.e);
            if (string == null) {
                string = "";
            }
            if ((list3 = rCallArguments.getOptionValues("only")) == null) {
                list3 = this.a;
            }
            if ((list2 = rCallArguments.getOptionValues("except")) == null) {
                list2 = this.b;
            }
            boolean bl3 = this.d || "true".equals(rCallArguments.getOptionValue("shallow", ""));
            for (RPsiElement rPsiElement : rCallArguments.getArguments()) {
                Object object;
                Object object2;
                Object object32;
                if (RouteParser.a(rPsiElement)) continue;
                String string2 = rCallArguments.getOptionValue("as");
                String string3 = string2 == null ? StringUtil.notNullize((String)RubyPsiUtil.getElementText((PsiElement)rPsiElement)) : string2;
                this.f.addControllerRef(string2 == null ? rPsiElement : rCallArguments.getOptionValueElement("as"), this.c);
                this.f.b.add(string3);
                if (!this.this$0.b.isInflectorAvailable()) continue;
                this.a(string3, bl2, string, list3, list2, bl3, rCallArguments.getRCallElement());
                List<String> list4 = rCallArguments.getOptionHashKeys(RouteParser.COLLECTION);
                for (String string4 : list4) {
                    this.a(string4 + "_" + string + string3, rCallArguments.getRCallElement());
                }
                String string4 = this.this$0.b.singularize(string3);
                List<String> object42 = rCallArguments.getOptionHashKeys(RouteParser.MEMBER);
                for (Object object32 : object42) {
                    this.a((String)object32 + "_" + string + (String)string4, rCallArguments.getRCallElement());
                }
                String string5 = string + this.this$0.b.singularize(string3) + "_";
                object32 = new RoutesCallable(this.this$0, this.f, string5, this.c, list3, list2, bl3);
                rCallArguments.interpretBlockWithGivenSelf((PsiCallable)object32, new PsiCallable[]{object32});
                List<String> list5 = rCallArguments.getOptionValues("has_one");
                if (list5 != null) {
                    object2 = list5.iterator();
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        this.a((String)object, true, string5, list3, list2, bl3, rCallArguments.getRCallElement());
                    }
                }
                if ((object2 = rCallArguments.getOptionValues("has_many")) == null) continue;
                object = object2.iterator();
                while (object.hasNext()) {
                    String string6 = (String)object.next();
                    this.a(string6, false, string5, list3, list2, bl3, rCallArguments.getRCallElement());
                }
            }
        }

        private void a(String string, boolean bl2, String string2, List<String> list2, List<String> list3, boolean bl3, PsiElement psiElement) {
            String string3;
            String string4;
            long l2 = g ^ 0x4955DE4A0908L;
            if (this.a("index", list2, list3) || this.a("create", list2, list3)) {
                this.a(string2 + string, psiElement);
            }
            String string5 = string4 = bl3 ? "" : string2;
            if (!bl2) {
                string3 = this.this$0.b.singularize(string);
                if (this.a("edit", list2, list3) || this.a("show", list2, list3) || this.a("update", list2, list3) || this.a("destroy", list2, list3)) {
                    this.a(string4 + string3, psiElement);
                }
            } else {
                string3 = string;
            }
            if (this.a("new", list2, list3)) {
                this.a("new_" + string2 + string3, psiElement);
            }
            if (this.a("edit", list2, list3)) {
                this.a("edit_" + string4 + string3, psiElement);
            }
        }

        private boolean a(String string, List<String> list2, List<String> list3) {
            if (list2 != null) {
                return list2.contains(string);
            }
            if (list3 != null) {
                return !list3.contains(string);
            }
            return true;
        }

        private boolean b(@NonNls String string) {
            return e.contains(string);
        }

        private boolean a(String string) {
            return d.contains(string);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = g ^ 0x6FB6CE55ED4BL;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "routesInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resourcePrefix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "namespace";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/rails/routes/RouteParser$RoutesCallable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MethodsCallable
        implements PsiCallable {
            private final boolean b;
            private final String c;
            private final boolean a;

            MethodsCallable(String resourcePrefix, boolean inCollection, boolean inMember) {
                this.c = resourcePrefix;
                this.a = inCollection;
                this.b = inMember;
            }

            @Override
            public void processCall(RCallArguments arguments) {
                if (RoutesCallable.this.a(arguments.getCommand())) {
                    RoutesCallable.this.a(arguments, this.c, this.a, this.b);
                }
            }
        }
    }
}

