/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.refactoring.rename;

import com.intellij.concurrency.JobScheduler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorOptions;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.special.GenerateMigrationAction;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.rails.refactoring.rename.RailsRenameUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.rename.RenameProcessor;
import org.jetbrains.plugins.ruby.settings.RProjectUtil;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class RenameByRailsModelClassProcessor
extends RenameProcessor {
    public static final Key<Boolean> IS_RENAMED_MODEL;
    public static final Key<String> OLD_NAME;
    private String b;
    private static final String a = "Rename Rails model";

    @Override
    public boolean canProcessElement(PsiElement element) {
        if (element instanceof RClass) {
            RailsModel railsModel = RailsModel.fromClass((RClass)element);
            return railsModel != null;
        }
        return false;
    }

    @Override
    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        RailsModel railsModel;
        if (element instanceof RClass && (railsModel = RailsModel.fromClass((RClass)element)) != null) {
            element.putCopyableUserData(IS_RENAMED_MODEL, (Object)true);
            element.putCopyableUserData(OLD_NAME, (Object)railsModel.getClassName());
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            InflectorService inflectorService = InflectorService.getInstance(module2);
            if (inflectorService != null && inflectorService.isInflectorAvailable()) {
                String string = inflectorService.pluralize(newName);
                RailsController railsController = railsModel.getController();
                if (railsController != null && !railsController.isApplicationController()) {
                    RailsRenameUtil.renameControllerStuff(railsController, string, allRenames);
                }
                RailsRenameUtil.renameModelStuff(railsModel, newName, allRenames);
            }
        }
    }

    @Override
    @Nullable
    public Runnable getPostRenameCallback(final PsiElement element, final String newName, RefactoringElementListener elementListener) {
        Module module2;
        PsiFile psiFile;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)element.getProject());
        Document document = psiDocumentManager.getDocument(psiFile = element.getContainingFile());
        if (document != null) {
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
        }
        if (element instanceof RClass && ActiveRecordModel.isActiveRecordClass((RClass)element) && element.getCopyableUserData(IS_RENAMED_MODEL) != null && (module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null) {
            final Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
            if (sdk == null) {
                ProjectRootManager.getInstance((Project)module2.getProject());
            }
            return new Runnable(){
                private static final long a = c.a(-6585624583305091608L, -7977725656214519682L, MethodHandles.lookup().lookupClass()).a(192156946893928L);

                @Override
                public void run() {
                    long l2 = a ^ 0x13FCD13856F5L;
                    if (sdk == null) {
                        return;
                    }
                    RailsApp railsApp = RailsApp.fromModule(module2);
                    if (railsApp == null) {
                        return;
                    }
                    String string = (String)element.getCopyableUserData(OLD_NAME);
                    RenameByRailsModelClassProcessor.this.b = this.a(string, newName);
                    MigrationListener migrationListener = new MigrationListener(module2, string, newName);
                    VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)migrationListener);
                    GenerateMigrationAction generateMigrationAction = new GenerateMigrationAction("migration");
                    GeneratorOptions generatorOptions = RProjectUtil.getGeneratorsOptions(module2.getProject());
                    String string2 = StringUtil.isEmpty((String)generatorOptions.ENVIRONMENT) ? "development" : generatorOptions.ENVIRONMENT;
                    generateMigrationAction.invokeAction(RenameByRailsModelClassProcessor.this.b, string2, module2);
                    FileDocumentManager.getInstance().saveAllDocuments();
                }

                private String a(String string, String string2) {
                    long l2 = a ^ 0x73A9197C0EDAL;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("rename").append(string).append("To").append(string2);
                    return stringBuilder.toString();
                }
            };
        }
        return null;
    }

    static {
        long l2 = c.a(-8522922682264858600L, 1418675323838313672L, MethodHandles.lookup().lookupClass()).a(249520035518526L) ^ 0x468C2A3056D1L;
        IS_RENAMED_MODEL = Key.create((String)"IS_RENAMED_MODEL");
        OLD_NAME = Key.create((String)"OLD_NAME");
    }

    private static class MigrationNotification
    extends Notification {
        private static final long a = c.a(2580472293707772495L, 5352433981335521729L, MethodHandles.lookup().lookupClass()).a(246414284692384L);

        MigrationNotification(final Module module2) {
            long l2 = a ^ 0x290259555502L;
            super(RenameByRailsModelClassProcessor.a, RBundle.message("rails.run.migration.title"), RBundle.message("rails.run.migration.message"), NotificationType.WARNING, new NotificationListener(){
                private static final long a = c.a(2088380277976087511L, -6564529262414991576L, MethodHandles.lookup().lookupClass()).a(9138248248675L);

                public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                    long l2 = a ^ 0x12F22534CEFL;
                    if (notification2 == null) {
                        1.a(0);
                    }
                    if (event == null) {
                        1.a(1);
                    }
                    RakeUtil.runRakeTask("db:migrate", module2, null);
                    notification2.expire();
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    long l2 = a ^ 0x2A2B8E2F8D15L;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/ruby/rails/refactoring/rename/RenameByRailsModelClassProcessor$MigrationNotification$1";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private final class MigrationListener
    implements VirtualFileListener {
        private final Ref<Module> a;
        private final String c;
        private final String b;
        private static final long d = com.jetbrains.python.psi.c.a(-1803475524648276971L, -8767883360724075638L, MethodHandles.lookup().lookupClass()).a(243198221705531L);

        MigrationListener(Module module2, String oldName, String newName) {
            if (module2 == null) {
                MigrationListener.a(0);
            }
            this.a = new Ref();
            this.a.set((Object)module2);
            this.c = oldName;
            this.b = newName;
            JobScheduler.getScheduler().schedule(() -> VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this), 30L, TimeUnit.SECONDS);
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            VirtualFile virtualFile;
            if (event == null) {
                MigrationListener.a(1);
            }
            if ((virtualFile = event.getFile()).getNameWithoutExtension().endsWith(NamingConventions.toUnderscoreCase(RenameByRailsModelClassProcessor.this.b))) {
                this.a(virtualFile);
                Notifications.Bus.notify((Notification)new MigrationNotification((Module)this.a.get()));
            }
            VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this);
            this.a.set(null);
        }

        private void a(VirtualFile virtualFile) {
            Module module2 = (Module)this.a.get();
            PsiFile psiFile = PsiManager.getInstance((Project)module2.getProject()).findFile(virtualFile);
            if (psiFile instanceof RContainer) {
                RClass rClass = RContainerUtil.getFirstClassInFile(psiFile);
                if (rClass == null) {
                    return;
                }
                Symbol symbol = SymbolUtil.getSymbolByContainer(rClass);
                if (symbol == null) {
                    return;
                }
                List<Symbol> list2 = symbol.getChildren(Types.METHODS, (PsiElement)rClass);
                if (RailsUtil.isRails31OrHigher(module2) && list2.size() == 1) {
                    this.a(module2, psiFile, list2.get(0));
                } else if (list2.size() == 2) {
                    this.a(module2, psiFile, list2.get(0));
                    this.a(module2, psiFile, list2.get(1));
                }
                CodeStyleManager.getInstance((Project)module2.getProject()).reformat((PsiElement)rClass);
            }
        }

        private void a(@NotNull Module module2, @NotNull PsiFile psiFile, @Nullable Symbol symbol) {
            if (module2 == null) {
                MigrationListener.a(2);
            }
            if (psiFile == null) {
                MigrationListener.a(3);
            }
            if (symbol == null) {
                return;
            }
            PsiElement psiElement = symbol.getPsiElement();
            if (psiElement == null) {
                return;
            }
            String string = psiElement.getText();
            InflectorService inflectorService = InflectorService.getInstance(module2);
            String string2 = inflectorService.tableize(this.c);
            String string3 = inflectorService.tableize(this.b);
            String string4 = this.a(string, string2, string3);
            RPsiElement rPsiElement = RubyElementFactory.createElementFromText((PsiElement)psiFile, string4);
            WriteCommandAction.writeCommandAction((Project)module2.getProject()).run(() -> psiElement.replace((PsiElement)rPsiElement));
        }

        private String a(String string, String string2, String string3) {
            long l2 = d ^ 0x19CDF1A6FB8CL;
            String string4 = "(.*)(\\n\\s+end)$";
            Pattern pattern = Pattern.compile("(.*)(\\n\\s+end)$");
            Matcher matcher = pattern.matcher(string);
            StringBuilder stringBuilder = new StringBuilder();
            if (matcher.matches()) {
                stringBuilder.append(matcher.group(1)).append("\n").append("rename_table ").append(":").append(string2).append(", :").append(string3).append(matcher.group(2));
            }
            return stringBuilder.toString();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = d ^ 0x6333F1F555A7L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/rails/refactoring/rename/RenameByRailsModelClassProcessor$MigrationListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insertTableRename";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

