/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.refactoring.rename;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsFileItem;
import org.jetbrains.plugins.ruby.rails.model.RailsHelper;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.rails.nameConventions.ControllersConventions;
import org.jetbrains.plugins.ruby.rails.nameConventions.HelpersConventions;
import org.jetbrains.plugins.ruby.rails.rspec.model.RailsRSpecModelTest;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RFieldHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class RailsRenameUtil {
    private static final long a = c.a(-5175191772850490415L, -1698199786267637594L, MethodHandles.lookup().lookupClass()).a(176478359330157L);

    private RailsRenameUtil() {
    }

    public static void renameControllerStuff(RailsController controller, String newControllerName, Map<PsiElement, String> allRenames) {
        PsiDirectory psiDirectory;
        Object object;
        Object object2;
        Object object3;
        RFieldHolder rFieldHolder;
        String string;
        long l2 = a ^ 0x6667036446FDL;
        RailsRenameUtil.a(controller, newControllerName, allRenames);
        RClass rClass = controller.getRClass();
        String string2 = controller.getName();
        String string3 = ControllersConventions.getControllerClassName(newControllerName);
        if (string3 == null) {
            return;
        }
        allRenames.put((PsiElement)rClass, string3);
        Module module2 = controller.getModule();
        String string4 = ControllersConventions.getControllerFileNameWithoutExtension(string3, module2);
        String string5 = ControllersConventions.getControllerFileName(string3, module2);
        RailsRenameUtil.a(string5, controller.getPsiFile(), allRenames);
        RailsHelper railsHelper = controller.getOwnHelper();
        if (railsHelper != null) {
            string = HelpersConventions.getHelperModuleNameByHelperName(newControllerName);
            rFieldHolder = railsHelper.getRModule();
            allRenames.put((PsiElement)rFieldHolder, string);
            object3 = railsHelper.getPsiFile();
            if (object3 != null) {
                object2 = HelpersConventions.getHelperFileNameByHelperModuleName(string);
                RailsRenameUtil.a((String)object2, object3, allRenames);
            }
        }
        if ((string = controller.getViewsFolder()) != null && string.isValid() && (rFieldHolder = rClass.getManager().findDirectory((VirtualFile)string)) != null) {
            allRenames.put((PsiElement)rFieldHolder, newControllerName);
        }
        if ((rFieldHolder = controller.getFunctionalTestClass()) != null) {
            object3 = rFieldHolder.getContainingFile();
            object2 = string4 + "_test.rb";
            RailsRenameUtil.a((String)object2, object3, allRenames);
            allRenames.put((PsiElement)rFieldHolder, string3 + "Test");
        }
        if ((object3 = controller.getUnitTestClass()) != null) {
            object2 = object3.getContainingFile();
            object = string4 + "_test.rb";
            RailsRenameUtil.a((String)object, object2, allRenames);
            allRenames.put((PsiElement)object3, string3 + "Test");
        }
        if ((object2 = controller.getSpecTest()) != null) {
            object = object2.getPsiFile();
            assert (object != null) : "Controller Spec test file cannot be null";
            psiDirectory = string4 + "_spec.rb";
            RailsRenameUtil.a((String)psiDirectory, object, allRenames);
        }
        RailsRenameUtil.b(controller, newControllerName, allRenames);
        RailsRenameUtil.c(controller, newControllerName, allRenames);
        if (railsHelper != null) {
            Object object4;
            Object object5;
            object = railsHelper.getUnitTest();
            if (object != null) {
                psiDirectory = object.getContainingFile();
                object5 = HelpersConventions.getHelperFileNameWithoutExtensionByHelperName(newControllerName) + "_test.rb";
                RailsRenameUtil.a((String)object5, (PsiFile)psiDirectory, allRenames);
                object4 = HelpersConventions.getHelperModuleNameByHelperName(newControllerName);
                allRenames.put((PsiElement)object, (String)object4 + "Test");
            }
            if ((psiDirectory = railsHelper.getSpecTest()) != null) {
                object5 = psiDirectory.getPsiFile();
                assert (object5 != null) : "Helper Spec test file cannot be null";
                object4 = HelpersConventions.getHelperFileNameWithoutExtensionByHelperName(newControllerName) + "_spec.rb";
                RailsRenameUtil.a((String)object4, object5, allRenames);
            }
        }
        if ((object = controller.getViewsSpecsFolder()) != null && (psiDirectory = controller.getPsiFile().getManager().findDirectory((VirtualFile)object)) != null) {
            allRenames.put((PsiElement)psiDirectory, newControllerName);
        }
        psiDirectory = controller.getLayouts();
        for (Object object4 : psiDirectory) {
            PsiFile psiFile;
            if (!string2.equals(((RailsFileItem)object4).getName()) || (psiFile = ((RailsFileItem)object4).getPsiFile()) == null) continue;
            RailsRenameUtil.a(newControllerName + psiFile.getName().substring(string2.length()), psiFile, allRenames);
        }
        RailsRenameUtil.e(controller, newControllerName, allRenames);
    }

    private static void b(RailsController railsController, String string, Map<PsiElement, String> map2) {
        long l2 = a ^ 0x1DCEF3C908C5L;
        VirtualFile virtualFile = railsController.getRequestSpec();
        if (virtualFile != null) {
            String string2 = string + "_spec.rb";
            PsiFile psiFile = railsController.getRClass().getManager().findFile(virtualFile);
            if (psiFile != null) {
                RailsRenameUtil.a(string2, psiFile, map2);
            }
        }
    }

    private static void c(RailsController railsController, String string, Map<PsiElement, String> map2) {
        long l2 = a ^ 0x67D3EE6AB19DL;
        VirtualFile virtualFile = railsController.getRoutingSpec();
        if (virtualFile != null) {
            String string2 = string + "_routing" + "_spec.rb";
            PsiFile psiFile = railsController.getRClass().getManager().findFile(virtualFile);
            if (psiFile != null) {
                RailsRenameUtil.a(string2, psiFile, map2);
            }
        }
    }

    private static void a(@Nullable String string, @NotNull PsiFile psiFile, Map<PsiElement, String> map2) {
        if (psiFile == null) {
            RailsRenameUtil.a(0);
        }
        if (string != null) {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            assert (virtualFile != null);
            VirtualFile virtualFile2 = virtualFile.getParent();
            assert (virtualFile2 != null);
            if (virtualFile2.findChild(string) == null) {
                map2.put((PsiElement)psiFile, string);
            }
        }
    }

    public static void renameModelStuff(RailsModel model, String newModelName, Map<PsiElement, String> allRenames) {
        RailsRenameUtil.a(model, newModelName, allRenames);
        RailsRenameUtil.c(model, newModelName, allRenames);
        RailsRenameUtil.d(model, newModelName, allRenames);
        RailsController railsController = model.getController();
        if (railsController != null) {
            RailsRenameUtil.b(model, newModelName, allRenames);
            RailsRenameUtil.d(railsController, newModelName, allRenames);
        }
    }

    private static void d(RailsModel railsModel, String string, Map<PsiElement, String> map2) {
        long l2 = a ^ 0x22580AD00666L;
        RailsRSpecModelTest railsRSpecModelTest = railsModel.getSpecTest();
        if (railsRSpecModelTest != null) {
            VirtualFile virtualFile = railsRSpecModelTest.getFile();
            String string2 = virtualFile.getExtension();
            PsiFile psiFile = railsModel.getRClass().getManager().findFile(virtualFile);
            if (psiFile != null) {
                String string3 = "_spec." + string2;
                RailsRenameUtil.a(NamingConventions.toUnderscoreCase(string) + string3, psiFile, map2);
            }
        }
    }

    private static void a(RailsController railsController, String string, Map<PsiElement, String> map2) {
        RailsApp railsApp = RailsApp.fromModule(railsController.getModule());
        assert (railsApp != null);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)railsApp.getProject(), (Collection)railsApp.getRoutesFiles().allFiles().collect(Collectors.toList()));
        PsiReference psiReference = (PsiReference)ReferencesSearch.search((PsiElement)railsController.getRClass(), (SearchScope)globalSearchScope).findFirst();
        if (psiReference != null) {
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), RCall.class);
            if (psiElement == null) {
                return;
            }
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            linkedHashMap.putAll(map2);
            map2.clear();
            map2.put(psiElement, string);
            map2.putAll((Map<PsiElement, String>)linkedHashMap);
        }
    }

    private static void e(RailsController railsController, String string, Map<PsiElement, String> map2) {
        String string2 = NamingConventions.toUnderscoreCase(string);
        String string3 = NamingConventions.toUnderscoreCase(railsController.getName());
        RailsApp railsApp = railsController.getApp();
        VirtualFile virtualFile = railsApp.getAssetsRoot();
        if (virtualFile != null) {
            VirtualFile[] virtualFileArray;
            PsiManager psiManager = railsController.getRClass().getManager();
            for (VirtualFile virtualFile2 : virtualFileArray = virtualFile.getChildren()) {
                VirtualFile[] virtualFileArray2;
                if (!virtualFile2.isDirectory()) continue;
                for (VirtualFile virtualFile3 : virtualFileArray2 = virtualFile2.getChildren()) {
                    String string4 = virtualFile3.getName();
                    String string5 = RailsRenameUtil.a(string4);
                    if (!string5.equals(string3)) continue;
                    String string6 = RailsRenameUtil.b(string4);
                    PsiFile psiFile = psiManager.findFile(virtualFile3);
                    if (psiFile != null) {
                        map2.put((PsiElement)psiFile, string2 + string6);
                        continue;
                    }
                    PsiDirectory psiDirectory = psiManager.findDirectory(virtualFile3);
                    if (psiDirectory == null) continue;
                    map2.put((PsiElement)psiDirectory, string2);
                }
            }
        }
    }

    private static void b(RailsModel railsModel, String string, Map<PsiElement, String> map2) {
        RailsController railsController = railsModel.getController();
        InflectorService inflectorService = InflectorService.getInstance(railsModel.getModule());
        String string2 = inflectorService.pluralize(string);
        RailsRenameUtil.renameControllerStuff(railsController, string2, map2);
    }

    private static void d(@NotNull RailsController railsController, String string, Map<PsiElement, String> map2) {
        long l2 = a ^ 0x7EC32601A524L;
        if (railsController == null) {
            RailsRenameUtil.a(1);
        }
        RClass rClass = railsController.getRClass();
        String string2 = railsController.getName();
        InflectorService inflectorService = InflectorService.getInstance(railsController.getModule());
        String string3 = inflectorService.singularize(string2);
        assert (string3 != null) : "Null as a singular for [" + string2 + "]";
        String string4 = inflectorService.pluralize(string);
        Symbol symbol = SymbolUtil.getSymbolByContainer(rClass);
        if (symbol != null) {
            List<Symbol> list2 = symbol.getChildren(Type.INSTANCE_FIELD, (PsiElement)rClass);
            for (Symbol symbol2 : list2) {
                String string5 = null;
                PsiElement psiElement = symbol2.getPsiElement();
                String string6 = symbol2.getName();
                if (psiElement == null || string6 == null) continue;
                if (string6.equals(string3)) {
                    string5 = NamingConventions.toUnderscoreCase(string);
                } else if (string6.equals(string2) && string4 != null) {
                    string5 = NamingConventions.toUnderscoreCase(string4);
                } else if (string6.endsWith(string3)) {
                    string5 = string6.replace(string3, NamingConventions.toUnderscoreCase(string));
                } else if (string6.endsWith(string2)) {
                    string5 = string6.replace(string2, NamingConventions.toUnderscoreCase(string4));
                }
                if (string5 == null) continue;
                map2.put(psiElement, string5);
            }
        }
    }

    private static String a(String string) {
        int n2 = string.indexOf(46);
        if (n2 < 0) {
            return string;
        }
        return string.substring(0, n2);
    }

    private static String b(String string) {
        int n2 = string.indexOf(46);
        if (n2 < 0) {
            return string;
        }
        return string.substring(n2);
    }

    private static void c(RailsModel railsModel, String string, Map<PsiElement, String> map2) {
        long l2 = a ^ 0x4AF98F0FD1C3L;
        RClass rClass = railsModel.getUnitTestClass();
        if (rClass != null) {
            PsiFile psiFile = rClass.getContainingFile();
            RailsRenameUtil.a(NamingConventions.toUnderscoreCase(string) + "_test.rb", psiFile, map2);
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null && virtualFile.isValid()) {
                map2.put((PsiElement)rClass, string + "Test");
            }
        }
    }

    private static void a(RailsModel railsModel, String string, Map<PsiElement, String> map2) {
        VirtualFile virtualFile = railsModel.getFixtureUnitTestFile();
        if (virtualFile == null) {
            return;
        }
        InflectorService inflectorService = InflectorService.getInstance(railsModel.getModule());
        PsiManager psiManager = railsModel.getRClass().getManager();
        PsiFile psiFile = psiManager.findFile(virtualFile);
        if (psiFile == null) {
            return;
        }
        String string2 = inflectorService.pluralize(string);
        String string3 = "." + virtualFile.getExtension();
        if (string2 != null) {
            RailsRenameUtil.a(NamingConventions.toUnderscoreCase(string2) + string3, psiFile, map2);
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x1D918315ECE8L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/refactoring/rename/RailsRenameUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addIfNameIfValid";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "renameInstanceVariablesInController";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

