/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.assetsPaths;

import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.cli.RMInspectionToolLaunchSettings;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketAssetsLoadPathManager;
import org.jetbrains.plugins.ruby.rails.codeInsight.sprockets.SprocketsUtil;
import org.jetbrains.plugins.ruby.rails.facet.versions.BaseRailsFacet;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RExpressionSubstitution;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RShiftExpressionNavigator;
import org.jetbrains.plugins.ruby.util.ProjectQueues;

public class AssetsRegistrationWatcher {
    public static final Topic<AssetsListener> ASSETS_CHANGED_TOPIC;
    private static final Logger b;
    private static final String f = "paths";
    private static final String c = "assets.paths";
    private static final String a = "#{Rails.root}";
    private final MergingUpdateQueue d;
    private final Module g;
    private VirtualFileListener h;
    public PsiTreeChangeAdapter myPsiListener;
    private MessageBusConnection e;
    private static final long i;

    public AssetsRegistrationWatcher(@NotNull Module module2) {
        long l2 = i ^ 0x3967FB451863L;
        if (module2 == null) {
            AssetsRegistrationWatcher.a(0);
        }
        this.d = new MergingUpdateQueue("AssetsRegistrationWatcher", 5000, true, null).setRestartTimerOnAdd(true);
        this.g = module2;
    }

    public void dispose() {
        if (this.h != null) {
            VirtualFileManager.getInstance().removeVirtualFileListener(this.h);
            this.h = null;
        }
        if (this.myPsiListener != null) {
            Project project = this.g.getProject();
            PsiManager.getInstance((Project)project).removePsiTreeChangeListener((PsiTreeChangeListener)this.myPsiListener);
            this.myPsiListener = null;
        }
        if (this.e != null) {
            this.e.disconnect();
            this.e = null;
        }
        this.d.cancelAllUpdates();
        Disposer.dispose((Disposable)this.d);
    }

    public static AssetsRegistrationWatcher getInstance(Module module2) {
        return (AssetsRegistrationWatcher)ModuleServiceManager.getService((Module)module2, AssetsRegistrationWatcher.class);
    }

    public void subscribe() {
        if (this.g.isDisposed()) {
            return;
        }
        RailsApp railsApp = RailsApp.fromModule(this.g);
        b.assertTrue(railsApp != null);
        StartupManager startupManager = StartupManager.getInstance((Project)this.g.getProject());
        startupManager.runWhenProjectIsInitialized(() -> {
            if (!RMInspectionToolLaunchSettings.getInstance().isActivated()) {
                this.a(railsApp);
            }
            AssetsRegistrationWatcher.b(this.g, railsApp).run();
        });
    }

    private void a(@NotNull RailsApp railsApp) {
        long l2 = i ^ 0x2C290254D2AFL;
        if (railsApp == null) {
            AssetsRegistrationWatcher.a(1);
        }
        final String string = railsApp.getApplicationFileUrl();
        final String string2 = railsApp.getInitializersRootUrl();
        if (string == null) {
            return;
        }
        assert (this.h == null) : "Double assets watcher registration";
        this.myPsiListener = new PsiTreeChangeAdapter(){
            private static final long a = com.jetbrains.python.psi.c.a(5174971253567386570L, -682713394854416855L, MethodHandles.lookup().lookupClass()).a(27512352673992L);

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.a(0);
                }
                AssetsRegistrationWatcher.this.a(event, string, string2);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.a(1);
                }
                AssetsRegistrationWatcher.this.a(event, string, string2);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.a(2);
                }
                AssetsRegistrationWatcher.this.a(event, string, string2);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.a(3);
                }
                AssetsRegistrationWatcher.this.a(event, string, string2);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.a(4);
                }
                AssetsRegistrationWatcher.this.a(event, string, string2);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x722B54EFB228L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/assetsPaths/AssetsRegistrationWatcher$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        PsiManager.getInstance((Project)this.g.getProject()).addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiListener);
        this.h = new VirtualFileListener(){
            private static final long a = com.jetbrains.python.psi.c.a(5311120376804984924L, -438015389218685479L, MethodHandles.lookup().lookupClass()).a(150251694170478L);

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.a(0);
                }
                AssetsRegistrationWatcher.this.a(event.getFile(), string, string2);
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.a(1);
                }
                AssetsRegistrationWatcher.this.a(event.getFile(), string, string2);
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    2.a(2);
                }
                AssetsRegistrationWatcher.this.a(event.getFile(), string, string2);
            }

            public void fileCopied(@NotNull VirtualFileCopyEvent event) {
                if (event == null) {
                    2.a(3);
                }
                AssetsRegistrationWatcher.this.a(event.getFile(), string, string2);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0xE2B4FD36EEEL;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/assetsPaths/AssetsRegistrationWatcher$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileMoved";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCopied";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        VirtualFileManager.getInstance().addVirtualFileListener(this.h);
        this.e = this.g.getProject().getMessageBus().connect();
        this.e.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
            private static final long a = com.jetbrains.python.psi.c.a(-6194838240444131128L, 2929697779387199724L, MethodHandles.lookup().lookupClass()).a(19486245979010L);

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    3.a(0);
                }
                AssetsRegistrationWatcher.this.a();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x566A47223654L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/assetsPaths/AssetsRegistrationWatcher$3", "rootsChanged"));
            }
        });
        this.e.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){
            private static final long a = com.jetbrains.python.psi.c.a(-2299249205144171737L, 7111223679143756298L, MethodHandles.lookup().lookupClass()).a(163977205445643L);

            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    4.a(0);
                }
                if (facet instanceof BaseRailsFacet && AssetsRegistrationWatcher.this.g == facet.getModule()) {
                    AssetsRegistrationWatcher.this.a();
                }
            }

            public void facetRemoved(@NotNull Facet facet) {
                if (facet == null) {
                    4.a(1);
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x524B9F798F55L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/assetsPaths/AssetsRegistrationWatcher$4";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void a(PsiTreeChangeEvent psiTreeChangeEvent, @NotNull String string, @NotNull String string2) {
        PsiFile psiFile;
        if (string == null) {
            AssetsRegistrationWatcher.a(2);
        }
        if (string2 == null) {
            AssetsRegistrationWatcher.a(3);
        }
        if ((psiFile = psiTreeChangeEvent.getFile()) != null) {
            this.a(psiFile.getVirtualFile(), string, string2);
        }
    }

    private void a(@Nullable VirtualFile virtualFile, @NotNull String string, @NotNull String string2) {
        if (string == null) {
            AssetsRegistrationWatcher.a(4);
        }
        if (string2 == null) {
            AssetsRegistrationWatcher.a(5);
        }
        if (virtualFile == null) {
            return;
        }
        String string3 = virtualFile.getUrl();
        if (!virtualFile.isDirectory() && string.equals(string3)) {
            this.a();
            return;
        }
        if (string3.contains(string2)) {
            this.a();
            return;
        }
    }

    private void a() {
        this.d.queue((Update)new MyAssetsPathScan(this.g));
    }

    private static Runnable b(@NotNull Module module2, @Nullable RailsApp railsApp) {
        if (module2 == null) {
            AssetsRegistrationWatcher.a(6);
        }
        final Runnable runnable = () -> AssetsRegistrationWatcher.a(module2, railsApp);
        return () -> {
            Project project = module2.getProject();
            DumbService.getInstance((Project)project).runWhenSmart(() -> {
                long l2 = i ^ 0x444B95955F34L;
                ProjectQueues.getInstance(project).queue(RBundle.message("rails.assets.scan.paths"), new Task.Backgroundable(project, RBundle.message("rails.assets.scan.paths.for", module2.getName()), false){
                    private static final long a = com.jetbrains.python.psi.c.a(5810553509306851203L, 6304251724648292601L, MethodHandles.lookup().lookupClass()).a(253620858733773L);

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            5.a(0);
                        }
                        if (this.myProject == null || this.myProject.isDisposed()) {
                            return;
                        }
                        ApplicationManager.getApplication().runReadAction(runnable);
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x6B98751F72E9L;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/assetsPaths/AssetsRegistrationWatcher$5", "run"));
                    }
                });
            });
        };
    }

    private static void a(Module module2, RailsApp railsApp) {
        if (module2.isDisposed()) {
            return;
        }
        if (railsApp == null) {
            return;
        }
        if (!SprocketsUtil.railsWithAssetsSupport(module2)) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(2);
        AssetsRegistrationWatcher.a(module2, railsApp, arrayList);
        SprocketAssetsLoadPathManager.getInstance(railsApp).setUsedDefinedAssetsRootPaths(arrayList);
        ((AssetsListener)module2.getMessageBus().syncPublisher(ASSETS_CHANGED_TOPIC)).rootsChanged(module2);
    }

    private static void a(@NotNull Module module2, @NotNull RailsApp railsApp, @NotNull List<String> list2) {
        VirtualFile virtualFile2;
        if (module2 == null) {
            AssetsRegistrationWatcher.a(7);
        }
        if (railsApp == null) {
            AssetsRegistrationWatcher.a(8);
        }
        if (list2 == null) {
            AssetsRegistrationWatcher.a(9);
        }
        if (!SprocketsUtil.areAssetsEnabled(railsApp)) {
            return;
        }
        String string = railsApp.getInitializersRootUrl();
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        PsiManager psiManager = PsiManager.getInstance((Project)module2.getProject());
        VirtualFile virtualFile3 = railsApp.getApplicationFile();
        if (virtualFile3 != null) {
            AssetsRegistrationWatcher.a(virtualFile3, railsApp, psiManager, list2);
        }
        if ((virtualFile2 = virtualFileManager.findFileByUrl(string)) != null) {
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module2).getFileIndex();
            moduleFileIndex.iterateContentUnderDirectory(virtualFile2, virtualFile -> {
                if (!virtualFile.isDirectory()) {
                    AssetsRegistrationWatcher.a(virtualFile, railsApp, psiManager, list2);
                }
                return true;
            });
        }
    }

    private static void a(@NotNull VirtualFile virtualFile, @NotNull RailsApp railsApp, @NotNull PsiManager psiManager, final @NotNull List<String> list2) {
        VirtualFile virtualFile2;
        long l2 = i ^ 0xBB2554344B7L;
        if (virtualFile == null) {
            AssetsRegistrationWatcher.a(10);
        }
        if (railsApp == null) {
            AssetsRegistrationWatcher.a(11);
        }
        if (psiManager == null) {
            AssetsRegistrationWatcher.a(12);
        }
        if (list2 == null) {
            AssetsRegistrationWatcher.a(13);
        }
        if ((virtualFile2 = railsApp.getRailsApplicationRoot()) == null) {
            return;
        }
        PsiFile psiFile = psiManager.findFile(virtualFile);
        if (psiFile == null) {
            b.warn("Unable to find PsiFile for " + virtualFile.getPath());
            return;
        }
        RubyPsiInterpreter rubyPsiInterpreter = new RubyPsiInterpreter(true);
        PsiCallable psiCallable = new PsiCallable(){
            private static final long a = com.jetbrains.python.psi.c.a(6006128149024819852L, -4640958645128230609L, MethodHandles.lookup().lookupClass()).a(137679725125685L);

            @Override
            public void processCall(RCallArguments arguments) {
                String string;
                long l2 = a ^ 0x5417C9014997L;
                String string2 = arguments.getCommand();
                if (!AssetsRegistrationWatcher.f.equals(string2)) {
                    return;
                }
                PsiElement psiElement = arguments.getCallElement();
                RBinaryExpression rBinaryExpression = RShiftExpressionNavigator.getShiftExpressionByLeftPart(psiElement);
                if (rBinaryExpression == null) {
                    return;
                }
                String string3 = psiElement.getText();
                if (!string3.endsWith(AssetsRegistrationWatcher.c)) {
                    return;
                }
                RPsiElement rPsiElement = rBinaryExpression.getRightOperand();
                if (rPsiElement == null) {
                    return;
                }
                if (!(rPsiElement instanceof RStringLiteral)) {
                    b.warn("Asset loadpath registration: Unrecognized argument detected: " + rPsiElement.getText());
                    return;
                }
                List<RExpressionSubstitution> list22 = ((RStringLiteral)rPsiElement).getExpressionSubstitutions();
                int n2 = list22.size();
                if (n2 == 0) {
                    string = rPsiElement.getText();
                } else if (n2 == 1) {
                    String string4 = StringUtil.unquoteString((String)rPsiElement.getText());
                    if (!string4.contains(AssetsRegistrationWatcher.a)) {
                        b.warn("Asset loadpath registration: Unrecognized substitutions detected in string argument: " + string4);
                        return;
                    }
                    string = string4.replace(AssetsRegistrationWatcher.a, virtualFile2.getPath());
                } else {
                    b.warn("Asset loadpath registration: Unrecognized substitutions detected in string argument: " + rPsiElement.getText());
                    return;
                }
                if (string == null) {
                    return;
                }
                list2.add(string);
            }
        };
        rubyPsiInterpreter.interpret((PsiElement)psiFile, psiCallable);
    }

    static {
        i = com.jetbrains.python.psi.c.a(6409744222353871806L, -1007818809213769741L, MethodHandles.lookup().lookupClass()).a(204593107731275L);
        long l2 = i ^ 0x59BCF82E01E6L;
        ASSETS_CHANGED_TOPIC = Topic.create((String)"assets changed", AssetsListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);
        b = Logger.getInstance(AssetsRegistrationWatcher.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = i ^ 0x7759831E169EL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsApp";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationRbUrl";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializersRootUrl";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundPaths";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/assetsPaths/AssetsRegistrationWatcher";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "enableWatchers";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processPsiEvent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processFileEvent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createScanTask";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "scanForAssetsRegistration";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "lookupAssetsInFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface AssetsListener {
        public void rootsChanged(Module var1);
    }

    private static class MyAssetsPathScan
    extends Update {
        private final Module a;
        private static final long b = com.jetbrains.python.psi.c.a(619523279765653996L, 4050922249982024933L, MethodHandles.lookup().lookupClass()).a(24673127658416L);

        MyAssetsPathScan(@NotNull Module module2) {
            long l2 = b ^ 0x4854456C4B96L;
            if (module2 == null) {
                MyAssetsPathScan.a(0);
            }
            super((Object)"Rails assets paths scan");
            this.a = module2;
        }

        public void run() {
            if (this.a.isDisposed()) {
                return;
            }
            AssetsRegistrationWatcher.b(this.a, RailsApp.fromModule(this.a)).run();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x11A4576F2955L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/ruby/rails/codeInsight/sprockets/assetsPaths/AssetsRegistrationWatcher$MyAssetsPathScan", "<init>"));
        }
    }
}

