/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.jetbrains.python.psi.c;
import icons.RubyPsiApiIcons;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.actions.navigation.SwitchToView;
import org.jetbrains.plugins.ruby.rails.codeInsight.daemon.StaticTooltipProvider;
import org.jetbrains.plugins.ruby.rails.codeInsight.daemon.a;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.rails.model.RailsController;
import org.jetbrains.plugins.ruby.rails.model.RailsMailerMethod;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyLineMarkerProviderDescriptor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class RailsRubyLineMarkerProvider
extends RubyLineMarkerProviderDescriptor {
    private static final ViewNavigationHandler a;
    private static final long b;

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            RailsRubyLineMarkerProvider.a(0);
        }
        if (this.canHoldRubyLineMarker(element)) {
            RContainer rContainer = (RContainer)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{RMethod.class, RClass.class});
            if (rContainer instanceof RMethod) {
                return RailsRubyLineMarkerProvider.a((RMethod)rContainer, element);
            }
            if (rContainer instanceof RClass) {
                return RailsRubyLineMarkerProvider.a((RClass)rContainer, element);
            }
        }
        return null;
    }

    @Nullable
    private static LineMarkerInfo a(RClass rClass, PsiElement psiElement) {
        long l2 = b ^ 0x141799AE2E25L;
        RailsController railsController = RailsController.fromClass(rClass);
        if (railsController != null && railsController.getAllViewsAndPartials().size() > 0) {
            String string = RBundle.message("codeInsight.rails.controller_to_view.tooltip", rClass.getName());
            string = RailsRubyLineMarkerProvider.appendShortcut(string, "org.jetbrains.plugins.ruby.rails.actions.navigation.SwitchToView", "RailsNavigatePopupAction");
            return new LineMarkerInfo(psiElement, psiElement.getTextRange(), RubyPsiApiIcons.ActionToView, 11, (Function)new StaticTooltipProvider(string), (GutterIconNavigationHandler)a, GutterIconRenderer.Alignment.RIGHT);
        }
        return null;
    }

    @Nullable
    private static LineMarkerInfo a(RMethod rMethod, PsiElement psiElement) {
        long l2 = b ^ 0x8F937EE729EL;
        RailsAction railsAction = RailsAction.fromMethod(rMethod);
        if (railsAction != null && !railsAction.getController().isApplicationController()) {
            return RailsRubyLineMarkerProvider.a(psiElement, RBundle.message("codeInsight.rails.action_to_view.tooltip", rMethod.getName()));
        }
        RailsMailerMethod railsMailerMethod = RailsMailerMethod.fromMethod(rMethod);
        if (railsMailerMethod != null) {
            return RailsRubyLineMarkerProvider.a(psiElement, RBundle.message("codeInsight.rails.mailer_to_view.tooltip", rMethod.getName()));
        }
        return null;
    }

    private static LineMarkerInfo a(PsiElement psiElement, String string) {
        long l2 = b ^ 0x6549B3274056L;
        string = RailsRubyLineMarkerProvider.appendShortcut(string, "org.jetbrains.plugins.ruby.rails.actions.navigation.SwitchToView", "RailsNavigatePopupAction");
        return new LineMarkerInfo(psiElement, psiElement.getTextRange(), RubyPsiApiIcons.ActionToView, 11, (Function)new StaticTooltipProvider(string), (GutterIconNavigationHandler)a, GutterIconRenderer.Alignment.RIGHT);
    }

    public static String appendShortcut(String tooltip, String ... actionIds) {
        long l2 = b ^ 0x690519314AA5L;
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        for (String string : actionIds) {
            Shortcut[] shortcutArray = keymap.getShortcuts(string);
            if (shortcutArray.length <= 0) continue;
            tooltip = tooltip + " (" + KeymapUtil.getShortcutsText((Shortcut[])shortcutArray) + ")";
            break;
        }
        return tooltip;
    }

    @Nullable
    public String getName() {
        long l2 = b ^ 0x7ACACB1855F9L;
        return RBundle.message("rails.line.marker.gutter.action.to.view.title");
    }

    @Nullable
    public Icon getIcon() {
        return RubyPsiApiIcons.ActionToView;
    }

    static {
        b = c.a(-8194987817582962801L, 2815982529341042849L, MethodHandles.lookup().lookupClass()).a(242315052384483L);
        a = new ViewNavigationHandler(null);
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = b ^ 0x62900A511614L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/ruby/rails/codeInsight/daemon/RailsRubyLineMarkerProvider", "getLineMarkerInfo"));
    }

    private static class ViewNavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        private ViewNavigationHandler() {
        }

        public void navigate(MouseEvent e10, PsiElement elt) {
            SwitchToView.switchOrCreateView(elt, new RelativePoint(e10));
        }

        /* synthetic */ ViewNavigationHandler(a x0) {
            this();
        }
    }
}

