/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.associations;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.associations.AssociationsCallTypes;
import org.jetbrains.plugins.ruby.mongoid.MongoidCallTypeProvider;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.associations.AssociationType;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsCallTypeProvider;
import org.jetbrains.plugins.ruby.rails.codeInsight.symbols.v2.ModelSymbol;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiStructureElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyClassModuleNameIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class AssociationsUtil {
    private static final long a = c.a(3995571601489981802L, -5588276460145842130L, MethodHandles.lookup().lookupClass()).a(266256525803846L);

    private AssociationsUtil() {
    }

    @NotNull
    public static Set<RCall> findAssociationsWithAsDeclaration(@NotNull Module module2, @NotNull String foreignKey, @Nullable PsiElement invocationPoint) {
        if (module2 == null) {
            AssociationsUtil.a(0);
        }
        if (foreignKey == null) {
            AssociationsUtil.a(1);
        }
        HashSet<RCall> hashSet = new HashSet<RCall>();
        AssociationsUtil.a(module2, invocationPoint, (Processor<? super RCall>)((Processor)rCall -> {
            long l2 = a ^ 0x29AB3C580AA9L;
            if (foreignKey.equals(RubyInterpretUtil.evaluateOptionValue(rCall, "as"))) {
                hashSet.add((RCall)rCall);
            }
            return true;
        }));
        HashSet<RCall> hashSet2 = hashSet;
        if (hashSet2 == null) {
            AssociationsUtil.a(2);
        }
        return hashSet2;
    }

    @NotNull
    public static Set<RCall> findAssociationsWithPolymorphicDeclaration(@NotNull Module module2, @NotNull String name, @Nullable PsiElement invocationPoint) {
        if (module2 == null) {
            AssociationsUtil.a(3);
        }
        if (name == null) {
            AssociationsUtil.a(4);
        }
        HashSet<RCall> hashSet = new HashSet<RCall>();
        AssociationsUtil.a(module2, invocationPoint, (Processor<? super RCall>)((Processor)rCall -> {
            if (AssociationsUtil.isPolymorphicAssociation(rCall) && name.equals(AssociationsUtil.getAssociationName(rCall))) {
                hashSet.add((RCall)rCall);
            }
            return true;
        }));
        HashSet<RCall> hashSet2 = hashSet;
        if (hashSet2 == null) {
            AssociationsUtil.a(5);
        }
        return hashSet2;
    }

    @NotNull
    public static List<RCall> getAssociations(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            AssociationsUtil.a(6);
        }
        List<RCall> list2 = symbol.getAllDeclarations(invocationPoint).stream().flatMap(psiElement -> AssociationsUtil.getAssociations(psiElement).stream()).collect(Collectors.toList());
        if (list2 == null) {
            AssociationsUtil.a(7);
        }
        return list2;
    }

    @NotNull
    public static List<RCall> getAssociations(@NotNull PsiElement model) {
        if (model == null) {
            AssociationsUtil.a(8);
        }
        if (!(model instanceof RClass)) {
            List<RCall> list2 = Collections.emptyList();
            if (list2 == null) {
                AssociationsUtil.a(9);
            }
            return list2;
        }
        RClass rClass = (RClass)model;
        ArrayList<RCall> arrayList = new ArrayList<RCall>();
        for (RPsiStructureElement rPsiStructureElement : rClass.getStructureElements()) {
            if (!AssociationsUtil.isAssociationCall((PsiElement)rPsiStructureElement) || AssociationsUtil.getAssociationName((RCall)rPsiStructureElement) == null) continue;
            arrayList.add((RCall)rPsiStructureElement);
        }
        ArrayList<RCall> arrayList2 = arrayList;
        if (arrayList2 == null) {
            AssociationsUtil.a(10);
        }
        return arrayList2;
    }

    @Nullable
    public static RCall resolveToAssociationCall(@NotNull RClass modelClass, @NotNull String name) {
        if (modelClass == null) {
            AssociationsUtil.a(11);
        }
        if (name == null) {
            AssociationsUtil.a(12);
        }
        return AssociationsUtil.getAssociations((PsiElement)modelClass).stream().filter(rCall -> name.equals(AssociationsUtil.getAssociationName(rCall))).findFirst().orElse(null);
    }

    @Nullable
    public static PsiElement resolveToAssociationName(@NotNull RClass modelClass, @NotNull String name) {
        if (modelClass == null) {
            AssociationsUtil.a(13);
        }
        if (name == null) {
            AssociationsUtil.a(14);
        }
        RCall rCall = AssociationsUtil.resolveToAssociationCall(modelClass, name);
        return (PsiElement)ObjectUtils.doIfNotNull((Object)rCall, AssociationsUtil::getAssociationNameElement);
    }

    @NotNull
    public static List<String> getAssociationsNames(@NotNull RClass modelClass) {
        if (modelClass == null) {
            AssociationsUtil.a(15);
        }
        ArrayList arrayList = new ArrayList(2);
        for (RCall rCall : AssociationsUtil.getAssociations((PsiElement)modelClass)) {
            String string = AssociationsUtil.getAssociationName(rCall);
            if (StringUtil.isEmpty((String)string)) continue;
            arrayList.add(string);
        }
        List<String> list2 = arrayList.isEmpty() ? Collections.emptyList() : arrayList;
        if (list2 == null) {
            AssociationsUtil.a(16);
        }
        return list2;
    }

    @Nullable
    public static RClass resolveToModel(@NotNull RCall association) {
        if (association == null) {
            AssociationsUtil.a(17);
        }
        return (RClass)ContainerUtil.getFirstItem(AssociationsUtil.resolveToModels(association));
    }

    @NotNull
    public static Set<RClass> resolveToModels(@NotNull RCall association) {
        Module module2;
        if (association == null) {
            AssociationsUtil.a(18);
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)association)) == null || !InflectorService.getInstance(module2).isInflectorAvailable()) {
            Set<RClass> set = Collections.emptySet();
            if (set == null) {
                AssociationsUtil.a(19);
            }
            return set;
        }
        Set<RClass> set = AssociationsUtil.a(module2, association, new HashSet<RCall>());
        if (set == null) {
            AssociationsUtil.a(20);
        }
        return set;
    }

    @NotNull
    private static Set<RClass> a(@NotNull Module module2, @NotNull RCall rCall, @NotNull Set<RCall> set) {
        FQN fQN;
        long l2 = a ^ 0x36215952B87AL;
        if (module2 == null) {
            AssociationsUtil.a(21);
        }
        if (rCall == null) {
            AssociationsUtil.a(22);
        }
        if (set == null) {
            AssociationsUtil.a(23);
        }
        if (!set.add(rCall)) {
            Set<RClass> set2 = Collections.emptySet();
            if (set2 == null) {
                AssociationsUtil.a(24);
            }
            return set2;
        }
        String string = AssociationsUtil.getAssociationName(rCall);
        AssociationType associationType = AssociationsUtil.getAssociationType(rCall);
        if (string == null) {
            Set<RClass> set3 = Collections.emptySet();
            if (set3 == null) {
                AssociationsUtil.a(25);
            }
            return set3;
        }
        String string2 = RubyInterpretUtil.evaluateOptionValue(rCall, "through");
        FQN fQN2 = FQN.ofNullable(RubyInterpretUtil.evaluateOptionValue(rCall, "class_name"));
        if (string2 != null) {
            if (associationType.allowsThrough()) {
                String string3 = RubyInterpretUtil.evaluateOptionValue(rCall, "source");
                FQN fQN3 = FQN.ofNullable(RubyInterpretUtil.evaluateOptionValue(rCall, "source_type"));
                Set<RClass> set4 = AssociationsUtil.a(module2, rCall, string2, (String)ObjectUtils.coalesce((Object)string3, (Object)string), fQN3 != FQN.INVALID ? fQN3 : fQN2, set);
                if (set4 == null) {
                    AssociationsUtil.a(26);
                }
                return set4;
            }
            Set<RClass> set5 = Collections.emptySet();
            if (set5 == null) {
                AssociationsUtil.a(27);
            }
            return set5;
        }
        if (associationType == AssociationType.BELONGS_TO && AssociationsUtil.isPolymorphicAssociation(rCall)) {
            Set set6 = ContainerUtil.map2Set(AssociationsUtil.findAssociationsWithAsDeclaration(module2, string, (PsiElement)rCall), RubyPsiUtil::getContainingRClass);
            if (set6 == null) {
                AssociationsUtil.a(28);
            }
            return set6;
        }
        if (fQN2 != FQN.INVALID) {
            Set set7 = ContainerUtil.createMaybeSingletonSet((Object)AssociationsUtil.findModel(fQN2, module2));
            if (set7 == null) {
                AssociationsUtil.a(29);
            }
            return set7;
        }
        FQN fQN4 = fQN = AssociationsUtil.isSingularAssociation(rCall) ? FQN.of(NamingConventions.toCamelCase(string)) : AssociationsUtil.classify(module2, string);
        if (fQN != FQN.INVALID) {
            Set set8 = ContainerUtil.createMaybeSingletonSet((Object)AssociationsUtil.findModel(fQN, module2));
            if (set8 == null) {
                AssociationsUtil.a(30);
            }
            return set8;
        }
        Set<RClass> set9 = Collections.emptySet();
        if (set9 == null) {
            AssociationsUtil.a(31);
        }
        return set9;
    }

    @Nullable
    public static String singularize(@NotNull Module module2, @NotNull String name) {
        InflectorService inflectorService;
        if (module2 == null) {
            AssociationsUtil.a(32);
        }
        if (name == null) {
            AssociationsUtil.a(33);
        }
        return (inflectorService = InflectorService.getInstance(module2)).isInflectorAvailable() ? inflectorService.singularize(name) : null;
    }

    @NotNull
    public static FQN classify(@NotNull Module module2, @NotNull String name) {
        InflectorService inflectorService;
        if (module2 == null) {
            AssociationsUtil.a(34);
        }
        if (name == null) {
            AssociationsUtil.a(35);
        }
        if (!(inflectorService = InflectorService.getInstance(module2)).isInflectorAvailable()) {
            FQN fQN = FQN.INVALID;
            if (fQN == null) {
                AssociationsUtil.a(36);
            }
            return fQN;
        }
        FQN fQN = FQN.ofNullable(inflectorService.classify(name));
        if (fQN == null) {
            AssociationsUtil.a(37);
        }
        return fQN;
    }

    @NotNull
    private static Set<RClass> a(@NotNull Module module2, @NotNull RCall rCall, @NotNull String string, @NotNull String string2, @NotNull FQN fQN, @NotNull Set<RCall> set) {
        if (module2 == null) {
            AssociationsUtil.a(38);
        }
        if (rCall == null) {
            AssociationsUtil.a(39);
        }
        if (string == null) {
            AssociationsUtil.a(40);
        }
        if (string2 == null) {
            AssociationsUtil.a(41);
        }
        if (fQN == null) {
            AssociationsUtil.a(42);
        }
        if (set == null) {
            AssociationsUtil.a(43);
        }
        Set<RClass> set2 = AssociationsUtil.findThroughModels(module2, rCall, string, set).stream().flatMap(rClass -> AssociationsUtil.a(module2, rCall, rClass, string2, fQN, set).stream()).collect(Collectors.toSet());
        if (set2 == null) {
            AssociationsUtil.a(44);
        }
        return set2;
    }

    @NotNull
    public static Set<RClass> findThroughModels(@NotNull Module module2, @NotNull RCall resolvee, @NotNull String through, @NotNull Set<RCall> visited) {
        RClass rClass;
        if (module2 == null) {
            AssociationsUtil.a(45);
        }
        if (resolvee == null) {
            AssociationsUtil.a(46);
        }
        if (through == null) {
            AssociationsUtil.a(47);
        }
        if (visited == null) {
            AssociationsUtil.a(48);
        }
        if ((rClass = RubyPsiUtil.getContainingRClass((PsiElement)resolvee)) != null) {
            Set<RClass> set = AssociationsUtil.a(module2, resolvee, rClass, through, FQN.INVALID, visited);
            if (set == null) {
                AssociationsUtil.a(49);
            }
            return set;
        }
        Set<RClass> set = Collections.emptySet();
        if (set == null) {
            AssociationsUtil.a(50);
        }
        return set;
    }

    @Nullable
    public static RClass findModel(@NotNull FQN modelFqn, @NotNull Module module2) {
        RailsApp railsApp;
        VirtualFile virtualFile;
        if (modelFqn == null) {
            AssociationsUtil.a(51);
        }
        if (module2 == null) {
            AssociationsUtil.a(52);
        }
        VirtualFile virtualFile2 = virtualFile = (railsApp = RailsApp.fromModule(module2)) != null ? railsApp.getModelsRoot() : null;
        if (virtualFile == null) {
            return null;
        }
        boolean bl2 = modelFqn.getCallerFQN() != FQN.INVALID;
        Project project = module2.getProject();
        return (RClass)RubyClassModuleNameIndex.findOne(project, modelFqn.getShortName(), GlobalSearchScope.allScope((Project)project), rContainer -> {
            VirtualFile virtualFile2 = rContainer.getContainingFile().getVirtualFile();
            if (rContainer instanceof RClass && virtualFile2 != null && VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (boolean)true)) {
                Symbol symbol;
                RClass rClass = (RClass)rContainer;
                return !bl2 || (symbol = SymbolUtil.getSymbolByContainer(rClass)) != null && symbol.getFQNWithNesting().equals(modelFqn);
            }
            return false;
        });
    }

    @NotNull
    private static Set<RClass> a(@NotNull Module module2, @NotNull RCall rCall, @NotNull RClass rClass2, @NotNull String string, @NotNull FQN fQN, @NotNull Set<RCall> set) {
        if (module2 == null) {
            AssociationsUtil.a(53);
        }
        if (rCall == null) {
            AssociationsUtil.a(54);
        }
        if (rClass2 == null) {
            AssociationsUtil.a(55);
        }
        if (string == null) {
            AssociationsUtil.a(56);
        }
        if (fQN == null) {
            AssociationsUtil.a(57);
        }
        if (set == null) {
            AssociationsUtil.a(58);
        }
        for (RCall rCall2 : AssociationsUtil.getAssociations((PsiElement)rClass2)) {
            if (!AssociationsUtil.isMatchingAssociationCall(module2, rCall, string, rCall2)) continue;
            Set<RClass> set2 = AssociationsUtil.a(module2, rCall2, set).stream().filter(rClass -> fQN == FQN.INVALID || fQN.equals(rClass.getFQNWithNesting())).collect(Collectors.toSet());
            if (set2 == null) {
                AssociationsUtil.a(59);
            }
            return set2;
        }
        Set<RClass> set3 = Collections.emptySet();
        if (set3 == null) {
            AssociationsUtil.a(60);
        }
        return set3;
    }

    public static boolean isMatchingAssociationCall(@NotNull Module module2, @NotNull RCall resolvee, @NotNull String source, @NotNull RCall candidate) {
        if (module2 == null) {
            AssociationsUtil.a(61);
        }
        if (resolvee == null) {
            AssociationsUtil.a(62);
        }
        if (source == null) {
            AssociationsUtil.a(63);
        }
        if (candidate == null) {
            AssociationsUtil.a(64);
        }
        RubyCallType<?> rubyCallType = resolvee.getCallType();
        RubyCallType<?> rubyCallType2 = candidate.getCallType();
        if (rubyCallType2 != rubyCallType && rubyCallType2 != RailsCallTypeProvider.BELONGS_TO_CALL) {
            return false;
        }
        boolean bl2 = Comparing.strEqual((String)source, (String)AssociationsUtil.getAssociationName(candidate));
        return bl2 |= rubyCallType == RailsCallTypeProvider.HAS_MANY_CALL && Comparing.strEqual((String)AssociationsUtil.singularize(module2, source), (String)AssociationsUtil.getAssociationName(candidate));
    }

    public static boolean isSingularAssociation(@NotNull RCall association) {
        if (association == null) {
            AssociationsUtil.a(65);
        }
        return AssociationsUtil.isSingularAssociation(AssociationsUtil.getAssociationType(association));
    }

    public static boolean isSingularAssociation(@NotNull AssociationType associationType) {
        if (associationType == null) {
            AssociationsUtil.a(66);
        }
        return AssociationsCallTypes.SINGULAR_ASSOCIATIONS.contains((Object)associationType);
    }

    public static boolean isPolymorphicAssociation(@NotNull RCall association) {
        long l2 = a ^ 0x7EAB0EADE78EL;
        if (association == null) {
            AssociationsUtil.a(67);
        }
        return "true".equals(RubyInterpretUtil.evaluateOptionValue(association, "polymorphic"));
    }

    @NotNull
    public static AssociationType getAssociationType(@NotNull RCall call) {
        RubyCallType<?> rubyCallType;
        if (call == null) {
            AssociationsUtil.a(68);
        }
        if ((rubyCallType = call.getCallType()) == RailsCallTypeProvider.HAS_ONE_CALL) {
            AssociationType associationType = AssociationType.HAS_ONE;
            if (associationType == null) {
                AssociationsUtil.a(69);
            }
            return associationType;
        }
        if (rubyCallType == RailsCallTypeProvider.BELONGS_TO_CALL) {
            AssociationType associationType = AssociationType.BELONGS_TO;
            if (associationType == null) {
                AssociationsUtil.a(70);
            }
            return associationType;
        }
        if (rubyCallType == RailsCallTypeProvider.HAS_AND_BELONGS_TO_MANY_CALL) {
            AssociationType associationType = AssociationType.HAS_AND_BELONGS_TO_MANY;
            if (associationType == null) {
                AssociationsUtil.a(71);
            }
            return associationType;
        }
        if (rubyCallType == RailsCallTypeProvider.HAS_MANY_CALL) {
            AssociationType associationType = AssociationType.HAS_MANY;
            if (associationType == null) {
                AssociationsUtil.a(72);
            }
            return associationType;
        }
        if (rubyCallType == MongoidCallTypeProvider.EMBEDS_MANY) {
            AssociationType associationType = AssociationType.EMBEDS_MANY;
            if (associationType == null) {
                AssociationsUtil.a(73);
            }
            return associationType;
        }
        if (rubyCallType == MongoidCallTypeProvider.EMBEDS_ONE) {
            AssociationType associationType = AssociationType.EMBEDS_ONE;
            if (associationType == null) {
                AssociationsUtil.a(74);
            }
            return associationType;
        }
        if (rubyCallType == MongoidCallTypeProvider.EMBEDDED_IN) {
            AssociationType associationType = AssociationType.EMBEDDED_IN;
            if (associationType == null) {
                AssociationsUtil.a(75);
            }
            return associationType;
        }
        AssociationType associationType = AssociationType.UNDEFINED;
        if (associationType == null) {
            AssociationsUtil.a(76);
        }
        return associationType;
    }

    @Nullable
    public static String getAssociationName(@NotNull RCall association) {
        if (association == null) {
            AssociationsUtil.a(77);
        }
        if (!AssociationsUtil.isAssociationCall((PsiElement)association)) {
            return null;
        }
        return (String)ContainerUtil.getFirstItem((List)((List)association.getData(new RubyCallType[0])));
    }

    @Nullable
    public static RPsiElement getAssociationNameElement(@NotNull RCall association) {
        if (association == null) {
            AssociationsUtil.a(78);
        }
        if (!AssociationsUtil.isAssociationCall((PsiElement)association)) {
            return null;
        }
        return association.getCallArguments().getFirstElement();
    }

    public static boolean isAssociationCall(@Nullable PsiElement element) {
        return element instanceof RCall && AssociationsCallTypes.TYPES.contains(((RCall)element).getCallType());
    }

    private static void a(@NotNull Module module2, @Nullable PsiElement psiElement, @NotNull Processor<? super RCall> processor2) {
        if (module2 == null) {
            AssociationsUtil.a(79);
        }
        if (processor2 == null) {
            AssociationsUtil.a(80);
        }
        ObjectUtils.doIfNotNull((Object)RailsApp.fromModule(module2), railsApp -> railsApp.processModels((Processor<RailsModel>)((Processor)railsModel -> {
            Symbol symbol = ModelSymbol.createModelSymbol(railsModel.getRClass());
            if (symbol == null) {
                return true;
            }
            for (RCall rCall : AssociationsUtil.getAssociations(symbol, psiElement)) {
                if (processor2.process((Object)rCall)) continue;
                return false;
            }
            return true;
        })));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x2439911CB97DL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 44: 
            case 49: 
            case 50: 
            case 59: 
            case 60: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 44: 
            case 49: 
            case 50: 
            case 59: 
            case 60: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreignKey";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 44: 
            case 49: 
            case 50: 
            case 59: 
            case 60: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/associations/AssociationsUtil";
                break;
            }
            case 4: 
            case 12: 
            case 14: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelClass";
                break;
            }
            case 17: 
            case 18: 
            case 22: 
            case 65: 
            case 67: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "association";
                break;
            }
            case 23: 
            case 43: 
            case 48: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 39: 
            case 46: 
            case 54: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvee";
                break;
            }
            case 40: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "through";
                break;
            }
            case 41: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 42: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelFqn";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "associationName";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "associationType";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/associations/AssociationsUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findAssociationsWithAsDeclaration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findAssociationsWithPolymorphicDeclaration";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociations";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociationsNames";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToModels";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToModelsImpl";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveThrough";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "findThroughModels";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "findAndResolve";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociationType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAssociationsWithAsDeclaration";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 44: 
            case 49: 
            case 50: 
            case 59: 
            case 60: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findAssociationsWithPolymorphicDeclaration";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAssociations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveToAssociationCall";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveToAssociationName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAssociationsNames";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveToModel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveToModels";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveToModelsImpl";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "singularize";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "resolveThrough";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findThroughModels";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findModel";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findAndResolve";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingAssociationCall";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isSingularAssociation";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isPolymorphicAssociation";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getAssociationType";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getAssociationName";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getAssociationNameElement";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "processAllAssociations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 44: 
            case 49: 
            case 50: 
            case 59: 
            case 60: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

