/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.generators;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.python.psi.c;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsExternalizer;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.GeneratorsActionGroup;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.SimpleGeneratorAction;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.testing.actions.RubyTestFinder;
import org.jetbrains.plugins.ruby.utils.ActionUtil;

public class GeneratorsModuleCache {
    private static final Logger h;
    private static boolean c;
    private final Module e;
    private String[] d;
    private boolean i = false;
    private boolean f;
    private final List<SimpleGeneratorAction> g = new ArrayList<SimpleGeneratorAction>();
    private final Collection<GeneratorListener> a = ContainerUtil.createConcurrentList();
    private final Collection<Runnable> b = ContainerUtil.createConcurrentList();
    private static final long j;

    public static GeneratorsModuleCache getInstance(@NotNull Module module2) {
        if (module2 == null) {
            GeneratorsModuleCache.a(0);
        }
        return (GeneratorsModuleCache)module2.getComponent(GeneratorsModuleCache.class);
    }

    public GeneratorsModuleCache(final Module module2) {
        MessageBusConnection messageBusConnection = module2.getMessageBus().connect((Disposable)module2);
        messageBusConnection.subscribe(GemManager.MODULE_GEMS_CHANGED_TOPIC, (Object)new GemManager.ModuleGemsListener(){

            @Override
            public void gemsChanged() {
                GeneratorsModuleCache.this.reloadGenerators(true, RModuleUtil.getInstance().findRubySdkForModule(module2), true);
            }
        });
        this.e = module2;
        String string = RailsFacetUtil.getRailsAppHomeDirPath(module2);
        if (string != null) {
            GeneratorsExternalizer generatorsExternalizer = new GeneratorsExternalizer();
            String[] stringArray = generatorsExternalizer.loadGeneratorList(string);
            this.setGenerators(stringArray);
        }
    }

    public void addGeneratorListener(@NotNull GeneratorListener generatorListener) {
        if (generatorListener == null) {
            GeneratorsModuleCache.a(1);
        }
        this.a.add(generatorListener);
    }

    public void removeGeneratorListener(@NotNull GeneratorListener generatorListener) {
        if (generatorListener == null) {
            GeneratorsModuleCache.a(2);
        }
        this.a.remove(generatorListener);
    }

    private static AnAction a(@NotNull String string) {
        if (string == null) {
            GeneratorsModuleCache.a(3);
        }
        return ActionUtil.registerActionIfNecessary(GeneratorsModuleCache.getActionId(string), () -> GeneratorsActionGroup.createGeneratorAction(string));
    }

    public boolean isLoadingGenerators() {
        return this.f;
    }

    public void setGenerators(@Nullable String[] generators) {
        long l2 = j ^ 0x134E3B7EED49L;
        this.d = generators;
        if (generators != null) {
            this.i = true;
            for (String string : generators) {
                AnAction anAction = GeneratorsModuleCache.a(string);
                assert (anAction instanceof SimpleGeneratorAction) : "Got inappropriate action for " + string + ": " + anAction;
                this.g.add((SimpleGeneratorAction)anAction);
            }
            for (GeneratorListener generatorListener : this.a) {
                generatorListener.onGeneratorsLoaded();
            }
        }
        this.f = false;
    }

    public String[] getGenerators() {
        if (!this.i) {
            this.reloadGenerators(true, RModuleUtil.getInstance().findRubySdkForModule(this.e), false);
        }
        return this.d;
    }

    public void reloadGenerators(boolean forceRegenerate, Sdk sdk, boolean isSilently) {
        if (!c && ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (!this.f) {
            this.f = true;
            this.g.clear();
            GeneratorsUtil.loadGeneratorsList(forceRegenerate, this.e, sdk, this, isSilently);
        }
    }

    public Collection<SimpleGeneratorAction> getGeneratorActions() {
        return this.g;
    }

    @NonNls
    public static String getActionId(String generator) {
        long l2 = j ^ 0x4C7F07A90C8BL;
        return "rails:generator:" + generator;
    }

    public static boolean appendGemToGemfile(@NotNull Module module2, @NotNull String gemName) {
        VirtualFile virtualFile;
        long l2 = j ^ 0x7F268ED025B2L;
        if (module2 == null) {
            GeneratorsModuleCache.a(4);
        }
        if (gemName == null) {
            GeneratorsModuleCache.a(5);
        }
        if ((virtualFile = BundlerUtil.getGemfile(module2)) == null) {
            return false;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder(VfsUtilCore.loadText((VirtualFile)virtualFile));
            String string = stringBuilder.toString();
            stringBuilder.append("\n\ngem '").append(gemName).append('\'');
            return (Boolean)ApplicationManager.getApplication().runWriteAction(() -> {
                VfsUtil.saveText((VirtualFile)virtualFile, (String)stringBuilder.toString());
                GeneratorsModuleCache.getInstance(module2).registerGeneratorUndoAction(() -> {
                    long l2 = j ^ 0x4709BE90B015L;
                    try {
                        VfsUtil.saveText((VirtualFile)virtualFile, (String)string);
                    }
                    catch (IOException iOException) {
                        h.error("Cannot rollback Gemfile; " + iOException.getMessage());
                    }
                });
                return true;
            });
        }
        catch (IOException iOException) {
            h.warn("Cannot update Gemfile; " + iOException.getMessage());
            return false;
        }
    }

    public void registerGeneratorUndoAction(@NotNull Runnable undoAction) {
        if (undoAction == null) {
            GeneratorsModuleCache.a(6);
        }
        this.b.add(undoAction);
    }

    private void a() {
        this.b.clear();
    }

    @NotNull
    public Notification createGeneratorNotFoundNotification(@NotNull String generatorName) {
        long l2 = j ^ 0x31678374D52DL;
        if (generatorName == null) {
            GeneratorsModuleCache.a(7);
        }
        Notification notification2 = new Notification(RubyTestFinder.NOTIFICATION_GROUP.getDisplayId(), RBundle.message("generator.notification.not.found.title"), RBundle.message("generator.notification.not.found.content", generatorName), NotificationType.WARNING, (NotificationListener)new TestGeneratorNotFoundListener()).whenExpired(() -> this.a());
        if (notification2 == null) {
            GeneratorsModuleCache.a(8);
        }
        return notification2;
    }

    public Notification createGeneratorRollbackNotification(@NotNull String generatorName) {
        long l2 = j ^ 0x3A3BBEAB3311L;
        if (generatorName == null) {
            GeneratorsModuleCache.a(9);
        }
        return new Notification(RubyTestFinder.NOTIFICATION_GROUP.getDisplayId(), RBundle.message("generator.notification.after.title"), RBundle.message("generator.notification.after.content", generatorName), NotificationType.INFORMATION, (NotificationListener)new PostGeneratorListener()).whenExpired(() -> this.a());
    }

    private void b() {
        WriteCommandAction.runWriteCommandAction((Project)this.e.getProject(), () -> {
            if (this.e.isDisposed()) {
                return;
            }
            for (Runnable runnable : this.b) {
                runnable.run();
            }
            this.b.clear();
        });
    }

    public static void runWithUpdateInTestMode(@NotNull Runnable runnable) {
        if (runnable == null) {
            GeneratorsModuleCache.a(10);
        }
        boolean bl2 = c;
        c = true;
        try {
            runnable.run();
        }
        finally {
            c = bl2;
        }
    }

    static {
        j = com.jetbrains.python.psi.c.a(-8414005433866170610L, -2892610371854502840L, MethodHandles.lookup().lookupClass()).a(45338015327342L);
        h = Logger.getInstance(GeneratorsModuleCache.class);
        c = false;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = j ^ 0x3756D64CD99FL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatorListener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoAction";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatorName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsModuleCache";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsModuleCache";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createGeneratorNotFoundNotification";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addGeneratorListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeGeneratorListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerGeneratorIfNecessary";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendGemToGemfile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerGeneratorUndoAction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createGeneratorNotFoundNotification";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createGeneratorRollbackNotification";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runWithUpdateInTestMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PostGeneratorListener
    extends NotificationListener.Adapter {
        private static final long a = com.jetbrains.python.psi.c.a(8656737899620351753L, 1999894106993379084L, MethodHandles.lookup().lookupClass()).a(7484272347713L);

        private PostGeneratorListener() {
        }

        protected void hyperlinkActivated(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
            long l2 = a ^ 0x2183B55A6A9DL;
            if (notification2 == null) {
                PostGeneratorListener.a(0);
            }
            if (event == null) {
                PostGeneratorListener.a(1);
            }
            if ("got_it".equals(event.getDescription())) {
                return;
            }
            if ("rollback".equals(event.getDescription())) {
                GeneratorsModuleCache.this.b();
            }
            notification2.expire();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x5337559D2326L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsModuleCache$PostGeneratorListener";
            objectArray[2] = "hyperlinkActivated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class TestGeneratorNotFoundListener
    extends NotificationListener.Adapter {
        private static final long a = com.jetbrains.python.psi.c.a(7211907497879917923L, -526564281179806722L, MethodHandles.lookup().lookupClass()).a(7744261030072L);

        private TestGeneratorNotFoundListener() {
        }

        protected void hyperlinkActivated(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
            long l2 = a ^ 0x4AFE1804D19BL;
            if (notification2 == null) {
                TestGeneratorNotFoundListener.a(0);
            }
            if (event == null) {
                TestGeneratorNotFoundListener.a(1);
            }
            if ("rollback".equals(event.getDescription())) {
                GeneratorsModuleCache.this.b();
            }
            notification2.expire();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x7FF98AA490F4L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsModuleCache$TestGeneratorNotFoundListener";
            objectArray[2] = "hyperlinkActivated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface GeneratorListener {
        public void onGeneratorsLoaded();
    }
}

