/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.jruby.warbler.helpers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.jruby.warbler.WarblerConstants;
import org.jetbrains.plugins.ruby.jruby.warbler.helpers.a;
import org.jetbrains.plugins.ruby.jruby.warbler.model.config.WarblerConfigModel;
import org.jetbrains.plugins.ruby.jruby.warbler.settings.WarblerSettings;
import org.jetbrains.plugins.ruby.jruby.warbler.utils.WarblerPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.words.RAbstractWords;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;

public class WarblerConfigHelper {
    private static final Logger a;
    private static final String d = "config.features = %%w(%s)";
    private static final String b = "config.dirs = %%w(%s)";
    private static final String e = "config.includes = FileList[%s]";
    private static final String f = "config.excludes = FileList[%s])";
    private static final String c = "config.webinf_files = FileList[%s]";
    private static final String i = "#Warbler output file name\nconfig.jar_name = \"%s\"";
    private static final String h = "assignmentsContainer";
    private static final String g = "Warbler::Config.new do |config|\n  config.features = %%w()\n\n  config.dirs = %%w()\n\n  config.includes = FileList[]\n  config.excludes = FileList[]\n\n  config.webinf_files += FileList[]\n\n  config.jar_name = \"%s\"\nend";
    private static final long j;

    private WarblerConfigHelper() {
    }

    @NotNull
    public static WarblerConfigModel readConfig(@NotNull Module module2) {
        WarblerConfigModel warblerConfigModel;
        RFile rFile;
        if (module2 == null) {
            WarblerConfigHelper.a(0);
        }
        if ((rFile = WarblerConfigHelper.c(module2)) != null) {
            warblerConfigModel = new WarblerConfigModel();
            WarblerConfigHelper.a(module2, warblerConfigModel, rFile);
        } else {
            warblerConfigModel = WarblerConfigHelper.getDefaultModel(module2);
        }
        if (warblerConfigModel.getFileName() == null) {
            warblerConfigModel.setFileName(module2.getName());
        }
        warblerConfigModel.setTrace(WarblerSettings.getInstance((Module)module2).myWarblerTraceMode);
        WarblerConfigModel warblerConfigModel2 = warblerConfigModel;
        if (warblerConfigModel2 == null) {
            WarblerConfigHelper.a(1);
        }
        return warblerConfigModel2;
    }

    public static void saveConfig(@NotNull Module module2, @NotNull WarblerConfigModel model) throws IOException {
        long l2 = j ^ 0x5823B203224EL;
        if (module2 == null) {
            WarblerConfigHelper.a(2);
        }
        if (model == null) {
            WarblerConfigHelper.a(3);
        }
        HashMap hashMap = new HashMap();
        RFile rFile = WarblerConfigHelper.b(module2);
        ApplicationManager.getApplication().runReadAction(() -> {
            Map<String, PsiElement> map3 = WarblerConfigHelper.a((PsiElement)rFile);
            hashMap.putAll(map3);
        });
        if (hashMap.get(h) == null) {
            throw new IOException(RBundle.message("warbler.error.cant.write.to.config"));
        }
        Map<String, PsiElement> map2 = WarblerConfigHelper.a(module2, model, (PsiElement)rFile);
        WriteCommandAction.writeCommandAction((Project)module2.getProject(), (PsiFile[])new PsiFile[]{rFile}).run(() -> {
            long l2 = j ^ 0x706552A1A25CL;
            for (Map.Entry entry : map2.entrySet()) {
                RAssignmentExpression rAssignmentExpression = (RAssignmentExpression)hashMap.get(entry.getKey());
                if (rAssignmentExpression != null) {
                    PsiElement psiElement = (PsiElement)entry.getValue();
                    rAssignmentExpression.replace(psiElement);
                    continue;
                }
                ((PsiElement)hashMap.get(h)).add((PsiElement)entry.getValue());
            }
        });
    }

    @NotNull
    private static RFile b(@NotNull Module module2) throws IOException {
        long l2 = j ^ 0x3C36990F65DFL;
        if (module2 == null) {
            WarblerConfigHelper.a(4);
        }
        RFile rFile = WarblerConfigHelper.c(module2);
        HashMap hashMap = new HashMap();
        if (rFile == null) {
            rFile = WarblerConfigHelper.d(module2);
        } else {
            RFile rFile2 = rFile;
            ApplicationManager.getApplication().runReadAction(() -> WarblerConfigHelper.a((PsiElement)rFile2, hashMap));
            if (hashMap.get(h) == null) {
                rFile = WarblerConfigHelper.d(module2);
            }
        }
        RFile rFile3 = rFile;
        if (rFile3 == null) {
            WarblerConfigHelper.a(5);
        }
        return rFile3;
    }

    @NotNull
    public static WarblerConfigModel getDefaultModel(@NotNull Module module2) {
        String[] stringArray;
        if (module2 == null) {
            WarblerConfigHelper.a(6);
        }
        WarblerConfigModel warblerConfigModel = new WarblerConfigModel();
        VirtualFile virtualFile = WarblerConfigHelper.getModuleDir(module2);
        warblerConfigModel.setFileName(module2.getName());
        for (String string : stringArray = WarblerConstants.DEFAULT_DIRS) {
            VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(string);
            if (virtualFile2 == null) continue;
            warblerConfigModel.getIncludeModel().addFile(virtualFile2);
        }
        WarblerConfigModel warblerConfigModel2 = warblerConfigModel;
        if (warblerConfigModel2 == null) {
            WarblerConfigHelper.a(7);
        }
        return warblerConfigModel2;
    }

    private static void a(@NotNull Module module2, @NotNull WarblerConfigModel warblerConfigModel, @NotNull String string, @NotNull String[] stringArray) {
        long l2 = j ^ 0x76DC668F5624L;
        if (module2 == null) {
            WarblerConfigHelper.a(8);
        }
        if (warblerConfigModel == null) {
            WarblerConfigHelper.a(9);
        }
        if (string == null) {
            WarblerConfigHelper.a(10);
        }
        if (stringArray == null) {
            WarblerConfigHelper.a(11);
        }
        if (string.equals("config.features")) {
            for (String string2 : stringArray) {
                if (string2.equalsIgnoreCase("executable")) {
                    warblerConfigModel.setExecutable(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("compiled")) {
                    warblerConfigModel.setPrecompiled(true);
                    continue;
                }
                if (!string2.equalsIgnoreCase("gemjar")) continue;
                warblerConfigModel.setGemJar(true);
            }
        } else if (string.equals("config.dirs")) {
            for (String string3 : stringArray) {
                VirtualFile virtualFile = WarblerConfigHelper.getModuleDir(module2).findChild(string3);
                if (virtualFile == null) continue;
                warblerConfigModel.getIncludeModel().addFile(virtualFile);
            }
        } else if (string.equals("config.jar_name") || string.equals("config.war_name")) {
            warblerConfigModel.setFileName(stringArray[0]);
        } else {
            for (String string4 : stringArray) {
                VirtualFile virtualFile = WarblerConfigHelper.getModuleDir(module2).findFileByRelativePath(string4);
                if (virtualFile == null) continue;
                if (string.equals("config.includes")) {
                    warblerConfigModel.getIncludeModel().addFile(virtualFile);
                    continue;
                }
                if (string.equals("config.excludes")) {
                    warblerConfigModel.getExcludeModel().addFile(virtualFile);
                    continue;
                }
                if (!string.equals("config.webinf_files")) continue;
                warblerConfigModel.getWebInfConfigModel().addFile(virtualFile);
            }
        }
    }

    @NotNull
    public static VirtualFile getModuleDir(@NotNull Module module2) {
        if (module2 == null) {
            WarblerConfigHelper.a(12);
        }
        VirtualFile virtualFile = ModuleRootManager.getInstance((Module)module2).getContentRoots()[0];
        if (virtualFile == null) {
            WarblerConfigHelper.a(13);
        }
        return virtualFile;
    }

    @NotNull
    private static Map<String, PsiElement> a(@NotNull PsiElement psiElement) {
        long l2 = j ^ 0x365BB22C285FL;
        if (psiElement == null) {
            WarblerConfigHelper.a(14);
        }
        HashMap<String, PsiElement> hashMap = new HashMap<String, PsiElement>();
        PsiElement psiElement2 = WarblerPsiUtil.findElementInPsiTree(psiElement, RDoCodeBlock.class);
        if (psiElement2 != null) {
            PsiElement psiElement3 = WarblerPsiUtil.findElementInPsiTree(psiElement2, RCompoundStatement.class);
            hashMap.put(h, psiElement3);
            if (psiElement3 != null) {
                for (PsiElement psiElement4 : psiElement3.getChildren()) {
                    RPsiElement rPsiElement;
                    if (!(psiElement4 instanceof RAssignmentExpression) || !((rPsiElement = ((RAssignmentExpression)psiElement4).getObject()) instanceof RDotReference)) continue;
                    String string = WarblerPsiUtil.getSimpleDotReferenceName((RDotReference)rPsiElement);
                    hashMap.put(string, psiElement4);
                }
            }
        }
        HashMap<String, PsiElement> hashMap2 = hashMap;
        if (hashMap2 == null) {
            WarblerConfigHelper.a(15);
        }
        return hashMap2;
    }

    private static void a(@NotNull Module module2, @NotNull WarblerConfigModel warblerConfigModel, @NotNull RAssignmentExpression rAssignmentExpression) {
        if (module2 == null) {
            WarblerConfigHelper.a(16);
        }
        if (warblerConfigModel == null) {
            WarblerConfigHelper.a(17);
        }
        if (rAssignmentExpression == null) {
            WarblerConfigHelper.a(18);
        }
        RPsiElement rPsiElement = rAssignmentExpression.getObject();
        RPsiElement rPsiElement2 = rAssignmentExpression.getValue();
        if (rPsiElement instanceof RDotReference && rPsiElement2 != null) {
            String string = WarblerPsiUtil.getSimpleDotReferenceName((RDotReference)rPsiElement);
            String[] stringArray = null;
            if (rAssignmentExpression.getValue() instanceof RAbstractWords) {
                stringArray = WarblerPsiUtil.parseStringArray((RAbstractWords)rPsiElement2);
            } else if (rAssignmentExpression.getValue() instanceof RArrayIndexing) {
                stringArray = WarblerPsiUtil.parseStringArray((RArrayIndexing)rPsiElement2);
            } else if (rAssignmentExpression.getValue() instanceof RBaseString) {
                RBaseString rBaseString = (RBaseString)rPsiElement2;
                stringArray = new String[]{rBaseString.getContent()};
            }
            if (stringArray != null) {
                WarblerConfigHelper.a(module2, warblerConfigModel, string, stringArray);
            }
        }
    }

    private static void a(@NotNull Module module2, @NotNull WarblerConfigModel warblerConfigModel, @NotNull RFile rFile) {
        long l2 = j ^ 0x82D588E79ECL;
        if (module2 == null) {
            WarblerConfigHelper.a(19);
        }
        if (warblerConfigModel == null) {
            WarblerConfigHelper.a(20);
        }
        if (rFile == null) {
            WarblerConfigHelper.a(21);
        }
        Map<String, PsiElement> map2 = WarblerConfigHelper.a((PsiElement)rFile);
        for (Map.Entry<String, PsiElement> virtualFileArray : map2.entrySet()) {
            if (virtualFileArray.getKey().equals(h)) continue;
            WarblerConfigHelper.a(module2, warblerConfigModel, (RAssignmentExpression)virtualFileArray.getValue());
        }
        WarblerConfigModel warblerConfigModel2 = WarblerConfigHelper.getDefaultModel(module2);
        if (warblerConfigModel.getIncludeModel().getFileList().length == 0) {
            for (VirtualFile virtualFile : warblerConfigModel2.getIncludeModel().getFileList()) {
                warblerConfigModel.getIncludeModel().addFile(virtualFile);
            }
        }
    }

    @Nullable
    private static VirtualFile a(@NotNull Module module2) {
        long l2 = j ^ 0x269C705A977FL;
        if (module2 == null) {
            WarblerConfigHelper.a(22);
        }
        VirtualFile virtualFile = WarblerConfigHelper.getModuleDir(module2);
        return virtualFile.findFileByRelativePath("config/warble.rb");
    }

    @Nullable
    private static RFile c(@NotNull Module module2) {
        if (module2 == null) {
            WarblerConfigHelper.a(23);
        }
        Ref ref = new Ref();
        VirtualFile virtualFile = WarblerConfigHelper.a(module2);
        if (virtualFile != null && !virtualFile.isDirectory()) {
            ApplicationManager.getApplication().runReadAction(() -> ref.set((Object)PsiManager.getInstance((Project)module2.getProject()).findFile(virtualFile)));
        }
        return (RFile)ref.get();
    }

    @NotNull
    private static String a(@NotNull WarblerConfigModel warblerConfigModel) {
        long l2 = j ^ 0x219A20A40BBAL;
        if (warblerConfigModel == null) {
            WarblerConfigHelper.a(24);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (warblerConfigModel.isExecutable()) {
            arrayList.add("executable");
        }
        if (warblerConfigModel.isPrecompiled()) {
            arrayList.add("compiled");
        }
        if (warblerConfigModel.isGemJar()) {
            arrayList.add("gemjar");
        }
        String string = String.format(d, StringUtil.join(arrayList, (String)" "));
        if (string == null) {
            WarblerConfigHelper.a(25);
        }
        return string;
    }

    @NotNull
    private static String a(@NotNull Module module2, @NotNull WarblerConfigModel warblerConfigModel) {
        long l2 = j ^ 0x9FA3883900BL;
        if (module2 == null) {
            WarblerConfigHelper.a(26);
        }
        if (warblerConfigModel == null) {
            WarblerConfigHelper.a(27);
        }
        VirtualFile virtualFile = WarblerConfigHelper.getModuleDir(module2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (VirtualFile virtualFile2 : warblerConfigModel.getIncludeModel().getFileList()) {
            if (!virtualFile2.isDirectory() || !virtualFile2.getParent().equals(virtualFile)) continue;
            arrayList.add(virtualFile2.getName());
        }
        String string = String.format(b, StringUtil.join(arrayList, (String)" "));
        if (string == null) {
            WarblerConfigHelper.a(28);
        }
        return string;
    }

    @NotNull
    private static String a(@NotNull VirtualFile virtualFile, @NotNull VirtualFile[] virtualFileArray, @NotNull FileFilter fileFilter, @NotNull String string) {
        long l2 = j ^ 0x52EB67EB8D69L;
        if (virtualFile == null) {
            WarblerConfigHelper.a(29);
        }
        if (virtualFileArray == null) {
            WarblerConfigHelper.a(30);
        }
        if (fileFilter == null) {
            WarblerConfigHelper.a(31);
        }
        if (string == null) {
            WarblerConfigHelper.a(32);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (VirtualFile virtualFile2 : virtualFileArray) {
            if (!fileFilter.accept(virtualFile2)) continue;
            arrayList.add('\"' + VfsUtilCore.findRelativePath((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (char)'/') + '\"');
        }
        String string2 = String.format(string, StringUtil.join(arrayList, (String)", "));
        if (string2 == null) {
            WarblerConfigHelper.a(33);
        }
        return string2;
    }

    @NotNull
    private static String b(@NotNull WarblerConfigModel warblerConfigModel) {
        long l2 = j ^ 0x1022A5AE0C3CL;
        if (warblerConfigModel == null) {
            WarblerConfigHelper.a(34);
        }
        String string = String.format(i, warblerConfigModel.getFileName());
        if (string == null) {
            WarblerConfigHelper.a(35);
        }
        return string;
    }

    @NotNull
    private static Map<String, PsiElement> a(@NotNull Module module2, @NotNull WarblerConfigModel warblerConfigModel, PsiElement psiElement) {
        long l2 = j ^ 0x19920B106218L;
        if (module2 == null) {
            WarblerConfigHelper.a(36);
        }
        if (warblerConfigModel == null) {
            WarblerConfigHelper.a(37);
        }
        HashMap<String, PsiElement> hashMap = new HashMap<String, PsiElement>();
        String string = WarblerConfigHelper.a(warblerConfigModel);
        hashMap.put("config.features", (PsiElement)RubyElementFactory.createElementFromText(psiElement, string));
        string = WarblerConfigHelper.a(module2, warblerConfigModel);
        hashMap.put("config.dirs", (PsiElement)RubyElementFactory.createElementFromText(psiElement, string));
        VirtualFile virtualFile = WarblerConfigHelper.getModuleDir(module2);
        ConfigIncludesFileFilter configIncludesFileFilter = new ConfigIncludesFileFilter(virtualFile, null);
        string = WarblerConfigHelper.a(virtualFile, warblerConfigModel.getIncludeModel().getFileList(), configIncludesFileFilter, e);
        hashMap.put("config.includes", (PsiElement)RubyElementFactory.createElementFromText(psiElement, string));
        FileFilter fileFilter = new FileFilter(null);
        string = WarblerConfigHelper.a(virtualFile, warblerConfigModel.getExcludeModel().getFileList(), fileFilter, f);
        hashMap.put("config.excludes", (PsiElement)RubyElementFactory.createElementFromText(psiElement, string));
        string = WarblerConfigHelper.a(virtualFile, warblerConfigModel.getWebInfConfigModel().getFileList(), fileFilter, c);
        hashMap.put("config.webinf_files", (PsiElement)RubyElementFactory.createElementFromText(psiElement, string));
        string = WarblerConfigHelper.b(warblerConfigModel);
        hashMap.put("config.jar_name", (PsiElement)RubyElementFactory.createElementFromText(psiElement, string));
        HashMap<String, PsiElement> hashMap2 = hashMap;
        if (hashMap2 == null) {
            WarblerConfigHelper.a(38);
        }
        return hashMap2;
    }

    @NotNull
    private static RFile d(@NotNull Module module2) throws IOException {
        VirtualFile virtualFile;
        long l2 = j ^ 0x6BBF5B114993L;
        if (module2 == null) {
            WarblerConfigHelper.a(39);
        }
        if ((virtualFile = WarblerConfigHelper.getModuleDir(module2).findFileByRelativePath("config")) == null) {
            virtualFile = WarblerConfigHelper.getModuleDir(module2).createChildDirectory((Object)module2, "config");
        }
        VirtualFile virtualFile2 = virtualFile;
        VirtualFile virtualFile3 = WarblerConfigHelper.a(module2);
        if (virtualFile3 == null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                long l2 = j ^ 0x21ACF1C71B86L;
                try {
                    if (virtualFile2 == null) {
                        throw new RuntimeException(RBundle.message("warbler.error.rails.directory.missed"));
                    }
                    virtualFile2.createChildData((Object)module2, "warble.rb");
                }
                catch (IOException iOException) {
                    a.error(iOException.getMessage(), (Throwable)iOException);
                    throw new RuntimeException(iOException);
                }
            });
        }
        if ((virtualFile3 = WarblerConfigHelper.a(module2)) == null) {
            String string = RBundle.message("warbler.error.cant.write.to.config");
            a.error(string);
            throw new IOException(string);
        }
        VirtualFile virtualFile4 = virtualFile3;
        File file = new File(virtualFile4.getPath());
        String string = String.format(g, module2.getName());
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                FileUtil.writeToFile((File)file, (byte[])string.getBytes(StandardCharsets.UTF_8));
                virtualFile4.refresh(false, false);
            }
            catch (IOException iOException) {
                a.error(iOException.getMessage(), (Throwable)iOException);
                throw new RuntimeException(iOException);
            }
        });
        RFile rFile = WarblerConfigHelper.c(module2);
        if (rFile == null) {
            WarblerConfigHelper.a(40);
        }
        return rFile;
    }

    private static /* synthetic */ void a(PsiElement psiElement, Map map2) {
        Map<String, PsiElement> map3 = WarblerConfigHelper.a(psiElement);
        map2.putAll(map3);
    }

    static {
        j = com.jetbrains.python.psi.c.a(5979569687417630553L, 2096259441441145339L, MethodHandles.lookup().lookupClass()).a(144174031866353L);
        a = Logger.getInstance(WarblerConfigHelper.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = j ^ 0x65210A0F2983L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 25: 
            case 28: 
            case 33: 
            case 35: 
            case 38: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 25: 
            case 28: 
            case 33: 
            case 35: 
            case 38: 
            case 40: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 25: 
            case 28: 
            case 33: 
            case 35: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/jruby/warbler/helpers/WarblerConfigHelper";
                break;
            }
            case 3: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 20: 
            case 24: 
            case 27: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDir";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileList";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFilter";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/jruby/warbler/helpers/WarblerConfigHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readConfig";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareWarblerConfigFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDir";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigAssignments";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFeaturesAssignments";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDirsValue";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFileListValues";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigWarFileNameValue";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewConfigValues";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createWarblerConfig";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readConfig";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 25: 
            case 28: 
            case 33: 
            case 35: 
            case 38: 
            case 40: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveConfig";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareWarblerConfigFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultModel";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putValueIntoConfigModel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDir";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConfigAssignments";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseConfigAssignment";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseWarbleConfig";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualConfigFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFeaturesAssignments";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getConfigDirsValue";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFileListValues";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getConfigWarFileNameValue";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getNewConfigValues";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createWarblerConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 25: 
            case 28: 
            case 33: 
            case 35: 
            case 38: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConfigIncludesFileFilter
    extends FileFilter {
        private final VirtualFile a;
        private static final long b = com.jetbrains.python.psi.c.a(7041139327302362229L, 22629291552297423L, MethodHandles.lookup().lookupClass()).a(118479595977089L);

        private ConfigIncludesFileFilter(@NotNull VirtualFile moduleDir) {
            if (moduleDir == null) {
                ConfigIncludesFileFilter.b(0);
            }
            super(null);
            this.a = moduleDir;
        }

        @Override
        public boolean accept(@NotNull VirtualFile file) {
            if (file == null) {
                ConfigIncludesFileFilter.b(1);
            }
            return !file.isDirectory() || !file.getParent().equals(this.a);
        }

        /* synthetic */ ConfigIncludesFileFilter(VirtualFile x0, a x1) {
            this(x0);
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = b ^ 0x352A86FFDB45L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleDir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/jruby/warbler/helpers/WarblerConfigHelper$ConfigIncludesFileFilter";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FileFilter {
        private static final long c = com.jetbrains.python.psi.c.a(5364097949301475111L, 1078041021144514695L, MethodHandles.lookup().lookupClass()).a(196519558558461L);

        private FileFilter() {
        }

        public boolean accept(@NotNull VirtualFile file) {
            if (file == null) {
                FileFilter.a(0);
            }
            return true;
        }

        /* synthetic */ FileFilter(a x0) {
            this();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = c ^ 0x64E0AB7DB67CL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/ruby/jruby/warbler/helpers/WarblerConfigHelper$FileFilter", "accept"));
        }
    }
}

