/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.util;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.gem.GemRunner;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public class ShowGemEnvironmentAction
extends AnAction
implements DumbAware {
    private static final long a = c.a(-5654490942686503776L, 6063946177578787265L, MethodHandles.lookup().lookupClass()).a(104190557267375L);

    public void update(@NotNull AnActionEvent e10) {
        if (e10 == null) {
            ShowGemEnvironmentAction.a(0);
        }
        DataContext dataContext = e10.getDataContext();
        Module module2 = RModuleUtil.getInstance().getModule(dataContext);
        Sdk sdk = module2 != null ? RModuleUtil.getInstance().findRubySdkForModule(module2) : null;
        boolean bl2 = sdk != null && GemManager.getInstance().isRegistered(sdk);
        e10.getPresentation().setEnabled(bl2);
        e10.getPresentation().setVisible(bl2 || PlatformUtils.isRubyMine());
    }

    public void actionPerformed(@NotNull AnActionEvent e10) {
        long l2 = a ^ 0x7AA48A0495BBL;
        if (e10 == null) {
            ShowGemEnvironmentAction.a(1);
        }
        DataContext dataContext = e10.getDataContext();
        final Module module2 = RModuleUtil.getInstance().getModule(dataContext);
        assert (module2 != null);
        final Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
        assert (sdk != null);
        final String string = ShowGemEnvironmentAction.a(sdk, module2);
        final Project project = module2.getProject();
        Task.Backgroundable backgroundable = new Task.Backgroundable(project, "Running 'gem environment' command..."){
            private static final long a = c.a(-4388873578179209484L, 2935465743582198611L, MethodHandles.lookup().lookupClass()).a(235189587817678L);

            public void run(@NotNull ProgressIndicator indicator) {
                String string3;
                long l2 = a ^ 0x74D551115C7AL;
                if (indicator == null) {
                    1.a(0);
                }
                string3 = (string3 = GemRunner.getRawEnvironment(module2, sdk)) != null ? string3.replaceAll("RubyGems Environment:(\r)?\n", "") : null;
                string3 = string3 != null ? string3.replace("    - ", "  ") : null;
                String string2 = string3 = string3 != null ? string3.replace("  - ", "") : null;
                ApplicationManager.getApplication().invokeLater(() -> {
                    long l2 = a ^ 0x6EFF0087F946L;
                    if (string2 != null) {
                        Messages.showDialog((Project)project, (String)"", (String)"RubyGems Environment", (String)(string2 + string), (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (int)0, null);
                    } else {
                        Messages.showErrorDialog((String)"Error running 'gem environment'", (String)"RubyGems Environment");
                    }
                });
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0xD27E0074DD6L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/gem/util/ShowGemEnvironmentAction$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)backgroundable);
    }

    private static String a(@NotNull Sdk sdk, @NotNull Module module2) {
        long l2 = a ^ 0x50CB4D926577L;
        if (sdk == null) {
            ShowGemEnvironmentAction.a(2);
        }
        if (module2 == null) {
            ShowGemEnvironmentAction.a(3);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\n');
        stringBuilder.append("----------------------");
        stringBuilder.append('\n');
        String string = sdk.getHomePath();
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        stringBuilder.append("IDE: ").append(applicationInfoEx.getFullApplicationName()).append(", build #").append(applicationInfoEx.getBuild().asString()).append('\n');
        stringBuilder.append("OS: ").append(System.getProperty("os.name")).append(' ').append(SystemInfo.OS_VERSION).append('[').append(SystemInfo.OS_ARCH).append(']').append('\n');
        stringBuilder.append("Java: ").append(SystemInfo.JAVA_RUNTIME_VERSION).append('\n');
        stringBuilder.append("RubyMine SDK Environment:").append('\n');
        stringBuilder.append("Sdk: ").append(sdk.getName()).append('\n');
        stringBuilder.append("Sdk Version: ").append(sdk.getVersionString()).append('\n');
        stringBuilder.append("Ruby Interpreter: ").append(string).append('\n');
        stringBuilder.append("RVM Sdk: ");
        stringBuilder.append(RubySdkUtil.getRubySdkAdditionalData(sdk).getVersionManagerSdkAdditionalData().getPresentableText());
        stringBuilder.append("Sdk Language Level: ").append(RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk).getShortName()).append('\n');
        stringBuilder.append("Sdk Load Path:").append('\n');
        VirtualFile[] virtualFileArray = RubySdkUtil.getSdkRoots(sdk);
        if (virtualFileArray.length == 0) {
            stringBuilder.append("<empty>").append('\n');
        } else {
            for (Object object : virtualFileArray) {
                stringBuilder.append("     ").append(ShowGemEnvironmentAction.a(object.getPath())).append('\n');
            }
        }
        stringBuilder.append("Sdk Gem paths: ").append('\n');
        Collection<String> collection = GemManager.getInstance().getGemRootUrlsForSDK(sdk);
        if (collection.size() == 0) {
            stringBuilder.append("<empty>").append('\n');
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                stringBuilder.append("     ").append(ShowGemEnvironmentAction.a(string2)).append('\n');
            }
        }
        stringBuilder.append("Gems used for '").append(module2.getName()).append("':\n");
        for (GemInfo gemInfo : GemManager.getAllGems(module2)) {
            Object object;
            object = gemInfo.getUrl();
            stringBuilder.append("     ").append(gemInfo.getName()).append(" (").append(gemInfo.getVersion()).append(")\n         ").append(ShowGemEnvironmentAction.a((String)object)).append("\n");
        }
        return stringBuilder.toString();
    }

    private static String a(String string) {
        long l2 = a ^ 0x5F8FB61E70E6L;
        return string.replace("file://", "").replace(SystemProperties.getUserHome(), "~");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x5521BE8B63C3L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/util/ShowGemEnvironmentAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collectRMGemsEnvironment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

