/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.module;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.RubyVMOptions;
import org.jetbrains.plugins.ruby.cli.RMInspectionToolLaunchSettings;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.detector.GemDetector;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsHolder;
import org.jetbrains.plugins.ruby.gem.module.GemScannerSuppressor;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemProvider;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rails.gems.DirectoryGemsProvider;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.util.ProjectQueues;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

public class GemRequirementsChangeWatcher
implements GemManager.GemSetListener {
    private static final Logger o;
    @NotNull
    private final Module c;
    private final ModuleRootManager g;
    private final PsiManager e;
    private final GemRequirementsHolder h;
    private final ModuleGemInfrastructure i;
    private final Object a;
    private volatile boolean p;
    private final AtomicBoolean n;
    private final Set<VirtualFile> m;
    private final List<VirtualFile> d;
    private final RailsApp k;
    @Nullable
    private VirtualFile b;
    private volatile Notification f;
    private final PsiTreeChangeAdapter q;
    private MessageBusConnection l;
    private MessageBusConnection j;
    private static final long r;

    public GemRequirementsChangeWatcher(@NotNull Module module2, ModuleRootManager moduleRootManager, PsiManager psiManager, GemRequirementsHolder holder, ModuleGemInfrastructure infrastructure) {
        if (module2 == null) {
            GemRequirementsChangeWatcher.a(0);
        }
        this.a = new Object();
        this.n = new AtomicBoolean(false);
        this.m = new HashSet<VirtualFile>();
        this.d = new ArrayList<VirtualFile>();
        this.q = new AddGemRequirementUpdateListener();
        this.c = module2;
        this.g = moduleRootManager;
        this.e = psiManager;
        this.h = holder;
        this.i = infrastructure;
        this.k = RailsApp.fromModule(this.c);
    }

    @Override
    public void gemSetChanged() {
        long l2 = r ^ 0x234CB2BAA9A6L;
        ProjectQueues.getInstance(this.c).queue("GemsetsUpdateQueue", Update.create((Object)this.c, () -> this.a((Boolean)null)), () -> {
            long l2 = r ^ 0x6395752AC32CL;
            return new MergingUpdateQueue("GemsetsUpdateQueue", 500, true, null, null, null, false).setRestartTimerOnAdd(true);
        });
    }

    public static GemRequirementsChangeWatcher getInstance(Module module2) {
        return (GemRequirementsChangeWatcher)ModuleServiceManager.getService((Module)module2, GemRequirementsChangeWatcher.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void j() {
        if (RubyVMOptions.disableGemsScanner()) {
            return;
        }
        PsiTreeChangeAdapter psiTreeChangeAdapter = this.q;
        synchronized (psiTreeChangeAdapter) {
            this.e.addPsiTreeChangeListener((PsiTreeChangeListener)this.q, (Disposable)this.c);
            this.l = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.c);
            this.j = this.c.getMessageBus().connect();
            this.j.subscribe(GemManager.GEMSET_CHANGED_TOPIC, (Object)this);
            this.j.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){
                private static final long a = com.jetbrains.python.psi.c.a(-7936353075593870930L, 8823233819578233544L, MethodHandles.lookup().lookupClass()).a(166824858314451L);

                public void moduleRemoved(@NotNull Project project, @NotNull Module module2) {
                    if (project == null) {
                        1.a(0);
                    }
                    if (module2 == null) {
                        1.a(1);
                    }
                    if (GemRequirementsChangeWatcher.this.c.equals(module2) || GemRequirementsChangeWatcher.this.c.isDisposed()) {
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (GemRequirementsChangeWatcher.this.c.isDisposed()) {
                            return;
                        }
                        GemManager.updateGemset(GemRequirementsChangeWatcher.this.c);
                    });
                }

                public void moduleAdded(@NotNull Project project, @NotNull Module addedModule) {
                    if (project == null) {
                        1.a(2);
                    }
                    if (addedModule == null) {
                        1.a(3);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (GemRequirementsChangeWatcher.this.c.isDisposed()) {
                            return;
                        }
                        GemManager.updateGemset(GemRequirementsChangeWatcher.this.c);
                    });
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    long l2 = a ^ 0x7C241CCDA255L;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "module";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "addedModule";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/GemRequirementsChangeWatcher$1";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "moduleRemoved";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "moduleAdded";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void m() {
        PsiTreeChangeAdapter psiTreeChangeAdapter = this.q;
        synchronized (psiTreeChangeAdapter) {
            this.e.removePsiTreeChangeListener((PsiTreeChangeListener)this.q);
            if (this.l != null) {
                this.l.disconnect();
            }
            this.l = null;
            if (this.j != null) {
                this.j.disconnect();
            }
            this.j = null;
        }
    }

    private void a(PsiTreeChangeEvent psiTreeChangeEvent, boolean bl2) {
        PsiFile psiFile = GemRequirementsChangeWatcher.b(psiTreeChangeEvent);
        PsiElement psiElement = psiTreeChangeEvent.getParent();
        if (psiFile != null) {
            if (bl2 && psiElement instanceof PsiDirectory && this.a((PsiFileSystemItem)psiElement)) {
                this.h.removeRequirements(psiFile.getVirtualFile());
            }
            if (!this.a((PsiFileSystemItem)psiFile)) {
                return;
            }
            GemDetector gemDetector = GemRequirementsChangeWatcher.getDetector(psiFile);
            if (gemDetector != null) {
                this.addFileScan(psiFile.getVirtualFile());
            }
            return;
        }
        PsiDirectory psiDirectory = GemRequirementsChangeWatcher.a(psiTreeChangeEvent);
        if (psiDirectory != null && (bl2 && this.a((PsiFileSystemItem)psiElement) || this.a((PsiFileSystemItem)psiDirectory))) {
            if (!bl2) {
                this.a(psiDirectory.getVirtualFile());
            } else {
                this.h.removeRequirementsFromDirectory(psiDirectory.getVirtualFile());
            }
        }
    }

    private boolean a(@Nullable PsiFileSystemItem psiFileSystemItem) {
        if (psiFileSystemItem == null || !psiFileSystemItem.isValid()) {
            return false;
        }
        String string = psiFileSystemItem.getName();
        if (this.b != null && this.b.isValid() && !BundlerUtil.isGemfile(psiFileSystemItem) && !GemRequirementsChangeWatcher.a(string)) {
            return false;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFileSystemItem);
        if (module2 != this.c || !RModuleUtil.getInstance().hasRubySupport(module2)) {
            return false;
        }
        return !this.f(psiFileSystemItem.getVirtualFile());
    }

    private boolean f(VirtualFile virtualFile) {
        if (this.k == null) {
            return false;
        }
        return this.k.isVendorFile(virtualFile);
    }

    @Nullable
    private Boolean d(@Nullable VirtualFile virtualFile) {
        long l2 = r ^ 0x505E33D49E45L;
        o.assertTrue(ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed(), (Object)"no read access, scripts running ahead");
        GemDetector gemDetector = GemRequirementsChangeWatcher.b(virtualFile);
        return gemDetector != null ? this.b(virtualFile, gemDetector) : null;
    }

    @Nullable
    private Boolean b(@NotNull VirtualFile virtualFile, @NotNull GemDetector gemDetector) {
        if (virtualFile == null) {
            GemRequirementsChangeWatcher.a(1);
        }
        if (gemDetector == null) {
            GemRequirementsChangeWatcher.a(2);
        }
        Boolean bl2 = null;
        Pair pair = (Pair)ReadAction.compute(() -> Pair.create((Object)this.a(virtualFile, gemDetector), (Object)RModuleUtil.getInstance().findRubySdkForModule(this.c)));
        if (((Boolean)pair.getFirst()).booleanValue()) {
            Sdk sdk = (Sdk)pair.getSecond();
            bl2 = this.i.hasMissingGems(sdk);
            Set<GemDependency> set = gemDetector.detect(this.c.getProject(), sdk, virtualFile);
            if (this.c.isDisposed()) {
                return null;
            }
            this.h.updateRequirements(set, virtualFile);
        } else {
            this.h.removeRequirements(virtualFile);
        }
        return bl2;
    }

    private boolean a(@NotNull VirtualFile virtualFile, GemDetector gemDetector) {
        long l2 = r ^ 0x212B70A77278L;
        if (virtualFile == null) {
            GemRequirementsChangeWatcher.a(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.c.isDisposed() || !virtualFile.isValid() || !this.g.getFileIndex().isInContent(virtualFile) || !gemDetector.accepts(virtualFile)) {
            return false;
        }
        if (this.b != null && this.b.isValid() && !virtualFile.equals(this.b) && !virtualFile.getName().endsWith(".gemspec")) {
            return false;
        }
        for (ModuleGemProvider moduleGemProvider : ModuleGemProvider.EP_NAME.getExtensionList()) {
            if (!(moduleGemProvider instanceof DirectoryGemsProvider) || !((DirectoryGemsProvider)moduleGemProvider).isUnderDependenciesRoot(virtualFile, this.c)) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> null")
    public static GemDetector getDetector(PsiFile file) {
        return file != null ? (GemDetector)GemDetector.EXTENSION.forLanguage(file.getLanguage()) : null;
    }

    @Nullable
    private static GemDetector b(VirtualFile virtualFile) {
        if (virtualFile == null) {
            return null;
        }
        FileType fileType = virtualFile.getFileType();
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        return (GemDetector)GemDetector.EXTENSION.forLanguage(((LanguageFileType)fileType).getLanguage());
    }

    @Nullable
    private static PsiFile b(PsiTreeChangeEvent psiTreeChangeEvent) {
        PsiFile psiFile = psiTreeChangeEvent.getFile();
        PsiElement psiElement = psiTreeChangeEvent.getChild();
        if (psiFile == null && psiElement instanceof PsiFile) {
            return (PsiFile)psiElement;
        }
        return psiFile;
    }

    @Nullable
    private static PsiDirectory a(PsiTreeChangeEvent psiTreeChangeEvent) {
        PsiElement psiElement = psiTreeChangeEvent.getElement();
        PsiElement psiElement2 = psiTreeChangeEvent.getChild();
        boolean bl2 = psiElement instanceof PsiDirectory;
        if (!bl2 && psiElement2 instanceof PsiDirectory) {
            return (PsiDirectory)psiElement2;
        }
        return bl2 ? (PsiDirectory)psiElement : null;
    }

    public void start() {
        if (this.c.isDisposed() || !RModuleUtil.getInstance().hasRubySupport(this.c)) {
            return;
        }
        if (!RMInspectionToolLaunchSettings.getInstance().isActivated()) {
            this.j();
        }
        this.a(() -> {
            this.b = BundlerUtil.getGemfile(this.c);
            this.k();
        });
    }

    public void stop() {
        this.m();
        this.a(() -> {
            this.b = null;
            this.h.clear();
            this.b();
        });
    }

    private void a(final @NotNull Runnable runnable) {
        long l2 = r ^ 0x3BC669682871L;
        if (runnable == null) {
            GemRequirementsChangeWatcher.a(4);
        }
        final Project project = this.c.getProject();
        ProjectQueues.getInstance(project).queue("GemRequirementsChangeWatcherQueue", new Task.Backgroundable(project, RBundle.message("gems.scanning.title", this.c.getName()), false){
            private static final long a = com.jetbrains.python.psi.c.a(1719345768770128442L, 3260772551189224985L, MethodHandles.lookup().lookupClass()).a(97923220190972L);

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.a(0);
                }
                DumbService.getInstance((Project)project).repeatUntilPassesInSmartMode(() -> {
                    if (GemRequirementsChangeWatcher.this.c.isDisposed()) {
                        return;
                    }
                    runnable.run();
                });
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x73A6483F58E1L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/gem/module/GemRequirementsChangeWatcher$2", "run"));
            }
        });
    }

    private void k() {
        long l2 = r ^ 0x5C5F613A7C1BL;
        if (this.c.isDisposed()) {
            return;
        }
        o.info("Initial scan started");
        long l3 = System.currentTimeMillis();
        this.h.clear();
        Ref ref = new Ref();
        if (this.b != null && this.b.isValid()) {
            ref.set((Object)this.d(this.b));
        } else {
            VirtualFile[] virtualFileArray;
            for (VirtualFile virtualFile : virtualFileArray = this.g.getContentRoots()) {
                GemRequirementsChangeWatcher.a((Ref<Boolean>)ref, this.h(virtualFile));
            }
        }
        o.info("Initial scan took: " + (System.currentTimeMillis() - l3) + " ms");
        if (o.isDebugEnabled()) {
            o.debug("Detected: " + this.h.getRequirements());
        }
        this.a((Boolean)ref.get());
    }

    private static void a(Ref<Boolean> ref, Boolean bl2) {
        if (ref.get() != null) {
            if (bl2 != null) {
                ref.set((Object)((Boolean)ref.get() != false || bl2 != false ? 1 : 0));
            }
        } else {
            ref.set((Object)bl2);
        }
    }

    private void a(@Nullable Boolean bl2) {
        long l2 = r ^ 0xD491E8CA5CAL;
        if (this.c.isDisposed()) {
            return;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(this.c);
        if (sdk == null) {
            o.warn("No Sdk selected for " + this.c);
            return;
        }
        Boolean bl3 = bl2 == null ? this.i.hasMissingGems(sdk) : bl2;
        Set<GemDependency> set = this.h.getRequirements();
        Set<GemDependency> set2 = GemUtil.getMissingDependencies(sdk, this.c, set);
        Notification notification2 = this.f;
        if (bl3 != null && bl3.booleanValue() || bl3 == null && set2.size() > 0) {
            if (notification2 == null || notification2.isExpired()) {
                this.f = new MissingGemsNotification(this);
                Notifications.Bus.notify((Notification)this.f, (Project)this.c.getProject());
                o.debug("Notifying about missing gems: [precalculated = " + bl2 + "; hasMissingGems = " + bl3 + "; missing = " + set2.stream().map(GemDependency::toString).collect(Collectors.joining(", ")) + "]");
            }
        } else {
            ApplicationManager.getApplication().invokeLater(() -> GemRequirementsChangeWatcher.a(notification2));
        }
        if (!(bl3 == null || bl3.booleanValue() || set2.size() <= 0 || this.b != null && this.b.isValid())) {
            o.error("Infrastructure reported that no gems missing, but we have detected: " + set2);
        }
        this.b();
    }

    private void b() {
        Runnable runnable = () -> {
            if (this.c.isDisposed()) {
                return;
            }
            GemManager.updateGemset(this.c);
            RbenvGemsetManager.refreshAttachedGemsetSdks(this.c);
            RMInspectionToolLaunchSettings rMInspectionToolLaunchSettings = RMInspectionToolLaunchSettings.getInstance();
            if (rMInspectionToolLaunchSettings.isActivated() && rMInspectionToolLaunchSettings.getVerboseLevel() > 0) {
                this.h();
            }
            DaemonCodeAnalyzer.getInstance((Project)this.c.getProject()).restart();
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            runnable.run();
        } else {
            application.invokeLater(runnable);
        }
    }

    private void h() {
        long l2 = r ^ 0x1C1F521DBBEBL;
        System.out.println("\nFollowing gems were detected:\n");
        Set<GemInfo> set = GemManager.getAllGems(this.c);
        if (set.isEmpty()) {
            System.out.println("    <no gems>");
        } else {
            for (GemInfo gemInfo : set) {
                System.out.println("    " + gemInfo.toString() + (gemInfo.isValid() ? "" : " [invalid]"));
            }
        }
    }

    @Nullable
    private Boolean h(VirtualFile virtualFile2) {
        if (this.c.isDisposed()) {
            return null;
        }
        if (virtualFile2 == null) {
            return null;
        }
        Ref ref = new Ref();
        this.g.getFileIndex().iterateContentUnderDirectory(virtualFile2, virtualFile -> {
            ThreeState threeState = (ThreeState)ReadAction.compute(() -> {
                if (this.c.isDisposed()) {
                    return ThreeState.NO;
                }
                if (!virtualFile.isValid() || virtualFile.isDirectory() || GemRequirementsChangeWatcher.b(virtualFile) == null) {
                    return ThreeState.YES;
                }
                return ThreeState.UNSURE;
            });
            if (threeState != ThreeState.UNSURE) {
                return threeState.toBoolean();
            }
            GemRequirementsChangeWatcher.a((Ref<Boolean>)ref, this.d(virtualFile));
            return true;
        }, virtualFile -> (Boolean)ReadAction.compute(() -> !GemScannerSuppressor.isFileSuppressed(virtualFile, this.c)));
        return (Boolean)ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualFile[] d() {
        Object object = this.a;
        synchronized (object) {
            VirtualFile virtualFile;
            VirtualFile[] virtualFileArray = new VirtualFile[this.m.size() + this.d.size()];
            int n2 = 0;
            Iterator<VirtualFile> iterator = this.m.iterator();
            while (iterator.hasNext()) {
                virtualFileArray[n2] = virtualFile = iterator.next();
                ++n2;
            }
            iterator = this.d.iterator();
            while (iterator.hasNext()) {
                virtualFileArray[n2] = virtualFile = iterator.next();
                ++n2;
            }
            this.m.clear();
            this.d.clear();
            return virtualFileArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileScan(VirtualFile file) {
        Object object = this.a;
        synchronized (object) {
            if (this.c(file)) {
                return;
            }
            this.m.add(file);
            this.e();
        }
    }

    private boolean c(VirtualFile virtualFile) {
        for (VirtualFile virtualFile2 : this.d) {
            if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(VirtualFile virtualFile) {
        Object object = this.a;
        synchronized (object) {
            if (this.c(virtualFile) || this.f(virtualFile)) {
                return;
            }
            for (VirtualFile virtualFile2 : new ArrayList<VirtualFile>(this.m)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (boolean)false)) continue;
                this.m.remove(virtualFile2);
            }
            this.d.add(virtualFile);
            this.e();
        }
    }

    private void e() {
        long l2 = r ^ 0x3234B6BEEDCCL;
        if (!this.p) {
            ProjectQueues.getInstance(this.c).queue("UpdateGemRequirementsQueue", new GemRequirementScan(), () -> {
                long l2 = r ^ 0x215D3488BE99L;
                return new MergingUpdateQueue("UpdateGemRequirementsQueue", 5000, true, null).setRestartTimerOnAdd(true);
            });
        } else {
            this.n.set(true);
        }
    }

    private static boolean a(String string) {
        long l2 = r ^ 0x26C8244EED2AL;
        return string.endsWith(".gemspec") || BundlerUtil.isGemfileLockName(string);
    }

    private static void a(Notification notification2) {
        if (notification2 != null && !notification2.isExpired()) {
            notification2.expire();
        }
    }

    static {
        r = com.jetbrains.python.psi.c.a(2703352245436214121L, -599670787694857421L, MethodHandles.lookup().lookupClass()).a(11887426558652L);
        o = Logger.getInstance(GemRequirementsChangeWatcher.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = r ^ 0x1E8DF1D872B0L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scanner";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/GemRequirementsChangeWatcher";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "detectAndAdd";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldScanForRequirements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addScanner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class AddGemRequirementUpdateListener
    extends PsiTreeChangeAdapter {
        private static final long a = com.jetbrains.python.psi.c.a(3556107377522983225L, 5622607734400238163L, MethodHandles.lookup().lookupClass()).a(133930845696605L);

        private AddGemRequirementUpdateListener() {
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                AddGemRequirementUpdateListener.a(0);
            }
            GemRequirementsChangeWatcher.this.a(event, false);
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                AddGemRequirementUpdateListener.a(1);
            }
            GemRequirementsChangeWatcher.this.a(event, true);
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                AddGemRequirementUpdateListener.a(2);
            }
            GemRequirementsChangeWatcher.this.a(event, false);
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                AddGemRequirementUpdateListener.a(3);
            }
            GemRequirementsChangeWatcher.this.a(event, false);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                AddGemRequirementUpdateListener.a(4);
            }
            GemRequirementsChangeWatcher.this.a(event, false);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x518AFDBF68BAL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "org/jetbrains/plugins/ruby/gem/module/GemRequirementsChangeWatcher$AddGemRequirementUpdateListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MissingGemsNotification
    extends Notification {
        final /* synthetic */ GemRequirementsChangeWatcher this$0;
        private static final long a = com.jetbrains.python.psi.c.a(2710011945569065987L, -5404718074285430541L, MethodHandles.lookup().lookupClass()).a(82735502070668L);

        private MissingGemsNotification(GemRequirementsChangeWatcher gemRequirementsChangeWatcher) {
            long l2 = a ^ 0x149DC9F533CFL;
            this.this$0 = gemRequirementsChangeWatcher;
            super("Gem Manager", PlatformUtils.isRubyMine() ? "RubyMine Gem Manager" : "Ruby Plugin Gem Manager", XmlStringUtil.wrapInHtml((CharSequence)RBundle.message("gems.requirements.missing", PlatformUtils.isRubyMine() ? "RubyMine" : "Ruby plugin", gemRequirementsChangeWatcher.c.getName())), NotificationType.WARNING, new NotificationListener(){
                private static final long a = com.jetbrains.python.psi.c.a(-8111325257145083933L, 4402176085426553602L, MethodHandles.lookup().lookupClass()).a(66798457064036L);

                public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                    if (notification2 == null) {
                        1.a(0);
                    }
                    if (event == null) {
                        1.a(1);
                    }
                    GemRequirementsChangeWatcher.this.i.updateModuleGemset();
                    GemRequirementsChangeWatcher.a(notification2);
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    long l2 = a ^ 0x4635590C2948L;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/ruby/gem/module/GemRequirementsChangeWatcher$MissingGemsNotification$1";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private class GemRequirementScan
    extends Update {
        private static final long a = com.jetbrains.python.psi.c.a(262778447257380549L, -2000903240864546403L, MethodHandles.lookup().lookupClass()).a(128916672308875L);

        GemRequirementScan() {
            super(GemRequirementsChangeWatcher.this.a);
        }

        public void run() {
            if (GemRequirementsChangeWatcher.this.p) {
                GemRequirementsChangeWatcher.this.n.set(true);
                return;
            }
            VirtualFile[] virtualFileArray = GemRequirementsChangeWatcher.this.d();
            if (GemRequirementsChangeWatcher.this.c.getProject().isDisposed() || virtualFileArray.length == 0) {
                return;
            }
            GemRequirementsChangeWatcher.this.a(() -> {
                long l2 = GemRequirementScan.a ^ 0x6BB12CC4C2FDL;
                try {
                    GemRequirementsChangeWatcher.this.p = true;
                    o.debug("Scanning " + virtualFileArray.length + " targets");
                    Ref ref = new Ref();
                    for (VirtualFile virtualFile : virtualFileArray) {
                        boolean bl2 = (Boolean)ReadAction.compute(() -> virtualFile.isValid());
                        if (!bl2) continue;
                        if (!virtualFile.isDirectory()) {
                            String string;
                            if (BundlerUtil.isGemfile(GemRequirementsChangeWatcher.this.c.getProject(), virtualFile)) {
                                string = GemRequirementsChangeWatcher.this.b;
                                GemRequirementsChangeWatcher.this.b = BundlerUtil.getGemfile(GemRequirementsChangeWatcher.this.c);
                                if (string == null && GemRequirementsChangeWatcher.this.b != null && GemRequirementsChangeWatcher.this.b.isValid()) {
                                    GemRequirementsChangeWatcher.this.h.clear();
                                }
                            }
                            string = virtualFile.getName();
                            VirtualFile virtualFile2 = GemRequirementsChangeWatcher.this.b;
                            VirtualFile virtualFile3 = virtualFile2 != null && string.endsWith(".gemspec") ? virtualFile2 : virtualFile;
                            GemRequirementsChangeWatcher.a((Ref<Boolean>)ref, GemRequirementsChangeWatcher.this.d(virtualFile3));
                            continue;
                        }
                        GemRequirementsChangeWatcher.a((Ref<Boolean>)ref, GemRequirementsChangeWatcher.this.h(virtualFile));
                    }
                    GemRequirementsChangeWatcher.this.a((Boolean)ref.get());
                }
                finally {
                    GemRequirementsChangeWatcher.this.p = false;
                    if (GemRequirementsChangeWatcher.this.n.compareAndSet(true, false)) {
                        GemRequirementsChangeWatcher.this.e();
                    }
                }
            });
        }
    }
}

