/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RubyVMOptions;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.bundler.BundleExecSettings;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerExecSettingsEditor;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rails.preload.spork.run.SporkServerRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtension;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.ui.RubySdkRenderer;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfiguration;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RTestUnitRunCommandLineState;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RTestUnitRunConfiguration;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public class BundlerRunConfigurationExtension
extends RubyRunConfigurationExtension {
    private static final Logger a;
    @NonNls
    private static final String b = "BundlerRunConfigurationExtension";
    private static final long c;

    @Nullable
    static <T extends AbstractRubyRunConfiguration> GemInfo getBundlerGem(T configuration, boolean execution) {
        return BundlerUtil.getBundlerGem(configuration.getSdk(), configuration.shouldUseAlternativeSdk() ? null : configuration.getModule(), execution);
    }

    @NotNull
    protected String getSerializationId() {
        long l2 = c ^ 0x6F56080E0436L;
        if (b == null) {
            BundlerRunConfigurationExtension.a(0);
        }
        return b;
    }

    protected void readExternal(@NotNull AbstractRubyRunConfiguration runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            BundlerRunConfigurationExtension.a(1);
        }
        if (element == null) {
            BundlerRunConfigurationExtension.a(2);
        }
        BundleExecSettings.putTo(runConfiguration, BundleExecSettings.readExternal(element));
    }

    protected void writeExternal(@NotNull AbstractRubyRunConfiguration runConfiguration, @NotNull Element element) {
        if (runConfiguration == null) {
            BundlerRunConfigurationExtension.a(3);
        }
        if (element == null) {
            BundlerRunConfigurationExtension.a(4);
        }
        BundleExecSettings.getFrom(runConfiguration).writeExternal(element);
    }

    protected <T extends AbstractRubyRunConfiguration<?>> SettingsEditor<T> createEditor(@NotNull T configuration) {
        if (configuration == null) {
            BundlerRunConfigurationExtension.a(5);
        }
        return new BundlerExecSettingsEditor();
    }

    protected String getEditorTitle() {
        long l2 = c ^ 0x276ECF838C9FL;
        return "Bundler";
    }

    public boolean isApplicableFor(@NotNull AbstractRubyRunConfiguration configuration) {
        if (configuration == null) {
            BundlerRunConfigurationExtension.a(6);
        }
        return true;
    }

    public boolean isEnabledFor(@NotNull AbstractRubyRunConfiguration applicableConfiguration, RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            BundlerRunConfigurationExtension.a(7);
        }
        BundleExecSettings bundleExecSettings = BundleExecSettings.getFrom(applicableConfiguration);
        if (bundleExecSettings.isBundleExecEnabled) {
            return true;
        }
        return BundlerRunConfigurationExtension.isTestUnitLoadPathPatchRequired(applicableConfiguration);
    }

    protected void patchCommandLine(@NotNull AbstractRubyRunConfiguration configuration, RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) throws ExecutionException {
        if (configuration == null) {
            BundlerRunConfigurationExtension.a(8);
        }
        if (cmdLine == null) {
            BundlerRunConfigurationExtension.a(9);
        }
        if (runnerId == null) {
            BundlerRunConfigurationExtension.a(10);
        }
        if (!configuration.isBundlerContextAllowed()) {
            return;
        }
        BundlerUtil.getBundlerPreprocessor(configuration.getSdk(), configuration.getModule(), runnerId, BundlerRunConfigurationExtension.isTestUnitLoadPathPatchRequired(configuration), configuration.shouldUseAlternativeSdk()).preprocess(cmdLine);
    }

    protected void validateConfiguration(@NotNull AbstractRubyRunConfiguration configuration, boolean isExecution) throws Exception {
        long l2 = c ^ 0x1D5EFD1B8665L;
        if (configuration == null) {
            BundlerRunConfigurationExtension.a(11);
        }
        RunConfigurationUtil.inspectSDK(configuration, isExecution);
        GemInfo gemInfo = BundlerRunConfigurationExtension.getBundlerGem(configuration, isExecution);
        if (gemInfo == null || !gemInfo.isValid()) {
            if (gemInfo == null) {
                a.warn("GemInfo for 'bundler' not found");
            } else {
                a.warn("Not valid bundler: " + gemInfo.getUrl());
            }
            String string = "Cannot find Bundler in " + RubySdkRenderer.getSdkText(configuration.getSdk()) + " SDK.";
            RunConfigurationUtil.throwExecutionOrRuntimeException(string, isExecution);
        }
        if (!BundlerUtil.hasGemfile(configuration.getModule())) {
            RunConfigurationUtil.throwExecutionOrRuntimeException("No Gemfile found", isExecution);
        }
    }

    protected void extendCreatedConfiguration(@NotNull AbstractRubyRunConfiguration configuration, @NotNull Location location) {
        if (configuration == null) {
            BundlerRunConfigurationExtension.a(12);
        }
        if (location == null) {
            BundlerRunConfigurationExtension.a(13);
        }
        if (!RubyVMOptions.isAutoBundlerEmulationDisabled()) {
            BundlerUtil.enableBundleEmulationIfNeeded(location.getModule(), configuration);
        }
    }

    protected void extendTemplateConfiguration(@NotNull AbstractRubyRunConfiguration configuration) {
        if (configuration == null) {
            BundlerRunConfigurationExtension.a(14);
        }
        BundleExecSettings.putTo(configuration, new BundleExecSettings());
    }

    protected void attachToProcess(@NotNull AbstractRubyRunConfiguration configuration, @NotNull ProcessHandler handler, RunnerSettings runnerSettings) {
        if (configuration == null) {
            BundlerRunConfigurationExtension.a(15);
        }
        if (handler == null) {
            BundlerRunConfigurationExtension.a(16);
        }
    }

    public static <T extends AbstractRubyRunConfiguration> boolean isTestUnitLoadPathPatchRequired(@NotNull AbstractRubyRunConfiguration<T> configuration) {
        if (configuration == null) {
            BundlerRunConfigurationExtension.a(17);
        }
        if (configuration instanceof RTestUnitRunConfiguration && RTestUnitRunCommandLineState.isGUIRunnerEnabled((RTestUnitRunConfiguration)configuration) || configuration instanceof RakeRunConfiguration && SupportedTestFramework.containsTestUnitBasedFramework(((RakeRunConfiguration)configuration).getAttachedTestFrameworks())) {
            Module module2 = configuration.getModule();
            return module2 != null && TestUnitUtil.isTestUnitGemAttached(module2) && BundlerUtil.hasGemfile(module2);
        }
        if (configuration instanceof SporkServerRunConfiguration) {
            SupportedTestFramework supportedTestFramework = ((SporkServerRunConfiguration)configuration).getTestFramework();
            return supportedTestFramework == SupportedTestFramework.SHOULDA || supportedTestFramework == SupportedTestFramework.TEST_UNIT;
        }
        return false;
    }

    static {
        c = com.jetbrains.python.psi.c.a(-3797725279937568296L, -8218723962091124788L, MethodHandles.lookup().lookupClass()).a(229311223990017L);
        long l2 = c ^ 0x262DED110B5BL;
        a = Logger.getInstance((String)"#org.jetbrains.plugins.ruby.gem.bundler.BundlerRunConfigurationExtension");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x240CF8F48090L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/bundler/BundlerRunConfigurationExtension";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializationId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/bundler/BundlerRunConfigurationExtension";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledFor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateConfiguration";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extendCreatedConfiguration";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extendTemplateConfiguration";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isTestUnitLoadPathPatchRequired";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

