/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.bundler;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfig;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfigServiceImpl;

public final class BundleConfigDataService
implements VirtualFileListener {
    private static final Logger a;
    private static final Pattern b;
    private final Map<VirtualFile, Map<String, String>> c = ContainerUtil.newConcurrentMap();
    private static final long d;

    private BundleConfigDataService() {
        LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)this);
        LocalFileSystem.getInstance().addRootsToWatch(Collections.singletonList(BundleConfig.PATH_TO_USER_BUNDLE_FOLDER), false);
    }

    @NotNull
    Map<String, String> getValues(@NotNull VirtualFile configFile) {
        if (configFile == null) {
            BundleConfigDataService.a(0);
        }
        Map map2 = (Map)ObjectUtils.notNull((Object)this.c.computeIfAbsent(configFile, virtualFile -> (Map)ReadAction.compute(() -> BundleConfigDataService.c(virtualFile))), Collections.emptyMap());
        if (map2 == null) {
            BundleConfigDataService.a(1);
        }
        return map2;
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        VirtualFile virtualFile;
        if (event == null) {
            BundleConfigDataService.a(2);
        }
        if (!BundleConfig.isConfig(virtualFile = event.getFile())) {
            return;
        }
        VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)new File(BundleConfig.PATH_TO_USER_BUNDLE_CONFIG), (boolean)false);
        if (virtualFile.equals(virtualFile2)) {
            BundleConfigServiceImpl.getInstance().queueUpdate();
            return;
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
            if (module2 == null) continue;
            BundleConfigServiceImpl.getInstance().getConfig(module2);
        }
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            BundleConfigDataService.a(3);
        }
        this.a((VirtualFileEvent)event);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            BundleConfigDataService.a(4);
        }
        this.d(event.getFile());
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            BundleConfigDataService.a(5);
        }
        this.a(event);
    }

    private void d(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            BundleConfigDataService.a(6);
        }
        this.c.remove(virtualFile);
        BundleConfigServiceImpl.getInstance().queueUpdate();
    }

    private void a(@NotNull VirtualFileEvent virtualFileEvent) {
        if (virtualFileEvent == null) {
            BundleConfigDataService.a(7);
        }
        VirtualFile virtualFile3 = virtualFileEvent.getFile();
        ContainerUtil.filter(new ArrayList<VirtualFile>(this.c.keySet()), virtualFile2 -> !virtualFile2.isValid() || VfsUtilCore.isAncestor((VirtualFile)virtualFile3, (VirtualFile)virtualFile2, (boolean)false)).forEach(virtualFile -> this.d((VirtualFile)virtualFile));
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            BundleConfigDataService.a(8);
        }
        this.a((VirtualFileEvent)event);
    }

    @Nullable
    private static Map<String, String> c(@NotNull VirtualFile virtualFile) {
        long l2 = d ^ 0x1F3F8655449DL;
        if (virtualFile == null) {
            BundleConfigDataService.a(9);
        }
        try {
            a.debug("Computing for " + virtualFile);
            String string2 = VfsUtilCore.loadText((VirtualFile)virtualFile);
            HashMap hashMap = new HashMap();
            StringUtil.split((String)string2, (String)"\n", (boolean)true, (boolean)true).forEach(string -> {
                Matcher matcher = b.matcher((CharSequence)string);
                if (matcher.matches()) {
                    String string2;
                    String string3 = matcher.group(1);
                    String string4 = matcher.group(2);
                    String string5 = string2 = string4 == null ? null : StringUtil.unquoteString((String)string4);
                    if (StringUtil.isNotEmpty((String)string3) && string2 != null) {
                        hashMap.put(string3, string2);
                    }
                }
            });
            return hashMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(hashMap);
        }
        catch (IOException iOException) {
            a.error("Error reading config file " + virtualFile, (Throwable)iOException);
            return null;
        }
    }

    @NotNull
    public static BundleConfigDataService getInstance() {
        BundleConfigDataService bundleConfigDataService = (BundleConfigDataService)Objects.requireNonNull(ServiceManager.getService(BundleConfigDataService.class));
        if (bundleConfigDataService == null) {
            BundleConfigDataService.a(10);
        }
        return bundleConfigDataService;
    }

    static {
        d = com.jetbrains.python.psi.c.a(3482403817849568024L, -2682719926431415840L, MethodHandles.lookup().lookupClass()).a(214290957700827L);
        long l2 = d ^ 0x5D62CAFAB712L;
        a = Logger.getInstance(BundleConfigDataService.class);
        b = Pattern.compile("\\s*(\\S+):\\s*(\\S+)\\s*");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x2F48A1FD873BL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/bundler/BundleConfigDataService";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToRemove";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/bundler/BundleConfigDataService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 1: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fileCreated";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "beforePropertyChange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "contentsChanged";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fileDeleted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeAndRequestUpdate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleParent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "beforeFileMovement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeConfigData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

