/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.jetbrains.python.psi.c;
import gnu.trove.THashSet;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemBox;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemModificationUtil;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGitLockReader;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.module.ModuleGemProvider;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.GemComparator;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.library.RubyLibraryProperties;
import org.jetbrains.plugins.ruby.rails.gems.DirectoryGemsProvider;
import org.jetbrains.plugins.ruby.rails.gems.FrozenGemInfo;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.nativerb.RubyStubBuilderService;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

@State(name="GemManagerSettings", storages={@Storage(value="$CACHE_FILE$")})
public class GemManager
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger u;
    private static final Set<String> o;
    private static final Key<Set<GemInfo>> f;
    public static final Topic<GemSetListener> GEMSET_CHANGED_TOPIC;
    public static final Topic<ModuleGemsListener> MODULE_GEMS_CHANGED_TOPIC;
    private static final int g = 4;
    @NonNls
    private static final String h = "gemManager";
    @NonNls
    private static final String i = "sdk2gems";
    @NonNls
    private static final String n = "sdk";
    @NonNls
    private static final String m = "libraryVersion";
    @NonNls
    public static final String NOTIFICATION_ID = "Gem Manager";
    private static final Predicate<GemInfo> b;
    private final ProjectJdkTable.Listener c;
    private final VirtualFileListener a;
    private final HashMap<String, LocalFileSystem.WatchRequest> p = new HashMap();
    private final MultiValuesMap<String, GemBox> k = new MultiValuesMap(true);
    private final MultiValuesMap<String, GemBox> t = new MultiValuesMap();
    private final MultiValuesMap<String, GemBox> j = new MultiValuesMap();
    private final ProjectJdkTable l;
    private boolean s;
    private int d;
    private static final String e = "ruby.test.hardRefreshGems";
    private static final boolean r;
    private Set<String> q = Sets.newLinkedHashSet();
    private static final long v;

    public static GemManager getInstance() {
        return (GemManager)ApplicationManager.getApplication().getComponent(GemManager.class);
    }

    public GemManager(ProjectJdkTable jdkTable) {
        GemManager.c();
        this.c = new ProjectJdkTable.Adapter(){
            private static final long a = com.jetbrains.python.psi.c.a(1709176476890961987L, -5128732593046699511L, MethodHandles.lookup().lookupClass()).a(232434187266962L);

            public void jdkRemoved(@NotNull Sdk sdk) {
                if (sdk == null) {
                    1.a(0);
                }
                if (RubySdkUtil.isRubySDK(sdk)) {
                    GemManager.a(() -> ApplicationManager.getApplication().runWriteAction(() -> GemManager.this.a(sdk, sdk.getName(), true)));
                }
            }

            public void jdkNameChanged(@NotNull Sdk sdk, @NotNull String previousName) {
                if (sdk == null) {
                    1.a(1);
                }
                if (previousName == null) {
                    1.a(2);
                }
                if (RubySdkUtil.isRubySDK(sdk)) {
                    GemManager.a(() -> {
                        Set<String> set = GemUtil.determineGemUrlsForSDK(sdk);
                        ApplicationManager.getApplication().runWriteAction(() -> {
                            GemManager.this.a(sdk, previousName, false);
                            GemManager.this.addGemsForSdk(sdk, set, true);
                        });
                    });
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = a ^ 0x3CD0FE22D649L;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = GemManager.n;
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "previousName";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemManager$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jdkRemoved";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jdkNameChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.a = new VirtualFileListener(){
            private static final long a = com.jetbrains.python.psi.c.a(-8241370618749807791L, 7439779327898444941L, MethodHandles.lookup().lookupClass()).a(38279664425898L);

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.a(0);
                }
                if (BundlerUtil.isGemfile(event.getFile())) {
                    GemManager.a(event.getFile());
                }
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.a(1);
                }
                GemManager.this.c(event.getFile());
                GemManager.a(event.getParent());
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.a(2);
                }
                GemManager.this.d(event.getFile());
                GemManager.a(event.getParent());
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    2.a(3);
                }
                GemManager.a(event.getNewParent());
                GemManager.a(event.getOldParent());
            }

            public void fileCopied(@NotNull VirtualFileCopyEvent event) {
                if (event == null) {
                    2.a(4);
                }
                GemManager.a(event.getParent());
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x52E30BE9264AL;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemManager$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileMoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCopied";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.l = jdkTable;
    }

    private static void c() {
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        WriteAction.runAndWait(() -> Stream.of(projectJdkTable.getAllJdks()).filter(sdk -> RubySdkUtil.isRubySDK(sdk) && RubySdkAdditionalData.isEmpty(sdk)).forEach(sdk -> {
            long l2 = v ^ 0x2C4DE4A6387EL;
            u.info("Removing corrupted: " + sdk);
            projectJdkTable.removeJdk(sdk);
        }));
    }

    private static void a(@NotNull Runnable runnable) {
        Application application;
        if (runnable == null) {
            GemManager.a(0);
        }
        if ((application = ApplicationManager.getApplication()).isHeadlessEnvironment()) {
            runnable.run();
        } else {
            application.invokeLater(runnable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void a(@NotNull ModifiableRootModel modifiableRootModel, @NotNull Set<? extends GemInfo> set, @NotNull Set<String> set2) {
        Library library;
        void gemInfo;
        long l2 = v ^ 0xE3DE34E99E3L;
        if (modifiableRootModel == null) {
            GemManager.a(1);
        }
        if (set == null) {
            GemManager.a(2);
        }
        if (set2 == null) {
            GemManager.a(3);
        }
        if (set.isEmpty()) {
            return;
        }
        Map<? extends VirtualFile, ? extends Module> map2 = GemManager.a(modifiableRootModel);
        LibraryTable libraryTable = modifiableRootModel.getModuleLibraryTable();
        Module module2 = libraryTable.getLibraries();
        int n2 = ((Library[])module2).length;
        boolean bl2 = false;
        while (gemInfo < n2) {
            library = module2[gemInfo];
            String string = library.getName();
            if (GemInfo.isPathGemLibrary(string) && set2.contains(string) && GemManager.a(library, map2)) {
                u.debug("Removing library: ", new Object[]{library});
                libraryTable.removeLibrary(library);
            }
            ++gemInfo;
        }
        module2 = modifiableRootModel.getModule();
        for (GemInfo gemInfo2 : set) {
            u.assertTrue(gemInfo2.isFromPath(), (Object)("Non-path-based gem: " + gemInfo2));
            library = GemManager.a(gemInfo2, map2);
            if (library != null) {
                if (library.equals(module2)) continue;
                modifiableRootModel.addModuleOrderEntry((Module)library);
                continue;
            }
            gemInfo2.createLibrary(libraryTable.getModifiableModel());
        }
    }

    private static boolean a(@NotNull Library library, @NotNull Map<? extends VirtualFile, ? extends Module> map2) {
        if (library == null) {
            GemManager.a(4);
        }
        if (map2 == null) {
            GemManager.a(5);
        }
        for (String string : library.getUrls(OrderRootType.CLASSES)) {
            if (!map2.containsKey(VirtualFileManager.getInstance().findFileByUrl(string))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Map<? extends VirtualFile, ? extends Module> a(@NotNull ModifiableRootModel modifiableRootModel) {
        if (modifiableRootModel == null) {
            GemManager.a(6);
        }
        HashMap hashMap = Maps.newHashMap();
        Project project = modifiableRootModel.getProject();
        for (VirtualFile virtualFile : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
            Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
            if (module2 == null) continue;
            hashMap.put(virtualFile, module2);
        }
        HashMap hashMap2 = hashMap;
        if (hashMap2 == null) {
            GemManager.a(7);
        }
        return hashMap2;
    }

    @Nullable
    private static Module a(@NotNull GemInfo gemInfo, @NotNull Map<? extends VirtualFile, ? extends Module> map2) {
        VirtualFile virtualFile;
        if (gemInfo == null) {
            GemManager.a(8);
        }
        if (map2 == null) {
            GemManager.a(9);
        }
        if ((virtualFile = gemInfo.getFile()) == null) {
            return null;
        }
        return map2.get(virtualFile);
    }

    public static List<GemInfo> buildGemsFromPathRequirements(Set<? extends GemDependency> fromPath) {
        ArrayList<GemInfo> arrayList = new ArrayList<GemInfo>();
        for (GemDependency gemDependency : fromPath) {
            if (!gemDependency.isFromPath()) continue;
            VirtualFile virtualFile = gemDependency.getGemRootDirectory();
            arrayList.addAll(virtualFile != null ? GemInfo.create(null, virtualFile, true) : Collections.emptyList());
        }
        return arrayList;
    }

    private void c(VirtualFile virtualFile) {
        Collection<GemBox> collection = this.b(virtualFile);
        if (collection == null) {
            return;
        }
        LibraryTable.ModifiableModel modifiableModel = GemModificationUtil.getLibraryTableModifiableModel();
        Map<String, String> map2 = GemManager.a(modifiableModel);
        for (GemBox gemBox : collection) {
            gemBox.addGem(virtualFile);
        }
        GemBox.updateLibraries(modifiableModel, map2, collection);
        modifiableModel.commit();
        GemManager.i();
    }

    private void d(VirtualFile virtualFile) {
        Collection<GemBox> collection = this.b(virtualFile);
        if (collection == null) {
            return;
        }
        LibraryTable.ModifiableModel modifiableModel = GemModificationUtil.getLibraryTableModifiableModel();
        Map<String, String> map2 = GemManager.a(modifiableModel);
        for (GemBox gemBox : collection) {
            gemBox.removeGem(virtualFile);
        }
        GemBox.updateLibraries(modifiableModel, map2, collection);
        modifiableModel.commit();
        GemManager.i();
    }

    @Nullable
    private Collection<GemBox> b(VirtualFile virtualFile) {
        VirtualFile virtualFile2 = virtualFile.getParent();
        if (virtualFile2 == null) {
            return null;
        }
        return this.t.get((Object)virtualFile2.getUrl());
    }

    private void a(Sdk sdk, @NotNull String string, boolean bl2) {
        Collection collection;
        if (string == null) {
            GemManager.a(10);
        }
        if (RbenvGemsetManager.isGemsetSdk(sdk)) {
            Object object;
            collection = this.getGemsetSdkGemboxes(sdk);
            if (collection.isEmpty()) {
                return;
            }
            Sdk sdk2 = RbenvGemsetManager.findRootRbenvSdk(sdk);
            if (sdk2 != null && (object = this.k.get((Object)sdk2.getName())) != null) {
                object.removeAll(collection);
            }
        } else {
            collection = this.k.get((Object)string);
            if (collection == null) {
                return;
            }
            this.k.removeAll((Object)string);
        }
        for (Object object : collection) {
            this.t.remove((Object)((GemBox)object).getUrl(), object);
            this.j.put((Object)string, object);
            this.s = true;
        }
        if (bl2) {
            this.c(string);
        }
        this.d();
        GemManager.i();
    }

    private void f() {
        if (this.j.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                LibraryTable.ModifiableModel modifiableModel = GemModificationUtil.getLibraryTableModifiableModel();
                for (GemBox gemBox : this.j.values()) {
                    gemBox.unregisterLibraries(modifiableModel);
                }
                modifiableModel.commit();
                this.j.clear();
            }
            finally {
                this.s = false;
            }
        });
    }

    public void addGemsForSdk(@NotNull Sdk sdk, Collection<String> urls, boolean doCommit) {
        boolean bl2;
        Sdk sdk2;
        if (sdk == null) {
            GemManager.a(11);
        }
        assert (RubySdkUtil.isRubySDK(sdk));
        if (RbenvGemsetManager.isGemsetSdk(sdk) && (sdk2 = RbenvGemsetManager.findRootRbenvSdk(sdk)) != null) {
            sdk = sdk2;
        }
        for (String string : urls) {
            GemBox gemBox = new GemBox(sdk, string);
            this.t.put((Object)string, (Object)gemBox);
            this.s = true;
            this.k.put((Object)sdk.getName(), (Object)gemBox);
        }
        boolean bl3 = bl2 = !urls.isEmpty();
        if (!urls.isEmpty()) {
            if (doCommit) {
                bl2 = this.a(sdk);
            }
            this.d();
        }
        if (bl2) {
            GemManager.i();
        }
    }

    private boolean e() {
        return (Boolean)WriteAction.compute(() -> {
            try {
                LibraryTable.ModifiableModel modifiableModel = GemModificationUtil.getLibraryTableModifiableModel();
                this.b(modifiableModel);
                boolean bl2 = modifiableModel.isChanged();
                modifiableModel.commit();
                Boolean bl3 = bl2;
                return bl3;
            }
            finally {
                this.s = false;
            }
        });
    }

    private void b(LibraryTable.ModifiableModel modifiableModel) {
        Map<String, String> map2 = GemManager.a(modifiableModel);
        GemBox.updateLibraries(modifiableModel, map2, this.k.values());
    }

    public void initializeComponent() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)this.c);
        VirtualFileManager.getInstance().addVirtualFileListener(this.a, (Disposable)this);
    }

    public void dispose() {
        this.f();
    }

    public boolean flushLibraries() {
        this.f();
        return this.e();
    }

    public boolean flushLibraries(@NotNull Sdk sdk) {
        if (sdk == null) {
            GemManager.a(12);
        }
        this.c(sdk.getName());
        return this.a(sdk);
    }

    private void c(@NotNull String string) {
        Collection collection;
        if (string == null) {
            GemManager.a(13);
        }
        if ((collection = this.j.get((Object)string)) == null || collection.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            LibraryTable.ModifiableModel modifiableModel = GemModificationUtil.getLibraryTableModifiableModel();
            for (GemBox gemBox : collection) {
                gemBox.unregisterLibraries(modifiableModel);
            }
            modifiableModel.commit();
            collection.clear();
        });
    }

    private boolean a(@NotNull Sdk sdk) {
        if (sdk == null) {
            GemManager.a(14);
        }
        return (Boolean)WriteAction.compute(() -> {
            LibraryTable.ModifiableModel modifiableModel = GemModificationUtil.getLibraryTableModifiableModel();
            this.a(sdk, modifiableModel);
            boolean bl2 = modifiableModel.isChanged();
            modifiableModel.commit();
            return bl2;
        });
    }

    private void a(@NotNull Sdk sdk, @NotNull LibraryTable.ModifiableModel modifiableModel) {
        if (sdk == null) {
            GemManager.a(15);
        }
        if (modifiableModel == null) {
            GemManager.a(16);
        }
        Map<String, String> map2 = GemManager.a(modifiableModel);
        GemBox.updateLibraries(modifiableModel, map2, this.c(sdk));
    }

    public Collection<String> getGemRootUrlsForSDK(@Nullable Sdk sdk) {
        if (sdk == null) {
            return Collections.emptySet();
        }
        Collection<GemBox> collection = this.c(sdk);
        return ContainerUtil.map(collection, GemBox::getUrl);
    }

    public boolean isRegistered(@Nullable Sdk sdk) {
        if (sdk == null) {
            return false;
        }
        if (RbenvGemsetManager.isGemsetSdk(sdk)) {
            return !this.getGemsetSdkGemboxes(sdk).isEmpty();
        }
        return this.k.containsKey((Object)sdk.getName());
    }

    @NotNull
    public Collection<GemBox> getGemsetSdkGemboxes(@Nullable Sdk gemsetSdk) {
        if (gemsetSdk == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                GemManager.a(17);
            }
            return list2;
        }
        Sdk sdk = RbenvGemsetManager.findRootRbenvSdk(gemsetSdk);
        if (sdk == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                GemManager.a(18);
            }
            return list3;
        }
        Collection collection = this.k.get((Object)sdk.getName());
        if (collection == null) {
            List list4 = ContainerUtil.emptyList();
            if (list4 == null) {
                GemManager.a(19);
            }
            return list4;
        }
        Collection<GemBox> collection2 = this.filterGemsetBoxes(collection, ContainerUtil.newArrayList((Object[])new String[]{RbenvGemsetManager.getRbenvGemset(gemsetSdk)}));
        if (collection2 == null) {
            GemManager.a(20);
        }
        return collection2;
    }

    @NotNull
    public Collection<GemInfo> getRootGemsToShow(@Nullable Sdk sdk) {
        Collection collection;
        Collection collection2 = collection = sdk != null ? this.k.get((Object)sdk.getName()) : null;
        if (sdk == null || collection == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                GemManager.a(21);
            }
            return list2;
        }
        Collection<GemInfo> collection3 = this.getGems(this.getRootGemBoxes(sdk));
        if (collection3 == null) {
            GemManager.a(22);
        }
        return collection3;
    }

    @NotNull
    public Collection<GemBox> getRootGemBoxes(@NotNull Sdk rootSdk) {
        Collection collection;
        if (rootSdk == null) {
            GemManager.a(23);
        }
        if ((collection = this.k.get((Object)rootSdk.getName())) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                GemManager.a(24);
            }
            return list2;
        }
        Collection collection2 = ContainerUtil.subtract((Collection)collection, this.filterGemsetBoxes(collection, RbenvGemsetManager.getRbenvGemsetNames(rootSdk)));
        if (collection2 == null) {
            GemManager.a(25);
        }
        return collection2;
    }

    @NotNull
    public Collection<GemBox> filterGemsetBoxes(@Nullable Collection<GemBox> gemBoxes, Collection<String> gemsetNames) {
        if (gemBoxes == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                GemManager.a(26);
            }
            return list2;
        }
        List list3 = ContainerUtil.filter(gemBoxes, gemBox -> {
            int n2;
            long l2 = v ^ 0x766C9EE27347L;
            String string = gemBox.getUrl();
            int n3 = string.lastIndexOf("/gems");
            if (n3 == -1) {
                return false;
            }
            int n4 = (string = string.substring(0, n3)).lastIndexOf("/bundler");
            if (n4 != -1) {
                string = string.substring(0, n4);
            }
            if ((n2 = string.lastIndexOf("/")) == -1) {
                return false;
            }
            return gemsetNames.contains(string.substring(n2 + 1));
        });
        if (list3 == null) {
            GemManager.a(27);
        }
        return list3;
    }

    @NotNull
    public Collection<GemInfo> getRbenvSdkWithGemsetsGems(@NotNull Sdk sdk, @NotNull List<String> gemsets) {
        if (sdk == null) {
            GemManager.a(28);
        }
        if (gemsets == null) {
            GemManager.a(29);
        }
        ArrayList<GemInfo> arrayList = new ArrayList<GemInfo>();
        arrayList.addAll(this.getRootGemsToShow(sdk));
        for (String string : gemsets) {
            Sdk sdk2 = RbenvGemsetManager.getGemsetSdk(sdk, string);
            if (sdk2 == null || !RbenvGemsetManager.isGemsetOfSdk(sdk, sdk2)) continue;
            arrayList.addAll(this.getRbenvGemsetGems(sdk2));
        }
        ArrayList<GemInfo> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GemManager.a(30);
        }
        return arrayList2;
    }

    @NotNull
    public Collection<GemInfo> getRbenvGemsetGems(@Nullable Sdk gemsetSdk) {
        this.refresh(gemsetSdk);
        if (gemsetSdk == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                GemManager.a(31);
            }
            return list2;
        }
        String string = RbenvGemsetManager.getRbenvGemset(gemsetSdk);
        if (string == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                GemManager.a(32);
            }
            return list3;
        }
        Sdk sdk = RbenvGemsetManager.findRootRbenvSdk(gemsetSdk);
        if (sdk == null) {
            List list4 = ContainerUtil.emptyList();
            if (list4 == null) {
                GemManager.a(33);
            }
            return list4;
        }
        Collection collection = this.k.get((Object)sdk.getName());
        Collection<GemInfo> collection2 = this.getGems(this.filterGemsetBoxes(collection, ContainerUtil.newSmartList((Object)string)));
        if (collection2 == null) {
            GemManager.a(34);
        }
        return collection2;
    }

    @NotNull
    public Collection<GemInfo> getAllGems(@Nullable Sdk sdk, @Nullable Module module2) {
        if (!RbenvGemsetManager.isRbenvSdk(sdk)) {
            Collection<Object> collection = sdk == null ? ContainerUtil.emptyList() : this.getGems(this.k.get((Object)sdk.getName()));
            if (collection == null) {
                GemManager.a(35);
            }
            return collection;
        }
        Sdk sdk2 = sdk;
        if (RbenvGemsetManager.isGemsetSdk(sdk)) {
            sdk2 = RbenvGemsetManager.findRootRbenvSdk(sdk);
        }
        if (sdk2 == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                GemManager.a(36);
            }
            return list2;
        }
        Collection collection = this.k.get((Object)sdk2.getName());
        ArrayList<GemBox> arrayList = new ArrayList<GemBox>(this.getRootGemBoxes(sdk2));
        if (module2 != null) {
            arrayList.addAll(this.filterGemsetBoxes(collection, RbenvGemsetManager.getRbenvCurrentGemsets(module2)));
        }
        Collection<GemInfo> collection2 = this.getGems(arrayList);
        if (collection2 == null) {
            GemManager.a(37);
        }
        return collection2;
    }

    @NotNull
    public Collection<GemInfo> getAllGems(@Nullable Sdk sdk) {
        Collection<GemInfo> collection = this.getAllGems(sdk, (Module)null);
        if (collection == null) {
            GemManager.a(38);
        }
        return collection;
    }

    @NotNull
    public Collection<GemInfo> getGems(@Nullable Collection<GemBox> gemBoxes) {
        HashSet<GemInfo> hashSet = new HashSet<GemInfo>();
        if (gemBoxes != null) {
            for (GemBox gemBox : gemBoxes) {
                assert (gemBox != null);
                hashSet.addAll(gemBox.getAllGems());
            }
        }
        HashSet<GemInfo> hashSet2 = hashSet;
        if (hashSet2 == null) {
            GemManager.a(39);
        }
        return hashSet2;
    }

    private static void a(@Nullable Collection<String> collection) {
        if (collection != null) {
            String[] stringArray;
            for (String string : stringArray = ArrayUtilRt.toStringArray(collection)) {
                GemManager.a(string);
            }
        }
    }

    public void refreshRootsInTestMode(Sdk sdk) {
        Set<String> set = GemUtil.determineGemUrlsForSDK(sdk);
        if (r || !this.q.equals(set)) {
            this.c(sdk, set);
            this.q = set;
        }
    }

    private void c(Sdk sdk, Set<String> set) {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            long l2 = v ^ 0xD0D8FAFE68FL;
            u.assertTrue(ApplicationManager.getApplication().isUnitTestMode(), (Object)"should hard-refresh roots only in unit-test mode");
            if (!RubySdkUtil.isRubySDK(sdk)) {
                return;
            }
            this.a(sdk, set);
        });
    }

    private void a(Sdk sdk, Collection<String> collection) {
        this.a(sdk, sdk.getName(), ApplicationManager.getApplication().isUnitTestMode());
        GemManager.a(collection);
        this.addGemsForSdk(sdk, collection, ApplicationManager.getApplication().isUnitTestMode());
    }

    public void softRefreshRoots(Sdk sdk, Set<String> paths) {
        boolean bl2;
        if (sdk == null) {
            return;
        }
        Collection<String> collection = this.getGemRootUrlsForSDK(sdk);
        boolean bl3 = bl2 = collection == null;
        if (!bl2 && !paths.isEmpty()) {
            boolean bl4 = bl2 = paths.size() != collection.size();
            if (!bl2) {
                for (String string : collection) {
                    if (paths.contains(string)) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.a(sdk, paths);
        } else {
            this.refresh(sdk);
        }
    }

    public void refresh(@Nullable Sdk sdk) {
        if (sdk == null) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (RubySdkUtil.isRubySDK(sdk)) {
            RbConfig.initIfNecessary(sdk);
            if (!this.isRegistered(sdk)) {
                this.addGemsForSdk(sdk, GemUtil.determineGemUrlsForSDK(sdk), application.isUnitTestMode());
            }
        }
        GemManager.a(this.getGemRootUrlsForSDK(sdk));
        Collection<GemBox> collection = this.c(sdk);
        for (GemBox gemBox : collection) {
            assert (gemBox != null);
            gemBox.updateGems();
        }
        boolean bl2 = true;
        if (application.isDispatchThread()) {
            bl2 = this.flushLibraries(sdk);
        }
        if (bl2) {
            GemManager.i();
        }
    }

    @NotNull
    private Collection<GemBox> c(@NotNull Sdk sdk) {
        Collection collection;
        if (sdk == null) {
            GemManager.a(40);
        }
        if (RbenvGemsetManager.isGemsetSdk(sdk)) {
            collection = this.getGemsetSdkGemboxes(sdk);
        } else if (RbenvGemsetManager.isRootRbenvSdk(sdk)) {
            collection = this.getRootGemBoxes(sdk);
        } else {
            collection = this.k.get((Object)sdk.getName());
            if (collection == null) {
                collection = ContainerUtil.emptyList();
            }
        }
        Collection collection2 = collection;
        if (collection2 == null) {
            GemManager.a(41);
        }
        return collection2;
    }

    private static void a(@NotNull Set<? extends VirtualFile> set, @Nullable Project project) {
        if (set == null) {
            GemManager.a(42);
        }
        if (set.isEmpty()) {
            return;
        }
        if (project == null) {
            GemManager.i();
            return;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        set.stream().map(virtualFile -> projectFileIndex.getModuleForFile(virtualFile, false)).filter(Objects::nonNull).distinct().forEach(module2 -> GemManager.a(module2));
    }

    private static void i() {
        ((GemSetListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(GEMSET_CHANGED_TOPIC)).gemSetChanged();
    }

    private static void a(@NotNull Module module2) {
        if (module2 == null) {
            GemManager.a(43);
        }
        ((GemSetListener)module2.getMessageBus().syncPublisher(GEMSET_CHANGED_TOPIC)).gemSetChanged();
    }

    private static void d(@NotNull Module module2) {
        if (module2 == null) {
            GemManager.a(44);
        }
        ((ModuleGemsListener)module2.getMessageBus().syncPublisher(MODULE_GEMS_CHANGED_TOPIC)).gemsChanged();
    }

    @Nullable
    private static VirtualFile a(@Nullable String string) {
        if (string == null) {
            return null;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(string);
        if (virtualFile != null && virtualFile.isValid()) {
            VirtualFile virtualFile2;
            VirtualFile virtualFile3 = virtualFile.getParent();
            if (virtualFile3 != null) {
                virtualFile3.refresh(false, false);
            }
            if ((virtualFile2 = GemUtil.getSpecFolder(virtualFile)) != null && virtualFile2.isValid()) {
                virtualFile2.getChildren();
                virtualFile2.refresh(false, false);
            }
            virtualFile.getChildren();
            virtualFile.refresh(false, true);
        }
        return virtualFile;
    }

    public static Set<GemInfo> getAllGems(@NotNull Module module2) {
        if (module2 == null) {
            GemManager.a(45);
        }
        if (module2.isDisposed()) {
            return Collections.emptySet();
        }
        Set set = (Set)module2.getUserData(f);
        if (set != null) {
            return set;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
        HashSet<GemInfo> hashSet = new HashSet<GemInfo>();
        GemManager.a(module2, ModuleRootManager.getInstance((Module)module2).getOrderEntries(), sdk, hashSet);
        return hashSet;
    }

    private static void a(@NotNull Module module2, OrderEntry[] orderEntryArray, Sdk sdk, Set<GemInfo> set) {
        if (module2 == null) {
            GemManager.a(46);
        }
        Collection<GemInfo> collection = GemManager.getInstance().getAllGems(sdk, module2);
        BundlerGitLockReader bundlerGitLockReader = BundlerGitLockReader.getInstance(module2);
        for (OrderEntry orderEntry : orderEntryArray) {
            GemInfo gemInfo;
            GemDependency gemDependency = GemManager.a(bundlerGitLockReader, GemManager.a(orderEntry));
            if (gemDependency == null || (gemInfo = GemSearchUtil.findGem(gemDependency.isFromPath() ? GemManager.buildGemsFromPathRequirements(Collections.singleton(gemDependency)) : collection, gemDependency)) == null) continue;
            set.add(gemInfo);
        }
        GemManager.addModuleGems(module2, set);
        module2.putUserData(f, set);
    }

    @Nullable
    private static Pair<String, String> a(@Nullable OrderEntry orderEntry) {
        if (orderEntry instanceof LibraryOrderEntry) {
            return GemInfo.getNameAndVersion(((LibraryOrderEntry)orderEntry).getLibraryName());
        }
        if (orderEntry instanceof ModuleOrderEntry) {
            return GemManager.b(((ModuleOrderEntry)orderEntry).getModule());
        }
        return null;
    }

    @Nullable
    private static Pair<String, String> b(@Nullable Module module2) {
        if (module2 == null) {
            return null;
        }
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        if (virtualFileArray.length == 0) {
            return null;
        }
        List<GemInfo> list2 = GemInfo.create(null, virtualFileArray[0], true);
        if (list2.isEmpty()) {
            return null;
        }
        GemInfo gemInfo = list2.get(0);
        return gemInfo == null ? null : Pair.create((Object)gemInfo.getName(), (Object)gemInfo.getVersion());
    }

    @Nullable
    private static GemDependency a(@NotNull BundlerGitLockReader bundlerGitLockReader, @Nullable Pair<String, String> pair) {
        GemDependency gemDependency;
        long l2 = v ^ 0x595BFE59A74CL;
        if (bundlerGitLockReader == null) {
            GemManager.a(47);
        }
        if (pair == null) {
            return null;
        }
        String string = (String)pair.first;
        if (string == null) {
            return null;
        }
        if (bundlerGitLockReader.isLocked() && ((gemDependency = bundlerGitLockReader.getDependency(string)) != null || !"bundler".equals(string))) {
            return gemDependency;
        }
        return GemDependency.equal(string, (String)pair.second);
    }

    @NotNull
    static Set<GemInfo> addModuleGems(@NotNull Module module2, @NotNull Set<GemInfo> result) {
        if (module2 == null) {
            GemManager.a(48);
        }
        if (result == null) {
            GemManager.a(49);
        }
        for (ModuleGemProvider moduleGemProvider : ModuleGemProvider.EP_NAME.getExtensionList()) {
            ReadAction.run(() -> {
                if (!module2.isDisposed()) {
                    Collections.addAll(result, moduleGemProvider.getGems(module2));
                }
            });
        }
        Set<GemInfo> set = result;
        if (set == null) {
            GemManager.a(50);
        }
        return set;
    }

    @Nullable
    public static GemInfo findGem(@NotNull Module module2, String gemName) {
        if (module2 == null) {
            GemManager.a(51);
        }
        return GemSearchUtil.findGem(module2, gemName);
    }

    public Element getState() {
        long l2 = v ^ 0x5F5F52998A99L;
        Element element = new Element(h);
        if (this.k.isEmpty()) {
            return element;
        }
        element.setAttribute(m, String.valueOf(4));
        for (Map.Entry entry : this.k.entrySet()) {
            Element element2 = new Element(i);
            element2.setAttribute(n, (String)entry.getKey());
            Collection collection = (Collection)entry.getValue();
            for (GemBox gemBox : collection) {
                element2.addContent(gemBox.getState());
            }
            element.addContent(element2);
        }
        return element;
    }

    public void loadState(@NotNull Element state2) {
        long l2 = v ^ 0x1C2E56557DCEL;
        if (state2 == null) {
            GemManager.a(52);
        }
        this.k.clear();
        this.t.clear();
        String string = state2.getAttributeValue(m);
        this.d = string != null ? Integer.valueOf(string) : -1;
        for (Object e10 : state2.getContent((Filter)new ElementFilter())) {
            Element element = (Element)e10;
            String string2 = element.getAttributeValue(n);
            Sdk sdk = string2 == null ? null : this.l.findJdk(string2);
            if (sdk == null) continue;
            for (Object e11 : element.getContent((Filter)new ElementFilter())) {
                GemBox gemBox = GemBox.create(sdk, (Element)e11);
                if (gemBox == null) continue;
                this.k.put((Object)string2, (Object)gemBox);
                this.t.put((Object)gemBox.getUrl(), (Object)gemBox);
            }
        }
        this.d();
    }

    private void d() {
        Object object;
        Object object22;
        Set set = ContainerUtil.map2Set((Collection)this.t.keySet(), string -> {
            String string2 = VfsUtilCore.urlToPath((String)string);
            return SystemInfo.isWindows ? StringUtil.toUpperCase((String)string2.substring(0, 3)) : string2;
        });
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object22 : set) {
            if (this.p.containsKey(object22)) continue;
            arrayList.add(object22);
        }
        ArrayList arrayList2 = new ArrayList();
        object22 = this.p.entrySet().iterator();
        while (object22.hasNext()) {
            object = (Map.Entry)object22.next();
            if (set.contains(object.getKey()) || object.getValue() == null) continue;
            arrayList2.add(object.getValue());
            object22.remove();
        }
        object22 = LocalFileSystem.getInstance().replaceWatchedRoots((Collection)arrayList2, arrayList, null);
        object = object22.iterator();
        while (object.hasNext()) {
            LocalFileSystem.WatchRequest watchRequest = (LocalFileSystem.WatchRequest)object.next();
            this.p.put(watchRequest.getRootPath(), watchRequest);
        }
    }

    private static void a(@NotNull ModifiableRootModel modifiableRootModel, @NotNull LibraryTable.ModifiableModel modifiableModel, @NotNull GemInfo gemInfo, @NotNull Set<? super String> set) {
        LibraryOrderEntry libraryOrderEntry;
        LibraryTable.ModifiableModel modifiableModel2;
        long l2 = v ^ 0x2721B235FB9L;
        if (modifiableRootModel == null) {
            GemManager.a(53);
        }
        if (modifiableModel == null) {
            GemManager.a(54);
        }
        if (gemInfo == null) {
            GemManager.a(55);
        }
        if (set == null) {
            GemManager.a(56);
        }
        if (gemInfo.isFromPath() && (modifiableModel2 = Arrays.asList(modifiableRootModel.getContentRoots())).contains(gemInfo.getFile())) {
            return;
        }
        modifiableModel2 = modifiableRootModel.getModuleLibraryTable().getModifiableModel();
        Library library = gemInfo.getLibrary(modifiableModel2);
        if (library != null) {
            set.add(gemInfo.getLibraryName());
            return;
        }
        if (gemInfo instanceof FrozenGemInfo) {
            gemInfo.createLibrary(modifiableModel2);
            set.add(gemInfo.getLibraryName());
            return;
        }
        library = gemInfo.getLibrary(modifiableModel);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            assert (library != null);
            libraryOrderEntry = library.getFiles(OrderRootType.CLASSES);
            assert (((LibraryOrderEntry)libraryOrderEntry).length >= 1 || o.contains(gemInfo.getName())) : "Roots: " + Arrays.asList(libraryOrderEntry) + "; Gem to add: " + gemInfo;
            for (LibraryOrderEntry libraryOrderEntry2 : libraryOrderEntry) {
                assert (libraryOrderEntry2.isValid());
            }
        }
        if (library != null) {
            libraryOrderEntry = modifiableRootModel.addLibraryEntry(library);
            libraryOrderEntry.setScope(DependencyScope.PROVIDED);
        }
        set.add(gemInfo.getLibraryName());
    }

    public void flushLibrariesIfNeeded(@Nullable Project project) {
        if (this.s && project != null) {
            ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(() -> this.flushLibraries());
        }
    }

    @NotNull
    public List<GemInfo> getAllGems(@Nullable Sdk sdk, @Nullable String name) {
        if (sdk == null || name == null) {
            List<GemInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                GemManager.a(57);
            }
            return list2;
        }
        ArrayList<GemInfo> arrayList = new ArrayList<GemInfo>();
        Collection collection = this.k.get((Object)sdk.getName());
        if (collection != null) {
            for (GemBox gemBox : collection) {
                assert (gemBox != null);
                arrayList.addAll(gemBox.findGem(name, null));
            }
        }
        ArrayList<GemInfo> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GemManager.a(58);
        }
        return arrayList2;
    }

    private static void a(VirtualFile virtualFile) {
        GemManager.a(virtualFile, null);
    }

    private static void a(VirtualFile virtualFile, @Nullable Project project) {
        THashSet tHashSet = new THashSet();
        for (ModuleGemProvider moduleGemProvider : ModuleGemProvider.EP_NAME.getExtensionList()) {
            if (!(moduleGemProvider instanceof DirectoryGemsProvider)) continue;
            DirectoryGemsProvider directoryGemsProvider = (DirectoryGemsProvider)moduleGemProvider;
            tHashSet.addAll(directoryGemsProvider.invalidateCaches(virtualFile));
        }
        GemManager.a((Set<? extends VirtualFile>)tHashSet, project);
    }

    public static void updateGemset(@NotNull Module module2) {
        if (module2 == null) {
            GemManager.a(59);
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
        GemManager.getInstance().refresh(sdk);
        ModifiableRootModel modifiableRootModel = GemModificationUtil.getModuleModifiableModel(module2);
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (GemManager.updateGemset(modifiableRootModel, sdk)) {
                GemModificationUtil.commitModuleModifiableModel(modifiableRootModel);
                GemManager.a(module2, modifiableRootModel.getOrderEntries(), sdk, new HashSet<GemInfo>());
                GemManager.d(module2);
            } else {
                GemModificationUtil.disposeModuleModifiableModel(modifiableRootModel);
            }
        });
    }

    public static boolean updateGemset(@NotNull ModifiableRootModel moduleRootModel, @Nullable Sdk sdk) {
        boolean bl2;
        if (moduleRootModel == null) {
            GemManager.a(60);
        }
        Set<String> set = GemManager.b(moduleRootModel);
        Module module2 = moduleRootModel.getModule();
        Set<GemInfo> set2 = GemManager.a(sdk, module2);
        GemManager.a(moduleRootModel, (Set<? extends GemInfo>)Sets.filter(set2, b), set);
        Set<String> set3 = GemManager.a(moduleRootModel, set2);
        boolean bl3 = bl2 = !Sets.symmetricDifference(set, set3).isEmpty();
        if (bl2) {
            RubyStubBuilderService.getInstance().requestStubsUpdate(module2, set2);
        }
        module2.putUserData(f, null);
        return bl2;
    }

    public static void removeAllGemLibraries() {
        WriteCommandAction.runWriteCommandAction(null, () -> {
            long l2 = v ^ 0x3EBDC2CF243DL;
            u.debug("Removing all gem libraries");
            LibraryTable.ModifiableModel modifiableModel = GemModificationUtil.getLibraryTableModifiableModel();
            for (Library library : modifiableModel.getLibraries()) {
                String string = library.getName();
                if (string == null || !string.endsWith("[gem]")) continue;
                u.debug("Removing library: ", new Object[]{library});
                modifiableModel.removeLibrary(library);
            }
            modifiableModel.commit();
        });
    }

    @NotNull
    private static Set<String> a(@NotNull ModifiableRootModel modifiableRootModel, @NotNull Set<? extends GemInfo> set) {
        if (modifiableRootModel == null) {
            GemManager.a(61);
        }
        if (set == null) {
            GemManager.a(62);
        }
        LibraryTable.ModifiableModel modifiableModel = GemModificationUtil.getLibraryTableModifiableModel();
        HashSet<String> hashSet = new HashSet<String>();
        for (GemInfo gemInfo : set) {
            GemManager.a(modifiableRootModel, modifiableModel, gemInfo, hashSet);
        }
        GemModificationUtil.disposeLibraryTableModifiableModel(modifiableModel);
        HashSet<String> hashSet2 = hashSet;
        if (hashSet2 == null) {
            GemManager.a(63);
        }
        return hashSet2;
    }

    private static boolean a(@NotNull Collection<? extends GemInfo> collection, @NotNull GemInfo gemInfo) {
        if (collection == null) {
            GemManager.a(64);
        }
        if (gemInfo == null) {
            GemManager.a(65);
        }
        for (GemInfo gemInfo2 : collection) {
            String string;
            String string2 = string = gemInfo2 instanceof FrozenGemInfo ? ((FrozenGemInfo)gemInfo2).getUnfrozenVersion() : gemInfo2.getVersion();
            if (!GemSearchUtil.hasSameNameAndVersion(gemInfo2.getName(), string, gemInfo)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Set<GemInfo> a(@Nullable Sdk sdk, @NotNull Module module2) {
        VirtualFile virtualFile;
        if (module2 == null) {
            GemManager.a(66);
        }
        if ((virtualFile = BundlerUtil.getGemfile(module2)) != null) {
            GemManager.a(virtualFile, module2.getProject());
        }
        ModuleGemInfrastructure moduleGemInfrastructure = ModuleGemInfrastructure.getInstance(module2);
        Set<GemInfo> set = moduleGemInfrastructure.getModuleRequiredGems(GemManager.addModuleGems(module2, Sets.newHashSet()));
        TreeSet treeSet = Sets.newTreeSet((Comparator)new GemComparator());
        for (GemInfo gemInfo : moduleGemInfrastructure.getModuleRequiredGems(GemManager.getInstance().getAllGems(sdk, module2))) {
            if (GemManager.a(set, gemInfo)) continue;
            treeSet.add(gemInfo);
        }
        treeSet.addAll(set);
        TreeSet treeSet2 = treeSet;
        if (treeSet2 == null) {
            GemManager.a(67);
        }
        return treeSet2;
    }

    @NotNull
    private static Set<String> b(@NotNull ModifiableRootModel modifiableRootModel) {
        long l2 = v ^ 0x31C5079BF6A5L;
        if (modifiableRootModel == null) {
            GemManager.a(68);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (OrderEntry orderEntry : modifiableRootModel.getOrderEntries()) {
            String string;
            if (orderEntry instanceof LibraryOrderEntry) {
                string = ((LibraryOrderEntry)orderEntry).getLibraryName();
                if (string == null || !string.startsWith("[gem]") && !string.endsWith("[gem]")) continue;
                hashSet.add(string);
                modifiableRootModel.removeOrderEntry(orderEntry);
                continue;
            }
            if (!(orderEntry instanceof ModuleOrderEntry)) continue;
            string = (ModuleOrderEntry)orderEntry;
            if (!RModuleUtil.getInstance().isRubyModule(string.getModule())) continue;
            hashSet.add(string.getModuleName());
            modifiableRootModel.removeOrderEntry(orderEntry);
        }
        HashSet<String> hashSet2 = hashSet;
        if (hashSet2 == null) {
            GemManager.a(69);
        }
        return hashSet2;
    }

    @NotNull
    private static Map<String, String> a(LibraryTable.ModifiableModel modifiableModel) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Library library : modifiableModel.getLibraries()) {
            String string = library.getName();
            if (library instanceof LibraryEx) {
                LibraryEx libraryEx = (LibraryEx)library;
                if (libraryEx.getProperties() instanceof RubyLibraryProperties) {
                    hashMap.put(string, ((RubyLibraryProperties)libraryEx.getProperties()).getVersion());
                    continue;
                }
                hashMap.put(string, "0");
                continue;
            }
            hashMap.put(string, "0");
        }
        HashMap<String, String> hashMap2 = hashMap;
        if (hashMap2 == null) {
            GemManager.a(70);
        }
        return hashMap2;
    }

    public boolean needsLibraryUpdate() {
        return this.d != 4;
    }

    public static void addGemsForSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            GemManager.a(71);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Set<String> set = GemUtil.determineGemUrlsForSDK(sdk);
            GemManager.a(() -> GemManager.getInstance().addGemsForSdk(sdk, set, false));
        });
    }

    static {
        v = com.jetbrains.python.psi.c.a(9060055184549408554L, 7691934560197258647L, MethodHandles.lookup().lookupClass()).a(59852699008546L);
        long l2 = v ^ 0x72E3FA132F50L;
        u = Logger.getInstance(GemManager.class);
        o = ContainerUtil.newHashSet((Object[])new String[]{"rails", "ffi"});
        f = new Key("moduleGemset");
        GEMSET_CHANGED_TOPIC = Topic.create((String)"gemset changed", GemSetListener.class);
        MODULE_GEMS_CHANGED_TOPIC = Topic.create((String)"module gems changed", ModuleGemsListener.class);
        b = gemInfo -> gemInfo != null && gemInfo.isFromPath();
        r = Boolean.parseBoolean(System.getProperty(e));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = v ^ 0x7AAF8A207834L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 50: 
            case 57: 
            case 58: 
            case 63: 
            case 67: 
            case 69: 
            case 70: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 50: 
            case 57: 
            case 58: 
            case 63: 
            case 67: 
            case 69: 
            case 70: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModifiableModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualGems";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldModuleLibraries";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 7: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 50: 
            case 57: 
            case 58: 
            case 63: 
            case 67: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gem";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root2ModuleMap";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkName";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 28: 
            case 40: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = n;
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSdk";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsets";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedRoots";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 51: 
            case 59: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locker";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 53: 
            case 60: 
            case 61: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRootModel";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalLibrariesModel";
                break;
            }
            case 55: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemToAdd";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gems";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot2ModuleMap";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsetSdkGemboxes";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootGemsToShow";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootGemBoxes";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "filterGemsetBoxes";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getRbenvSdkWithGemsetsGems";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getRbenvGemsetGems";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllGems";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getGems";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkBoxes";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "addModuleGems";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "addLibraries";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsToAdd";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanupOldLibraries";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryName2VersionMap";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runInEDT";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addRemovePathBasedGems";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isModuleLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRoot2ModuleMap";
                break;
            }
            case 7: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 50: 
            case 57: 
            case 58: 
            case 63: 
            case 67: 
            case 69: 
            case 70: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findModuleForGem";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeGemsForSdk";
                break;
            }
            case 11: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "addGemsForSdk";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "flushLibraries";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cleanOldBoxes";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateLibraries";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRootGemBoxes";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRbenvSdkWithGemsetsGems";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSdkBoxes";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "fireGemSetChanged";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleGemsChanged";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getAllGems";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "calculateDependency";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addModuleGems";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findGem";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "addLibrary";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "updateGemset";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "addLibraries";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "alreadyAdded";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getGemsToAdd";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "cleanupOldLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 50: 
            case 57: 
            case 58: 
            case 63: 
            case 67: 
            case 69: 
            case 70: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ModuleGemsListener {
        public void gemsChanged();
    }

    public static interface GemSetListener {
        public void gemSetChanged();
    }
}

