/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemBoxState;
import org.jetbrains.plugins.ruby.gem.GemDataContext;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.GemsDataKeys;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.implementation.RubyImplementationHandler;

public class GemBox {
    public static final String DEFAULT_GEM_SUMMARY_SUFFIX = " is bundled with Ruby";
    private static final Logger b;
    @NonNls
    private static final String a = "url";
    @NonNls
    private static final String f = "box";
    private static final String c = "@global";
    private static boolean d;
    private final GemBoxState e;
    @NotNull
    private final Sdk h;
    @NotNull
    private final String g;
    private static final long i;

    public GemBox(@NotNull Sdk sdk, @NotNull String gemUrl) {
        if (sdk == null) {
            GemBox.a(0);
        }
        if (gemUrl == null) {
            GemBox.a(1);
        }
        this(sdk, gemUrl, true);
    }

    private GemBox(@NotNull Sdk sdk, @NotNull String gemUrl, boolean update) {
        if (sdk == null) {
            GemBox.a(2);
        }
        if (gemUrl == null) {
            GemBox.a(3);
        }
        this.e = new GemBoxState();
        this.h = sdk;
        this.g = gemUrl;
        if (update) {
            this.updateGems();
        }
    }

    @NotNull
    public static String getDefaultGemName(@NotNull VirtualFile gemFile) {
        String string;
        int n2;
        if (gemFile == null) {
            GemBox.a(4);
        }
        String string2 = GemBox.a(n2 = (string = gemFile.getNameWithoutExtension()).lastIndexOf("-"), string) ? string.substring(0, n2) : string;
        if (string2 == null) {
            GemBox.a(5);
        }
        return string2;
    }

    @Nullable
    public static String getDefaultGemVersion(@NotNull VirtualFile gemFile) {
        String string;
        int n2;
        if (gemFile == null) {
            GemBox.a(6);
        }
        return GemBox.a(n2 = (string = gemFile.getNameWithoutExtension()).lastIndexOf("-"), string) ? string.substring(n2 + 1) : null;
    }

    private static boolean a(int n2, String string) {
        long l2 = i ^ 0x2B6326421621L;
        return n2 >= 0 && StringUtil.containsAnyChar((String)string.substring(n2 + 1), (String)"0123456789");
    }

    public String getUrl() {
        return this.g;
    }

    public void updateGems() {
        VirtualFile virtualFile = this.getRoot();
        this.e.doWrite((map2, set) -> {
            set.addAll(map2.values());
            ContainerUtil.filter(map2.values(), gemInfo -> !gemInfo.isValid()).forEach(gemInfo -> {
                GemInfo cfr_ignored_0 = (GemInfo)map2.remove(gemInfo.getUrl());
            });
            if (virtualFile == null) {
                return;
            }
            ContainerUtil.filter((Object[])virtualFile.getChildren(), virtualFile -> !map2.containsKey(virtualFile.getUrl())).forEach(this::addGem);
            this.a(virtualFile, (Map<String, GemInfo>)map2);
        });
    }

    private void a(@NotNull VirtualFile virtualFile, @NotNull Map<String, GemInfo> map2) {
        long l2 = i ^ 0x1112F7164282L;
        if (virtualFile == null) {
            GemBox.a(7);
        }
        if (map2 == null) {
            GemBox.a(8);
        }
        b.debug("Looking for default gems in ", new Object[]{this.g, " for ", this.h});
        LanguageLevel languageLevel = RubyLanguageLevelPusher.getEffectiveLanguageLevel(this.h);
        if (languageLevel.isLessThan(LanguageLevel.RUBY20)) {
            b.debug("Too low language level: ", new Object[]{languageLevel});
            return;
        }
        VirtualFile virtualFile2 = GemUtil.getSpecFolder(virtualFile);
        if (virtualFile2 == null) {
            b.debug("No spec folder for ", new Object[]{virtualFile});
            return;
        }
        VirtualFile virtualFile3 = virtualFile2.findChild("default");
        if (virtualFile3 == null || !virtualFile3.isDirectory()) {
            b.debug("No default subfolder in specs root: ", new Object[]{virtualFile2});
            return;
        }
        RbConfig rbConfig = RbConfig.from(this.h);
        if (rbConfig == null) {
            b.warn("Sdk without RbConfig " + this.h);
            return;
        }
        PathMappingSettings pathMappingSettings = RubyRunner.notNullFrom(this.h).addDefaultMappings(null);
        List list2 = RubyImplementationHandler.notNullFrom(this.h).getLoadPath().stream().map(string -> VfsUtil.findFileByIoFile((File)new File(pathMappingSettings.convertToLocal(string)), (boolean)true)).filter(Objects::nonNull).collect(Collectors.toList());
        if (list2.isEmpty()) {
            b.warn("Empty loadpath in " + this.h);
            return;
        }
        b.debug("Processing default specs folder: ", new Object[]{virtualFile3});
        b.debug("Loadpaths for: ", new Object[]{this.h, "; ", list2});
        for (VirtualFile virtualFile4 : virtualFile3.getChildren()) {
            VirtualFile virtualFile5;
            String string2;
            String string3 = GemBox.getDefaultGemName(virtualFile4);
            if ("test-unit".equals(string3) || (string2 = GemBox.getDefaultGemVersion(virtualFile4)) == null) continue;
            GemDataContext gemDataContext = new GemDataContext();
            gemDataContext.putData(GemsDataKeys.NAME, string3);
            gemDataContext.putData(GemsDataKeys.VERSION, string2);
            gemDataContext.putData(GemsDataKeys.SUMMARY, "This " + string3 + DEFAULT_GEM_SUMMARY_SUFFIX);
            gemDataContext.putData(GemsDataKeys.SDK, this.h);
            gemDataContext.putData(GemsDataKeys.FROM_PATH, false);
            VirtualFile virtualFile6 = null;
            String string4 = FileUtil.toSystemIndependentName((String)FileUtil.join((String[])string3.split("-")));
            Object object = list2.iterator();
            while (object.hasNext() && (virtualFile6 = (virtualFile5 = (VirtualFile)object.next()).findFileByRelativePath(string4)) == null) {
            }
            if (virtualFile6 != null) {
                object = GemInfo.create(gemDataContext, virtualFile6.getUrl(), null);
                if (object != null) {
                    map2.put(((GemInfo)object).getUrl(), (GemInfo)object);
                    b.debug("Found gem ", new Object[]{object, " in ", virtualFile6});
                    continue;
                }
                b.debug("Could not create a geminfo for ", new Object[]{gemDataContext, " and ", virtualFile6});
                continue;
            }
            b.debug("Unable to find a library file for gem ", new Object[]{string3, " relative path ", string4});
        }
    }

    @Nullable
    public VirtualFile getRoot() {
        VirtualFile virtualFile;
        boolean bl2 = d || !ApplicationManager.getApplication().isUnitTestMode();
        VirtualFile virtualFile2 = virtualFile = bl2 ? VirtualFileManager.getInstance().refreshAndFindFileByUrl(this.g) : VirtualFileManager.getInstance().findFileByUrl(this.g);
        if (bl2 && virtualFile != null && virtualFile.isValid()) {
            virtualFile.refresh(false, true);
        }
        return virtualFile;
    }

    public void unregisterLibraries(LibraryTable.ModifiableModel model) {
        long l2 = i ^ 0x575D916F5BA8L;
        b.debug("Removing all libraries for: ", new Object[]{this.g, "; ", this.h});
        this.getAllGems().forEach(gemInfo -> gemInfo.removeLibrary(model));
    }

    public Collection<GemInfo> getAllGems() {
        return this.e.compute((map2, set) -> new ArrayList(map2.values()));
    }

    public static void updateLibraries(@NotNull LibraryTable.ModifiableModel model, @NotNull Map<String, String> name2SourceRoots, @NotNull Collection<? extends GemBox> gemBoxes) {
        if (model == null) {
            GemBox.a(9);
        }
        if (name2SourceRoots == null) {
            GemBox.a(10);
        }
        if (gemBoxes == null) {
            GemBox.a(11);
        }
        MultiMap multiMap = new MultiMap();
        MultiMap multiMap2 = new MultiMap();
        for (GemBox gemBox : gemBoxes) {
            gemBox.e.doWrite((map2, set) -> {
                map2.values().forEach(gemInfo -> multiMap2.putValue((Object)gemInfo.getLibraryName(), gemInfo));
                set.forEach(gemInfo -> multiMap.putValue((Object)gemInfo.getLibraryName(), gemInfo));
                set.clear();
            });
        }
        multiMap.keySet().stream().filter(string -> !multiMap2.containsKey(string)).map(string -> model.getLibraryByName(string)).filter(Objects::nonNull).forEach(library -> {
            long l2 = i ^ 0x3C276DCB8D9FL;
            b.debug("Removing library: ", new Object[]{library});
            model.removeLibrary(library);
        });
        multiMap2.entrySet().stream().map(entry -> GemBox.a((Collection)entry.getValue())).forEach(gemInfo -> GemBox.a(model, name2SourceRoots, gemInfo));
    }

    public Element getState() {
        long l2 = i ^ 0x606F4067332BL;
        Element element = new Element(f);
        element.setAttribute(a, this.g);
        this.getAllGems().stream().map(GemInfo::getState).forEach(arg_0 -> ((Element)element).addContent(arg_0));
        return element;
    }

    @Nullable
    public static GemBox create(@NotNull Sdk sdk, @NotNull Element element) {
        long l2 = i ^ 0x5ABAFB5633F2L;
        if (sdk == null) {
            GemBox.a(12);
        }
        if (element == null) {
            GemBox.a(13);
        }
        String string = element.getAttributeValue(a);
        if (!Comparing.strEqual((String)element.getName(), (String)f) || string == null) {
            return null;
        }
        GemBox gemBox = new GemBox(sdk, string, false);
        gemBox.e.doWrite((map2, set) -> {
            for (Object e10 : element.getContent((Filter)new ElementFilter())) {
                GemInfo gemInfo = GemInfo.create(sdk, (Element)e10);
                if (gemInfo == null) continue;
                map2.put(gemInfo.getUrl(), gemInfo);
            }
        });
        return gemBox;
    }

    public Collection<GemInfo> findGem(@NotNull String gemName, @Nullable String gemVersion) {
        if (gemName == null) {
            GemBox.a(14);
        }
        HashSet<GemInfo> hashSet = new HashSet<GemInfo>();
        for (GemInfo gemInfo : this.getAllGems()) {
            if (!Comparing.strEqual((String)gemInfo.getName(), (String)gemName)) continue;
            if (gemVersion != null) {
                if (!Comparing.strEqual((String)gemInfo.getVersion(), (String)gemVersion)) continue;
                return Collections.singletonList(gemInfo);
            }
            hashSet.add(gemInfo);
        }
        return hashSet;
    }

    public void addGem(VirtualFile file) {
        this.e.doWrite((map2, set) -> GemInfo.create(this.h, file).forEach(gemInfo -> map2.put(gemInfo.getUrl(), gemInfo)));
    }

    public void removeGem(VirtualFile file) {
        this.e.doWrite((map2, set) -> {
            String string = file.getUrl();
            GemInfo gemInfo = (GemInfo)map2.get(string);
            if (gemInfo != null) {
                this.b(gemInfo);
            } else {
                String[] stringArray;
                for (String string2 : stringArray = ArrayUtilRt.toStringArray(map2.keySet())) {
                    if (!string2.startsWith(string)) continue;
                    this.b((GemInfo)map2.get(string2));
                }
            }
        });
    }

    private void b(GemInfo gemInfo) {
        this.e.doWrite((map2, set) -> {
            map2.remove(gemInfo.getUrl());
            set.add(gemInfo);
        });
    }

    @NotNull
    private static GemInfo a(@NotNull Collection<? extends GemInfo> collection) {
        if (collection == null) {
            GemBox.a(15);
        }
        GemInfo gemInfo3 = Collections.min(collection, (gemInfo, gemInfo2) -> {
            long l2 = i ^ 0x7C413B3F3F1DL;
            int n2 = Boolean.compare(gemInfo.getRequirePaths().isEmpty(), gemInfo2.getRequirePaths().isEmpty());
            if (n2 != 0) {
                return n2;
            }
            n2 = Boolean.compare(gemInfo.getUrl().contains(c), gemInfo2.getUrl().contains(c));
            if (n2 != 0) {
                return n2;
            }
            return gemInfo.getUrl().compareTo(gemInfo2.getUrl());
        });
        if (gemInfo3 == null) {
            GemBox.a(16);
        }
        return gemInfo3;
    }

    private static void a(@NotNull LibraryTable.ModifiableModel modifiableModel, @NotNull Map<String, String> map2, @NotNull GemInfo gemInfo) {
        String string;
        if (modifiableModel == null) {
            GemBox.a(17);
        }
        if (map2 == null) {
            GemBox.a(18);
        }
        if (gemInfo == null) {
            GemBox.a(19);
        }
        if (map2.getOrDefault(string = gemInfo.getLibraryName(), "0") != "4") {
            gemInfo.createLibrary(modifiableModel);
            map2.put(string, "4");
        }
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        GemBox gemBox = (GemBox)o2;
        if (!this.h.equals(gemBox.h)) {
            return false;
        }
        return this.g.equals(gemBox.g);
    }

    public int hashCode() {
        int n2 = this.h.hashCode();
        n2 = 31 * n2 + this.g.hashCode();
        return n2;
    }

    public static void enforceRefreshInTests(boolean value) {
        d = value;
    }

    static {
        i = com.jetbrains.python.psi.c.a(4609626710701261135L, -1821414871845850088L, MethodHandles.lookup().lookupClass()).a(95638111852537L);
        b = Logger.getInstance(GemBox.class);
        d = false;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = i ^ 0x7E68603FEAA9L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 16: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemUrl";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFile";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemBox";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemBoxRoot";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsMap";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2SourceRoots";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemBoxes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gems";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gem";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemBox";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultGemName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseBestGem";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultGemName";
                break;
            }
            case 5: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultGemVersion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultGems";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateLibraries";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findGem";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "chooseBestGem";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateLibraryByGemInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

