/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ex.CustomEditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.imports.OptimizeImportsQuickFix;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.inspections.PyPep8Inspection;
import com.jetbrains.python.inspections.quickfix.PyFillParagraphFix;
import com.jetbrains.python.inspections.quickfix.ReformatFix;
import com.jetbrains.python.inspections.quickfix.RemoveTrailingBlankLinesFix;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyFileImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.validation.Pep8ProblemSuppressor;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Pep8ExternalAnnotator
extends ExternalAnnotator<State, Results> {
    private static final String e = "E121,E123,E126,E226,E24,E704,W503,W504";
    private static final Logger b;
    private static final Pattern c;
    private boolean a;
    private static final Pattern d;
    private static final long f;

    @Nullable
    public State collectInformation(@NotNull PsiFile file) {
        HighlightDisplayKey highlightDisplayKey;
        VirtualFile virtualFile;
        long l2 = f ^ 0x47C1B6D22BE2L;
        if (file == null) {
            Pep8ExternalAnnotator.a(0);
        }
        if ((virtualFile = file.getVirtualFile()) == null || virtualFile.getFileType() != PythonFileType.INSTANCE) {
            return null;
        }
        Sdk sdk = PythonSdkType.findLocalCPython(ModuleUtilCore.findModuleForPsiElement((PsiElement)file));
        if (sdk == null) {
            if (!this.a) {
                this.a = true;
                Pep8ExternalAnnotator.a();
            }
            return null;
        }
        String string = sdk.getHomePath();
        if (string == null) {
            if (!this.a) {
                this.a = true;
                b.info("Could not find home path for interpreter " + string);
            }
            return null;
        }
        InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)file.getProject()).getCurrentProfile();
        if (!inspectionProfileImpl.isToolEnabled(highlightDisplayKey = HighlightDisplayKey.find((String)"PyPep8Inspection"), (PsiElement)file)) {
            return null;
        }
        if (file instanceof PyFileImpl && !((PyFileImpl)file).isAcceptedFor(PyPep8Inspection.class)) {
            return null;
        }
        PyPep8Inspection pyPep8Inspection = (PyPep8Inspection)inspectionProfileImpl.getUnwrappedTool(PyPep8Inspection.KEY.toString(), (PsiElement)file);
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((PsiFile)file);
        PyCodeStyleSettings pyCodeStyleSettings = (PyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PyCodeStyleSettings.class);
        ArrayList arrayList = Lists.newArrayList(pyPep8Inspection.ignoredErrors);
        if (!pyCodeStyleSettings.SPACE_AFTER_NUMBER_SIGN) {
            arrayList.add("E262");
            arrayList.add("E265");
        }
        if (!pyCodeStyleSettings.SPACE_BEFORE_NUMBER_SIGN) {
            arrayList.add("E261");
        }
        return new State(string, file.getText(), inspectionProfileImpl.getErrorLevel(highlightDisplayKey, (PsiElement)file), arrayList, codeStyleSettings.getRightMargin((Language)PythonLanguage.getInstance()), pyCodeStyleSettings.HANG_CLOSING_BRACKETS);
    }

    private static void a() {
        long l2 = f ^ 0x52278C4B8D73L;
        b.info("Found no suitable interpreter to run pycodestyle.py. Available interpreters are: [");
        List<Sdk> list2 = PythonSdkType.getAllSdks();
        Collections.sort(list2, PreferredSdkComparator.INSTANCE);
        for (Sdk sdk : list2) {
            b.info("  Path: " + sdk.getHomePath() + "; Flavor: " + PythonSdkFlavor.getFlavor(sdk) + "; Remote: " + PythonSdkType.isRemote(sdk));
        }
        b.info("]");
    }

    @Nullable
    public Results doAnnotate(State collectedInfo) {
        long l2 = f ^ 0x6E5815DDBF6FL;
        if (collectedInfo == null) {
            return null;
        }
        ArrayList arrayList = Lists.newArrayList();
        if (!collectedInfo.b.isEmpty()) {
            arrayList.add("--ignore=E121,E123,E126,E226,E24,E704,W503,W504," + StringUtil.join((Collection)collectedInfo.b, (String)","));
        }
        if (collectedInfo.d) {
            arrayList.add("--hang-closing");
        }
        arrayList.add("--max-line-length=" + collectedInfo.e);
        arrayList.add("-");
        GeneralCommandLine generalCommandLine = PythonHelper.PYCODESTYLE.newCommandLine(collectedInfo.f, (List<String>)arrayList);
        ProcessOutput processOutput = PySdkUtil.getProcessOutput(generalCommandLine, new File(collectedInfo.f).getParent(), (Map<String, String>)ImmutableMap.of((Object)"PYTHONBUFFERED", (Object)"1"), 10000, collectedInfo.c.getBytes(StandardCharsets.UTF_8), false);
        Results results = new Results(collectedInfo.a);
        if (processOutput.isTimeout()) {
            b.info("Timeout running pycodestyle.py");
            return results;
        }
        if (!processOutput.getStderr().isEmpty() && ((ApplicationInfoImpl)ApplicationInfo.getInstance()).isEAP()) {
            b.info("Error running pycodestyle.py: " + processOutput.getStderr());
        }
        for (String string : processOutput.getStdoutLines()) {
            ContainerUtil.addIfNotNull(results.problems, (Object)Pep8ExternalAnnotator.a(string));
        }
        return results;
    }

    public void apply(@NotNull PsiFile file, Results annotationResult, @NotNull AnnotationHolder holder) {
        long l2 = f ^ 0x299485964C2DL;
        if (file == null) {
            Pep8ExternalAnnotator.a(1);
        }
        if (holder == null) {
            Pep8ExternalAnnotator.a(2);
        }
        if (annotationResult == null || !file.isValid()) {
            return;
        }
        String string = file.getText();
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        for (Problem problem : annotationResult.problems) {
            PsiElement psiElement;
            int n2 = problem.d - 1;
            int n3 = problem.a - 1;
            int n4 = document != null ? (n2 >= document.getLineCount() ? document.getTextLength() - 1 : document.getLineStartOffset(n2) + n3) : StringUtil.lineColToOffset((CharSequence)string, (int)n2, (int)n3);
            PsiElement psiElement2 = file.findElementAt(n4);
            if (!(psiElement2 instanceof PsiWhiteSpace) && problem.c.startsWith("E3") && (psiElement = file.findElementAt(Math.max(0, n4 - 1))) instanceof PsiWhiteSpace) {
                psiElement2 = psiElement;
            }
            if (psiElement2 == null && document != null && n4 == document.getTextLength() && problem.c.equals("W292")) {
                psiElement2 = file.findElementAt(Math.max(0, n4 - 1));
            }
            if (Pep8ExternalAnnotator.a(file, problem, psiElement2) || Pep8ExternalAnnotator.a(problem, file, psiElement2) || psiElement2 == null || problem.c.equals("E701") && psiElement2.getNode().getElementType() == PyTokenTypes.COLON && psiElement2.getParent() instanceof PyAnnotation) continue;
            psiElement = psiElement2.getTextRange();
            if (Pep8ExternalAnnotator.a(document, string, (TextRange)psiElement)) {
                int n5 = document != null ? (n2 >= document.getLineCount() ? document.getTextLength() - 1 : document.getLineEndOffset(n2)) : StringUtil.lineColToOffset((CharSequence)string, (int)(n2 + 1), (int)0) - 1;
                if (n4 > n5) continue;
                psiElement = new TextRange(n4, n5);
            }
            boolean bl2 = ApplicationManager.getApplication().isInternal();
            String string2 = "PEP 8: " + (bl2 ? problem.c + " " : "") + problem.b;
            Annotation annotation = annotationResult.a == HighlightDisplayLevel.ERROR ? holder.createErrorAnnotation((TextRange)psiElement, string2) : (annotationResult.a == HighlightDisplayLevel.WARNING ? holder.createWarningAnnotation((TextRange)psiElement, string2) : holder.createWeakWarningAnnotation((TextRange)psiElement, string2));
            if (problem.c.equals("E401")) {
                annotation.registerUniversalFix((IntentionAction)new OptimizeImportsQuickFix(), null, null);
            } else if (problem.c.equals("W391")) {
                annotation.registerUniversalFix((IntentionAction)new RemoveTrailingBlankLinesFix(), null, null);
            } else if (problem.c.equals("E501")) {
                annotation.registerFix((IntentionAction)new PyFillParagraphFix());
            } else {
                annotation.registerUniversalFix((IntentionAction)new ReformatFix(), null, null);
            }
            annotation.registerFix((IntentionAction)new IgnoreErrorFix(problem.c));
            annotation.registerFix((IntentionAction)new CustomEditInspectionToolsSettingsAction(HighlightDisplayKey.find((String)"PyPep8Inspection"), () -> {
                long l2 = f ^ 0xB534CD3F10FL;
                return "Edit inspection profile setting";
            }));
        }
    }

    private static boolean a(@NotNull Problem problem, @NotNull PsiFile psiFile, @Nullable PsiElement psiElement) {
        if (problem == null) {
            Pep8ExternalAnnotator.a(3);
        }
        if (psiFile == null) {
            Pep8ExternalAnnotator.a(4);
        }
        Pep8ProblemSuppressor[] pep8ProblemSuppressorArray = (Pep8ProblemSuppressor[])Pep8ProblemSuppressor.EP_NAME.getExtensions();
        return Arrays.stream(pep8ProblemSuppressorArray).anyMatch(pep8ProblemSuppressor -> pep8ProblemSuppressor.isProblemSuppressed(problem, psiFile, psiElement));
    }

    private static boolean a(@Nullable Document document, String string, TextRange textRange) {
        int n2 = textRange.getStartOffset();
        int n3 = textRange.getEndOffset();
        if (document != null) {
            return document.getLineNumber(n2) != document.getLineNumber(n3);
        }
        return StringUtil.offsetToLineNumber((CharSequence)string, (int)n2) != StringUtil.offsetToLineNumber((CharSequence)string, (int)n3);
    }

    private static boolean a(PsiFile psiFile, Problem problem, @Nullable PsiElement psiElement) {
        long l2 = f ^ 0x5E994D1300B7L;
        EditorSettingsExternalizable editorSettingsExternalizable = EditorSettingsExternalizable.getInstance();
        if (!editorSettingsExternalizable.getStripTrailingSpaces().equals("None") && (problem.c.equals("W291") || problem.c.equals("W293"))) {
            return true;
        }
        CommonCodeStyleSettings commonCodeStyleSettings = CodeStyle.getLanguageSettings((PsiFile)psiFile, (Language)PythonLanguage.getInstance());
        PyCodeStyleSettings pyCodeStyleSettings = (PyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)psiFile, PyCodeStyleSettings.class);
        if (psiElement instanceof PsiWhiteSpace) {
            Matcher matcher;
            if (problem.c.equals("E303") && (matcher = c.matcher(problem.b)).matches()) {
                boolean bl2;
                int n2 = Integer.parseInt(matcher.group(1));
                PsiElement psiElement2 = PyPsiUtils.getNextNonWhitespaceSibling(psiElement);
                PsiElement psiElement3 = PyPsiUtils.getPrevNonWhitespaceSibling(psiElement);
                boolean bl3 = psiElement3 instanceof PyClass || psiElement2 instanceof PyClass;
                boolean bl4 = bl2 = psiElement3 instanceof PyFunction || psiElement2 instanceof PyFunction;
                if ((bl2 || bl3) && (PyUtil.isTopLevel(psiElement) ? n2 <= pyCodeStyleSettings.BLANK_LINES_AROUND_TOP_LEVEL_CLASSES_FUNCTIONS : bl3 && n2 <= commonCodeStyleSettings.BLANK_LINES_AROUND_CLASS || bl2 && n2 <= commonCodeStyleSettings.BLANK_LINES_AROUND_METHOD)) {
                    return true;
                }
            }
            if (problem.c.equals("E251") && (psiElement.getParent() instanceof PyParameter && pyCodeStyleSettings.SPACE_AROUND_EQ_IN_NAMED_PARAMETER || psiElement.getParent() instanceof PyKeywordArgument && pyCodeStyleSettings.SPACE_AROUND_EQ_IN_KEYWORD_ARGUMENT)) {
                return true;
            }
        }
        return problem.c.equals("W191") && CodeStyle.getIndentOptions((PsiFile)psiFile).USE_TAB_CHARACTER;
    }

    @Nullable
    private static Problem a(String string) {
        long l2 = f ^ 0x1C26924E9748L;
        Matcher matcher = d.matcher(string);
        if (matcher.matches()) {
            int n2 = Integer.parseInt(matcher.group(1));
            int n3 = Integer.parseInt(matcher.group(2));
            return new Problem(n2, n3, matcher.group(3), matcher.group(4));
        }
        if (((ApplicationInfoImpl)ApplicationInfo.getInstance()).isEAP()) {
            b.info("Failed to parse problem line from pycodestyle.py: " + string);
        }
        return null;
    }

    static {
        f = com.jetbrains.python.psi.c.a(-6811572309694458109L, -1009045409762455235L, MethodHandles.lookup().lookupClass()).a(148611585817227L);
        long l2 = f ^ 0x54FC1A2EACBFL;
        b = Logger.getInstance(Pep8ExternalAnnotator.class);
        c = Pattern.compile(".*\\((\\d+)\\)$");
        d = Pattern.compile(".+:(\\d+):(\\d+): ([EW]\\d{3}) (.+)");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = f ^ 0x7338F9A94B94L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/Pep8ExternalAnnotator";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInformation";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoredDueToProblemSuppressors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class IgnoreErrorFix
    implements IntentionAction {
        private final String a;
        private static final long b = com.jetbrains.python.psi.c.a(1108878919826603580L, 7748293571818802785L, MethodHandles.lookup().lookupClass()).a(119147990196753L);

        IgnoreErrorFix(String code) {
            this.a = code;
        }

        @NotNull
        public String getText() {
            long l2 = b ^ 0x77B02F8E2691L;
            if ("Ignore errors like this" == null) {
                IgnoreErrorFix.a(0);
            }
            return "Ignore errors like this";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                IgnoreErrorFix.a(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
            if (project == null) {
                IgnoreErrorFix.a(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                IgnoreErrorFix.a(3);
            }
            InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, inspectionProfileModifiableModel -> {
                long l2 = b ^ 0x659E34E869EEL;
                PyPep8Inspection pyPep8Inspection = (PyPep8Inspection)inspectionProfileModifiableModel.getUnwrappedTool("PyPep8Inspection", (PsiElement)file);
                if (!pyPep8Inspection.ignoredErrors.contains(this.a)) {
                    pyPep8Inspection.ignoredErrors.add(this.a);
                }
            });
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = b ^ 0x41AADF04ED91L;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/validation/Pep8ExternalAnnotator$IgnoreErrorFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/validation/Pep8ExternalAnnotator$IgnoreErrorFix";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Results {
        public final List<Problem> problems = new ArrayList<Problem>();
        private final HighlightDisplayLevel a;

        public Results(HighlightDisplayLevel level) {
            this.a = level;
        }
    }

    public static class State {
        private final String f;
        private final String c;
        private final HighlightDisplayLevel a;
        private final List<String> b;
        private final int e;
        private final boolean d;

        public State(String interpreterPath, String fileText, HighlightDisplayLevel level, List<String> ignoredErrors, int margin, boolean hangClosingBrackets) {
            this.f = interpreterPath;
            this.c = fileText;
            this.a = level;
            this.b = ignoredErrors;
            this.e = margin;
            this.d = hangClosingBrackets;
        }
    }

    public static class Problem {
        private final int d;
        private final int a;
        private final String c;
        private final String b;
        private static final long e = com.jetbrains.python.psi.c.a(8629581413423836820L, -2549554605203634991L, MethodHandles.lookup().lookupClass()).a(20344778643764L);

        public Problem(int line2, int column, @NotNull String code, @NotNull String description) {
            if (code == null) {
                Problem.a(0);
            }
            if (description == null) {
                Problem.a(1);
            }
            this.d = line2;
            this.a = column;
            this.c = code;
            this.b = description;
        }

        public int getLine() {
            return this.d;
        }

        public int getColumn() {
            return this.a;
        }

        @NotNull
        public String getCode() {
            String string = this.c;
            if (string == null) {
                Problem.a(2);
            }
            return string;
        }

        @NotNull
        public String getDescription() {
            String string = this.b;
            if (string == null) {
                Problem.a(3);
            }
            return string;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = e ^ 0x40A6563DF8D5L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/validation/Pep8ExternalAnnotator$Problem";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/validation/Pep8ExternalAnnotator$Problem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

