/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.spellchecker;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.generator.SpellCheckerDictionaryGenerator;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;

public class PythonSpellcheckerDictionaryGenerator
extends SpellCheckerDictionaryGenerator {
    private static final long a = c.a(8574511994166163644L, -606201883419442379L, MethodHandles.lookup().lookupClass()).a(128907207063075L);

    public PythonSpellcheckerDictionaryGenerator(Project project, String dictOutputFolder) {
        long l2 = a ^ 0x54353F5504F2L;
        super(project, dictOutputFolder, "python");
    }

    protected void processFolder(HashSet<String> seenNames, PsiManager manager, VirtualFile folder) {
        if (!this.myExcludedFolders.contains(folder)) {
            String string = folder.getName();
            IdentifierSplitter.getInstance().split(string, TextRange.allOf((String)string), textRange -> {
                String string2 = textRange.substring(string);
                this.addSeenWord(seenNames, string2, Language.ANY);
            });
        }
        super.processFolder(seenNames, manager, folder);
    }

    protected void processFile(PsiFile file, final HashSet<String> seenNames) {
        file.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyFunction(PyFunction node) {
                super.visitPyFunction(node);
                PythonSpellcheckerDictionaryGenerator.this.processLeafsNames(node, seenNames);
            }

            @Override
            public void visitPyClass(PyClass node) {
                super.visitPyClass(node);
                PythonSpellcheckerDictionaryGenerator.this.processLeafsNames((PsiElement)node, seenNames);
            }

            @Override
            public void visitPyTargetExpression(PyTargetExpression node) {
                super.visitPyTargetExpression(node);
                if (PsiTreeUtil.getParentOfType((PsiElement)node, ScopeOwner.class) instanceof PyFile) {
                    PythonSpellcheckerDictionaryGenerator.this.processLeafsNames(node, seenNames);
                }
            }
        });
    }
}

