/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PyCondaRunKt;
import com.jetbrains.python.sdk.flavors.VirtualEnvSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CondaEnvSdkFlavor
extends CPythonSdkFlavor {
    public static final String[] CONDA_DEFAULT_ROOTS;
    public static final CondaEnvSdkFlavor INSTANCE;
    private static final long c;

    private CondaEnvSdkFlavor() {
    }

    @Override
    public Collection<String> suggestHomePaths(@Nullable Module module2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Sdk sdk = (Sdk)ReadAction.compute(() -> PythonSdkType.findPythonSdk(module2));
        try {
            List<String> list2 = PyCondaRunKt.listCondaEnvironments(sdk);
            for (String string : list2) {
                arrayList.addAll((Collection)ReadAction.compute(() -> {
                    VirtualFile virtualFile = StandardFileSystems.local().findFileByPath(string);
                    return ((StreamEx)StreamEx.of(VirtualEnvSdkFlavor.findInRootDirectory(virtualFile)).filter(string -> CondaEnvSdkFlavor.getCondaEnvRoot(string) != null)).toList();
                }));
            }
        }
        catch (ExecutionException executionException) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            CondaEnvSdkFlavor.c(0);
        }
        if (!super.isValidSdkPath(file)) {
            return false;
        }
        return PythonSdkType.isConda(file.getPath());
    }

    @Nullable
    public static File getCondaEnvRoot(@NotNull String binaryPath) {
        File file;
        File file2;
        long l2 = c ^ 0x6FC143D45E30L;
        if (binaryPath == null) {
            CondaEnvSdkFlavor.c(1);
        }
        if ((file2 = (file = new File(binaryPath)).getParentFile()) == null) {
            return null;
        }
        File file3 = file2.getParentFile();
        if (file3 == null) {
            return null;
        }
        File file4 = file3.getParentFile();
        if (file4 != null && "envs".equals(file4.getName())) {
            return file3;
        }
        if ("envs".equals(file3.getName())) {
            return file2;
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return PythonIcons.Python.Anaconda;
    }

    static {
        c = com.jetbrains.python.psi.c.a(5764743472099500978L, -1824606148490997493L, MethodHandles.lookup().lookupClass()).a(70972155015561L);
        long l2 = c ^ 0x30D74A0DEB8CL;
        CONDA_DEFAULT_ROOTS = new String[]{"anaconda", "anaconda2", "anaconda3", "miniconda", "miniconda2", "miniconda3", "Anaconda", "Anaconda2", "Anaconda3", "Miniconda", "Miniconda2", "Miniconda3"};
        INSTANCE = new CondaEnvSdkFlavor();
    }

    private static /* synthetic */ void c(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x40EFB0C39E0CL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/sdk/flavors/CondaEnvSdkFlavor";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidSdkPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCondaEnvRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

