/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Ref;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.LanguageCaseCollector;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.remote.PyCredentialsContribution;
import org.jetbrains.annotations.Nullable;

public abstract class CredentialsTypeExChecker {
    private boolean c;
    private boolean a;
    private boolean b;

    public CredentialsTypeExChecker withSshContribution(boolean sshContribution) {
        this.c = sshContribution;
        return this;
    }

    public CredentialsTypeExChecker withVagrantContribution(boolean vagrantContribution) {
        this.a = vagrantContribution;
        return this;
    }

    public CredentialsTypeExChecker withWebDeploymentContribution(boolean webDeploymentContribution) {
        this.b = webDeploymentContribution;
        return this;
    }

    public boolean check(@Nullable Sdk sdk) {
        if (sdk == null) {
            return false;
        }
        RemoteSdkAdditionalData remoteSdkAdditionalData = (RemoteSdkAdditionalData)ObjectUtils.tryCast((Object)sdk.getSdkAdditionalData(), RemoteSdkAdditionalData.class);
        if (remoteSdkAdditionalData == null) {
            return false;
        }
        return this.check(remoteSdkAdditionalData);
    }

    public boolean check(RemoteSdkAdditionalData data) {
        final Ref ref = Ref.create((Object)this.c);
        data.switchOnConnectionType(new LanguageCaseCollector<PyCredentialsContribution>(){

            protected void processLanguageContribution(PyCredentialsContribution languageContribution, Object credentials) {
                ref.set((Object)CredentialsTypeExChecker.this.checkLanguageContribution(languageContribution));
            }
        }.collectCases(PyCredentialsContribution.class, new CredentialsCase[]{new CredentialsCase.Ssh(){

            public void process(RemoteCredentialsHolder credentials) {
                ref.set((Object)CredentialsTypeExChecker.this.c);
            }
        }, new CredentialsCase.Vagrant(){

            public void process(VagrantBasedCredentialsHolder credentials) {
                ref.set((Object)CredentialsTypeExChecker.this.a);
            }
        }, new CredentialsCase.WebDeployment(){

            public void process(WebDeploymentCredentialsHolder credentials) {
                ref.set((Object)CredentialsTypeExChecker.this.b);
            }
        }}));
        return (Boolean)ref.get();
    }

    protected abstract boolean checkLanguageContribution(PyCredentialsContribution var1);
}

