/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.run.PythonConfigurationType;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.RunnableScriptFilter;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonRunConfigurationProducer
extends LazyRunConfigurationProducer<PythonRunConfiguration> {
    private static final long a = c.a(2072837772637757165L, 3833531406828270717L, MethodHandles.lookup().lookupClass()).a(69721087759794L);

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        PythonConfigurationType.PythonConfigurationFactory pythonConfigurationFactory = PythonConfigurationType.getInstance().getFactory();
        if (pythonConfigurationFactory == null) {
            PythonRunConfigurationProducer.a(0);
        }
        return pythonConfigurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull PythonRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Module module2;
        Location location;
        if (configuration == null) {
            PythonRunConfigurationProducer.a(1);
        }
        if (context == null) {
            PythonRunConfigurationProducer.a(2);
        }
        if (sourceElement == null) {
            PythonRunConfigurationProducer.a(3);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        PsiFile psiFile = location.getPsiElement().getContainingFile();
        if (!PythonRunConfigurationProducer.a(location, psiFile)) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        configuration.setScriptName(virtualFile.getPath());
        VirtualFile virtualFile2 = virtualFile.getParent();
        if (virtualFile2 != null && StringUtil.isEmpty((String)configuration.getWorkingDirectory())) {
            configuration.setWorkingDirectory(virtualFile2.getPath());
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile)) != null) {
            configuration.setUseModuleSdk(true);
            configuration.setModule(module2);
        }
        configuration.setName(configuration.suggestedName());
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull PythonRunConfiguration configuration, @NotNull ConfigurationContext context) {
        String string;
        Location location;
        if (configuration == null) {
            PythonRunConfigurationProducer.a(4);
        }
        if (context == null) {
            PythonRunConfigurationProducer.a(5);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        PsiFile psiFile = location.getPsiElement().getContainingFile();
        if (!PythonRunConfigurationProducer.a(location, psiFile)) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (virtualFile instanceof LightVirtualFile) {
            return false;
        }
        String string2 = configuration.getWorkingDirectory();
        String string3 = configuration.getScriptName();
        return string3.equals(string = virtualFile.getPath()) || string.equals(new File(string2, string3).getAbsolutePath());
    }

    private static boolean a(@NotNull Location location, @Nullable PsiFile psiFile) {
        if (location == null) {
            PythonRunConfigurationProducer.a(6);
        }
        if (psiFile == null || psiFile.getFileType() != PythonFileType.INSTANCE || !psiFile.getViewProvider().getBaseLanguage().isKindOf((Language)PythonLanguage.INSTANCE)) {
            return false;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module2 != null) {
            for (RunnableScriptFilter runnableScriptFilter : RunnableScriptFilter.EP_NAME.getExtensionList()) {
                if (!runnableScriptFilter.isRunnableScript(psiFile, module2, location, TypeEvalContext.userInitiated(location.getProject(), null))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return other.isProducedBy(PythonRunConfigurationProducer.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x1C1E4677E2F6L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/PythonRunConfigurationProducer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/PythonRunConfigurationProducer";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

