/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.remote.ProcessControlWithMappings;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.console.PyDebugConsoleBuilder;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.facet.PythonPathContributingFacet;
import com.jetbrains.python.library.PythonLibraryType;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PyRemoteProcessStarter;
import com.jetbrains.python.run.PyRemoteTracebackFilter;
import com.jetbrains.python.run.PythonCommandLineEnvironmentProvider;
import com.jetbrains.python.run.PythonProcessRunner;
import com.jetbrains.python.run.PythonRunConfigurationExtensionsManager;
import com.jetbrains.python.run.PythonRunParams;
import com.jetbrains.python.run.PythonTracebackFilter;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.JythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonCommandLineState
extends CommandLineState {
    private static final Logger c;
    public static final String GROUP_EXE_OPTIONS = "Exe Options";
    public static final String GROUP_DEBUGGER = "Debugger";
    public static final String GROUP_PROFILER = "Profiler";
    public static final String GROUP_COVERAGE = "Coverage";
    public static final String GROUP_MODULE = "Module";
    public static final String GROUP_SCRIPT = "Script";
    public static final String MODULE_PARAMETER = "-m";
    private final AbstractPythonRunConfiguration b;
    private Boolean a = null;
    private boolean d = PtyCommandLine.isEnabled();
    private static final long m;

    public boolean isRunWithPty() {
        return this.d;
    }

    public boolean isDebug() {
        long l2 = m ^ 0x7173755C66ADL;
        return "PyDebugRunner".equals(this.getEnvironment().getRunner().getRunnerId());
    }

    public static ServerSocket createServerSocket() throws ExecutionException {
        ServerSocket serverSocket;
        long l2 = m ^ 0x529212FEF887L;
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException iOException) {
            throw new ExecutionException("Failed to find free socket port", (Throwable)iOException);
        }
        return serverSocket;
    }

    public PythonCommandLineState(AbstractPythonRunConfiguration runConfiguration, ExecutionEnvironment env) {
        super(env);
        this.b = runConfiguration;
    }

    @Nullable
    public PythonSdkFlavor getSdkFlavor() {
        return PythonSdkFlavor.getFlavor(this.b.getInterpreterPath());
    }

    @Nullable
    public Sdk getSdk() {
        return this.b.getSdk();
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            PythonCommandLineState.a(0);
        }
        if (runner == null) {
            PythonCommandLineState.a(1);
        }
        ExecutionResult executionResult = this.execute(executor, (CommandLinePatcher[])null);
        if (executionResult == null) {
            PythonCommandLineState.a(2);
        }
        return executionResult;
    }

    public ExecutionResult execute(Executor executor, CommandLinePatcher ... patchers) throws ExecutionException {
        return this.execute(executor, this.getDefaultPythonProcessStarter(), patchers);
    }

    public ExecutionResult execute(Executor executor, PythonProcessStarter processStarter, CommandLinePatcher ... patchers) throws ExecutionException {
        ProcessHandler processHandler = this.startProcess(processStarter, patchers);
        ConsoleView consoleView = this.createAndAttachConsole(this.b.getProject(), processHandler, executor);
        return new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler, this.createActions(consoleView, processHandler));
    }

    @NotNull
    protected ConsoleView createAndAttachConsole(Project project, ProcessHandler processHandler, Executor executor) throws ExecutionException {
        ConsoleView consoleView = this.a(project).getConsole();
        consoleView.addMessageFilter((Filter)this.createUrlFilter(processHandler));
        this.addTracebackFilter(project, consoleView, processHandler);
        consoleView.attachToProcess(processHandler);
        ConsoleView consoleView2 = consoleView;
        if (consoleView2 == null) {
            PythonCommandLineState.a(3);
        }
        return consoleView2;
    }

    protected void addTracebackFilter(Project project, ConsoleView consoleView, ProcessHandler processHandler) {
        if (PySdkUtil.isRemote(this.b.getSdk())) {
            assert (processHandler instanceof ProcessControlWithMappings);
            consoleView.addMessageFilter((Filter)new PyRemoteTracebackFilter(project, this.b.getWorkingDirectory(), (ProcessControlWithMappings)processHandler));
        } else {
            consoleView.addMessageFilter((Filter)new PythonTracebackFilter(project, this.b.getWorkingDirectorySafe()));
        }
        consoleView.addMessageFilter((Filter)this.createUrlFilter(processHandler));
    }

    private TextConsoleBuilder a(Project project) {
        if (this.isDebug()) {
            return new PyDebugConsoleBuilder(project, PythonSdkType.findSdkByPath(this.b.getInterpreterPath()));
        }
        return TextConsoleBuilderFactory.getInstance().createBuilder(project);
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        ProcessHandler processHandler = this.startProcess(this.getDefaultPythonProcessStarter(), new CommandLinePatcher[0]);
        if (processHandler == null) {
            PythonCommandLineState.a(4);
        }
        return processHandler;
    }

    @Deprecated
    @NotNull
    protected ProcessHandler startProcess(CommandLinePatcher ... patchers) throws ExecutionException {
        ProcessHandler processHandler = this.startProcess(this.getDefaultPythonProcessStarter(), patchers);
        if (processHandler == null) {
            PythonCommandLineState.a(5);
        }
        return processHandler;
    }

    @NotNull
    protected ProcessHandler startProcess(PythonProcessStarter processStarter, CommandLinePatcher ... patchers) throws ExecutionException {
        GeneralCommandLine generalCommandLine = this.generateCommandLine(patchers);
        PythonRunConfigurationExtensionsManager.Companion.getInstance().patchCommandLine((RunConfigurationBase)this.b, this.getRunnerSettings(), generalCommandLine, this.getEnvironment().getRunner().getRunnerId());
        ProcessHandler processHandler = processStarter.start(this.b, generalCommandLine);
        PythonRunConfigurationExtensionsManager.Companion.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.b, processHandler, this.getRunnerSettings());
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            PythonCommandLineState.a(6);
        }
        return processHandler2;
    }

    @NotNull
    protected final PythonProcessStarter getDefaultPythonProcessStarter() {
        PythonProcessStarter pythonProcessStarter = (abstractPythonRunConfiguration, generalCommandLine) -> {
            ProcessHandler processHandler;
            Sdk sdk = PythonSdkType.findSdkByPath(this.b.getInterpreterPath());
            if (PySdkUtil.isRemote(sdk)) {
                PyRemotePathMapper pyRemotePathMapper = this.a();
                processHandler = this.createRemoteProcessStarter().startRemoteProcess(sdk, generalCommandLine, this.b.getProject(), pyRemotePathMapper);
            } else {
                EncodingEnvironmentUtil.setLocaleEnvironmentIfMac((GeneralCommandLine)generalCommandLine);
                processHandler = this.doCreateProcess(generalCommandLine);
                ProcessTerminatedListener.attach((ProcessHandler)processHandler);
            }
            return processHandler;
        };
        if (pythonProcessStarter == null) {
            PythonCommandLineState.a(7);
        }
        return pythonProcessStarter;
    }

    @Nullable
    private PyRemotePathMapper a() {
        if (this.b.getMappingSettings() == null) {
            return null;
        }
        return PyRemotePathMapper.fromSettings(this.b.getMappingSettings(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
    }

    protected PyRemoteProcessStarter createRemoteProcessStarter() {
        return new PyRemoteProcessStarter();
    }

    @NotNull
    public final GeneralCommandLine generateCommandLine(@Nullable CommandLinePatcher[] patchers) {
        GeneralCommandLine generalCommandLine = PythonCommandLineState.a(this.generateCommandLine(), patchers);
        if (generalCommandLine == null) {
            PythonCommandLineState.a(8);
        }
        return generalCommandLine;
    }

    @NotNull
    private static GeneralCommandLine a(@NotNull GeneralCommandLine generalCommandLine, @Nullable CommandLinePatcher[] commandLinePatcherArray) {
        if (generalCommandLine == null) {
            PythonCommandLineState.a(9);
        }
        if (commandLinePatcherArray != null) {
            for (CommandLinePatcher commandLinePatcher : commandLinePatcherArray) {
                if (commandLinePatcher == null) continue;
                commandLinePatcher.patchCommandLine(generalCommandLine);
            }
        }
        GeneralCommandLine generalCommandLine2 = generalCommandLine;
        if (generalCommandLine2 == null) {
            PythonCommandLineState.a(10);
        }
        return generalCommandLine2;
    }

    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        return PythonProcessRunner.createProcess(commandLine);
    }

    @NotNull
    public GeneralCommandLine generateCommandLine() {
        GeneralCommandLine generalCommandLine = PythonCommandLineState.createPythonCommandLine(this.b.getProject(), this.b, this.isDebug(), this.d);
        this.buildCommandLineParameters(generalCommandLine);
        this.customizeEnvironmentVars(generalCommandLine.getEnvironment(), this.b.isPassParentEnvs());
        GeneralCommandLine generalCommandLine2 = generalCommandLine;
        if (generalCommandLine2 == null) {
            PythonCommandLineState.a(11);
        }
        return generalCommandLine2;
    }

    @NotNull
    public static GeneralCommandLine createPythonCommandLine(Project project, PythonRunParams config, boolean isDebug, boolean runWithPty) {
        GeneralCommandLine generalCommandLine = PythonCommandLineState.a(runWithPty);
        generalCommandLine.withCharset(EncodingProjectManager.getInstance((Project)project).getDefaultCharset());
        PythonCommandLineState.createStandardGroups(generalCommandLine);
        PythonCommandLineState.initEnvironment(project, generalCommandLine, config, isDebug);
        PythonCommandLineState.setRunnerPath(project, generalCommandLine, config);
        GeneralCommandLine generalCommandLine2 = generalCommandLine;
        if (generalCommandLine2 == null) {
            PythonCommandLineState.a(12);
        }
        return generalCommandLine2;
    }

    private static GeneralCommandLine a(boolean bl2) {
        return bl2 ? new PtyCommandLine().withConsoleMode(false) : new GeneralCommandLine();
    }

    public static void createStandardGroups(GeneralCommandLine commandLine) {
        long l2 = m ^ 0x3B5DEDBDA9CL;
        ParametersList parametersList = commandLine.getParametersList();
        parametersList.addParamsGroup(GROUP_EXE_OPTIONS);
        parametersList.addParamsGroup(GROUP_DEBUGGER);
        parametersList.addParamsGroup(GROUP_PROFILER);
        parametersList.addParamsGroup(GROUP_COVERAGE);
        parametersList.addParamsGroup(GROUP_MODULE);
        parametersList.addParamsGroup(GROUP_SCRIPT);
    }

    protected static void initEnvironment(Project project, GeneralCommandLine commandLine, PythonRunParams runParams, boolean isDebug) {
        HashMap hashMap = Maps.newHashMap();
        PythonCommandLineState.a(hashMap, commandLine.getCharset());
        if (runParams.getEnvs() != null) {
            hashMap.putAll(runParams.getEnvs());
        }
        PythonCommandLineState.addCommonEnvironmentVariables(PythonCommandLineState.getInterpreterPath(project, runParams), hashMap);
        PythonCommandLineState.a(runParams, hashMap, runParams.getSdkHome());
        commandLine.getEnvironment().clear();
        commandLine.getEnvironment().putAll(hashMap);
        commandLine.withParentEnvironmentType(runParams.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        PythonCommandLineState.buildPythonPath(project, commandLine, runParams, isDebug);
        for (PythonCommandLineEnvironmentProvider pythonCommandLineEnvironmentProvider : PythonCommandLineEnvironmentProvider.EP_NAME.getExtensionList()) {
            pythonCommandLineEnvironmentProvider.extendEnvironment(project, commandLine, runParams);
        }
    }

    private static void a(PythonRunParams pythonRunParams, Map<String, String> map2, String string) {
        long l2 = m ^ 0x3D67291C3204L;
        Sdk sdk = PythonSdkType.findSdkByPath(string);
        if (sdk != null && (Registry.is((String)"python.activate.virtualenv.on.run") && PythonSdkType.isVirtualEnv(string) || PythonSdkType.isConda(sdk))) {
            Map<String, String> map3 = PythonSdkType.activateVirtualEnv(sdk);
            map2.putAll(map3);
            for (Map.Entry<String, String> entry : pythonRunParams.getEnvs().entrySet()) {
                if (!map3.containsKey(entry.getKey())) continue;
                if ("PATH".equals(entry.getKey())) {
                    map2.put(entry.getKey(), PythonEnvUtil.addToPathEnvVar(map2.get("PATH"), entry.getValue(), true));
                    continue;
                }
                map2.put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected static void addCommonEnvironmentVariables(@Nullable String homePath, Map<String, String> env) {
        long l2 = m ^ 0x651B485CDBD1L;
        PythonEnvUtil.setPythonUnbuffered(env);
        if (homePath != null) {
            PythonEnvUtil.resetHomePathChanges(homePath, env);
        }
        env.put("PYCHARM_HOSTED", "1");
    }

    public void customizeEnvironmentVars(Map<String, String> envs, boolean passParentEnvs) {
    }

    private static void a(Map<String, String> map2, Charset charset) {
        PythonSdkFlavor.setupEncodingEnvs(map2, charset);
    }

    public static void buildPythonPath(@NotNull Project project, @NotNull GeneralCommandLine commandLine, @NotNull PythonRunParams config, boolean isDebug) {
        if (project == null) {
            PythonCommandLineState.a(13);
        }
        if (commandLine == null) {
            PythonCommandLineState.a(14);
        }
        if (config == null) {
            PythonCommandLineState.a(15);
        }
        Module module2 = PythonCommandLineState.a(project, config);
        PythonCommandLineState.buildPythonPath(module2, commandLine, config.getSdkHome(), config.isPassParentEnvs(), config.shouldAddContentRoots(), config.shouldAddSourceRoots(), isDebug);
    }

    public static void buildPythonPath(@Nullable Module module2, @NotNull GeneralCommandLine commandLine, @Nullable String sdkHome, boolean passParentEnvs, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        Sdk sdk;
        if (commandLine == null) {
            PythonCommandLineState.a(16);
        }
        if ((sdk = PythonSdkType.findSdkByPath(sdkHome)) != null) {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.addAll(PythonCommandLineState.getAddedPaths(sdk));
            arrayList.addAll(PythonCommandLineState.collectPythonPath(module2, sdkHome, shouldAddContentRoots, shouldAddSourceRoots, isDebug));
            PythonCommandLineState.initPythonPath(commandLine, passParentEnvs, arrayList, sdkHome);
        }
    }

    public static void initPythonPath(@NotNull GeneralCommandLine commandLine, boolean passParentEnvs, @NotNull List<String> pathList, String interpreterPath) {
        PythonSdkFlavor pythonSdkFlavor;
        if (commandLine == null) {
            PythonCommandLineState.a(17);
        }
        if (pathList == null) {
            PythonCommandLineState.a(18);
        }
        if ((pythonSdkFlavor = PythonSdkFlavor.getFlavor(interpreterPath)) != null) {
            pythonSdkFlavor.initPythonPath(commandLine, passParentEnvs, pathList);
        } else {
            PythonSdkFlavor.initPythonPath(commandLine.getEnvironment(), passParentEnvs, pathList);
        }
    }

    @NotNull
    public static List<String> getAddedPaths(@NotNull Sdk pythonSdk2) {
        if (pythonSdk2 == null) {
            PythonCommandLineState.a(19);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        SdkAdditionalData sdkAdditionalData = pythonSdk2.getSdkAdditionalData();
        if (sdkAdditionalData instanceof PythonSdkAdditionalData) {
            Set<VirtualFile> set = ((PythonSdkAdditionalData)sdkAdditionalData).getAddedPathFiles();
            for (VirtualFile virtualFile : set) {
                PythonCommandLineState.a(virtualFile, arrayList);
            }
        }
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PythonCommandLineState.a(20);
        }
        return arrayList2;
    }

    private static void a(VirtualFile virtualFile, Collection<String> collection) {
        if (virtualFile.getFileSystem() instanceof JarFileSystem) {
            VirtualFile virtualFile2 = JarFileSystem.getInstance().getVirtualFileForJar(virtualFile);
            if (virtualFile2 != null) {
                PythonCommandLineState.b(virtualFile2, collection);
            }
        } else {
            PythonCommandLineState.b(virtualFile, collection);
        }
    }

    private static void b(@NotNull VirtualFile virtualFile, @NotNull Collection<String> collection) {
        if (virtualFile == null) {
            PythonCommandLineState.a(21);
        }
        if (collection == null) {
            PythonCommandLineState.a(22);
        }
        PythonCommandLineState.addIfNeeded(collection, virtualFile.getPath());
    }

    protected static void addIfNeeded(Collection<String> pathList, String path) {
        String string;
        HashSet hashSet = Sets.newHashSet(pathList);
        if (!hashSet.contains(string = FileUtil.toSystemDependentName((String)path))) {
            pathList.add(string);
        }
    }

    @VisibleForTesting
    public static Collection<String> collectPythonPath(Project project, PythonRunParams config, boolean isDebug) {
        Module module2 = PythonCommandLineState.a(project, config);
        return PythonCommandLineState.collectPythonPath(module2, config.getSdkHome(), config.shouldAddContentRoots(), config.shouldAddSourceRoots(), isDebug);
    }

    @NotNull
    public static Collection<String> collectPythonPath(@Nullable Module module2, @Nullable String sdkHome, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        long l2 = m ^ 0x315E2F141D35L;
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet(PythonCommandLineState.collectPythonPath(module2, shouldAddContentRoots, shouldAddSourceRoots));
        if (isDebug && PythonSdkFlavor.getFlavor(sdkHome) instanceof JythonSdkFlavor) {
            linkedHashSet.add(PythonHelpersLocator.getHelperPath("pycharm"));
            linkedHashSet.add(PythonHelpersLocator.getHelperPath("pydev"));
        }
        LinkedHashSet linkedHashSet2 = linkedHashSet;
        if (linkedHashSet2 == null) {
            PythonCommandLineState.a(23);
        }
        return linkedHashSet2;
    }

    @Nullable
    private static Module a(Project project, PythonRunParams pythonRunParams) {
        String string = pythonRunParams.getModuleName();
        return StringUtil.isEmpty((String)string) ? null : ModuleManager.getInstance((Project)project).findModuleByName(string);
    }

    @NotNull
    public static Collection<String> collectPythonPath(@Nullable Module module2) {
        Collection<String> collection = PythonCommandLineState.collectPythonPath(module2, true, true);
        if (collection == null) {
            PythonCommandLineState.a(24);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> collectPythonPath(@Nullable Module module2, boolean addContentRoots, boolean addSourceRoots) {
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        if (module2 != null) {
            HashSet hashSet = new HashSet();
            ModuleUtilCore.getDependencies((Module)module2, hashSet);
            if (addContentRoots) {
                PythonCommandLineState.a(linkedHashSet, ModuleRootManager.getInstance((Module)module2).getContentRoots());
                for (Module module3 : hashSet) {
                    PythonCommandLineState.a(linkedHashSet, ModuleRootManager.getInstance((Module)module3).getContentRoots());
                }
            }
            if (addSourceRoots) {
                PythonCommandLineState.a(linkedHashSet, ModuleRootManager.getInstance((Module)module2).getSourceRoots());
                for (Module module3 : hashSet) {
                    PythonCommandLineState.a(linkedHashSet, ModuleRootManager.getInstance((Module)module3).getSourceRoots());
                }
            }
            PythonCommandLineState.a(module2, (Collection<String>)linkedHashSet);
            PythonCommandLineState.b(module2, (Collection<String>)linkedHashSet);
            for (Module module3 : hashSet) {
                PythonCommandLineState.a(module3, (Collection<String>)linkedHashSet);
                PythonCommandLineState.b(module3, (Collection<String>)linkedHashSet);
            }
        }
        LinkedHashSet linkedHashSet2 = linkedHashSet;
        if (linkedHashSet2 == null) {
            PythonCommandLineState.a(25);
        }
        return linkedHashSet2;
    }

    private static void a(Module module2, Collection<String> collection) {
        OrderEntry[] orderEntryArray;
        long l2 = m ^ 0x138656AF9EF1L;
        for (OrderEntry orderEntry : orderEntryArray = ModuleRootManager.getInstance((Module)module2).getOrderEntries()) {
            String string;
            if (!(orderEntry instanceof LibraryOrderEntry) || (string = ((LibraryOrderEntry)orderEntry).getLibraryName()) != null && string.endsWith(" interpreter library")) continue;
            for (VirtualFile virtualFile : ((LibraryOrderEntry)orderEntry).getRootFiles(OrderRootType.CLASSES)) {
                PersistentLibraryKind persistentLibraryKind;
                Library library = ((LibraryOrderEntry)orderEntry).getLibrary();
                if (!PlatformUtils.isPyCharm()) {
                    PythonCommandLineState.a(virtualFile, collection);
                    continue;
                }
                if (!(library instanceof LibraryImpl) || (persistentLibraryKind = ((LibraryImpl)library).getKind()) != PythonLibraryType.getInstance().getKind()) continue;
                PythonCommandLineState.a(virtualFile, collection);
            }
        }
    }

    private static void b(Module module2, Collection<String> collection) {
        VirtualFile virtualFile;
        CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module2);
        if (compilerModuleExtension != null) {
            VirtualFile virtualFile2;
            virtualFile = compilerModuleExtension.getCompilerOutputPath();
            if (virtualFile != null) {
                collection.add(virtualFile.getPath());
            }
            if ((virtualFile2 = compilerModuleExtension.getCompilerOutputPathForTests()) != null) {
                collection.add(virtualFile2.getPath());
            }
        }
        for (VirtualFile virtualFile3 : virtualFile = FacetManager.getInstance((Module)module2).getAllFacets()) {
            List<String> list2;
            if (!(virtualFile3 instanceof PythonPathContributingFacet) || (list2 = ((PythonPathContributingFacet)virtualFile3).getAdditionalPythonPath()) == null) continue;
            collection.addAll(list2);
        }
    }

    private static void a(Collection<String> collection, VirtualFile[] virtualFileArray) {
        for (VirtualFile virtualFile : virtualFileArray) {
            PythonCommandLineState.a(virtualFile, collection);
        }
    }

    protected static void setRunnerPath(Project project, GeneralCommandLine commandLine, PythonRunParams config) {
        String string = PythonCommandLineState.getInterpreterPath(project, config);
        if (StringUtil.isNotEmpty((String)string)) {
            commandLine.setExePath(FileUtil.toSystemDependentName((String)string));
        }
    }

    @Nullable
    public static String getInterpreterPath(Project project, PythonRunParams config) {
        Module module2;
        Sdk sdk;
        String string = config.getSdkHome();
        if ((config.isUseModuleSdk() || StringUtil.isEmpty((String)string)) && (sdk = PythonSdkType.findPythonSdk(module2 = PythonCommandLineState.a(project, config))) != null) {
            string = sdk.getHomePath();
        }
        return string;
    }

    protected String getInterpreterPath() throws ExecutionException {
        long l2 = m ^ 0x1E4CD0A78EBCL;
        String string = this.b.getInterpreterPath();
        if (string == null) {
            throw new ExecutionException("Cannot find Python interpreter for this run configuration");
        }
        return string;
    }

    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
    }

    public boolean isMultiprocessDebug() {
        if (this.a != null) {
            return this.a;
        }
        return PyDebuggerOptionsProvider.getInstance(this.b.getProject()).isAttachToSubprocess();
    }

    public void setMultiprocessDebug(boolean multiprocessDebug) {
        this.a = multiprocessDebug;
    }

    public void setRunWithPty(boolean runWithPty) {
        this.d = runWithPty;
    }

    @NotNull
    protected UrlFilter createUrlFilter(ProcessHandler handler) {
        UrlFilter urlFilter = new UrlFilter();
        if (urlFilter == null) {
            PythonCommandLineState.a(26);
        }
        return urlFilter;
    }

    static {
        m = com.jetbrains.python.psi.c.a(-4224649802740204757L, 2411584142638799859L, MethodHandles.lookup().lookupClass()).a(169721028023073L);
        long l2 = m ^ 0x7792BBA73A23L;
        c = Logger.getInstance((String)"#com.jetbrains.python.run.PythonCommandLineState");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = m ^ 0x2B36BFFB962DL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/PythonCommandLineState";
                break;
            }
            case 9: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathList";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonSdk";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/PythonCommandLineState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAttachConsole";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPythonProcessStarter";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCommandLine";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPatchers";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createPythonCommandLine";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddedPaths";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPythonPath";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createUrlFilter";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyPatchers";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildPythonPath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "initPythonPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAddedPaths";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PythonProcessStarter {
        @NotNull
        public ProcessHandler start(@NotNull AbstractPythonRunConfiguration var1, @NotNull GeneralCommandLine var2) throws ExecutionException;
    }
}

