/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.move.PyBaseMoveDialog;
import com.jetbrains.python.refactoring.move.makeFunctionTopLevel.PyMakeFunctionTopLevelDialog;
import com.jetbrains.python.refactoring.move.makeFunctionTopLevel.PyMakeLocalFunctionTopLevelProcessor;
import com.jetbrains.python.refactoring.move.makeFunctionTopLevel.PyMakeMethodTopLevelProcessor;
import com.jetbrains.python.refactoring.move.moduleMembers.PyMoveModuleMembersDialog;
import com.jetbrains.python.refactoring.move.moduleMembers.PyMoveModuleMembersHelper;
import com.jetbrains.python.refactoring.move.moduleMembers.PyMoveModuleMembersProcessor;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMoveSymbolDelegate
extends MoveHandlerDelegate {
    private static final long a = c.a(666286159164540399L, 9029295326185327037L, MethodHandles.lookup().lookupClass()).a(124307258769246L);

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        if (targetContainer != null && !super.canMove(elements, targetContainer, reference)) {
            return false;
        }
        if (PyMoveSymbolDelegate.isMovableLocalFunctionOrMethod(elements[0])) {
            return true;
        }
        for (PsiElement psiElement : elements) {
            if (PyMoveModuleMembersHelper.isMovableModuleMember(psiElement)) continue;
            return false;
        }
        return true;
    }

    public void doMove(@NotNull Project project, @NotNull List<PyElement> elements) {
        BaseRefactoringProcessor baseRefactoringProcessor;
        Object object;
        long l2 = a ^ 0x7674746C375L;
        if (project == null) {
            PyMoveSymbolDelegate.a(0);
        }
        if (elements == null) {
            PyMoveSymbolDelegate.a(1);
        }
        PsiElement psiElement = (PsiElement)elements.get(0);
        String string = StringUtil.notNullize((String)PyPsiUtils.getContainingFilePath(psiElement));
        if (PyMoveSymbolDelegate.isMovableLocalFunctionOrMethod(psiElement)) {
            object = (PyFunction)psiElement;
            PyMakeFunctionTopLevelDialog pyMakeFunctionTopLevelDialog = new PyMakeFunctionTopLevelDialog(project, (PyFunction)object, string, string);
            if (!pyMakeFunctionTopLevelDialog.showAndGet()) {
                return;
            }
            baseRefactoringProcessor = object.getContainingClass() != null ? new PyMakeMethodTopLevelProcessor((PyFunction)object, pyMakeFunctionTopLevelDialog.getTargetPath()) : new PyMakeLocalFunctionTopLevelProcessor((PyFunction)object, pyMakeFunctionTopLevelDialog.getTargetPath());
            baseRefactoringProcessor.setPreviewUsages(pyMakeFunctionTopLevelDialog.isPreviewUsages());
        } else {
            object = Lists.newArrayList();
            for (PsiElement psiNamedElementArray2 : elements) {
                PsiNamedElement psiNamedElement = PyMoveModuleMembersHelper.extractNamedElement(psiNamedElementArray2);
                if (psiNamedElement == null) {
                    return;
                }
                object.add(psiNamedElement);
            }
            Object object2 = new PyMoveModuleMembersDialog(project, (List<PsiNamedElement>)object, string, string);
            if (!object2.showAndGet()) {
                return;
            }
            PsiNamedElement[] psiNamedElementArray = (PsiNamedElement[])ContainerUtil.findAllAsArray(((PyMoveModuleMembersDialog)((Object)object2)).getSelectedTopLevelSymbols(), PsiNamedElement.class);
            baseRefactoringProcessor = new PyMoveModuleMembersProcessor(psiNamedElementArray, ((PyBaseMoveDialog)((Object)object2)).getTargetPath());
            baseRefactoringProcessor.setPreviewUsages(object2.isPreviewUsages());
        }
        try {
            baseRefactoringProcessor.run();
        }
        catch (IncorrectOperationException incorrectOperationException) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw incorrectOperationException;
            }
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)incorrectOperationException.getMessage(), null, (Project)project);
        }
    }

    public boolean tryToMove(@NotNull PsiElement element, @NotNull Project project, @Nullable DataContext dataContext, @Nullable PsiReference reference, @Nullable Editor editor2) {
        if (element == null) {
            PyMoveSymbolDelegate.a(2);
        }
        if (project == null) {
            PyMoveSymbolDelegate.a(3);
        }
        PsiFile psiFile = element.getContainingFile();
        if (editor2 != null && psiFile instanceof PyFile && PyMoveSymbolDelegate.a(editor2)) {
            List<PyElement> list2 = PyMoveSymbolDelegate.a(editor2, (PyFile)psiFile);
            if (list2.isEmpty()) {
                PyMoveSymbolDelegate.a(project, editor2);
            } else {
                this.doMove(project, list2);
            }
            return true;
        }
        PsiNamedElement psiNamedElement = PyMoveModuleMembersHelper.extractNamedElement(element);
        if (psiNamedElement != null && PyMoveModuleMembersHelper.hasMovableElementType((PsiElement)psiNamedElement)) {
            if (PyMoveModuleMembersHelper.isMovableModuleMember((PsiElement)psiNamedElement) || PyMoveSymbolDelegate.isMovableLocalFunctionOrMethod((PsiElement)psiNamedElement)) {
                this.doMove(project, Collections.singletonList((PyElement)psiNamedElement));
            } else {
                PyMoveSymbolDelegate.a(project, editor2);
            }
            return true;
        }
        return false;
    }

    private static void a(@NotNull Project project, @Nullable Editor editor2) {
        long l2 = a ^ 0x638A1768D938L;
        if (project == null) {
            PyMoveSymbolDelegate.a(4);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)PyBundle.message("refactoring.move.module.members.error.selection", new Object[0]), (String)RefactoringBundle.message((String)"error.title"), null);
    }

    private static boolean a(@NotNull Editor editor2) {
        if (editor2 == null) {
            PyMoveSymbolDelegate.a(5);
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        Document document = editor2.getDocument();
        return document.getLineNumber(selectionModel.getSelectionStart()) != document.getLineNumber(selectionModel.getSelectionEnd());
    }

    @NotNull
    private static List<PyElement> a(@NotNull Editor editor2, @NotNull PyFile pyFile) {
        if (editor2 == null) {
            PyMoveSymbolDelegate.a(6);
        }
        if (pyFile == null) {
            PyMoveSymbolDelegate.a(7);
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        TextRange textRange = new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
        List<PyElement> list2 = PyMoveModuleMembersHelper.getTopLevelModuleMembers(pyFile);
        List list3 = ContainerUtil.filter(list2, pyElement -> {
            PsiElement psiElement = PyMoveModuleMembersHelper.expandNamedElementBody((PsiNamedElement)pyElement);
            return psiElement != null && textRange.contains(psiElement.getTextRange());
        });
        if (list3 == null) {
            PyMoveSymbolDelegate.a(8);
        }
        return list3;
    }

    @VisibleForTesting
    public static boolean isMovableLocalFunctionOrMethod(@NotNull PsiElement element) {
        if (element == null) {
            PyMoveSymbolDelegate.a(9);
        }
        return PyMoveSymbolDelegate.a(element) || PyMoveSymbolDelegate.b(element);
    }

    private static boolean b(@Nullable PsiElement psiElement) {
        PyFunction pyFunction = PyUtil.as(psiElement, PyFunction.class);
        if (pyFunction == null || pyFunction.getContainingClass() == null) {
            return false;
        }
        String string = pyFunction.getName();
        if (string == null || PyUtil.isSpecialName(string)) {
            return false;
        }
        TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(pyFunction.getProject(), pyFunction.getContainingFile());
        if (PySuperMethodsSearch.search(pyFunction, typeEvalContext).findFirst() != null) {
            return false;
        }
        if (PyOverridingMethodsSearch.search(pyFunction, true).findFirst() != null) {
            return false;
        }
        if (pyFunction.getDecoratorList() != null || pyFunction.getModifier() != null) {
            return false;
        }
        return pyFunction.getContainingClass().findPropertyByCallable(pyFunction) == null;
    }

    private static boolean a(@Nullable PsiElement psiElement) {
        return psiElement instanceof PyFunction && PsiTreeUtil.getParentOfType((PsiElement)psiElement, ScopeOwner.class, (boolean)true) instanceof PyFunction;
    }

    public boolean supportsLanguage(@NotNull Language language) {
        if (language == null) {
            PyMoveSymbolDelegate.a(10);
        }
        return language.isKindOf((Language)PythonLanguage.getInstance());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x1354F59F086EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/move/PyMoveSymbolDelegate";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/move/PyMoveSymbolDelegate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllMovableElementsInSelection";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doMove";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryToMove";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showBadSelectionErrorHint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectionSpansMultipleLines";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectAllMovableElementsInSelection";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMovableLocalFunctionOrMethod";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "supportsLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

