/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.actions.CreatePackageAction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.imports.PyImportOptimizer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMoveFileHandler
extends MoveFileHandler {
    private static final Key<PsiNamedElement> a;
    private static final Key<String> b;
    private static final long c;

    public boolean canProcessElement(PsiFile element) {
        return element.getFileType() == PythonFileType.INSTANCE;
    }

    public void prepareMovedFile(PsiFile file, PsiDirectory moveDestination, Map<PsiElement, PsiElement> oldToNewMap) {
        if (file != null) {
            PsiDirectory psiDirectory;
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                PyUtil.deletePycFiles(virtualFile.getPath());
            }
            Collection<VirtualFile> collection = PyUtil.getSourceRoots((PsiElement)file);
            for (psiDirectory = moveDestination; psiDirectory != null && !collection.contains(psiDirectory.getVirtualFile()); psiDirectory = psiDirectory.getParentDirectory()) {
            }
            boolean bl2 = RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE;
            if (moveDestination != psiDirectory && psiDirectory != null && bl2 && !PyMoveFileHandler.a(file, moveDestination, psiDirectory)) {
                CreatePackageAction.createInitPyInHierarchy(moveDestination, psiDirectory);
            }
        }
    }

    public void updateMovedFile(PsiFile file) throws IncorrectOperationException {
        if (file instanceof PyFile) {
            PyMoveFileHandler.a((PyFile)file);
        }
    }

    private static void a(@NotNull PyFile pyFile) {
        QualifiedName qualifiedName;
        PsiFileSystemItem psiFileSystemItem;
        String string;
        if (pyFile == null) {
            PyMoveFileHandler.a(0);
        }
        if ((string = (String)pyFile.getUserData(b)) == null) {
            return;
        }
        for (PyFromImportStatement stubBasedPsiElement : pyFile.getFromImports()) {
            if (!PyMoveFileHandler.a(stubBasedPsiElement)) continue;
            int n2 = Math.max(stubBasedPsiElement.getRelativeLevel(), 1);
            psiFileSystemItem = PyMoveFileHandler.a(stubBasedPsiElement.getManager(), string, stubBasedPsiElement.getImportSource(), n2);
            if (psiFileSystemItem == null) continue;
            qualifiedName = QualifiedNameFinder.findShortestImportableQName(psiFileSystemItem);
            PyMoveFileHandler.a(stubBasedPsiElement, qualifiedName);
        }
        for (PyImportElement pyImportElement : pyFile.getImportTargets()) {
            ScopeOwner scopeOwner;
            PyReferenceExpression pyReferenceExpression = pyImportElement.getImportReferenceExpression();
            if (!PyMoveFileHandler.a(pyImportElement) || pyReferenceExpression == null || (psiFileSystemItem = PyMoveFileHandler.a(pyImportElement.getManager(), string, pyReferenceExpression, 1)) == null) continue;
            qualifiedName = QualifiedNameFinder.findShortestImportableQName(psiFileSystemItem);
            PyMoveFileHandler.a((PsiElement)pyReferenceExpression, qualifiedName);
            final QualifiedName qualifiedName2 = pyReferenceExpression.asQualifiedName();
            if (Comparing.equal((Object)qualifiedName2, (Object)qualifiedName) || (scopeOwner = ScopeUtil.getScopeOwner((PsiElement)pyImportElement)) == null) continue;
            scopeOwner.accept(new PyRecursiveElementVisitor(){

                @Override
                public void visitPyReferenceExpression(PyReferenceExpression node) {
                    if (Comparing.equal((Object)node.asQualifiedName(), (Object)qualifiedName2)) {
                        PyMoveFileHandler.a((PsiElement)node, qualifiedName);
                    } else {
                        super.visitPyReferenceExpression(node);
                    }
                }
            });
        }
    }

    private static boolean a(@NotNull PyFromImportStatement pyFromImportStatement) {
        if (pyFromImportStatement == null) {
            PyMoveFileHandler.a(1);
        }
        return LanguageLevel.forElement((PsiElement)pyFromImportStatement).isPython2() || pyFromImportStatement.getRelativeLevel() > 0;
    }

    private static boolean a(@NotNull PyImportElement pyImportElement) {
        if (pyImportElement == null) {
            PyMoveFileHandler.a(2);
        }
        return LanguageLevel.forElement((PsiElement)pyImportElement).isPython2();
    }

    @Nullable
    private static PsiFileSystemItem a(@NotNull PsiManager psiManager, @NotNull String string, @Nullable PyReferenceExpression pyReferenceExpression, int n2) {
        long l2 = c ^ 0x181B12F47A45L;
        if (psiManager == null) {
            PyMoveFileHandler.a(3);
        }
        if (string == null) {
            PyMoveFileHandler.a(4);
        }
        String string2 = VirtualFileManager.extractPath((String)string);
        for (int i10 = 0; i10 < n2; ++i10) {
            string2 = PathUtil.getParentPath((String)string2);
        }
        if (!string2.isEmpty()) {
            Object object;
            VirtualFile virtualFile;
            String string3 = VirtualFileManager.extractProtocol((String)string);
            assert (string3 != null) : "Original location: " + string;
            String string4 = VirtualFileManager.constructUrl((String)string3, (String)string2);
            VirtualFile virtualFile2 = virtualFile = VirtualFileManager.getInstance().findFileByUrl(string4);
            if (virtualFile != null && virtualFile.isDirectory() && pyReferenceExpression != null) {
                object = pyReferenceExpression.asQualifiedName();
                if (object == null) {
                    return null;
                }
                String string5 = object.join("/");
                virtualFile2 = virtualFile.findFileByRelativePath(string5);
                if (virtualFile2 == null) {
                    virtualFile2 = virtualFile.findFileByRelativePath(string5 + ".py");
                }
            }
            if (virtualFile2 != null) {
                object = virtualFile2.isDirectory() ? psiManager.findDirectory(virtualFile2) : psiManager.findFile(virtualFile2);
                return object;
            }
        }
        return null;
    }

    private static boolean a(@NotNull PsiFile psiFile, @NotNull PsiDirectory psiDirectory, @NotNull PsiDirectory psiDirectory2) {
        long l2 = c ^ 0x227021C9809L;
        if (psiFile == null) {
            PyMoveFileHandler.a(5);
        }
        if (psiDirectory == null) {
            PyMoveFileHandler.a(6);
        }
        if (psiDirectory2 == null) {
            PyMoveFileHandler.a(7);
        }
        if (LanguageLevel.forElement((PsiElement)psiFile).isPython2()) {
            return false;
        }
        while (psiDirectory != null && psiDirectory != psiDirectory2) {
            if (psiDirectory.findFile("__init__.py") != null) {
                return false;
            }
            psiDirectory = psiDirectory.getParent();
        }
        return true;
    }

    public List<UsageInfo> findUsages(PsiFile file, PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        if (file != null) {
            file.putUserData(b, (Object)file.getVirtualFile().getUrl());
            List<UsageInfo> list2 = PyRefactoringUtil.findUsages((PsiNamedElement)file, false);
            for (UsageInfo usageInfo : list2) {
                PsiElement psiElement = usageInfo.getElement();
                if (psiElement == null) continue;
                psiElement.putCopyableUserData(a, (Object)file);
            }
            return list2;
        }
        return null;
    }

    public void retargetUsages(List<UsageInfo> usages, Map<PsiElement, PsiElement> oldToNewMap) {
        HashSet<PsiFile> hashSet = new HashSet<PsiFile>();
        for (UsageInfo object : usages) {
            TypeEvalContext typeEvalContext;
            PsiElement psiElement = object.getElement();
            if (psiElement == null) continue;
            PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement.getCopyableUserData(a);
            psiElement.putCopyableUserData(a, null);
            if (psiNamedElement == null) continue;
            PsiFile psiFile = psiElement.getContainingFile();
            PyImportStatementBase pyImportStatementBase = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyImportStatementBase.class);
            if (pyImportStatementBase != null) {
                boolean bl2;
                PyResolveContext pyResolveContext;
                if (psiFile.getUserData(b) != null) {
                    typeEvalContext = TypeEvalContext.userInitiated(psiFile.getProject(), psiFile);
                    pyResolveContext = PyResolveContext.defaultContext().withTypeEvalContext(typeEvalContext);
                    if (ContainerUtil.getFirstItem(PyUtil.multiResolveTopPriority(psiElement, pyResolveContext)) == psiNamedElement) continue;
                }
                hashSet.add(psiFile);
                boolean bl3 = bl2 = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyImportElement.class) != null;
                if (bl2 && PyClassRefactoringUtil.updateUnqualifiedImportOfElement(pyImportStatementBase, psiNamedElement)) continue;
                pyResolveContext = QualifiedNameFinder.findCanonicalImportPath((PsiElement)psiNamedElement, psiElement);
                if (pyImportStatementBase instanceof PyFromImportStatement) {
                    if (bl2) continue;
                    PyMoveFileHandler.a((PyFromImportStatement)pyImportStatementBase, (QualifiedName)pyResolveContext);
                    continue;
                }
                PyMoveFileHandler.a(psiElement, (QualifiedName)pyResolveContext);
                continue;
            }
            if (!(psiElement instanceof PyReferenceExpression)) continue;
            hashSet.add(psiFile);
            if (((PyReferenceExpression)psiElement).isQualified()) {
                typeEvalContext = QualifiedNameFinder.findCanonicalImportPath((PsiElement)psiNamedElement, psiElement);
                PyMoveFileHandler.a(psiElement, (QualifiedName)typeEvalContext);
                continue;
            }
            typeEvalContext = QualifiedName.fromComponents((String[])new String[]{PyClassRefactoringUtil.getOriginalName(psiNamedElement)});
            PyMoveFileHandler.a(psiElement, (QualifiedName)typeEvalContext);
        }
        if (!hashSet.isEmpty()) {
            PyImportOptimizer pyImportOptimizer = PyImportOptimizer.onlyRemoveUnused();
            for (PsiFile psiFile : hashSet) {
                boolean bl4 = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).isInjectedFragment(psiFile);
                if (bl4) continue;
                pyImportOptimizer.processFile(psiFile).run();
            }
        }
    }

    @NotNull
    private static PsiElement a(@NotNull PsiElement psiElement, @Nullable QualifiedName qualifiedName) {
        PyElementGenerator pyElementGenerator;
        PyExpression pyExpression;
        if (psiElement == null) {
            PyMoveFileHandler.a(8);
        }
        if (qualifiedName != null && PyClassRefactoringUtil.isValidQualifiedName(qualifiedName) && (pyExpression = (pyElementGenerator = PyElementGenerator.getInstance(psiElement.getProject())).createExpressionFromText(LanguageLevel.forElement(psiElement), qualifiedName.toString())) != null) {
            PsiElement psiElement2 = psiElement.replace((PsiElement)pyExpression);
            if (psiElement2 == null) {
                PyMoveFileHandler.a(9);
            }
            return psiElement2;
        }
        PsiElement psiElement3 = psiElement;
        if (psiElement3 == null) {
            PyMoveFileHandler.a(10);
        }
        return psiElement3;
    }

    @NotNull
    private static PsiElement a(@NotNull PyFromImportStatement pyFromImportStatement, @Nullable QualifiedName qualifiedName) {
        Couple<PsiElement> couple;
        if (pyFromImportStatement == null) {
            PyMoveFileHandler.a(11);
        }
        if ((couple = PyMoveFileHandler.b(pyFromImportStatement)) != null && qualifiedName != null) {
            if (couple.getFirst() != couple.getSecond()) {
                pyFromImportStatement.deleteChildRange(((PsiElement)couple.getFirst()).getNextSibling(), (PsiElement)couple.getSecond());
            }
            PyMoveFileHandler.a((PsiElement)couple.getFirst(), qualifiedName);
        }
        PyFromImportStatement pyFromImportStatement2 = pyFromImportStatement;
        if (pyFromImportStatement2 == null) {
            PyMoveFileHandler.a(12);
        }
        return pyFromImportStatement2;
    }

    @Nullable
    private static Couple<PsiElement> b(@NotNull PyFromImportStatement pyFromImportStatement) {
        if (pyFromImportStatement == null) {
            PyMoveFileHandler.a(13);
        }
        PsiElement psiElement = pyFromImportStatement.getFirstChild();
        assert (psiElement.getNode().getElementType() == PyTokenTypes.FROM_KEYWORD);
        PsiElement psiElement2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)psiElement);
        if (psiElement2 == null) {
            return null;
        }
        if (psiElement2 instanceof PyReferenceExpression) {
            return Couple.of((Object)psiElement2, (Object)psiElement2);
        }
        if (psiElement2.getNode().getElementType() == PyTokenTypes.DOT) {
            PsiElement psiElement3;
            PsiElement psiElement4 = psiElement2;
            do {
                psiElement3 = psiElement4;
            } while ((psiElement4 = PsiTreeUtil.skipWhitespacesForward((PsiElement)psiElement4)) != null && psiElement4.getNode().getElementType() == PyTokenTypes.DOT);
            if (psiElement4 instanceof PyReferenceExpression) {
                return Couple.of((Object)psiElement2, (Object)psiElement4);
            }
            return Couple.of((Object)psiElement2, (Object)psiElement3);
        }
        return null;
    }

    static {
        c = com.jetbrains.python.psi.c.a(-6143273989665563445L, -309322435482034514L, MethodHandles.lookup().lookupClass()).a(247964194888701L);
        long l2 = c ^ 0x696B00247B9L;
        a = Key.create((String)"PY_REFERENCED_ELEMENT");
        b = Key.create((String)"PY_ORIGINAL_FILE_LOCATION");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x149857E8C36BL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleLocation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/move/PyMoveFileHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/move/PyMoveFileHandler";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithQualifiedExpression";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceRelativeImportSourceWithQualifiedExpression";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateRelativeImportsInModule";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canBeRelative";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveRelativeImportFromModuleLocation";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "probablyNamespacePackage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithQualifiedExpression";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceRelativeImportSourceWithQualifiedExpression";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeImportSourceRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

