/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.extractmethod;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.codeFragment.CodeFragment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.AbstractExtractMethodDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodDecorator;
import com.intellij.refactoring.extractMethod.ExtractMethodHelper;
import com.intellij.refactoring.extractMethod.ExtractMethodSettings;
import com.intellij.refactoring.extractMethod.ExtractMethodValidator;
import com.intellij.refactoring.extractMethod.SimpleDuplicatesFinder;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.AbstractVariableData;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.codeFragment.PyCodeFragment;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExtractMethodUtil {
    public static final String NAME = "extract.method.name";
    private static final long a = c.a(4659870366705349305L, -3772943972049530901L, MethodHandles.lookup().lookupClass()).a(13027262740841L);

    private PyExtractMethodUtil() {
    }

    public static void extractFromStatements(@NotNull Project project, @NotNull Editor editor2, @NotNull PyCodeFragment fragment, @NotNull PsiElement statement1, @NotNull PsiElement statement2) {
        long l2 = a ^ 0x3A77B7CE1035L;
        if (project == null) {
            PyExtractMethodUtil.a(0);
        }
        if (editor2 == null) {
            PyExtractMethodUtil.a(1);
        }
        if (fragment == null) {
            PyExtractMethodUtil.a(2);
        }
        if (statement1 == null) {
            PyExtractMethodUtil.a(3);
        }
        if (statement2 == null) {
            PyExtractMethodUtil.a(4);
        }
        if (!fragment.getOutputVariables().isEmpty() && fragment.isReturnInstructionInside()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)PyBundle.message("refactoring.extract.method.error.local.variable.modifications.and.returns", new Object[0]), (String)RefactoringBundle.message((String)"error.title"), (String)"refactoring.extractMethod");
            return;
        }
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)statement1, PyFunction.class);
        PyUtil.MethodFlags methodFlags = pyFunction == null ? null : PyUtil.MethodFlags.of(pyFunction);
        boolean bl2 = methodFlags != null && methodFlags.isClassMethod();
        boolean bl3 = methodFlags != null && methodFlags.isStaticMethod();
        List list2 = PsiTreeUtil.getElementsOfRange((PsiElement)statement1, (PsiElement)statement2);
        if (list2.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)PyBundle.message("refactoring.extract.method.error.empty.fragment", new Object[0]), (String)RefactoringBundle.message((String)"extract.method.title"), (String)"refactoring.extractMethod");
            return;
        }
        Pair<String, AbstractVariableData[]> pair = PyExtractMethodUtil.a(project, fragment, statement1, bl2, bl3);
        if (pair.first == null || pair.second == null) {
            return;
        }
        String string = (String)pair.first;
        AbstractVariableData[] abstractVariableDataArray = (AbstractVariableData[])pair.second;
        SimpleDuplicatesFinder simpleDuplicatesFinder = new SimpleDuplicatesFinder(statement1, statement2, fragment.getOutputVariables(), abstractVariableDataArray);
        CommandProcessor.getInstance().executeCommand(project, () -> {
            PsiElement psiElement3;
            Object object;
            Object object2;
            long l2 = a ^ 0x65151F8EC0B6L;
            RefactoringEventData refactoringEventData = new RefactoringEventData();
            refactoringEventData.addElements(new PsiElement[]{statement1, statement2});
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(PyExtractMethodUtil.getRefactoringId(), refactoringEventData);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl4 = fragment.isAsync();
            if (bl4) {
                stringBuilder.append("async ");
            }
            stringBuilder.append("def f():\n    ");
            ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>(list2);
            boolean bl5 = !fragment.getOutputVariables().isEmpty();
            PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(project);
            LanguageLevel languageLevel = LanguageLevel.forElement(statement1);
            if (bl5) {
                object2 = StringUtil.join((Collection)fragment.getOutputVariables(), (String)", ");
                object = stringBuilder + "return " + (String)object2;
                stringBuilder.append((String)object2);
                psiElement3 = pyElementGenerator.createFromText(languageLevel, PyFunction.class, (String)object);
                PyStatement pyStatement = psiElement3.getStatementList().getStatements()[0];
                arrayList.add((PsiElement)pyStatement);
            }
            object2 = PyExtractMethodUtil.a(string, abstractVariableDataArray, arrayList, methodFlags, bl4);
            object = (PyFunction)WriteAction.compute(() -> PyExtractMethodUtil.d(statement1, (PyFunction)object2));
            psiElement3 = (PsiElement)list2.get(0);
            boolean bl6 = PyPsiUtils.isMethodContext(psiElement3);
            WriteAction.run(() -> PyExtractMethodUtil.a(project, (PyFunction)object, abstractVariableDataArray, bl6, bl2, bl3, fragment));
            if (bl5) {
                stringBuilder.append(" = ");
            } else if (fragment.isReturnInstructionInside()) {
                stringBuilder.append("return ");
            }
            if (bl4) {
                stringBuilder.append("await ");
            } else if (fragment.isYieldInside()) {
                stringBuilder.append("yield from ");
            }
            if (bl6) {
                PyExtractMethodUtil.a(psiElement3, stringBuilder, bl3);
            }
            stringBuilder.append(string).append("(");
            stringBuilder.append(PyExtractMethodUtil.b(abstractVariableDataArray)).append(")");
            PyFunction pyFunction = pyElementGenerator.createFromText(languageLevel, PyFunction.class, stringBuilder.toString());
            PyStatement pyStatement = pyFunction.getStatementList().getStatements()[0];
            PyPsiUtils.assertValid(statement1);
            PyPsiUtils.assertValid(statement2);
            List<SimpleMatch> list3 = PyExtractMethodUtil.a(simpleDuplicatesFinder, statement1, (PyFunction)object);
            PsiElement psiElement4 = (PsiElement)WriteAction.compute(() -> PyExtractMethodUtil.a(list2, (PsiElement)pyStatement));
            psiElement4 = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)psiElement4);
            if (psiElement4 != null) {
                PyExtractMethodUtil.a(list3, psiElement4, editor2);
            }
            PyExtractMethodUtil.a(editor2, psiElement4);
            RefactoringEventData refactoringEventData2 = new RefactoringEventData();
            refactoringEventData2.addElement((PsiElement)object);
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(PyExtractMethodUtil.getRefactoringId(), refactoringEventData2);
        }, PyBundle.message("refactoring.extract.method", new Object[0]), null);
    }

    @NotNull
    private static List<SimpleMatch> a(@NotNull SimpleDuplicatesFinder simpleDuplicatesFinder, @NotNull PsiElement psiElement, @NotNull PyFunction pyFunction) {
        if (simpleDuplicatesFinder == null) {
            PyExtractMethodUtil.a(5);
        }
        if (psiElement == null) {
            PyExtractMethodUtil.a(6);
        }
        if (pyFunction == null) {
            PyExtractMethodUtil.a(7);
        }
        List<PsiElement> list2 = PyExtractMethodUtil.c(psiElement, pyFunction);
        List list3 = ExtractMethodHelper.collectDuplicates((SimpleDuplicatesFinder)simpleDuplicatesFinder, list2, (PsiElement)pyFunction);
        if (list3 == null) {
            PyExtractMethodUtil.a(8);
        }
        return list3;
    }

    @NotNull
    private static List<PsiElement> c(@NotNull PsiElement psiElement, @NotNull PyFunction pyFunction) {
        ScopeOwner scopeOwner;
        if (psiElement == null) {
            PyExtractMethodUtil.a(9);
        }
        if (pyFunction == null) {
            PyExtractMethodUtil.a(10);
        }
        if ((scopeOwner = ScopeUtil.getScopeOwner(psiElement)) instanceof PsiFile) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                PyExtractMethodUtil.a(11);
            }
            return list2;
        }
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        if (scopeOwner instanceof PyFunction) {
            arrayList.add((PsiElement)scopeOwner);
            PyClass pyClass = ((PyFunction)scopeOwner).getContainingClass();
            if (pyClass != null) {
                for (PyFunction pyFunction2 : pyClass.getMethods()) {
                    if (pyFunction2.equals(scopeOwner) || pyFunction2.equals(pyFunction)) continue;
                    arrayList.add(pyFunction2);
                }
            }
        }
        ArrayList<PsiElement> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PyExtractMethodUtil.a(12);
        }
        return arrayList2;
    }

    private static void a(@NotNull List<SimpleMatch> list2, @NotNull PsiElement psiElement, @NotNull Editor editor2) {
        if (list2 == null) {
            PyExtractMethodUtil.a(13);
        }
        if (psiElement == null) {
            PyExtractMethodUtil.a(14);
        }
        if (editor2 == null) {
            PyExtractMethodUtil.a(15);
        }
        ExtractMethodHelper.replaceDuplicates((PsiElement)psiElement, (Editor)editor2, pair -> PyExtractMethodUtil.a((SimpleMatch)pair.first, ((PsiElement)pair.second).copy()), list2);
    }

    private static void b(@NotNull PyFunction pyFunction, @NotNull PyCodeFragment pyCodeFragment) {
        long l2 = a ^ 0x1DCC8C78206DL;
        if (pyFunction == null) {
            PyExtractMethodUtil.a(16);
        }
        if (pyCodeFragment == null) {
            PyExtractMethodUtil.a(17);
        }
        Set<String> set = pyCodeFragment.getGlobalWrites();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Scope scope = ControlFlowCache.getScope(pyFunction);
        for (String object : set) {
            if (scope.isGlobal(object)) continue;
            linkedHashSet.add(object);
        }
        if (!linkedHashSet.isEmpty()) {
            PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(pyFunction.getProject());
            PyGlobalStatement pyGlobalStatement = pyElementGenerator.createFromText(LanguageLevel.forElement(pyFunction), PyGlobalStatement.class, "global " + StringUtil.join(linkedHashSet, (String)", "));
            PyStatementList pyStatementList = pyFunction.getStatementList();
            pyStatementList.addBefore(pyGlobalStatement, pyStatementList.getFirstChild());
        }
    }

    private static void a(@NotNull PyFunction pyFunction, @NotNull PyCodeFragment pyCodeFragment) {
        long l2 = a ^ 0x3B11471C5571L;
        if (pyFunction == null) {
            PyExtractMethodUtil.a(18);
        }
        if (pyCodeFragment == null) {
            PyExtractMethodUtil.a(19);
        }
        Set<String> set = pyCodeFragment.getNonlocalWrites();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Scope scope = ControlFlowCache.getScope(pyFunction);
        for (String object : set) {
            if (scope.isNonlocal(object)) continue;
            linkedHashSet.add(object);
        }
        if (!linkedHashSet.isEmpty()) {
            PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(pyFunction.getProject());
            PyNonlocalStatement pyNonlocalStatement = pyElementGenerator.createFromText(LanguageLevel.forElement(pyFunction), PyNonlocalStatement.class, "nonlocal " + StringUtil.join(linkedHashSet, (String)", "));
            PyStatementList pyStatementList = pyFunction.getStatementList();
            pyStatementList.addBefore((PsiElement)pyNonlocalStatement, pyStatementList.getFirstChild());
        }
    }

    private static void a(@NotNull PsiElement psiElement, @NotNull StringBuilder stringBuilder, boolean bl2) {
        if (psiElement == null) {
            PyExtractMethodUtil.a(20);
        }
        if (stringBuilder == null) {
            PyExtractMethodUtil.a(21);
        }
        if (bl2) {
            PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyClass.class);
            assert (pyClass != null);
            stringBuilder.append(pyClass.getName());
        } else {
            stringBuilder.append(PyUtil.getFirstParameterName((PyFunction)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyFunction.class)));
        }
        stringBuilder.append(".");
    }

    public static void extractFromExpression(@NotNull Project project, @NotNull Editor editor2, @NotNull PyCodeFragment fragment, @NotNull PsiElement expression) {
        long l2 = a ^ 0x2B5C797E4AFAL;
        if (project == null) {
            PyExtractMethodUtil.a(22);
        }
        if (editor2 == null) {
            PyExtractMethodUtil.a(23);
        }
        if (fragment == null) {
            PyExtractMethodUtil.a(24);
        }
        if (expression == null) {
            PyExtractMethodUtil.a(25);
        }
        if (!fragment.getOutputVariables().isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)PyBundle.message("refactoring.extract.method.error.local.variable.modifications", new Object[0]), (String)RefactoringBundle.message((String)"error.title"), (String)"refactoring.extractMethod");
            return;
        }
        if (fragment.isReturnInstructionInside()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)PyBundle.message("refactoring.extract.method.error.returns", new Object[0]), (String)RefactoringBundle.message((String)"error.title"), (String)"refactoring.extractMethod");
            return;
        }
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, PyFunction.class);
        PyUtil.MethodFlags methodFlags = pyFunction == null ? null : PyUtil.MethodFlags.of(pyFunction);
        boolean bl2 = methodFlags != null && methodFlags.isClassMethod();
        boolean bl3 = methodFlags != null && methodFlags.isClassMethod();
        Pair<String, AbstractVariableData[]> pair = PyExtractMethodUtil.a(project, fragment, expression, bl2, bl3);
        if (pair.first == null || pair.second == null) {
            return;
        }
        String string = (String)pair.first;
        AbstractVariableData[] abstractVariableDataArray = (AbstractVariableData[])pair.second;
        SimpleDuplicatesFinder simpleDuplicatesFinder = new SimpleDuplicatesFinder(expression, expression, fragment.getOutputVariables(), abstractVariableDataArray);
        if (fragment.getOutputVariables().isEmpty()) {
            CommandProcessor.getInstance().executeCommand(project, () -> {
                long l2 = a ^ 0x2D82707D16B8L;
                boolean bl4 = fragment.isAsync();
                PyFunction pyFunction = PyExtractMethodUtil.a(string, abstractVariableDataArray, expression, methodFlags, bl4);
                PyFunction pyFunction2 = (PyFunction)WriteAction.compute(() -> PyExtractMethodUtil.b(expression, pyFunction));
                boolean bl5 = PyPsiUtils.isMethodContext(expression);
                WriteAction.run(() -> PyExtractMethodUtil.a(project, pyFunction2, abstractVariableDataArray, bl5, bl2, bl3));
                StringBuilder stringBuilder = new StringBuilder();
                if (bl4) {
                    stringBuilder.append("async ");
                }
                stringBuilder.append("def f():\n    ");
                if (bl4) {
                    stringBuilder.append("await ");
                } else if (fragment.isYieldInside()) {
                    stringBuilder.append("yield from ");
                } else {
                    stringBuilder.append("return ");
                }
                if (bl5) {
                    PyExtractMethodUtil.a(expression, stringBuilder, bl3);
                }
                stringBuilder.append(string);
                stringBuilder.append("(").append(PyExtractMethodUtil.b(abstractVariableDataArray)).append(")");
                PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(project);
                PyFunction pyFunction3 = pyElementGenerator.createFromText(LanguageLevel.forElement(expression), PyFunction.class, stringBuilder.toString());
                PyStatement pyStatement = pyFunction3.getStatementList().getStatements()[0];
                PyExpression pyExpression = pyStatement instanceof PyReturnStatement ? ((PyReturnStatement)pyStatement).getExpression() : (pyStatement instanceof PyExpressionStatement ? ((PyExpressionStatement)pyStatement).getExpression() : null);
                PyPsiUtils.assertValid(expression);
                List<SimpleMatch> list2 = PyExtractMethodUtil.a(simpleDuplicatesFinder, expression, pyFunction2);
                PsiElement psiElement2 = null;
                if (pyExpression != null && (psiElement2 = (PsiElement)WriteAction.compute(() -> PyExtractMethodUtil.a(expression, (PsiElement)pyExpression))) != null) {
                    PyExtractMethodUtil.a(list2, psiElement2, editor2);
                }
                PyExtractMethodUtil.a(editor2, psiElement2);
            }, PyBundle.message("refactoring.extract.method", new Object[0]), null);
        }
    }

    private static void a(@NotNull Editor editor2, @Nullable PsiElement psiElement) {
        if (editor2 == null) {
            PyExtractMethodUtil.a(26);
        }
        editor2.getSelectionModel().removeSelection();
        if (psiElement != null) {
            int n2 = psiElement.getTextOffset();
            editor2.getCaretModel().moveToOffset(n2);
        }
    }

    @NotNull
    private static PsiElement b(@NotNull List<PsiElement> list2, @NotNull PsiElement psiElement) {
        if (list2 == null) {
            PyExtractMethodUtil.a(27);
        }
        if (psiElement == null) {
            PyExtractMethodUtil.a(28);
        }
        psiElement = list2.get(0).replace(psiElement);
        if (list2.size() > 1) {
            psiElement.getParent().deleteChildRange(list2.get(1), list2.get(list2.size() - 1));
        }
        PsiElement psiElement2 = psiElement;
        if (psiElement2 == null) {
            PyExtractMethodUtil.a(29);
        }
        return psiElement2;
    }

    @NotNull
    private static PsiElement a(@NotNull SimpleMatch simpleMatch, @NotNull PsiElement psiElement) {
        Object object;
        Object object2;
        long l2 = a ^ 0x6EEF8BE1907AL;
        if (simpleMatch == null) {
            PyExtractMethodUtil.a(30);
        }
        if (psiElement == null) {
            PyExtractMethodUtil.a(31);
        }
        List list2 = PsiTreeUtil.getElementsOfRange((PsiElement)simpleMatch.getStartElement(), (PsiElement)simpleMatch.getEndElement());
        Map map2 = simpleMatch.getChangedParameters();
        Object object3 = psiElement;
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(object3.getProject());
        if (psiElement instanceof PyAssignmentStatement) {
            object2 = ((PyAssignmentStatement)psiElement).getAssignedValue();
            if (object2 != null) {
                object3 = object2;
            }
            if (((PyExpression[])(object = ((PyAssignmentStatement)psiElement).getTargets())).length == 1) {
                PyExpression[] pyExpressionArray = simpleMatch.getChangedOutput();
                PyExpression pyExpression = pyElementGenerator.createFromText(LanguageLevel.forElement(object3), PyAssignmentStatement.class, (String)pyExpressionArray + " = 1").getTargets()[0];
                object[0].replace((PsiElement)pyExpression);
            }
        }
        if (psiElement instanceof PyExpressionStatement) {
            object3 = ((PyExpressionStatement)psiElement).getExpression();
        }
        if (object3 instanceof PyCallExpression) {
            object2 = map2.keySet();
            object = ((PyCallExpression)object3).getArgumentList();
            if (object != null) {
                for (PyExpression pyExpression : object.getArguments()) {
                    String string = pyExpression.getText();
                    if (string == null || !object2.contains(string)) continue;
                    pyExpression.replace((PsiElement)pyElementGenerator.createExpressionFromText(LanguageLevel.forElement(object3), (String)map2.get(string)));
                }
            }
        }
        PsiElement psiElement2 = PyExtractMethodUtil.b(list2, psiElement);
        if (psiElement2 == null) {
            PyExtractMethodUtil.a(32);
        }
        return psiElement2;
    }

    @NotNull
    private static String b(@NotNull AbstractVariableData[] abstractVariableDataArray) {
        if (abstractVariableDataArray == null) {
            PyExtractMethodUtil.a(33);
        }
        String string = StringUtil.join((Collection)ContainerUtil.mapNotNull((Object[])abstractVariableDataArray, abstractVariableData -> abstractVariableData.isPassAsParameter() ? abstractVariableData.getOriginalName() : null), (String)",");
        if (string == null) {
            PyExtractMethodUtil.a(34);
        }
        return string;
    }

    private static void a(@NotNull Project project, @NotNull PyFunction pyFunction, @NotNull AbstractVariableData[] abstractVariableDataArray, boolean bl2, boolean bl3, boolean bl4) {
        long l2 = a ^ 0x46F72BB8961CL;
        if (project == null) {
            PyExtractMethodUtil.a(35);
        }
        if (pyFunction == null) {
            PyExtractMethodUtil.a(36);
        }
        if (abstractVariableDataArray == null) {
            PyExtractMethodUtil.a(37);
        }
        Map<String, String> map2 = PyExtractMethodUtil.a(abstractVariableDataArray);
        for (PyParameter pyParameter : pyFunction.getParameterList().getParameters()) {
            String string = pyParameter.getName();
            String string2 = map2.get(string);
            if (string == null || string2 == null || string.equals(string2)) continue;
            java.util.HashMap<PyParameter, String> hashMap = new java.util.HashMap<PyParameter, String>();
            hashMap.put(pyParameter, string2);
            UsageInfo[] usageInfoArray = RenameUtil.findUsages((PsiElement)pyParameter, (String)string2, (boolean)false, (boolean)false, hashMap);
            try {
                RenameUtil.doRename((PsiElement)pyParameter, (String)string2, (UsageInfo[])usageInfoArray, (Project)project, (RefactoringElementListener)new RefactoringElementListenerComposite());
            }
            catch (IncorrectOperationException incorrectOperationException) {
                RenameUtil.showErrorMessage((IncorrectOperationException)incorrectOperationException, (PsiElement)pyParameter, (Project)project);
                return;
            }
        }
        PyFunctionBuilder pyFunctionBuilder = new PyFunctionBuilder("foo", pyFunction);
        if (bl3) {
            pyFunctionBuilder.parameter("cls");
        } else if (bl2 && !bl4) {
            pyFunctionBuilder.parameter("self");
        }
        for (AbstractVariableData abstractVariableData : abstractVariableDataArray) {
            if (!abstractVariableData.isPassAsParameter()) continue;
            pyFunctionBuilder.parameter(abstractVariableData.getName());
        }
        PyParameterList pyParameterList = pyFunctionBuilder.buildFunction().getParameterList();
        pyFunction.getParameterList().replace((PsiElement)pyParameterList);
    }

    @NotNull
    private static Map<String, String> a(@NotNull AbstractVariableData[] abstractVariableDataArray) {
        if (abstractVariableDataArray == null) {
            PyExtractMethodUtil.a(38);
        }
        HashMap hashMap = new HashMap();
        for (AbstractVariableData abstractVariableData : abstractVariableDataArray) {
            hashMap.put(abstractVariableData.getOriginalName(), abstractVariableData.getName());
        }
        HashMap hashMap2 = hashMap;
        if (hashMap2 == null) {
            PyExtractMethodUtil.a(39);
        }
        return hashMap2;
    }

    @NotNull
    private static PyFunction b(@NotNull PsiElement psiElement, @NotNull PyFunction pyFunction) {
        PsiElement psiElement2;
        PsiNamedElement psiNamedElement;
        Pair pair;
        if (psiElement == null) {
            PyExtractMethodUtil.a(40);
        }
        if (pyFunction == null) {
            PyExtractMethodUtil.a(41);
        }
        if ((pair = (Pair)psiElement.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE)) != null) {
            psiElement = (PsiElement)pair.first;
        }
        if ((psiNamedElement = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{PyFile.class, PyClass.class, PyFunction.class})) instanceof PyFunction) {
            psiElement2 = psiNamedElement.getParent().addAfter((PsiElement)pyFunction, (PsiElement)psiNamedElement);
        } else {
            PsiNamedElement psiNamedElement2 = psiNamedElement instanceof PyClass ? ((PyClass)psiNamedElement).getStatementList() : psiNamedElement;
            PsiElement psiElement3 = PyPsiUtils.getParentRightBefore(psiElement, (PsiElement)psiNamedElement2);
            assert (psiElement3 != null);
            List<PsiComment> list2 = PyPsiUtils.getPrecedingComments(psiElement3);
            psiElement2 = psiElement3.getParent().addBefore((PsiElement)pyFunction, !list2.isEmpty() ? (PsiElement)list2.get(0) : psiElement3);
        }
        psiElement2.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){
            private static final long a = c.a(-665566334505499399L, 1725102387127602128L, MethodHandles.lookup().lookupClass()).a(40031309185491L);

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.a(0);
                }
                super.visitElement(element);
                CodeEditUtil.setNodeGenerated((ASTNode)element.getNode(), (boolean)true);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x53C9B1E74ED2L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil$1", "visitElement"));
            }
        });
        PyFunction pyFunction2 = (PyFunction)psiElement2;
        if (pyFunction2 == null) {
            PyExtractMethodUtil.a(42);
        }
        return pyFunction2;
    }

    @NotNull
    private static PyFunction a(@NotNull String string, @NotNull AbstractVariableData[] abstractVariableDataArray, @NotNull PsiElement psiElement, @Nullable PyUtil.MethodFlags methodFlags, boolean bl2) {
        long l2 = a ^ 0x49F5EA81C9D8L;
        if (string == null) {
            PyExtractMethodUtil.a(43);
        }
        if (abstractVariableDataArray == null) {
            PyExtractMethodUtil.a(44);
        }
        if (psiElement == null) {
            PyExtractMethodUtil.a(45);
        }
        PyFunctionBuilder pyFunctionBuilder = new PyFunctionBuilder(string, psiElement);
        PyExtractMethodUtil.a(pyFunctionBuilder, methodFlags);
        PyExtractMethodUtil.a(pyFunctionBuilder, abstractVariableDataArray);
        if (bl2) {
            pyFunctionBuilder.makeAsync();
        }
        String string2 = psiElement instanceof PyYieldExpression ? String.format("(%s)", psiElement.getText()) : psiElement.getText();
        pyFunctionBuilder.statement("return " + string2);
        PyFunction pyFunction = pyFunctionBuilder.buildFunction();
        if (pyFunction == null) {
            PyExtractMethodUtil.a(46);
        }
        return pyFunction;
    }

    @NotNull
    private static PyFunction a(@NotNull String string, @NotNull AbstractVariableData[] abstractVariableDataArray, @NotNull List<PsiElement> list2, @Nullable PyUtil.MethodFlags methodFlags, boolean bl2) {
        Object object2;
        long l2 = a ^ 0x2DC43DE6F35EL;
        if (string == null) {
            PyExtractMethodUtil.a(47);
        }
        if (abstractVariableDataArray == null) {
            PyExtractMethodUtil.a(48);
        }
        if (list2 == null) {
            PyExtractMethodUtil.a(49);
        }
        assert (!list2.isEmpty()) : "Empty statements list was selected!";
        PyFunctionBuilder pyFunctionBuilder = new PyFunctionBuilder(string, list2.get(0));
        if (bl2) {
            pyFunctionBuilder.makeAsync();
        }
        PyExtractMethodUtil.a(pyFunctionBuilder, methodFlags);
        PyExtractMethodUtil.a(pyFunctionBuilder, abstractVariableDataArray);
        PyFunction pyFunction = pyFunctionBuilder.buildFunction();
        PyStatementList pyStatementList = pyFunction.getStatementList();
        for (Object object2 : list2) {
            if (object2 instanceof PsiWhiteSpace) continue;
            pyStatementList.add((PsiElement)object2);
        }
        PsiElement psiElement = pyStatementList.getFirstChild();
        if (psiElement != null) {
            psiElement.delete();
        }
        object2 = pyStatementList;
        while (object2 != null) {
            if (!((object2 = object2.getLastChild()) instanceof PsiWhiteSpace)) continue;
            object2.delete();
        }
        PyFunction pyFunction2 = pyFunction;
        if (pyFunction2 == null) {
            PyExtractMethodUtil.a(50);
        }
        return pyFunction2;
    }

    private static void a(@NotNull PyFunctionBuilder pyFunctionBuilder, @Nullable PyUtil.MethodFlags methodFlags) {
        long l2 = a ^ 0x3B8E87F47AD8L;
        if (pyFunctionBuilder == null) {
            PyExtractMethodUtil.a(51);
        }
        if (methodFlags != null) {
            if (methodFlags.isClassMethod()) {
                pyFunctionBuilder.decorate("classmethod");
            } else if (methodFlags.isStaticMethod()) {
                pyFunctionBuilder.decorate("staticmethod");
            }
        }
    }

    private static void a(@NotNull PyFunctionBuilder pyFunctionBuilder, @NotNull AbstractVariableData[] abstractVariableDataArray) {
        if (pyFunctionBuilder == null) {
            PyExtractMethodUtil.a(52);
        }
        if (abstractVariableDataArray == null) {
            PyExtractMethodUtil.a(53);
        }
        for (AbstractVariableData abstractVariableData : abstractVariableDataArray) {
            pyFunctionBuilder.parameter(abstractVariableData.getOriginalName());
        }
    }

    @NotNull
    private static Pair<String, AbstractVariableData[]> a(@NotNull Project project, @NotNull CodeFragment codeFragment, @NotNull PsiElement psiElement, final boolean bl2, final boolean bl3) {
        long l2 = a ^ 0x47CCFE240D0AL;
        if (project == null) {
            PyExtractMethodUtil.a(54);
        }
        if (codeFragment == null) {
            PyExtractMethodUtil.a(55);
        }
        if (psiElement == null) {
            PyExtractMethodUtil.a(56);
        }
        PyExtractMethodValidator pyExtractMethodValidator = new PyExtractMethodValidator(psiElement, project);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String string;
            String string2 = System.getProperty(NAME);
            if (string2 == null) {
                string2 = "foo";
            }
            if ((string = pyExtractMethodValidator.check(string2)) != null) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new CommonRefactoringUtil.RefactoringErrorHintException(string);
                }
                if (Messages.showOkCancelDialog((String)(string + ". " + RefactoringBundle.message((String)"do.you.wish.to.continue")), (String)RefactoringBundle.message((String)"warning.title"), (Icon)Messages.getWarningIcon()) != 0) {
                    throw new CommonRefactoringUtil.RefactoringErrorHintException(string);
                }
            }
            ArrayList<AbstractVariableData> arrayList = new ArrayList<AbstractVariableData>();
            for (String string3 : codeFragment.getInputVariables()) {
                AbstractVariableData abstractVariableData = new AbstractVariableData();
                abstractVariableData.name = string3 + "_new";
                abstractVariableData.originalName = string3;
                abstractVariableData.passAsParameter = true;
                arrayList.add(abstractVariableData);
            }
            Pair pair = Pair.create((Object)string2, (Object)arrayList.toArray(new AbstractVariableData[0]));
            if (pair == null) {
                PyExtractMethodUtil.a(57);
            }
            return pair;
        }
        final boolean bl4 = PyPsiUtils.isMethodContext(psiElement);
        ExtractMethodDecorator<Object> extractMethodDecorator = new ExtractMethodDecorator<Object>(){
            private static final long a = c.a(-714784759102762024L, 2391450382925394499L, MethodHandles.lookup().lookupClass()).a(236482238221782L);

            @NotNull
            public String createMethodSignature(@NotNull ExtractMethodSettings<Object> settings) {
                long l2 = a ^ 0x8CC151AD62L;
                if (settings == null) {
                    2.a(0);
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (bl2) {
                    stringBuilder.append("cls");
                } else if (bl4 && !bl3) {
                    stringBuilder.append("self");
                }
                for (AbstractVariableData abstractVariableData : settings.getAbstractVariableData()) {
                    if (!abstractVariableData.passAsParameter) continue;
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(abstractVariableData.name);
                }
                stringBuilder.insert(0, "(");
                stringBuilder.insert(0, settings.getMethodName());
                stringBuilder.insert(0, "def ");
                stringBuilder.append(")");
                String string = stringBuilder.toString();
                if (string == null) {
                    2.a(1);
                }
                return string;
            }

            private static /* synthetic */ void a(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                long l2 = a ^ 0x7FAE5810A166L;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 1: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settings";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil$2";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createMethodSignature";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createMethodSignature";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        AbstractExtractMethodDialog<Object> abstractExtractMethodDialog = new AbstractExtractMethodDialog<Object>(project, "method_name", codeFragment, ArrayUtilRt.EMPTY_OBJECT_ARRAY, (ExtractMethodValidator)pyExtractMethodValidator, (ExtractMethodDecorator)extractMethodDecorator, (FileType)PythonFileType.INSTANCE){
            private static final long a = c.a(-2168891415621110856L, 8156989389275843709L, MethodHandles.lookup().lookupClass()).a(250161921301060L);

            protected String getHelpId() {
                long l2 = a ^ 0x25217568E800L;
                return "python.reference.extractMethod";
            }
        };
        abstractExtractMethodDialog.show();
        if (!abstractExtractMethodDialog.isOK()) {
            Pair pair = Pair.empty();
            if (pair == null) {
                PyExtractMethodUtil.a(58);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)abstractExtractMethodDialog.getMethodName(), (Object)abstractExtractMethodDialog.getAbstractVariableData());
        if (pair == null) {
            PyExtractMethodUtil.a(59);
        }
        return pair;
    }

    @NotNull
    public static String getRefactoringId() {
        long l2 = a ^ 0x617376216AD2L;
        if ("refactoring.python.extract.method" == null) {
            PyExtractMethodUtil.a(60);
        }
        return "refactoring.python.extract.method";
    }

    private static /* synthetic */ PsiElement a(PsiElement psiElement, PsiElement psiElement2) throws RuntimeException {
        return PyReplaceExpressionUtil.replaceExpression(psiElement, psiElement2);
    }

    private static /* synthetic */ PsiElement a(List list2, PsiElement psiElement) throws RuntimeException {
        return PyExtractMethodUtil.b(list2, psiElement);
    }

    private static /* synthetic */ void a(Project project, PyFunction pyFunction, AbstractVariableData[] abstractVariableDataArray, boolean bl2, boolean bl3, boolean bl4, PyCodeFragment pyCodeFragment) throws RuntimeException {
        PyExtractMethodUtil.a(project, pyFunction, abstractVariableDataArray, bl2, bl3, bl4);
        PyExtractMethodUtil.b(pyFunction, pyCodeFragment);
        PyExtractMethodUtil.a(pyFunction, pyCodeFragment);
    }

    private static /* synthetic */ PyFunction d(PsiElement psiElement, PyFunction pyFunction) throws RuntimeException {
        return PyExtractMethodUtil.b(psiElement, pyFunction);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x42272FE03E2EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 29: 
            case 32: 
            case 34: 
            case 39: 
            case 42: 
            case 46: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 29: 
            case 32: 
            case 34: 
            case 39: 
            case 42: 
            case 46: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 15: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 17: 
            case 19: 
            case 24: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalScopeAnchor";
                break;
            }
            case 7: 
            case 10: 
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedMethod";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 29: 
            case 32: 
            case 34: 
            case 39: 
            case 42: 
            case 46: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil";
                break;
            }
            case 9: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstElement";
                break;
            }
            case 21: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 25: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 27: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsRange";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callElement";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 31: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDatas";
                break;
            }
            case 37: 
            case 38: 
            case 44: 
            case 48: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableData";
                break;
            }
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDuplicates";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectScopes";
                break;
            }
            case 29: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceElements";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createCallArgsString";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createMap";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "insertGeneratedMethod";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMethodFromExpression";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMethodFromElements";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameAndVariableData";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringId";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractFromStatements";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectDuplicates";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 29: 
            case 32: 
            case 34: 
            case 39: 
            case 42: 
            case 46: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectScopes";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processDuplicates";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalWrites";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processNonlocalWrites";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "appendSelf";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "extractFromExpression";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setSelectionAndCaret";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "replaceElements";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createCallArgsString";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processParameters";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createMap";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "insertGeneratedMethod";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodFromExpression";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodFromElements";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addDecorators";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addFakeParameters";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getNameAndVariableData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 29: 
            case 32: 
            case 34: 
            case 39: 
            case 42: 
            case 46: 
            case 50: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PyExtractMethodValidator
    implements ExtractMethodValidator {
        private final PsiElement a;
        private final Project c;
        @Nullable
        private final Function<String, Boolean> b;
        private static final long d = com.jetbrains.python.psi.c.a(5878154784300128739L, 7659693167393396593L, MethodHandles.lookup().lookupClass()).a(189583813469576L);

        PyExtractMethodValidator(PsiElement element, Project project) {
            this.a = element;
            this.c = project;
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(this.a);
            this.b = string -> {
                ScopeOwner scopeOwner2 = scopeOwner;
                while (scopeOwner2 != null) {
                    if (scopeOwner2 instanceof PyClass && ((PyClass)scopeOwner2).findMethodByName((String)string, true, null) != null) {
                        return false;
                    }
                    Scope scope = ControlFlowCache.getScope(scopeOwner2);
                    if (scope.containsDeclaration((String)string)) {
                        return false;
                    }
                    scopeOwner2 = ScopeUtil.getScopeOwner((PsiElement)scopeOwner2);
                }
                return true;
            };
        }

        @Nullable
        public String check(String name) {
            long l2 = d ^ 0x547C2E483016L;
            if (this.b != null && !((Boolean)this.b.fun((Object)name)).booleanValue()) {
                return PyBundle.message("refactoring.extract.method.error.name.clash", new Object[0]);
            }
            return null;
        }

        public boolean isValidName(@NotNull String name) {
            if (name == null) {
                PyExtractMethodValidator.a(0);
            }
            NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)PythonLanguage.getInstance());
            assert (namesValidator != null);
            return namesValidator.isIdentifier(name, this.c);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = d ^ 0x7874FAE66E7DL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodUtil$PyExtractMethodValidator", "isValidName"));
        }
    }
}

